/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.util.MathHelper;

public class ItemSign
extends Item {
    public ItemSign(int i2) {
        super(i2);
        this.maxDamage = 64;
        this.maxStackSize = 16;
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i2, int j2, int k2, int l2) {
        if (l2 == 0) {
            return false;
        }
        if (!world.getMaterialXYZ(i2, j2, k2).isSolidMaterial()) {
            return false;
        }
        if (l2 == 1) {
            ++j2;
        }
        if (l2 == 2) {
            --k2;
        }
        if (l2 == 3) {
            ++k2;
        }
        if (l2 == 4) {
            --i2;
        }
        if (l2 == 5) {
            ++i2;
        }
        if (!Block.signPost.canPlace(world, i2, j2, k2)) {
            return false;
        }
        if (l2 == 1) {
            world.setBlockAndMetadataWithNotify(i2, j2, k2, Block.signPost.blockID, MathHelper.floor_double((double)((entityplayer.rotationYaw + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        } else {
            world.setBlockAndMetadataWithNotify(i2, j2, k2, Block.pressurePlateWoodIdle.blockID, l2);
        }
        --itemstack.stackSize;
        entityplayer.displayGUIEditSign((TileEntitySign)world.getBlockTileEntity(i2, j2, k2));
        return true;
    }
}

