/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.render;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.render.FontRenderer;
import com.mojang.minecraft.render.Render;
import com.mojang.minecraft.render.RenderBlocks;
import com.mojang.minecraft.render.RenderEngine;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.util.MathHelper;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public class RenderItem
extends Render {
    private RenderBlocks renderBlocks = new RenderBlocks();
    private Random field_200_e = new Random();
    public boolean field_27004_a;

    public RenderItem() {
        this.shadowSize = 0.15f;
        this.field_194_c = 0.75f;
    }

    public void initialize(EntityItem entityitem, double d2, double d1, double d22, float f2, float f1) {
        this.field_200_e.setSeed(187L);
        ItemStack itemstack = entityitem.item;
        GL11.glPushMatrix();
        float f22 = MathHelper.sin(((float)entityitem.age + f1) / 10.0f + entityitem.field_804_d) * 0.1f + 0.1f;
        float f3 = (((float)entityitem.age + f1) / 20.0f + entityitem.field_804_d) * 57.29578f;
        int byte0 = 1;
        if (entityitem.item.stackSize > 1) {
            byte0 = 2;
        }
        if (entityitem.item.stackSize > 5) {
            byte0 = 3;
        }
        if (entityitem.item.stackSize > 20) {
            byte0 = 4;
        }
        GL11.glTranslatef((float)((float)d2), (float)((float)d1 + f22), (float)((float)d22));
        GL11.glEnable((int)32826);
        if (itemstack.itemID == 0) {
            System.out.println("Got a bad item ID!");
            itemstack.itemID = new Random().nextInt(64);
        }
        if (itemstack.itemID < 256 && RenderBlocks.getRenderItemType(Block.allBlocks[itemstack.itemID].getRenderType())) {
            GL11.glRotatef((float)f3, (float)0.0f, (float)1.0f, (float)0.0f);
            this.loadTexture("/terrain.png");
            float f4 = 0.25f;
            if (!Block.allBlocks[itemstack.itemID].renderAsNormalBlock() && itemstack.itemID != Block.stairSingle.blockID) {
                f4 = 0.5f;
            }
            GL11.glScalef((float)f4, (float)f4, (float)f4);
            int j2 = 0;
            while (j2 < byte0) {
                GL11.glPushMatrix();
                if (j2 > 0) {
                    float f5 = (this.field_200_e.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                    float f7 = (this.field_200_e.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                    float f9 = (this.field_200_e.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                    GL11.glTranslatef((float)f5, (float)f7, (float)f9);
                }
                this.renderBlocks.renderThrownItems(Block.allBlocks[itemstack.itemID]);
                GL11.glPopMatrix();
                ++j2;
            }
        } else {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            int i2 = itemstack.getIconIndex();
            if (itemstack.itemID < 256) {
                this.loadTexture("/terrain.png");
            } else {
                this.loadTexture("/gui/items.png");
            }
            Tessellator tessellator = Tessellator.instance;
            float f6 = (float)(i2 % 16 * 16 + 0) / 256.0f;
            float f8 = (float)(i2 % 16 * 16 + 16) / 256.0f;
            float f10 = (float)(i2 / 16 * 16 + 0) / 256.0f;
            float f11 = (float)(i2 / 16 * 16 + 16) / 256.0f;
            float f12 = 1.0f;
            float f13 = 0.5f;
            float f14 = 0.25f;
            int k2 = 0;
            while (k2 < byte0) {
                GL11.glPushMatrix();
                if (k2 > 0) {
                    float f15 = (this.field_200_e.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float f16 = (this.field_200_e.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float f17 = (this.field_200_e.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)f15, (float)f16, (float)f17);
                }
                GL11.glRotatef((float)(180.0f - this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                tessellator.addVertexWithUV(0.0f - f13, 0.0f - f14, 0.0, f6, f11);
                tessellator.addVertexWithUV(f12 - f13, 0.0f - f14, 0.0, f8, f11);
                tessellator.addVertexWithUV(f12 - f13, 1.0f - f14, 0.0, f8, f10);
                tessellator.addVertexWithUV(0.0f - f13, 1.0f - f14, 0.0, f6, f10);
                tessellator.draw();
                GL11.glPopMatrix();
                ++k2;
            }
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void renderItemBlock(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i2, int j2) {
        if (itemstack == null) {
            return;
        }
        if (itemstack.itemID == 0) {
            System.out.println("Got a bad item ID!");
            itemstack.itemID = new Random().nextInt(64);
        }
        if (itemstack.itemID < 256 && RenderBlocks.getRenderItemType(Block.allBlocks[itemstack.itemID].getRenderType())) {
            int k2 = itemstack.itemID;
            renderengine.bindTex(renderengine.getTex("/terrain.png"));
            Block block = Block.allBlocks[k2];
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(i2 - 2), (float)(j2 + 3), (float)0.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)8.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            this.renderBlocks.renderThrownItems(block);
            GL11.glPopMatrix();
        } else if (itemstack.getIconIndex() >= 0) {
            GL11.glDisable((int)2896);
            if (itemstack.itemID < 256) {
                renderengine.bindTex(renderengine.getTex("/terrain.png"));
            } else {
                renderengine.bindTex(renderengine.getTex("/gui/items.png"));
            }
            this.renderTexturedQuad(i2, j2, itemstack.getIconIndex() % 16 * 16, itemstack.getIconIndex() / 16 * 16, 16, 16);
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
    }

    public void drawItemIntoGui(FontRenderer fontrenderer, RenderEngine renderengine, int i2, int j2, int k2, int l2, int i1) {
        if (i2 < 256 && RenderBlocks.getRenderItemType(Block.allBlocks[i2].getRenderType())) {
            int j1 = i2;
            renderengine.bindTex(renderengine.getTex("/terrain.png"));
            Block block = Block.allBlocks[j1];
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(l2 - 2), (float)(i1 + 3), (float)-3.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int l1 = 0xFFFFFF;
            float f2 = (float)(l1 >> 16 & 0xFF) / 255.0f;
            float f4 = (float)(l1 >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(l1 & 0xFF) / 255.0f;
            if (this.field_27004_a) {
                GL11.glColor4f((float)f2, (float)f4, (float)f5, (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBlocks.renderThrownItems(block);
            GL11.glPopMatrix();
        } else if (k2 >= 0) {
            GL11.glDisable((int)2896);
            if (i2 < 256) {
                renderengine.bindTex(renderengine.getTex("/terrain.png"));
            } else {
                renderengine.bindTex(renderengine.getTex("/gui/items.png"));
            }
            int k1 = 0xFFFFFF;
            float f2 = (float)(k1 >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(k1 >> 8 & 0xFF) / 255.0f;
            float f3 = (float)(k1 & 0xFF) / 255.0f;
            if (this.field_27004_a) {
                GL11.glColor4f((float)f2, (float)f1, (float)f3, (float)1.0f);
            }
            this.renderTexturedQuad(l2, i1, k2 % 16 * 16, k2 / 16 * 16, 16, 16);
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
    }

    public void renderItemIntoGUI(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i2, int j2) {
        if (itemstack == null) {
            return;
        }
        this.drawItemIntoGui(fontrenderer, renderengine, itemstack.itemID, itemstack.getItemDamage(), itemstack.getIconIndex(), i2, j2);
    }

    public void renderTextDmg(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i2, int j2) {
        if (itemstack == null) {
            return;
        }
        if (itemstack.stackSize > 1) {
            String s2 = "" + itemstack.stackSize;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            fontrenderer.drawStringWithShadow(s2, i2 + 19 - 2 - fontrenderer.getStringWidth(s2), j2 + 6 + 3, 0xFFFFFF);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        if (itemstack.itemDamage > 0) {
            int k2 = 13 - itemstack.itemDamage * 13 / itemstack.getMaxDmg();
            int l2 = 255 - itemstack.itemDamage * 255 / itemstack.getMaxDmg();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            Tessellator tessellator = Tessellator.instance;
            int i1 = 255 - l2 << 16 | l2 << 8;
            int j1 = (255 - l2) / 4 << 16 | 0x3F00;
            this.func_162_a(tessellator, i2 + 2, j2 + 13, 13, 2, 0);
            this.func_162_a(tessellator, i2 + 2, j2 + 13, 12, 1, j1);
            this.func_162_a(tessellator, i2 + 2, j2 + 13, k2, 1, i1);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void func_162_a(Tessellator tessellator, int i2, int j2, int k2, int l2, int i1) {
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(i1);
        tessellator.addVertex(i2 + 0, j2 + 0, 0.0);
        tessellator.addVertex(i2 + 0, j2 + l2, 0.0);
        tessellator.addVertex(i2 + k2, j2 + l2, 0.0);
        tessellator.addVertex(i2 + k2, j2 + 0, 0.0);
        tessellator.draw();
    }

    public void renderTexturedQuad(int i2, int j2, int k2, int l2, int i1, int j1) {
        float f2 = 0.0f;
        float f1 = 0.00390625f;
        float f22 = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(i2 + 0, j2 + j1, f2, (float)(k2 + 0) * f1, (float)(l2 + j1) * f22);
        tessellator.addVertexWithUV(i2 + i1, j2 + j1, f2, (float)(k2 + i1) * f1, (float)(l2 + j1) * f22);
        tessellator.addVertexWithUV(i2 + i1, j2 + 0, f2, (float)(k2 + i1) * f1, (float)(l2 + 0) * f22);
        tessellator.addVertexWithUV(i2 + 0, j2 + 0, f2, (float)(k2 + 0) * f1, (float)(l2 + 0) * f22);
        tessellator.draw();
    }

    public void doRender(Entity entity, double d2, double d1, double d22, float f2, float f1) {
        this.initialize((EntityItem)entity, d2, d1, d22, f2, f1);
    }
}

