/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.gui.Gui;
import com.mojang.minecraft.gui.GuiButton;
import com.mojang.minecraft.render.FontRenderer;
import com.mojang.minecraft.render.Tessellator;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreen
extends Gui {
    protected Minecraft mc;
    public int width;
    public int height;
    protected List<Object> controlList = new ArrayList<Object>();
    public boolean field_948_f = false;
    protected FontRenderer fontRenderer;
    private GuiButton field_946_a = null;
    public int scrollAmount = 0;

    public void drawScreen(int i2, int j2, float f2) {
        int k2 = 0;
        while (k2 < this.controlList.size()) {
            GuiButton guibutton = (GuiButton)this.controlList.get(k2);
            guibutton.func_561_a(this.mc, i2, j2);
            ++k2;
        }
    }

    protected void keyTyped(char c2, int i2) {
        if (i2 == 1) {
            this.mc.setCurrentScreen(null);
            this.mc.func_123_e();
        }
    }

    public static String getClipboardString() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String s2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return s2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void mouseClicked(int i2, int j2, int k2) {
        if (k2 == 0) {
            int l2 = this.controlList.size() - 1;
            while (l2 >= 0) {
                GuiButton guibutton = (GuiButton)this.controlList.get(l2);
                if (guibutton.func_562_c(this.mc, i2, j2)) {
                    this.field_946_a = guibutton;
                    this.mc.soundMGR.playSoundFX("random.click", 1.0f, 1.0f);
                    this.actionPerformed(guibutton);
                    break;
                }
                --l2;
            }
        }
    }

    protected void func_573_b(int i2, int j2, int k2) {
        if (this.field_946_a != null && k2 == 0) {
            this.field_946_a.func_559_a(i2, j2);
            this.field_946_a = null;
        }
    }

    protected void actionPerformed(GuiButton guibutton) {
    }

    public void setResolution(Minecraft minecraft, int i2, int j2) {
        this.mc = minecraft;
        this.fontRenderer = minecraft.fontRender;
        this.width = i2;
        this.height = j2;
        this.initGui();
    }

    public void initGui() {
    }

    public void func_564_d() {
        while (Mouse.next()) {
            this.func_566_e();
        }
        while (Keyboard.next()) {
            this.handleKeyboardInput();
        }
    }

    public void func_566_e() {
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            this.sendScroll(wheel);
        }
        if (Mouse.getEventButtonState()) {
            int i2 = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int k2 = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            this.mouseClicked(i2, k2, Mouse.getEventButton());
        } else {
            int j2 = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int l2 = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            this.func_573_b(j2, l2, Mouse.getEventButton());
        }
    }

    public void handleKeyboardInput() {
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == 87) {
                this.mc.func_133_h();
                return;
            }
            this.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public void updateScreen() {
    }

    public void onGuiClosed() {
    }

    public void drawDefaultBackground() {
        this.func_567_a(0);
    }

    public void func_567_a(int i2) {
        if (this.mc.mcWorld != null) {
            this.drawGradientRect(0, 0, this.width, this.height, -1072689136, -804253680);
        } else {
            this.func_579_b(i2);
        }
    }

    public void func_579_b(int i2) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTex("/dirt.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f2 = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / f2 + (float)i2);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / f2, (float)this.height / f2 + (float)i2);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / f2, 0 + i2);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0 + i2);
        tessellator.draw();
    }

    public boolean doesGuiPauseGame() {
        return true;
    }

    public void func_568_a(boolean flag, int i2) {
    }

    public void selectNextField() {
    }

    public void sendScroll(int j2) {
        if (j2 > 0) {
            j2 = 1;
        }
        if (j2 < 0) {
            j2 = -1;
        }
        this.scrollAmount -= j2;
    }
}

