/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFluids;
import com.mojang.minecraft.level.tile.BlockSponge;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockFlowing
extends BlockFluids {
    int field_460_a = 0;
    boolean[] field_459_b = new boolean[4];
    int[] field_461_c = new int[4];

    protected BlockFlowing(int i2, Material material) {
        super(i2, material);
    }

    private void func_294_j(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        world.setBlockAndMetadata(i2, j2, k2, this.blockID + 1, l2);
        world.markBlocksDirty(i2, j2, k2, i2, j2, k2);
        world.markBlockNeedsUpdate(i2, j2, k2);
    }

    public int getTextureIndex(int i2) {
        return this.blockIndexInTexture + 1;
    }

    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        int l2 = this.func_290_h(world, i2, j2, k2);
        boolean flag = true;
        if (l2 > 0) {
            int i1 = -100;
            this.field_460_a = 0;
            i1 = this.func_296_f(world, i2 - 1, j2, k2, i1);
            i1 = this.func_296_f(world, i2 + 1, j2, k2, i1);
            i1 = this.func_296_f(world, i2, j2, k2 - 1, i1);
            int j1 = (i1 = this.func_296_f(world, i2, j2, k2 + 1, i1)) + this.field_458_d;
            if (j1 >= 8 || i1 < 0) {
                j1 = -1;
            }
            if (this.func_290_h(world, i2, j2 + 1, k2) >= 0) {
                int l1 = this.func_290_h(world, i2, j2 + 1, k2);
                j1 = l1 >= 8 ? l1 : l1 + 8;
            }
            if (this.field_460_a >= 2 && this.blockMaterial == Material.water) {
                if (world.isBlockNormalCube(i2, j2 - 1, k2) || world.isWater(i2, j2 - 1, k2)) {
                    j1 = 0;
                } else if (world.getMaterialXYZ(i2, j2 - 1, k2) == this.blockMaterial && world.getBlockMetadata(i2, j2, k2) == 0 && !BlockSponge.getSurroundSponge(world, i2, j2, k2)) {
                    j1 = 0;
                }
            }
            if (this.blockMaterial == Material.lava && l2 < 8 && j1 < 8 && j1 > l2 && random.nextInt(4) != 0) {
                j1 = l2;
                flag = false;
            }
            if (j1 != l2) {
                l2 = j1;
                if (l2 < 0) {
                    world.setBlockWithNotify(i2, j2, k2, 0);
                } else {
                    world.setBlockMetadataWithNotify(i2, j2, k2, l2);
                    world.scheduleUpdateTick(i2, j2, k2, this.blockID);
                    world.notifyBlocksOfNeighborChange(i2, j2, k2, this.blockID);
                }
            } else if (flag) {
                this.func_294_j(world, i2, j2, k2);
            }
        } else {
            this.func_294_j(world, i2, j2, k2);
        }
        if (this.liquidCanDisplaceBlock(world, i2, j2 - 1, k2)) {
            if (l2 >= 8) {
                world.setBlockAndMetadataWithNotify(i2, j2 - 1, k2, this.blockID, l2);
            } else {
                world.setBlockAndMetadataWithNotify(i2, j2 - 1, k2, this.blockID, l2 + 8);
            }
        } else if (l2 >= 0 && (l2 == 0 || this.func_295_l(world, i2, j2 - 1, k2))) {
            boolean[] aflag = this.func_297_k(world, i2, j2, k2);
            int k1 = l2 + this.field_458_d;
            if (l2 >= 8) {
                k1 = 1;
            }
            if (k1 >= 8) {
                return;
            }
            if (aflag[0]) {
                this.flowIntoBlock(world, i2 - 1, j2, k2, k1);
            }
            if (aflag[1]) {
                this.flowIntoBlock(world, i2 + 1, j2, k2, k1);
            }
            if (aflag[2]) {
                this.flowIntoBlock(world, i2, j2, k2 - 1, k1);
            }
            if (aflag[3]) {
                this.flowIntoBlock(world, i2, j2, k2 + 1, k1);
            }
        }
    }

    private void flowIntoBlock(World world, int i2, int j2, int k2, int l2) {
        if (this.liquidCanDisplaceBlock(world, i2, j2, k2)) {
            int i1 = world.getBlockId(i2, j2, k2);
            if (i1 > 0) {
                if (this.blockMaterial == Material.lava) {
                    this.triggerLavaMixEffects(world, i2, j2, k2);
                } else {
                    Block.allBlocks[i1].dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
                }
            }
            world.setBlockAndMetadataWithNotify(i2, j2, k2, this.blockID, l2);
        }
    }

    private int calculateFlowCost(World world, int i2, int j2, int k2, int l2, int i1) {
        int j1 = 1000;
        int k1 = 0;
        while (k1 < 4) {
            if (!(k1 == 0 && i1 == 1 || k1 == 1 && i1 == 0 || k1 == 2 && i1 == 3 || k1 == 3 && i1 == 2)) {
                int l1 = i2;
                int i22 = j2;
                int j22 = k2;
                if (k1 == 0) {
                    --l1;
                }
                if (k1 == 1) {
                    ++l1;
                }
                if (k1 == 2) {
                    --j22;
                }
                if (k1 == 3) {
                    ++j22;
                }
                if (!(this.func_295_l(world, l1, i22, j22) || world.getMaterialXYZ(l1, i22, j22) == this.blockMaterial && world.getBlockMetadata(l1, i22, j22) == 0)) {
                    int k22;
                    if (!this.func_295_l(world, l1, i22 - 1, j22)) {
                        return l2;
                    }
                    if (l2 < 4 && (k22 = this.calculateFlowCost(world, l1, i22, j22, l2 + 1, k1)) < j1) {
                        j1 = k22;
                    }
                }
            }
            ++k1;
        }
        return j1;
    }

    private boolean[] func_297_k(World world, int i2, int j2, int k2) {
        int l2 = 0;
        while (l2 < 4) {
            this.field_461_c[l2] = 1000;
            int j1 = i2;
            int i22 = j2;
            int j22 = k2;
            if (l2 == 0) {
                --j1;
            }
            if (l2 == 1) {
                ++j1;
            }
            if (l2 == 2) {
                --j22;
            }
            if (l2 == 3) {
                ++j22;
            }
            if (!(this.func_295_l(world, j1, i22, j22) || world.getMaterialXYZ(j1, i22, j22) == this.blockMaterial && world.getBlockMetadata(j1, i22, j22) == 0)) {
                this.field_461_c[l2] = !this.func_295_l(world, j1, i22 - 1, j22) ? 0 : this.calculateFlowCost(world, j1, i22, j22, 1, l2);
            }
            ++l2;
        }
        int i1 = this.field_461_c[0];
        int k1 = 1;
        while (k1 < 4) {
            if (this.field_461_c[k1] < i1) {
                i1 = this.field_461_c[k1];
            }
            ++k1;
        }
        int l1 = 0;
        while (l1 < 4) {
            this.field_459_b[l1] = this.field_461_c[l1] == i1;
            ++l1;
        }
        return this.field_459_b;
    }

    private boolean func_295_l(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockId(i2, j2, k2);
        if (l2 == Block.doorWood.blockID || BlockSponge.getSurroundSponge(world, i2, j2, k2) || l2 == Block.doorSteel.blockID || l2 == Block.signPost.blockID || l2 == Block.ladder.blockID || l2 == Block.reed.blockID) {
            return true;
        }
        if (l2 == 0) {
            return false;
        }
        Material material = Block.allBlocks[l2].blockMaterial;
        return material.isSolidMaterial();
    }

    protected int func_296_f(World world, int i2, int j2, int k2, int l2) {
        int i1 = this.func_290_h(world, i2, j2, k2);
        if (i1 < 0) {
            return l2;
        }
        if (i1 == 0) {
            ++this.field_460_a;
        }
        if (i1 >= 8) {
            i1 = 0;
        }
        return l2 >= 0 && i1 >= l2 ? l2 : i1;
    }

    private boolean liquidCanDisplaceBlock(World world, int i2, int j2, int k2) {
        Material material = world.getMaterialXYZ(i2, j2, k2);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.lava) {
            return false;
        }
        return !this.func_295_l(world, i2, j2, k2);
    }

    public void onBlockAdded(World world, int i2, int j2, int k2) {
        super.onBlockAdded(world, i2, j2, k2);
        if (world.getBlockId(i2, j2, k2) == this.blockID) {
            world.scheduleUpdateTick(i2, j2, k2, this.blockID);
        }
    }
}

