/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFluids;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockStationary
extends BlockFluids {
    protected BlockStationary(int i2, Material material) {
        super(i2, material);
        this.setTickOnLoad(false);
        if (material == Material.lava) {
            this.setTickOnLoad(true);
        }
    }

    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        super.onNeighborBlockChange(world, i2, j2, k2, l2);
        if (world.getBlockId(i2, j2, k2) == this.blockID) {
            this.func_302_j(world, i2, j2, k2);
        }
    }

    private void func_302_j(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        world.etitingBlocks = true;
        world.setBlockAndMetadata(i2, j2, k2, this.blockID - 1, l2);
        world.markBlocksDirty(i2, j2, k2, i2, j2, k2);
        world.scheduleUpdateTick(i2, j2, k2, this.blockID - 1);
        world.etitingBlocks = false;
    }

    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        if (this.blockMaterial == Material.lava) {
            int l2 = random.nextInt(3);
            int i1 = 0;
            while (i1 < l2) {
                int j1 = world.getBlockId(i2 += random.nextInt(3) - 1, ++j2, k2 += random.nextInt(3) - 1);
                if (j1 == 0) {
                    if (this.func_301_k(world, i2 - 1, j2, k2) || this.func_301_k(world, i2 + 1, j2, k2) || this.func_301_k(world, i2, j2, k2 - 1) || this.func_301_k(world, i2, j2, k2 + 1) || this.func_301_k(world, i2, j2 - 1, k2) || this.func_301_k(world, i2, j2 + 1, k2)) {
                        world.setBlockWithNotify(i2, j2, k2, Block.fire.blockID);
                        return;
                    }
                } else if (Block.allBlocks[j1].blockMaterial.blocksMovement()) {
                    return;
                }
                ++i1;
            }
        }
    }

    private boolean func_301_k(World world, int i2, int j2, int k2) {
        return world.getMaterialXYZ(i2, j2, k2).getBurning();
    }
}

