/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockStep
extends Block {
    private boolean isDouble;

    public BlockStep(int i2, boolean flag) {
        super(i2, 6, Material.rock);
        this.isDouble = flag;
        if (!flag) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
        this.setLightOpacity(255);
    }

    public int getTextureIndex(int i2) {
        return i2 > 1 ? 5 : 6;
    }

    public boolean isOpaqueCube() {
        return this.isDouble;
    }

    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (this != Block.stairSingle) {
            return;
        }
    }

    public void onBlockAdded(World world, int i2, int j2, int k2) {
        int l2;
        if (this != Block.stairSingle) {
            super.onBlockAdded(world, i2, j2, k2);
        }
        if ((l2 = world.getBlockId(i2, j2 - 1, k2)) == BlockStep.stairSingle.blockID) {
            world.setBlockWithNotify(i2, j2, k2, 0);
            world.setBlockWithNotify(i2, j2 - 1, k2, Block.stairDouble.blockID);
        }
    }

    public int idDropped(int i2, Random random) {
        return Block.stairSingle.blockID;
    }

    public int quantityDropped(Random random) {
        if (!this.isDouble) {
            return 1;
        }
        return 2;
    }

    public boolean renderAsNormalBlock() {
        return this.isDouble;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        if (this != Block.stairSingle) {
            super.shouldSideBeRendered(iblockaccess, i2, j2, k2, l2);
        }
        if (l2 == 1) {
            return true;
        }
        if (!super.shouldSideBeRendered(iblockaccess, i2, j2, k2, l2)) {
            return false;
        }
        if (l2 == 0) {
            return true;
        }
        return iblockaccess.getBlockId(i2, j2, k2) != this.blockID;
    }
}

