/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.networknew.packet;

import com.mojang.minecraft.networknew.NetHandler;
import com.mojang.minecraft.networknew.packet.Packet0KeepAlive;
import com.mojang.minecraft.networknew.packet.Packet100OpenWindow;
import com.mojang.minecraft.networknew.packet.Packet101CloseWindow;
import com.mojang.minecraft.networknew.packet.Packet102WindowClick;
import com.mojang.minecraft.networknew.packet.Packet103SetSlot;
import com.mojang.minecraft.networknew.packet.Packet104WindowItems;
import com.mojang.minecraft.networknew.packet.Packet105UpdateProgressbar;
import com.mojang.minecraft.networknew.packet.Packet106Transaction;
import com.mojang.minecraft.networknew.packet.Packet10Flying;
import com.mojang.minecraft.networknew.packet.Packet11PlayerPosition;
import com.mojang.minecraft.networknew.packet.Packet12PlayerLook;
import com.mojang.minecraft.networknew.packet.Packet130UpdateSign;
import com.mojang.minecraft.networknew.packet.Packet131MapData;
import com.mojang.minecraft.networknew.packet.Packet13PlayerLookMove;
import com.mojang.minecraft.networknew.packet.Packet14BlockDig;
import com.mojang.minecraft.networknew.packet.Packet15Place;
import com.mojang.minecraft.networknew.packet.Packet16BlockItemSwitch;
import com.mojang.minecraft.networknew.packet.Packet17Sleep;
import com.mojang.minecraft.networknew.packet.Packet18Animation;
import com.mojang.minecraft.networknew.packet.Packet19EntityAction;
import com.mojang.minecraft.networknew.packet.Packet1Login;
import com.mojang.minecraft.networknew.packet.Packet200Statistic;
import com.mojang.minecraft.networknew.packet.Packet20NamedEntitySpawn;
import com.mojang.minecraft.networknew.packet.Packet21PickupSpawn;
import com.mojang.minecraft.networknew.packet.Packet22Collect;
import com.mojang.minecraft.networknew.packet.Packet23VehicleSpawn;
import com.mojang.minecraft.networknew.packet.Packet24MobSpawn;
import com.mojang.minecraft.networknew.packet.Packet255KickDisconnect;
import com.mojang.minecraft.networknew.packet.Packet25EntityPainting;
import com.mojang.minecraft.networknew.packet.Packet27Position;
import com.mojang.minecraft.networknew.packet.Packet28EntityVelocity;
import com.mojang.minecraft.networknew.packet.Packet29DestroyEntity;
import com.mojang.minecraft.networknew.packet.Packet2Handshake;
import com.mojang.minecraft.networknew.packet.Packet30Entity;
import com.mojang.minecraft.networknew.packet.Packet31RelEntityMove;
import com.mojang.minecraft.networknew.packet.Packet32EntityLook;
import com.mojang.minecraft.networknew.packet.Packet33RelEntityMoveLook;
import com.mojang.minecraft.networknew.packet.Packet34EntityTeleport;
import com.mojang.minecraft.networknew.packet.Packet38EntityStatus;
import com.mojang.minecraft.networknew.packet.Packet39AttachEntity;
import com.mojang.minecraft.networknew.packet.Packet3Chat;
import com.mojang.minecraft.networknew.packet.Packet40EntityMetadata;
import com.mojang.minecraft.networknew.packet.Packet4UpdateTime;
import com.mojang.minecraft.networknew.packet.Packet50PreChunk;
import com.mojang.minecraft.networknew.packet.Packet51MapChunk;
import com.mojang.minecraft.networknew.packet.Packet52MultiBlockChange;
import com.mojang.minecraft.networknew.packet.Packet53BlockChange;
import com.mojang.minecraft.networknew.packet.Packet54PlayNoteBlock;
import com.mojang.minecraft.networknew.packet.Packet5PlayerInventory;
import com.mojang.minecraft.networknew.packet.Packet60Explosion;
import com.mojang.minecraft.networknew.packet.Packet61DoorChange;
import com.mojang.minecraft.networknew.packet.Packet69PlayerScore;
import com.mojang.minecraft.networknew.packet.Packet6SpawnPosition;
import com.mojang.minecraft.networknew.packet.Packet70Bed;
import com.mojang.minecraft.networknew.packet.Packet71Weather;
import com.mojang.minecraft.networknew.packet.Packet7UseEntity;
import com.mojang.minecraft.networknew.packet.Packet8UpdateHealth;
import com.mojang.minecraft.networknew.packet.Packet9Respawn;
import com.mojang.minecraft.networknew.packet.PacketCounter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Packet {
    private static Map packetIdToClassMap = new HashMap();
    private static Map packetClassToIdMap = new HashMap();
    private static Set clientPacketIdList = new HashSet();
    private static Set serverPacketIdList = new HashSet();
    public final long creationTimeMillis = System.currentTimeMillis();
    public boolean isChunkDataPacket = false;
    private static HashMap packetStats = new HashMap();
    private static int totalPacketsCount = 0;

    static {
        Packet.addIdClassMapping(0, true, true, Packet0KeepAlive.class);
        Packet.addIdClassMapping(1, true, true, Packet1Login.class);
        Packet.addIdClassMapping(2, true, true, Packet2Handshake.class);
        Packet.addIdClassMapping(3, true, true, Packet3Chat.class);
        Packet.addIdClassMapping(4, true, false, Packet4UpdateTime.class);
        Packet.addIdClassMapping(5, true, false, Packet5PlayerInventory.class);
        Packet.addIdClassMapping(6, true, false, Packet6SpawnPosition.class);
        Packet.addIdClassMapping(7, false, true, Packet7UseEntity.class);
        Packet.addIdClassMapping(8, true, false, Packet8UpdateHealth.class);
        Packet.addIdClassMapping(9, true, true, Packet9Respawn.class);
        Packet.addIdClassMapping(10, true, true, Packet10Flying.class);
        Packet.addIdClassMapping(11, true, true, Packet11PlayerPosition.class);
        Packet.addIdClassMapping(12, true, true, Packet12PlayerLook.class);
        Packet.addIdClassMapping(13, true, true, Packet13PlayerLookMove.class);
        Packet.addIdClassMapping(14, false, true, Packet14BlockDig.class);
        Packet.addIdClassMapping(15, false, true, Packet15Place.class);
        Packet.addIdClassMapping(16, true, true, Packet16BlockItemSwitch.class);
        Packet.addIdClassMapping(17, true, false, Packet17Sleep.class);
        Packet.addIdClassMapping(18, true, true, Packet18Animation.class);
        Packet.addIdClassMapping(19, false, true, Packet19EntityAction.class);
        Packet.addIdClassMapping(20, true, false, Packet20NamedEntitySpawn.class);
        Packet.addIdClassMapping(21, true, false, Packet21PickupSpawn.class);
        Packet.addIdClassMapping(22, true, false, Packet22Collect.class);
        Packet.addIdClassMapping(23, true, false, Packet23VehicleSpawn.class);
        Packet.addIdClassMapping(24, true, false, Packet24MobSpawn.class);
        Packet.addIdClassMapping(25, true, false, Packet25EntityPainting.class);
        Packet.addIdClassMapping(27, false, true, Packet27Position.class);
        Packet.addIdClassMapping(28, true, false, Packet28EntityVelocity.class);
        Packet.addIdClassMapping(29, true, false, Packet29DestroyEntity.class);
        Packet.addIdClassMapping(30, true, false, Packet30Entity.class);
        Packet.addIdClassMapping(31, true, false, Packet31RelEntityMove.class);
        Packet.addIdClassMapping(32, true, false, Packet32EntityLook.class);
        Packet.addIdClassMapping(33, true, false, Packet33RelEntityMoveLook.class);
        Packet.addIdClassMapping(34, true, false, Packet34EntityTeleport.class);
        Packet.addIdClassMapping(38, true, false, Packet38EntityStatus.class);
        Packet.addIdClassMapping(39, true, false, Packet39AttachEntity.class);
        Packet.addIdClassMapping(40, true, false, Packet40EntityMetadata.class);
        Packet.addIdClassMapping(50, true, false, Packet50PreChunk.class);
        Packet.addIdClassMapping(51, true, false, Packet51MapChunk.class);
        Packet.addIdClassMapping(52, true, false, Packet52MultiBlockChange.class);
        Packet.addIdClassMapping(53, true, false, Packet53BlockChange.class);
        Packet.addIdClassMapping(54, true, false, Packet54PlayNoteBlock.class);
        Packet.addIdClassMapping(60, true, false, Packet60Explosion.class);
        Packet.addIdClassMapping(61, true, false, Packet61DoorChange.class);
        Packet.addIdClassMapping(69, true, true, Packet69PlayerScore.class);
        Packet.addIdClassMapping(70, true, false, Packet70Bed.class);
        Packet.addIdClassMapping(71, true, false, Packet71Weather.class);
        Packet.addIdClassMapping(100, true, false, Packet100OpenWindow.class);
        Packet.addIdClassMapping(101, true, true, Packet101CloseWindow.class);
        Packet.addIdClassMapping(102, false, true, Packet102WindowClick.class);
        Packet.addIdClassMapping(103, true, false, Packet103SetSlot.class);
        Packet.addIdClassMapping(104, true, false, Packet104WindowItems.class);
        Packet.addIdClassMapping(105, true, false, Packet105UpdateProgressbar.class);
        Packet.addIdClassMapping(106, true, true, Packet106Transaction.class);
        Packet.addIdClassMapping(130, true, true, Packet130UpdateSign.class);
        Packet.addIdClassMapping(131, true, false, Packet131MapData.class);
        Packet.addIdClassMapping(200, true, false, Packet200Statistic.class);
        Packet.addIdClassMapping(255, true, true, Packet255KickDisconnect.class);
    }

    static void addIdClassMapping(int i2, boolean flag, boolean flag1, Class class1) {
        if (packetIdToClassMap.containsKey(i2)) {
            throw new IllegalArgumentException("Duplicate packet id:" + i2);
        }
        if (packetClassToIdMap.containsKey(class1)) {
            throw new IllegalArgumentException("Duplicate packet class:" + class1);
        }
        packetIdToClassMap.put(i2, class1);
        packetClassToIdMap.put(class1, i2);
        if (flag) {
            clientPacketIdList.add(i2);
        }
        if (flag1) {
            serverPacketIdList.add(i2);
        }
    }

    public static Packet getNewPacket(int i2) {
        Class class1;
        block3: {
            try {
                class1 = (Class)packetIdToClassMap.get(i2);
                if (class1 != null) break block3;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Skipping packet with id " + i2);
                return null;
            }
        }
        return (Packet)class1.newInstance();
    }

    public final int getPacketId() {
        return (Integer)packetClassToIdMap.get(this.getClass());
    }

    public static Packet readPacket(DataInputStream datainputstream, boolean flag) throws IOException {
        Packet packet;
        int i2;
        block7: {
            i2 = 0;
            packet = null;
            try {
                i2 = datainputstream.read();
                if (i2 != -1) break block7;
                return null;
            }
            catch (EOFException eofexception) {
                System.out.println("Reached end of stream");
                return null;
            }
        }
        if (flag && !serverPacketIdList.contains(i2) || !flag && !clientPacketIdList.contains(i2)) {
            System.out.println(datainputstream.read());
            System.out.println(datainputstream.read());
            System.out.println(datainputstream.read());
            System.out.println(datainputstream.read());
            throw new IOException("Bad packet id " + i2);
        }
        packet = Packet.getNewPacket(i2);
        if (packet == null) {
            throw new IOException("Bad packet id " + i2);
        }
        packet.readPacketData(datainputstream);
        PacketCounter packetcounter = (PacketCounter)packetStats.get(i2);
        if (packetcounter == null) {
            packetcounter = new PacketCounter(null);
            packetStats.put(i2, packetcounter);
        }
        packetcounter.addPacket(packet.getPacketSize());
        if (++totalPacketsCount % 1000 != 0) {
            // empty if block
        }
        return packet;
    }

    public static void writePacket(Packet packet, DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.write(packet.getPacketId());
        packet.writePacketData(dataoutputstream);
    }

    public static void writeString(String s2, DataOutputStream dataoutputstream) throws IOException {
        if (s2.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        dataoutputstream.writeShort(s2.length());
        dataoutputstream.writeChars(s2);
    }

    public static String readString(DataInputStream datainputstream, int i2) throws IOException {
        int word0 = datainputstream.readShort();
        StringBuilder stringbuilder1 = new StringBuilder();
        if (word0 > i2) {
            throw new IOException("Received string length longer than maximum allowed (" + word0 + " > " + i2 + ")");
        }
        if (word0 < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        StringBuilder stringbuilder = new StringBuilder();
        int j2 = 0;
        while (j2 < word0) {
            stringbuilder.append(datainputstream.readChar());
            ++j2;
        }
        return stringbuilder.toString();
    }

    public abstract void readPacketData(DataInputStream var1) throws IOException;

    public abstract void writePacketData(DataOutputStream var1) throws IOException;

    public abstract void processPacket(NetHandler var1);

    public abstract int getPacketSize();

    static Class _mthclass$(String s2) {
        try {
            return Class.forName(s2);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }
}

