/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.networknew.packet;

import com.mojang.minecraft.level.chunk.ChunkPosition;
import com.mojang.minecraft.networknew.NetHandler;
import com.mojang.minecraft.networknew.packet.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class Packet60Explosion
extends Packet {
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public float explosionSize;
    public Set destroyedBlockPositions;

    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.explosionX = datainputstream.readDouble();
        this.explosionY = datainputstream.readDouble();
        this.explosionZ = datainputstream.readDouble();
        this.explosionSize = datainputstream.readFloat();
        int i2 = datainputstream.readInt();
        this.destroyedBlockPositions = new HashSet();
        int j2 = (int)this.explosionX;
        int k2 = (int)this.explosionY;
        int l2 = (int)this.explosionZ;
        int i1 = 0;
        while (i1 < i2) {
            int j1 = datainputstream.readByte() + j2;
            int k1 = datainputstream.readByte() + k2;
            int l1 = datainputstream.readByte() + l2;
            this.destroyedBlockPositions.add(new ChunkPosition(j1, k1, l1));
            ++i1;
        }
    }

    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeDouble(this.explosionX);
        dataoutputstream.writeDouble(this.explosionY);
        dataoutputstream.writeDouble(this.explosionZ);
        dataoutputstream.writeFloat(this.explosionSize);
        dataoutputstream.writeInt(this.destroyedBlockPositions.size());
        int i2 = (int)this.explosionX;
        int j2 = (int)this.explosionY;
        int k2 = (int)this.explosionZ;
        for (ChunkPosition chunkposition : this.destroyedBlockPositions) {
            int l2 = chunkposition.x - i2;
            int i1 = chunkposition.y - j2;
            int j1 = chunkposition.z - k2;
            dataoutputstream.writeByte(l2);
            dataoutputstream.writeByte(i1);
            dataoutputstream.writeByte(j1);
        }
    }

    public void processPacket(NetHandler nethandler) {
        nethandler.func_12245_a(this);
    }

    public int getPacketSize() {
        return 32 + this.destroyedBlockPositions.size() * 3;
    }
}

