/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.player.inventory;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.player.inventory.Container;

public class InventoryCrafting
implements IInventory {
    private ItemStack[] stackList;
    private int nbrSlots;
    private Container eventHandler;

    public InventoryCrafting(Container container, int i2, int j2) {
        int k2 = i2 * j2;
        this.stackList = new ItemStack[k2];
        this.eventHandler = container;
        this.nbrSlots = i2;
    }

    public int getSizeInventory() {
        return this.stackList.length;
    }

    public ItemStack getStackInSlot(int i2) {
        if (i2 >= this.getSizeInventory()) {
            return null;
        }
        return this.stackList[i2];
    }

    public ItemStack func_21103_b(int i2, int j2) {
        if (i2 < 0 || i2 >= this.nbrSlots) {
            return null;
        }
        int k2 = i2 + j2 * this.nbrSlots;
        return this.getStackInSlot(k2);
    }

    public String getInvName() {
        return "Crafting";
    }

    public ItemStack decrStackSize(int i2, int j2) {
        if (this.stackList[i2] != null) {
            if (this.stackList[i2].stackSize <= j2) {
                ItemStack itemstack = this.stackList[i2];
                this.stackList[i2] = null;
                this.eventHandler.onCraftMatrixChanged(this);
                return itemstack;
            }
            ItemStack itemstack1 = this.stackList[i2].splitStack(j2);
            if (this.stackList[i2].stackSize == 0) {
                this.stackList[i2] = null;
            }
            this.eventHandler.onCraftMatrixChanged(this);
            return itemstack1;
        }
        return null;
    }

    public void setInventorySlotContents(int i2, ItemStack itemstack) {
        this.stackList[i2] = itemstack;
        this.eventHandler.onCraftMatrixChanged(this);
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void onInventoryChanged() {
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return true;
    }
}

