/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.util;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.util.Session;
import com.mojang.minecraft.util.auth.GameProfile;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.TreeMap;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import sun.net.www.protocol.http.HttpURLConnection;

public class ThreadFetchSkins
extends Thread {
    public static TreeMap<String, String> customCapes = new TreeMap();
    public static TreeMap<String, String> customColors = new TreeMap();
    public static TreeMap<String, String> customParticles = new TreeMap();
    private EntityPlayer thePlayer;
    private GameProfile theProfile;
    private Minecraft mc;
    private UUID id;
    private String name;

    public ThreadFetchSkins() {
        this.setName("Cape data download thread");
        this.setDaemon(true);
    }

    private static String getSkinFrom(String uuid) throws IOException, JSONException {
        String inputLine;
        String url = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid;
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.getResponseCode();
        BufferedReader in2 = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in2.readLine()) != null) {
            response.append(inputLine);
        }
        in2.close();
        JSONObject json = new JSONObject(response.toString());
        JSONArray json2 = json.getJSONArray("properties");
        return new JSONObject(new String(Base64.decode(json2.getJSONObject(0).getString("value")))).getJSONObject("textures").getJSONObject("SKIN").getString("url");
    }

    private static String getCapeFrom(String uuid) throws IOException, JSONException {
        String inputLine;
        String url = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid;
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.getResponseCode();
        BufferedReader in2 = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in2.readLine()) != null) {
            response.append(inputLine);
        }
        in2.close();
        JSONObject json = new JSONObject(response.toString());
        JSONArray json2 = json.getJSONArray("properties");
        return new JSONObject(new String(Base64.decode(json2.getJSONObject(0).getString("value")))).getJSONObject("textures").getJSONObject("CAPE").getString("url");
    }

    public void run() {
        String[] textures = new String[2];
        try {
            textures = this.getPostUrl(this.thePlayer.playerName);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.thePlayer.skinURL = textures[0];
        this.thePlayer.cloakURL = textures[1];
        this.thePlayer.worldObj.obtainEntitySkin(this.thePlayer);
    }

    public void grabCustomCapes() {
        try {
            URL capeDownload = new URL("http://androdome.com/nsss/capes.txt");
            File capeFile = File.createTempFile("nsss-capes", null);
            HttpURLConnection con = (HttpURLConnection)capeDownload.openConnection();
            con.getResponseCode();
            BufferedReader in2 = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String line = in2.readLine();
            customCapes.clear();
            while (line != null) {
                String[] data = line.split(";");
                customCapes.put(data[0], data[2]);
                customColors.put(data[0], data[3]);
                customParticles.put(data[0], data[4]);
                line = in2.readLine();
            }
            in2.close();
            if (capeFile.exists()) {
                try {
                    capeFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (customCapes.get(this.name) != null) {
                this.thePlayer.cloakURL = customCapes.get(this.name);
                if (!customColors.get(this.name).equals("n")) {
                    this.thePlayer.chatColor = customColors.get(this.name);
                }
                this.thePlayer.particleEffect = customParticles.get(this.name);
                this.thePlayer.worldObj.obtainEntitySkin(this.thePlayer);
            }
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
            return;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return;
        }
    }

    public void start(EntityPlayer player, GameProfile profile, Minecraft minecraft) {
        this.thePlayer = player;
        this.theProfile = profile;
        this.name = profile.getName();
        this.mc = minecraft;
        try {
            this.id = this.getUUIDFromName(player.playerName);
        }
        catch (JSONException e2) {
            System.out.println("id fetch failed due to JSON error");
            e2.printStackTrace();
        }
        catch (IOException e3) {
            System.out.println("id fetch failed due to IO error");
            e3.printStackTrace();
        }
        super.start();
    }

    public String[] getPostUrl(String username) throws IOException, JSONException {
        String cape;
        String inputLine;
        String[] textures = new String[2];
        String url = "https://api.mojang.com/users/profiles/minecraft/" + username;
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.getResponseCode();
        BufferedReader in2 = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in2.readLine()) != null) {
            response.append(inputLine);
        }
        in2.close();
        JSONObject json = new JSONObject(response.toString());
        String skin = ThreadFetchSkins.getSkinFrom(json.getString("id"));
        try {
            cape = ThreadFetchSkins.getCapeFrom(json.getString("id"));
        }
        catch (Exception ex2) {
            this.grabCustomCapes();
            cape = this.thePlayer.cloakURL;
        }
        textures[0] = skin;
        textures[1] = cape;
        return textures;
    }

    public UUID getUUIDFromName(String username) throws IOException, JSONException {
        String inputLine;
        String url = "https://api.mojang.com/users/profiles/minecraft/" + username;
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.getResponseCode();
        BufferedReader in2 = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in2.readLine()) != null) {
            response.append(inputLine);
        }
        in2.close();
        JSONObject json = new JSONObject(response.toString());
        String suuid = json.getString("id");
        Session cfr_ignored_0 = this.mc.session;
        UUID uuid = Session.fromString(suuid);
        return uuid;
    }

    public void start(String username, EntityPlayer player, Minecraft minecraft) {
        this.name = username;
        this.thePlayer = player;
        this.mc = minecraft;
        try {
            this.id = this.getUUIDFromName(username);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
            this.id = null;
        }
        catch (IOException e3) {
            e3.printStackTrace();
            this.id = null;
        }
        super.start();
    }

    public void start(UUID uuid, String username, EntityPlayer player, Minecraft minecraft) {
        this.id = uuid;
        this.name = username;
        this.thePlayer = player;
        this.mc = minecraft;
        super.start();
    }
}

