/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.crafting;

import com.mojang.minecraft.crafting.IRecipe;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.player.inventory.InventoryCrafting;

public class ShapedRecipes
implements IRecipe {
    private int recipeWidth;
    private int recipeHeight;
    private ItemStack[] recipeItems;
    private ItemStack recipeOutput;
    public final int recipeOutputItemID;

    public ShapedRecipes(int i, int j, ItemStack[] aitemstack, ItemStack itemstack) {
        this.recipeOutputItemID = itemstack.itemID;
        this.recipeWidth = i;
        this.recipeHeight = j;
        this.recipeItems = aitemstack;
        this.recipeOutput = itemstack;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public boolean matches(InventoryCrafting inventorycrafting) {
        int i = 0;
        while (i <= 3 - this.recipeWidth) {
            int j = 0;
            while (j <= 3 - this.recipeHeight) {
                if (this.func_21137_a(inventorycrafting, i, j, true)) {
                    return true;
                }
                if (this.func_21137_a(inventorycrafting, i, j, false)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean func_21137_a(InventoryCrafting inventorycrafting, int i, int j, boolean flag) {
        int k = 0;
        while (k < 3) {
            int l = 0;
            while (l < 3) {
                ItemStack itemstack1;
                int i1 = k - i;
                int j1 = l - j;
                ItemStack itemstack = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    itemstack = flag ? this.recipeItems[this.recipeWidth - i1 - 1 + j1 * this.recipeWidth] : this.recipeItems[i1 + j1 * this.recipeWidth];
                }
                if ((itemstack1 = inventorycrafting.func_21103_b(k, l)) != null || itemstack != null) {
                    if (itemstack1 == null && itemstack != null || itemstack1 != null && itemstack == null) {
                        return false;
                    }
                    if (itemstack.itemID != itemstack1.itemID) {
                        return false;
                    }
                    if (itemstack.getItemDamage() != -1 && itemstack.getItemDamage() != itemstack1.getItemDamage()) {
                        return false;
                    }
                }
                ++l;
            }
            ++k;
        }
        return true;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        return new ItemStack(this.recipeOutput.itemID, this.recipeOutput.stackSize, this.recipeOutput.getItemDamage());
    }

    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }
}

