/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityClientPlayerMP;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.StepSound;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;
import java.util.List;

public class EntityLiving
extends Entity {
    int spongeArmor;
    int airQuart;
    public int maxHealth;
    public float field_738_k;
    public float field_737_l;
    public float field_736_m;
    public float renderYawOffset;
    public float prevRenderYawOffset;
    public float field_733_p;
    public float field_732_q;
    public float field_731_r;
    public float unknownFloat;
    protected boolean field_729_t;
    protected String texture;
    protected boolean field_727_v;
    protected float field_726_w;
    protected String field_725_x;
    protected float field_724_y;
    protected int scoreYield;
    protected float field_721_A;
    public boolean isMultiplayerEntity;
    public float prevSwingProgress;
    public float swingProgress;
    public int health;
    public int prevHealth;
    private int field_748_a;
    public int hurtTime;
    public int maxHurtTime;
    public float attackedAtYaw;
    public int deathTime;
    public int attackTime;
    public float lookPitch;
    public float field_709_M;
    protected boolean dead;
    public int entityAge;
    public float field_706_P;
    public float field_705_Q;
    public float limbSwingAmount;
    public float limbSwing;
    private int field_747_b;
    private double field_746_c;
    private double field_745_d;
    private double field_744_e;
    private double field_743_f;
    private double field_742_g;
    float field_702_T;
    protected int field_701_U;
    protected float movingLeftRight;
    protected float movingForwardBack;
    protected float field_698_X;
    protected boolean isJumping;
    public boolean isRunning;
    protected float field_696_Z;
    protected float move_speed;
    public Entity ridingEntity;
    private int field_740_i;
    public boolean isCreative;

    public EntityLiving(World world) {
        super(world);
        this.airQuart = this.spongeArmor;
        this.maxHealth = 20;
        this.renderYawOffset = 0.0f;
        this.prevRenderYawOffset = 0.0f;
        this.field_729_t = true;
        this.texture = "/char.png";
        this.field_727_v = true;
        this.field_726_w = 0.0f;
        this.field_725_x = null;
        this.field_724_y = 1.0f;
        this.scoreYield = 0;
        this.field_721_A = 0.0f;
        this.isMultiplayerEntity = false;
        this.attackedAtYaw = 0.0f;
        this.deathTime = 0;
        this.attackTime = 0;
        this.dead = false;
        this.entityAge = -1;
        this.field_706_P = (float)(Math.random() * (double)0.9f + (double)0.1f);
        this.field_702_T = 0.0f;
        this.field_701_U = 0;
        this.isJumping = false;
        this.isRunning = false;
        this.field_696_Z = 0.0f;
        this.move_speed = 0.7f;
        this.field_740_i = 0;
        this.health = 10;
        this.preventEntitySpawning = true;
        this.field_736_m = (float)(Math.random() + 1.0) * 0.01f;
        this.setPosition(this.posX, this.posY, this.posZ);
        this.field_738_k = (float)Math.random() * 12398.0f;
        this.rotationYaw = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.field_737_l = 1.0f;
        this.stepHeight = 0.5f;
        this.isCreative = false;
        this.leatherArmor = 0;
        this.goldArmor = 0;
        this.chainArmor = 0;
        this.steelArmor = 0;
        this.diamondArmor = 0;
    }

    protected void entityInit() {
    }

    protected void damageEntity(int i) {
        this.health -= i;
    }

    protected boolean canEntityBeSeen(Entity entity) {
        return this.worldObj.rayTraceBlocks(Vec3D.createVector(this.posX, this.posY + (double)this.func_373_s(), this.posZ), Vec3D.createVector(entity.posX, entity.posY + (double)entity.func_373_s(), entity.posZ)) == null;
    }

    public String getEntityTexture() {
        return this.texture;
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public boolean canBePushed() {
        return !this.isDead;
    }

    protected float func_373_s() {
        return this.height * 0.85f;
    }

    public int func_421_b() {
        return 80;
    }

    public void onEntityUpdate() {
        this.prevSwingProgress = this.swingProgress;
        super.onEntityUpdate();
        if (this.rand.nextInt(1000) < this.field_748_a++) {
            this.field_748_a = -this.func_421_b();
            String s = this.idleSound();
            if (s != null) {
                this.worldObj.playSoundAtEntity(this, s, this.func_413_f(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            }
        }
        if (this.isEntityAlive() && this.isEntityInsideOpaqueBlock()) {
            this.attackEntityFrom(null, 1);
        }
        if (this.worldObj.multiplayerWorld) {
            this.fire = 0;
        }
        if (this.isEntityAlive() && this.isInsideOfMaterial(Material.water)) {
            if (this.spongeArmor > 0 && this.airQuart > 0) {
                --this.airQuart;
            } else if (this.spongeArmor == 0 || this.airQuart == 0) {
                --this.air;
                this.airQuart = this.spongeArmor;
            }
            if (this.air == -20) {
                this.air = 0;
                int i = 0;
                while (i < 8) {
                    float f = this.rand.nextFloat() - this.rand.nextFloat();
                    float f1 = this.rand.nextFloat() - this.rand.nextFloat();
                    float f2 = this.rand.nextFloat() - this.rand.nextFloat();
                    this.worldObj.spawnParticle("bubble", this.posX + (double)f, this.posY + (double)f1, this.posZ + (double)f2, this.motionX, this.motionY, this.motionZ);
                    ++i;
                }
                this.attackEntityFrom(null, 2);
            }
            this.fire = 0;
        } else {
            this.air = this.maxAir;
        }
        this.lookPitch = this.field_709_M;
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.heartsLife > 0) {
            --this.heartsLife;
        }
        if (this.health <= 0) {
            ++this.deathTime;
            if (this.deathTime > 20 && !(this instanceof EntityClientPlayerMP)) {
                this.func_436_D();
                this.setEntityDead();
                int j = 0;
                while (j < 20) {
                    double d = this.rand.nextGaussian() * 0.02;
                    double d1 = this.rand.nextGaussian() * 0.02;
                    double d2 = this.rand.nextGaussian() * 0.02;
                    this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
                    ++j;
                }
            }
        }
        this.unknownFloat = this.field_731_r;
        this.prevRenderYawOffset = this.renderYawOffset;
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
    }

    public void func_415_z() {
        int i = 0;
        while (i < 20) {
            double d = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            double d3 = 10.0;
            this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - d * d3, this.posY + (double)(this.rand.nextFloat() * this.height) - d1 * d3, this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - d2 * d3, d, d1, d2);
            ++i;
        }
    }

    public void updateRidden() {
        super.updateRidden();
        this.field_733_p = this.field_732_q;
        this.field_732_q = 0.0f;
    }

    public void setPositionAndRotation2(double d, double d1, double d2, float f, float f1, int i) {
        this.yOffset = 0.0f;
        this.field_746_c = d;
        this.field_745_d = d1;
        this.field_744_e = d2;
        this.field_743_f = f;
        this.field_742_g = f1;
        this.field_747_b = i;
    }

    public float getEyeHeight() {
        return this.yOffset;
    }

    public void onUpdate() {
        boolean flag;
        super.onUpdate();
        this.onLivingUpdate();
        double d = this.posX - this.prevPosX;
        double d1 = this.posZ - this.prevPosZ;
        float f = MathHelper.sqrt_double(d * d + d1 * d1);
        float f1 = this.renderYawOffset;
        float f2 = 0.0f;
        this.field_733_p = this.field_732_q;
        float f3 = 0.0f;
        if (f > 0.05f) {
            f3 = 1.0f;
            f2 = f * 3.0f;
            f1 = (float)Math.atan2(d1, d) * 180.0f / 3.141593f - 90.0f;
        }
        if (this.swingProgress > 0.0f) {
            f1 = this.rotationYaw;
        }
        if (!this.onGround) {
            f3 = 0.0f;
        }
        this.field_732_q += (f3 - this.field_732_q) * 0.3f;
        float f4 = f1 - this.renderYawOffset;
        while (f4 < -180.0f) {
            f4 += 360.0f;
        }
        while (f4 >= 180.0f) {
            f4 -= 360.0f;
        }
        this.renderYawOffset += f4 * 0.3f;
        float f5 = this.rotationYaw - this.renderYawOffset;
        while (f5 < -180.0f) {
            f5 += 360.0f;
        }
        while (f5 >= 180.0f) {
            f5 -= 360.0f;
        }
        boolean bl = flag = f5 < -90.0f || f5 >= 90.0f;
        if (f5 < -75.0f) {
            f5 = -75.0f;
        }
        if (f5 >= 75.0f) {
            f5 = 75.0f;
        }
        this.renderYawOffset = this.rotationYaw - f5;
        if (f5 * f5 > 2500.0f) {
            this.renderYawOffset += f5 * 0.2f;
        }
        if (flag) {
            f2 *= -1.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset < -180.0f) {
            this.prevRenderYawOffset -= 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset >= 180.0f) {
            this.prevRenderYawOffset += 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        this.field_731_r += f2;
    }

    protected void setSize(float f, float f1) {
        super.setSize(f, f1);
    }

    public void performHurtAnimation() {
        this.maxHurtTime = 10;
        this.hurtTime = 10;
        this.attackedAtYaw = 0.0f;
    }

    public void handleHealthUpdate(byte byte0) {
        if (byte0 == 2) {
            this.limbSwingAmount = 1.5f;
            this.heartsLife = this.maxHealth;
            this.maxHurtTime = 10;
            this.hurtTime = 10;
            this.attackedAtYaw = 0.0f;
            this.worldObj.playSoundAtEntity(this, this.hurtSound(), 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.attackEntityFrom(null, 0);
        } else if (byte0 == 3) {
            this.worldObj.playSoundAtEntity(this, this.deathSound(), 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.health = 0;
            this.onDeath(null);
        } else {
            super.handleHealthUpdate(byte0);
        }
    }

    public void heal(int i) {
        if (this.health <= 0) {
            return;
        }
        this.health += i;
        if (this.health > 20) {
            this.health = 20;
        }
        this.heartsLife = this.maxHealth / 2;
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        this.attackedAtYaw = 0.0f;
        if (entity != null) {
            double d = entity.posX - this.posX;
            double d1 = entity.posZ - this.posZ;
            while (d * d + d1 * d1 < 1.0E-4) {
                d = (Math.random() - Math.random()) * 0.01;
                d1 = (Math.random() - Math.random()) * 0.01;
            }
            this.attackedAtYaw = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - this.rotationYaw;
            this.func_434_a(entity, i, d, d1);
        } else {
            this.attackedAtYaw = (int)(Math.random() * 2.0) * 180;
        }
        if (this.worldObj.multiplayerWorld) {
            return false;
        }
        this.field_701_U = 0;
        if (this.health <= 0 || this.isCreative) {
            return false;
        }
        this.limbSwingAmount = 1.5f;
        if ((float)this.heartsLife > (float)this.maxHealth / 2.0f) {
            if (this.prevHealth - i >= this.health) {
                return false;
            }
            this.health = this.prevHealth - i;
        } else {
            this.prevHealth = this.health;
            this.heartsLife = this.maxHealth;
            this.health -= i;
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
        if (this.health <= 0) {
            this.worldObj.playSoundAtEntity(this, this.deathSound(), this.func_413_f(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.onDeath(entity);
        } else {
            this.worldObj.playSoundAtEntity(this, this.hurtSound(), this.func_413_f(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
        return true;
    }

    protected float func_413_f() {
        return 1.0f;
    }

    protected String idleSound() {
        return null;
    }

    protected String hurtSound() {
        return "random.hurt";
    }

    protected String deathSound() {
        return "random.hurt";
    }

    public void func_434_a(Entity entity, int i, double d, double d1) {
        float f = MathHelper.sqrt_double(d * d + d1 * d1);
        float f1 = 0.4f;
        this.motionX /= 2.0;
        this.motionY /= 2.0;
        this.motionZ /= 2.0;
        this.motionX -= d / (double)f * (double)f1;
        this.motionY += (double)0.4f;
        this.motionZ -= d1 / (double)f * (double)f1;
        if (this.motionY > (double)0.4f) {
            this.motionY = 0.4f;
        }
    }

    public void onDeath(Entity entity) {
        if (this.scoreYield > 0 && entity != null) {
            entity.addToPlayerScore(this, this.scoreYield);
        }
        this.dead = true;
        int i = this.deathDropItem();
        if (i > 0 && !this.worldObj.multiplayerWorld) {
            int j = this.rand.nextInt(3);
            int k = 0;
            while (k < j) {
                this.dropItem(i, 1);
                ++k;
            }
        }
    }

    protected int deathDropItem() {
        return 0;
    }

    protected void fall(float fallDist) {
        int damage = (int)Math.ceil(fallDist - 3.0f) - this.goldArmor * 2;
        if (damage > 0) {
            this.attackEntityFrom(null, damage);
            int j = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset), MathHelper.floor_double(this.posZ));
            if (j > 0) {
                StepSound stepsound = Block.allBlocks[j].stepSound;
                this.worldObj.playSoundAtEntity(this, stepsound.func_1145_d(), stepsound.getVolume() * 0.5f, stepsound.getPitch() * 0.75f);
            }
        }
    }

    public void func_435_b(float leftRight, float forwardBack) {
        if (this.handleWaterMovement()) {
            double d = this.posY;
            this.moveFlying(leftRight, forwardBack, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.8f;
            this.motionY *= (double)0.8f;
            this.motionZ *= (double)0.8f;
            this.motionY -= 0.02;
            this.motionX += this.motionX * ((double)(this.spongeArmor / 4) * 0.15);
            this.motionZ += this.motionZ * ((double)(this.spongeArmor / 4) * 0.15);
            if (this.isCollidedHorizionally && this.isOffsetPositionInLiquid(this.motionX, this.motionY + (double)0.6f - this.posY + d, this.motionZ)) {
                this.motionY = 0.3f;
            }
        } else if (this.handleLavaMovement()) {
            double d1 = this.posY;
            this.moveFlying(leftRight, forwardBack, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
            this.motionY -= 0.02;
            if (this.isCollidedHorizionally && this.isOffsetPositionInLiquid(this.motionX, this.motionY + (double)0.6f - this.posY + d1, this.motionZ)) {
                this.motionY = 0.3f;
            }
        } else {
            float f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.5460001f;
                int i = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
                if (i > 0) {
                    f2 = Block.allBlocks[i].slipperiness * 0.91f;
                }
            }
            float f3 = 0.1627714f / (f2 * f2 * f2);
            this.moveFlying(leftRight, forwardBack, this.onGround ? 0.1f * f3 : 0.02f);
            f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.5460001f;
                int j = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
                if (j > 0) {
                    f2 = Block.allBlocks[j].slipperiness * 0.91f;
                }
            }
            if (this.onLadder()) {
                this.fallDistance = 0.0f;
                if (this.motionY < -0.15) {
                    this.motionY = -0.15;
                }
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            if (this.isCollidedHorizionally && this.onLadder()) {
                this.motionY = 0.2;
            }
            this.motionY -= 0.08;
            this.motionY *= (double)0.98f;
            this.motionX *= (double)f2;
            this.motionZ *= (double)f2;
        }
        this.field_705_Q = this.limbSwingAmount;
        double d2 = this.posX - this.prevPosX;
        double d3 = this.posZ - this.prevPosZ;
        float f4 = MathHelper.sqrt_double(d2 * d2 + d3 * d3) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.limbSwingAmount += (f4 - this.limbSwingAmount) * 0.4f;
        this.limbSwing += this.limbSwingAmount;
    }

    public boolean onLadder() {
        int k;
        int j;
        int i = MathHelper.floor_double(this.posX);
        return this.worldObj.getBlockId(i, j = MathHelper.floor_double(this.boundingBox.minY), k = MathHelper.floor_double(this.posZ)) == Block.ladder.blockID || this.worldObj.getBlockId(i, j + 1, k) == Block.ladder.blockID;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("Health", (short)this.health);
        nbttagcompound.setShort("HurtTime", (short)this.hurtTime);
        nbttagcompound.setShort("DeathTime", (short)this.deathTime);
        nbttagcompound.setShort("AttackTime", (short)this.attackTime);
        nbttagcompound.setBool("isCreative", this.isCreative);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.health = nbttagcompound.getShort("Health");
        if (!nbttagcompound.hasKey("Health")) {
            this.health = 10;
        }
        this.hurtTime = nbttagcompound.getShort("HurtTime");
        this.deathTime = nbttagcompound.getShort("DeathTime");
        this.attackTime = nbttagcompound.getShort("AttackTime");
        this.isCreative = nbttagcompound.getBoolean("isCreative");
    }

    public boolean isEntityAlive() {
        return !this.isDead && this.health > 0;
    }

    public void onLivingUpdate() {
        if (this.field_747_b > 0) {
            double d = this.posX + (this.field_746_c - this.posX) / (double)this.field_747_b;
            double d1 = this.posY + (this.field_745_d - this.posY) / (double)this.field_747_b;
            double d2 = this.posZ + (this.field_744_e - this.posZ) / (double)this.field_747_b;
            double d3 = this.field_743_f - (double)this.rotationYaw;
            while (d3 < -180.0) {
                d3 += 360.0;
            }
            while (d3 >= 180.0) {
                d3 -= 360.0;
            }
            this.rotationYaw = (float)((double)this.rotationYaw + d3 / (double)this.field_747_b);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.field_742_g - (double)this.rotationPitch) / (double)this.field_747_b);
            --this.field_747_b;
            this.setPosition(d, d1, d2);
            this.setRotation(this.rotationYaw, this.rotationPitch);
        }
        if (this.health <= 0) {
            this.isJumping = false;
            this.movingLeftRight = 0.0f;
            this.movingForwardBack = 0.0f;
            this.field_698_X = 0.0f;
        } else if (!this.isMultiplayerEntity) {
            this.updateEntityActionState();
        }
        boolean flag = this.handleWaterMovement();
        boolean flag1 = this.handleLavaMovement();
        if (this.isJumping) {
            if (flag) {
                this.motionY += (double)0.04f;
            } else if (flag1) {
                this.motionY += (double)0.04f;
            } else if (this.onGround) {
                this.func_424_C();
            }
        }
        this.movingLeftRight *= 0.98f;
        this.movingForwardBack *= 0.98f;
        this.field_698_X *= 0.9f;
        this.func_435_b(this.movingLeftRight, this.movingForwardBack);
        List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                Entity entity = list.get(i);
                if (entity.canBePushed()) {
                    entity.applyEntityCollision(this);
                }
                ++i;
            }
        }
    }

    protected void func_424_C() {
        this.motionY = 0.42f;
    }

    protected void updateEntityActionState() {
        ++this.field_701_U;
        EntityPlayer entityplayer = this.worldObj.getPlayerEntityAtHeight(this, -1.0);
        if (entityplayer != null) {
            double d = entityplayer.posX - this.posX;
            double d1 = entityplayer.posY - this.posY;
            double d2 = entityplayer.posZ - this.posZ;
            double d3 = d * d + d1 * d1 + d2 * d2;
            if (d3 > 16384.0) {
                this.setEntityDead();
            }
            if (this.field_701_U > 600 && this.rand.nextInt(800) == 0) {
                if (d3 < 1024.0) {
                    this.field_701_U = 0;
                } else {
                    this.setEntityDead();
                }
            }
        }
        this.movingLeftRight = 0.0f;
        this.movingForwardBack = 0.0f;
        float f = 8.0f;
        if (this.rand.nextFloat() < 0.02f) {
            EntityPlayer entityplayer1 = this.worldObj.getPlayerEntityAtHeight(this, f);
            if (entityplayer1 != null) {
                this.ridingEntity = entityplayer1;
                this.field_740_i = 10 + this.rand.nextInt(20);
            } else {
                this.field_698_X = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.ridingEntity != null) {
            this.func_426_b(this.ridingEntity, 10.0f);
            if (this.field_740_i-- <= 0 || this.ridingEntity.isDead || this.ridingEntity.getDistanceSqToEntity(this) > (double)(f * f)) {
                this.ridingEntity = null;
            }
        } else {
            if (this.rand.nextFloat() < 0.05f) {
                this.field_698_X = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
            this.rotationYaw += this.field_698_X;
            this.rotationPitch = this.field_696_Z;
        }
        boolean flag = this.handleWaterMovement();
        boolean flag1 = this.handleLavaMovement();
        if (flag || flag1) {
            this.isJumping = this.rand.nextFloat() < 0.8f;
        }
    }

    public void func_426_b(Entity entity, float f) {
        double d1;
        double d = entity.posX - this.posX;
        double d2 = entity.posZ - this.posZ;
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            d1 = entityliving.posY + (double)entityliving.func_373_s() - (this.posY + (double)this.func_373_s());
        } else {
            d1 = (entity.boundingBox.minY + entity.boundingBox.maxY) / 2.0 - (this.posY + (double)this.func_373_s());
        }
        double d3 = MathHelper.sqrt_double(d * d + d2 * d2);
        float f1 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
        float f2 = (float)(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732);
        this.rotationPitch = this.func_417_b(this.rotationPitch, f2, f);
        this.rotationYaw = this.func_417_b(this.rotationYaw, f1, f);
    }

    private float func_417_b(float f, float f1, float f2) {
        float f3 = f1 - f;
        while (f3 < -180.0f) {
            f3 += 360.0f;
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        return f + f3;
    }

    public void func_436_D() {
    }

    public boolean func_433_a() {
        return this.worldObj.func_604_a(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0 && !this.worldObj.getIsAnyLiquid(this.boundingBox);
    }

    protected void kill() {
        this.attackEntityFrom(null, 4);
    }

    public float getSwingProgress(float f) {
        float f1 = this.swingProgress - this.prevSwingProgress;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.prevSwingProgress + f1 * f;
    }

    public Vec3D func_427_e(float f) {
        if (f == 1.0f) {
            return Vec3D.createVector(this.posX, this.posY, this.posZ);
        }
        double d = this.prevPosX + (this.posX - this.prevPosX) * (double)f;
        double d1 = this.prevPosY + (this.posY - this.prevPosY) * (double)f;
        double d2 = this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f;
        return Vec3D.createVector(d, d1, d2);
    }

    public Vec3D func_430_f(float f) {
        if (f == 1.0f) {
            float f1 = MathHelper.cos(-this.rotationYaw * 0.01745329f - 3.141593f);
            float f3 = MathHelper.sin(-this.rotationYaw * 0.01745329f - 3.141593f);
            float f5 = -MathHelper.cos(-this.rotationPitch * 0.01745329f);
            float f7 = MathHelper.sin(-this.rotationPitch * 0.01745329f);
            return Vec3D.createVector(f3 * f5, f7, f1 * f5);
        }
        float f2 = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * f;
        float f4 = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * f;
        float f6 = MathHelper.cos(-f4 * 0.01745329f - 3.141593f);
        float f8 = MathHelper.sin(-f4 * 0.01745329f - 3.141593f);
        float f9 = -MathHelper.cos(-f2 * 0.01745329f);
        float f10 = MathHelper.sin(-f2 * 0.01745329f);
        return Vec3D.createVector(f8 * f9, f10, f6 * f9);
    }

    public MovingObjectPosition func_416_a(double d, float f) {
        Vec3D vec3d = this.func_427_e(f);
        Vec3D vec3d1 = this.func_430_f(f);
        Vec3D vec3d2 = vec3d.addVector(vec3d1.xCoord * d, vec3d1.yCoord * d, vec3d1.zCoord * d);
        return this.worldObj.rayTraceBlocks(vec3d, vec3d2);
    }

    protected void updateEntityActionStateIndev() {
    }
}

