/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.tile;

import com.mojang.minecraft.entity.tile.TileEntityChest;
import com.mojang.minecraft.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.entity.tile.TileEntityGear;
import com.mojang.minecraft.entity.tile.TileEntityMobSpawner;
import com.mojang.minecraft.entity.tile.TileEntityMotor;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.nbt.NBTTagCompound;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileEntity {
    private static Map<String, Class<?>> nameToClassMap = new HashMap();
    private static Map<Class<?>, String> classToNameMap = new HashMap();
    public World world;
    public int x;
    public int y;
    public int z;

    static {
        TileEntity.func_476_a(TileEntityFurnace.class, "Furnace");
        TileEntity.func_476_a(TileEntityChest.class, "Chest");
        TileEntity.func_476_a(TileEntitySign.class, "Sign");
        TileEntity.func_476_a(TileEntityMobSpawner.class, "MobSpawner");
        TileEntity.func_476_a(TileEntityGear.class, "Gear");
        TileEntity.func_476_a(TileEntityMotor.class, "Motor");
    }

    private static void func_476_a(Class<?> class1, String s) {
        if (classToNameMap.containsKey(s)) {
            throw new IllegalArgumentException("Duplicate id: " + s);
        }
        nameToClassMap.put(s, class1);
        classToNameMap.put(class1, s);
    }

    public void func_482_a(NBTTagCompound nbttagcompound) {
        this.x = nbttagcompound.getInteger("x");
        this.y = nbttagcompound.getInteger("y");
        this.z = nbttagcompound.getInteger("z");
    }

    public void func_481_b(NBTTagCompound nbttagcompound) {
        String s = classToNameMap.get(this.getClass());
        if (s == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        nbttagcompound.setString("id", s);
        nbttagcompound.setInteger("x", this.x);
        nbttagcompound.setInteger("y", this.y);
        nbttagcompound.setInteger("z", this.z);
    }

    public void func_475_b() {
    }

    public static TileEntity createAndLoadEntity(NBTTagCompound nbttagcompound) {
        TileEntity tileentity = null;
        try {
            Class<?> class1 = nameToClassMap.get(nbttagcompound.getString("id"));
            if (class1 != null) {
                tileentity = (TileEntity)class1.newInstance();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tileentity != null) {
            tileentity.func_482_a(nbttagcompound);
        } else {
            System.out.println("Skipping TileEntity with id " + nbttagcompound.getString("id"));
        }
        return tileentity;
    }

    public int func_479_f() {
        return this.world.getBlockMetadata(this.x, this.y, this.z);
    }

    public void onInventoryChanged() {
        if (this.world != null) {
            this.world.cacheTileEntity(this.x, this.y, this.z, this);
        }
    }

    public double func_480_a(double d, double d1, double d2) {
        double d3 = (double)this.x + 0.5 - d;
        double d4 = (double)this.y + 0.5 - d1;
        double d5 = (double)this.z + 0.5 - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public Block func_478_g() {
        return Block.allBlocks[this.world.getBlockId(this.x, this.y, this.z)];
    }

    static Class<?> _mthclass$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }
}

