/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile.fx;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.fx.TextureFX;
import com.mojang.minecraft.util.MathHelper;
import java.io.IOException;
import javax.imageio.ImageIO;

public class TextureGearIdleFX
extends TextureFX {
    private int tickCounter = 0;
    private int[] gear = new int[1024];
    private int[] gearMiddle = new int[1024];
    private int alternate;

    public TextureGearIdleFX(int n) {
        super(Block.gear.blockIndexInTexture + n);
        this.alternate = (n << 1) - 1;
        this.tickCounter = 2;
        try {
            ImageIO.read(Minecraft.class.getResource("/misc/gear.png")).getRGB(0, 0, 32, 32, this.gear, 0, 32);
            ImageIO.read(Minecraft.class.getResource("/misc/gearmiddle.png")).getRGB(0, 0, 16, 16, this.gearMiddle, 0, 16);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public final void render() {
        this.tickCounter = 1 + this.alternate & 0x3F;
        float a = MathHelper.sin((float)this.tickCounter / 64.0f * (float)Math.PI * 2.0f);
        float b = MathHelper.cos((float)this.tickCounter / 64.0f * (float)Math.PI * 2.0f);
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                float n = ((float)i / 15.0f - 0.5f) * 31.0f;
                float n2 = ((float)j / 15.0f - 0.5f) * 31.0f;
                float n3 = b * n - a * n2;
                n = b * n2 + a * n;
                int n4 = (int)(n3 + 16.0f);
                int n5 = (int)(n + 16.0f);
                int n6 = 0;
                if (n4 >= 0 && n5 >= 0 && n4 < 32 && n5 < 32) {
                    n6 = this.gear[n4 + (n5 << 5)];
                    n5 = this.gearMiddle[i + (j << 4)];
                    if (n5 >>> 24 > 128) {
                        n6 = n5;
                    }
                }
                n5 = n6 >> 16 & 0xFF;
                n4 = n6 >> 8 & 0xFF;
                int n7 = n6 & 0xFF;
                n6 = n6 >>> 24 > 128 ? 255 : 0;
                int n8 = i + (j << 4);
                this.field_1127_a[n8 << 2] = (byte)n5;
                this.field_1127_a[(n8 << 2) + 1] = (byte)n4;
                this.field_1127_a[(n8 << 2) + 2] = (byte)n7;
                this.field_1127_a[(n8 << 2) + 3] = (byte)n6;
                ++j;
            }
            ++i;
        }
    }
}

