/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.enums.EnumArt;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.List;

public class EntityPainting
extends Entity {
    private int field_695_c = 0;
    public int direction = 0;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public EnumArt art;

    public EntityPainting(World world) {
        super(world);
        this.yOffset = 0.0f;
        this.setSize(0.5f, 0.5f);
    }

    public EntityPainting(World world, int i, int j, int k, int l) {
        this(world);
        this.xPosition = i;
        this.yPosition = j;
        this.zPosition = k;
        ArrayList<EnumArt> arraylist = new ArrayList<EnumArt>();
        EnumArt[] aenumart = EnumArt.values();
        int i1 = aenumart.length;
        int j1 = 0;
        while (j1 < i1) {
            EnumArt enumart;
            this.art = enumart = aenumart[j1];
            this.func_412_b(l);
            if (this.func_410_i()) {
                arraylist.add(enumart);
            }
            ++j1;
        }
        if (arraylist.size() > 0) {
            this.art = (EnumArt)((Object)arraylist.get(this.rand.nextInt(arraylist.size())));
        }
        this.func_412_b(l);
    }

    public EntityPainting(World world, int i, int j, int k, int l, String s) {
        this(world);
        this.xPosition = i;
        this.yPosition = j;
        this.zPosition = k;
        for (EnumArt enumart : EnumArt.values()) {
            if (!enumart.title.equals(s)) continue;
            this.art = enumart;
            break;
        }
        this.func_412_b(l);
    }

    public void func_412_b(int i) {
        this.direction = i;
        this.prevRotationYaw = this.rotationYaw = (float)(i * 90);
        if (this.art == null) {
            return;
        }
        float f = this.art.sizeX;
        float f1 = this.art.sizeY;
        float f2 = this.art.sizeX;
        if (i == 0 || i == 2) {
            f2 = 0.5f;
        } else {
            f = 0.5f;
        }
        f /= 32.0f;
        f1 /= 32.0f;
        f2 /= 32.0f;
        float f3 = (float)this.xPosition + 0.5f;
        float f4 = (float)this.yPosition + 0.5f;
        float f5 = (float)this.zPosition + 0.5f;
        float f6 = 0.5625f;
        if (i == 0) {
            f5 -= f6;
        }
        if (i == 1) {
            f3 -= f6;
        }
        if (i == 2) {
            f5 += f6;
        }
        if (i == 3) {
            f3 += f6;
        }
        if (i == 0) {
            f3 -= this.func_411_c(this.art.sizeX);
        }
        if (i == 1) {
            f5 += this.func_411_c(this.art.sizeX);
        }
        if (i == 2) {
            f3 += this.func_411_c(this.art.sizeX);
        }
        if (i == 3) {
            f5 -= this.func_411_c(this.art.sizeX);
        }
        this.setPosition(f3, f4 += this.func_411_c(this.art.sizeY), f5);
        float f7 = -0.00625f;
        this.boundingBox.setBounds(f3 - f - f7, f4 - f1 - f7, f5 - f2 - f7, f3 + f + f7, f4 + f1 + f7, f5 + f2 + f7);
    }

    protected void entityInit() {
    }

    private float func_411_c(int i) {
        if (i == 32) {
            return 0.5f;
        }
        return i != 64 ? 0.0f : 0.5f;
    }

    public void onUpdate() {
        if (this.worldObj.multiplayerWorld) {
            return;
        }
        if (this.field_695_c++ == 100 && !this.func_410_i()) {
            this.field_695_c = 0;
            this.setEntityDead();
            this.worldObj.entityJoinedWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.painting)));
        }
    }

    public boolean func_410_i() {
        if (this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() > 0) {
            return false;
        }
        int i = this.art.sizeX / 16;
        int j = this.art.sizeY / 16;
        int k = this.xPosition;
        int l = this.yPosition;
        int i1 = this.zPosition;
        if (this.direction == 0) {
            k = MathHelper.floor_double(this.posX - (double)((float)this.art.sizeX / 32.0f));
        }
        if (this.direction == 1) {
            i1 = MathHelper.floor_double(this.posZ - (double)((float)this.art.sizeX / 32.0f));
        }
        if (this.direction == 2) {
            k = MathHelper.floor_double(this.posX - (double)((float)this.art.sizeX / 32.0f));
        }
        if (this.direction == 3) {
            i1 = MathHelper.floor_double(this.posZ - (double)((float)this.art.sizeX / 32.0f));
        }
        l = MathHelper.floor_double(this.posY - (double)((float)this.art.sizeY / 32.0f));
        int j1 = 0;
        while (j1 < i) {
            int k1 = 0;
            while (k1 < j) {
                Material material = this.direction == 0 || this.direction == 2 ? this.worldObj.getMaterialXYZ(k + j1, l + k1, this.zPosition) : this.worldObj.getMaterialXYZ(this.xPosition, l + k1, i1 + j1);
                if (!material.isSolidMaterial()) {
                    return false;
                }
                ++k1;
            }
            ++j1;
        }
        List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox);
        int l1 = 0;
        while (l1 < list.size()) {
            if (list.get(l1) instanceof EntityPainting) {
                return false;
            }
            ++l1;
        }
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        if (this.worldObj.multiplayerWorld || this.isDead) {
            return true;
        }
        this.setEntityDead();
        this.worldObj.entityJoinedWorld(new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.painting)));
        return true;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setByte("Dir", (byte)this.direction);
        nbttagcompound.setString("Motive", this.art.title);
        nbttagcompound.setInteger("TileX", this.xPosition);
        nbttagcompound.setInteger("TileY", this.yPosition);
        nbttagcompound.setInteger("TileZ", this.zPosition);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.direction = nbttagcompound.getByte("Dir");
        this.xPosition = nbttagcompound.getInteger("TileX");
        this.yPosition = nbttagcompound.getInteger("TileY");
        this.zPosition = nbttagcompound.getInteger("TileZ");
        String s = nbttagcompound.getString("Motive");
        EnumArt[] aenumart = EnumArt.values();
        int i = aenumart.length;
        int j = 0;
        while (j < i) {
            EnumArt enumart = aenumart[j];
            if (enumart.title.equals(s)) {
                this.art = enumart;
            }
            ++j;
        }
        if (this.art == null) {
            this.art = EnumArt.Kebab;
        }
        this.func_412_b(this.direction);
    }
}

