/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.gui.GuiButton;
import com.mojang.minecraft.gui.GuiDeleteWorld;
import com.mojang.minecraft.gui.GuiNameWorld;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.player.controller.PlayerControllerSP;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;

public class GuiSelectWorld
extends GuiScreen {
    int list = 0;
    long timeSinceClick = System.currentTimeMillis();
    protected GuiScreen field_958_a;
    protected String field_960_h = "Select world";
    private boolean field_959_i = false;

    public GuiSelectWorld(GuiScreen guiscreen) {
        this.field_958_a = guiscreen;
    }

    public void initGui() {
        this.setButtons(this.list);
    }

    public void setButtons(int next) {
        this.controlList.clear();
        this.list = next;
        String name = "Select world";
        if (this instanceof GuiDeleteWorld) {
            name = "Delete World";
        }
        this.field_960_h = String.valueOf(name) + " (" + (this.list + 1) + " - " + (this.list + 5) + ")";
        File file = Minecraft.func_106_b();
        int i = this.list;
        while (i < this.list + 5) {
            NBTTagCompound nbttagcompound = World.func_629_a(file, "World" + (i + 1));
            if (nbttagcompound == null) {
                this.controlList.add(new GuiButton(i, this.width / 2 - 100, this.height / 6 + 24 * (i - this.list), "- empty -\u0000"));
            } else {
                String s = "World " + (i + 1);
                File f = new File(file, "NSSSsaves/World" + (i + 1) + "/name.data");
                if (f.exists()) {
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(f));
                        s = br.readLine().replace("\u0000", "");
                        br.close();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                long l = nbttagcompound.getLong("SizeOnDisk");
                s = s + " (" + (float)(l / 1024L * 100L / 1024L) / 100.0f + " MB)";
                this.controlList.add(new GuiButton(i, this.width / 2 - 100, this.height / 6 + 24 * (i - this.list), s));
                this.controlList.add(new GuiButton(i, this.width / 2 - 100, this.height / 6 + 24 * (i - this.list), s));
            }
            ++i;
        }
        this.func_585_j();
    }

    protected String func_586_d(int i) {
        File file = Minecraft.func_106_b();
        return World.func_629_a(file, "World" + i) == null ? null : "World" + i;
    }

    public void func_585_j() {
        GuiButton gbnext = new GuiButton(-3, this.width / 2 + 6, this.height / 6 + 128, ">");
        gbnext.width = 95;
        this.controlList.add(gbnext);
        GuiButton gbprev = new GuiButton(-4, this.width / 2 - 100, this.height / 6 + 128, "<");
        gbprev.width = 95;
        gbprev.enabled = this.list > 0;
        this.controlList.add(gbprev);
        this.controlList.add(new GuiButton(-1, this.width / 2 - 100, this.height / 6 + 120 + 32 + 2, "Delete world..."));
        this.controlList.add(new GuiButton(-2, this.width / 2 - 100, this.height / 6 + 168 + 10, "Cancel"));
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (this.timeSinceClick < System.currentTimeMillis() - 50L) {
            this.timeSinceClick = System.currentTimeMillis();
            if (!guibutton.enabled) {
                return;
            }
            if (guibutton.id == -3) {
                this.controlList.clear();
                this.setButtons(this.list + 5);
            }
            if (guibutton.id == -4) {
                this.controlList.clear();
                if (this.list - 5 < 0) {
                    this.list = 5;
                }
                this.setButtons(this.list - 5);
            }
            if (guibutton.id > -1) {
                if (this instanceof GuiDeleteWorld || !guibutton.displayString.contains("\u0000")) {
                    this.func_584_c(guibutton.id + 1);
                } else {
                    this.mc.setCurrentScreen(new GuiNameWorld(this, guibutton.id + 1));
                }
            } else if (guibutton.id == -1) {
                this.mc.setCurrentScreen(new GuiDeleteWorld(this));
            } else if (guibutton.id == -2) {
                this.mc.setCurrentScreen(this.field_958_a);
            }
        }
    }

    public void func_584_c(int i) {
        this.func_584_c(i, new Random().nextInt(4) == 0, true, 0);
    }

    public void func_584_c(int i, boolean snowCovered, boolean cheatsEnabled, int worldType) {
        this.mc.setCurrentScreen(null);
        if (this.field_959_i) {
            return;
        }
        this.field_959_i = true;
        this.mc.playerController = new PlayerControllerSP(this.mc);
        this.mc.func_113_b("World" + i, snowCovered, !cheatsEnabled, worldType);
        this.mc.setCurrentScreen(null);
    }

    public void drawScreen(int i, int j, float f) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, this.field_960_h, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(i, j, f);
    }
}

