/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.generate.IChunkLoader;
import com.mojang.minecraft.level.generate.IChunkProvider;
import java.io.IOException;

public class ChunkProviderLoadOrGenerate
implements IChunkProvider {
    private Chunk field_897_c;
    private IChunkProvider field_896_d;
    private IChunkLoader field_895_e;
    private Chunk[] field_894_f = new Chunk[1024];
    private World field_893_g;
    int field_891_a = -999999999;
    int field_890_b = -999999999;
    private Chunk field_892_h;
    private int curChunkX;
    private int curChunkY;

    public ChunkProviderLoadOrGenerate(World world, IChunkLoader ichunkloader, IChunkProvider ichunkprovider) {
        this.field_897_c = new Chunk(world, new byte[32768], 0, 0);
        this.field_897_c.hasEntities2 = true;
        this.field_897_c.neverSave = true;
        this.field_893_g = world;
        this.field_895_e = ichunkloader;
        this.field_896_d = ichunkprovider;
    }

    public void setCurrentChunkOver(int i, int j) {
        this.curChunkX = i;
        this.curChunkY = j;
    }

    public boolean canChunkExist(int i, int j) {
        int byte0 = 15;
        return i >= this.curChunkX - byte0 && j >= this.curChunkY - byte0 && i <= this.curChunkX + byte0 && j <= this.curChunkY + byte0;
    }

    public boolean chunkExists(int i, int j) {
        if (i == this.field_891_a && j == this.field_890_b && this.field_892_h != null) {
            return true;
        }
        int k = i & 0x1F;
        int l = j & 0x1F;
        int i1 = k + l * 32;
        return this.field_894_f[i1] != null && (this.field_894_f[i1] == this.field_897_c || this.field_894_f[i1].isAtLocation(i, j));
    }

    public Chunk provideChunk(int i, int j) {
        if (i == this.field_891_a && j == this.field_890_b && this.field_892_h != null) {
            return this.field_892_h;
        }
        int k = i & 0x1F;
        int l = j & 0x1F;
        int i1 = k + l * 32;
        if (!this.chunkExists(i, j)) {
            Chunk chunk;
            if (this.field_894_f[i1] != null) {
                this.field_894_f[i1].onChunkUnload();
                this.func_540_b(this.field_894_f[i1]);
                this.func_541_a(this.field_894_f[i1]);
            }
            if ((chunk = this.func_542_c(i, j)) == null) {
                chunk = this.field_896_d == null ? this.field_897_c : this.field_896_d.provideChunk(i, j);
            }
            this.field_894_f[i1] = chunk;
            if (this.field_894_f[i1] != null) {
                this.field_894_f[i1].onChunkLoad();
            }
            if (!this.field_894_f[i1].isTerrainPopulated && this.chunkExists(i + 1, j + 1) && this.chunkExists(i, j + 1) && this.chunkExists(i + 1, j)) {
                this.generateStructures(this, i, j);
            }
            if (this.chunkExists(i - 1, j) && !this.provideChunk((int)(i - 1), (int)j).isTerrainPopulated && this.chunkExists(i - 1, j + 1) && this.chunkExists(i, j + 1) && this.chunkExists(i - 1, j)) {
                this.generateStructures(this, i - 1, j);
            }
            if (this.chunkExists(i, j - 1) && !this.provideChunk((int)i, (int)(j - 1)).isTerrainPopulated && this.chunkExists(i + 1, j - 1) && this.chunkExists(i, j - 1) && this.chunkExists(i + 1, j)) {
                this.generateStructures(this, i, j - 1);
            }
            if (this.chunkExists(i - 1, j - 1) && !this.provideChunk((int)(i - 1), (int)(j - 1)).isTerrainPopulated && this.chunkExists(i - 1, j - 1) && this.chunkExists(i, j - 1) && this.chunkExists(i - 1, j)) {
                this.generateStructures(this, i - 1, j - 1);
            }
        }
        this.field_891_a = i;
        this.field_890_b = j;
        this.field_892_h = this.field_894_f[i1];
        return this.field_894_f[i1];
    }

    private Chunk func_542_c(int i, int j) {
        if (this.field_895_e == null) {
            return null;
        }
        try {
            Chunk chunk = this.field_895_e.loadChunk(this.field_893_g, i, j);
            if (chunk != null) {
                chunk.lastSaveTime = this.field_893_g.worldTime;
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void func_541_a(Chunk chunk) {
        if (this.field_895_e == null) {
            return;
        }
        try {
            this.field_895_e.saveExtraChunkData(this.field_893_g, chunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_540_b(Chunk chunk) {
        if (this.field_895_e == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.field_893_g.worldTime;
            this.field_895_e.saveChunk(this.field_893_g, chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public void generateStructures(IChunkProvider ichunkprovider, int i, int j) {
        Chunk chunk = this.provideChunk(i, j);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.field_896_d != null) {
                this.field_896_d.generateStructures(ichunkprovider, i, j);
                chunk.setChunkModified();
            }
        }
    }

    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        int i = 0;
        int j = 0;
        if (iprogressupdate != null) {
            int k = 0;
            while (k < this.field_894_f.length) {
                if (this.field_894_f[k] != null && this.field_894_f[k].needsSaving(flag)) {
                    ++j;
                }
                ++k;
            }
        }
        int l = 0;
        int i1 = 0;
        while (i1 < this.field_894_f.length) {
            if (this.field_894_f[i1] != null) {
                if (flag && !this.field_894_f[i1].neverSave) {
                    this.func_541_a(this.field_894_f[i1]);
                }
                if (this.field_894_f[i1].needsSaving(flag)) {
                    this.func_540_b(this.field_894_f[i1]);
                    this.field_894_f[i1].isModified = false;
                    if (++i == 2 && !flag) {
                        return false;
                    }
                    if (iprogressupdate != null && ++l % 10 == 0) {
                        iprogressupdate.setProgess(l * 100 / j);
                    }
                }
            }
            ++i1;
        }
        if (flag) {
            if (this.field_895_e == null) {
                return true;
            }
            this.field_895_e.saveExtraData();
        }
        return true;
    }

    public boolean unknownBoolean1() {
        if (this.field_895_e != null) {
            this.field_895_e.func_814_a();
        }
        return this.field_896_d.unknownBoolean1();
    }

    public boolean unknownBoolean2() {
        return true;
    }
}

