/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.networknew.packet;

import com.mojang.minecraft.networknew.NetHandler;
import com.mojang.minecraft.networknew.packet.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Packet52MultiBlockChange
extends Packet {
    public int xPosition;
    public int zPosition;
    public short[] coordinateArray;
    public byte[] typeArray;
    public byte[] metadataArray;
    public int size;

    public Packet52MultiBlockChange() {
        this.isChunkDataPacket = true;
    }

    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.xPosition = datainputstream.readInt();
        this.zPosition = datainputstream.readInt();
        this.size = datainputstream.readShort() & 0xFFFF;
        this.coordinateArray = new short[this.size];
        this.typeArray = new byte[this.size];
        this.metadataArray = new byte[this.size];
        int i = 0;
        while (i < this.size) {
            this.coordinateArray[i] = datainputstream.readShort();
            ++i;
        }
        datainputstream.readFully(this.typeArray);
        datainputstream.readFully(this.metadataArray);
    }

    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeInt(this.xPosition);
        dataoutputstream.writeInt(this.zPosition);
        dataoutputstream.writeShort((short)this.size);
        int i = 0;
        while (i < this.size) {
            dataoutputstream.writeShort(this.coordinateArray[i]);
            ++i;
        }
        dataoutputstream.write(this.typeArray);
        dataoutputstream.write(this.metadataArray);
    }

    public void processPacket(NetHandler nethandler) {
        nethandler.handleMultiBlockChange(this);
    }

    public int getPacketSize() {
        return 10 + this.size * 4;
    }
}

