/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft;

import com.mojang.minecraft.MinecraftApplet;
import com.mojang.minecraft.MinecraftError;
import com.mojang.minecraft.MinecraftException;
import com.mojang.minecraft.MinecraftImpl;
import com.mojang.minecraft.Timer;
import com.mojang.minecraft.entity.EntityClientPlayerMP;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityPlayerSP;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemRenderer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.model.ModelBiped;
import com.mojang.minecraft.enums.EnumOS2;
import com.mojang.minecraft.enums.EnumOSMappingHelper;
import com.mojang.minecraft.gui.GuiBuild;
import com.mojang.minecraft.gui.GuiChat;
import com.mojang.minecraft.gui.GuiConflictWarning;
import com.mojang.minecraft.gui.GuiConnecting;
import com.mojang.minecraft.gui.GuiGameOver;
import com.mojang.minecraft.gui.GuiGrayScreen;
import com.mojang.minecraft.gui.GuiIngame;
import com.mojang.minecraft.gui.GuiIngameMenu;
import com.mojang.minecraft.gui.GuiInventory;
import com.mojang.minecraft.gui.GuiMainMenu;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.gui.GuiUnused;
import com.mojang.minecraft.gui.LoadingScreenRenderer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.level.chunk.ChunkProviderLoadOrGenerate;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.fx.TextureCompassFX;
import com.mojang.minecraft.level.tile.fx.TextureFlamesFX;
import com.mojang.minecraft.level.tile.fx.TextureGearFX;
import com.mojang.minecraft.level.tile.fx.TextureGearIdleFX;
import com.mojang.minecraft.level.tile.fx.TextureLavaFX;
import com.mojang.minecraft.level.tile.fx.TextureLavaFlowFX;
import com.mojang.minecraft.level.tile.fx.TextureWaterFX;
import com.mojang.minecraft.level.tile.fx.TextureWaterOverlayFX;
import com.mojang.minecraft.level.tile.fx.TexureWaterFlowFX;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.networknew.NetClientHandler;
import com.mojang.minecraft.player.controller.GameSettings;
import com.mojang.minecraft.player.controller.GameWindowListener;
import com.mojang.minecraft.player.controller.MouseHelper;
import com.mojang.minecraft.player.controller.MovementInputFromOptions;
import com.mojang.minecraft.player.controller.PlayerController;
import com.mojang.minecraft.player.controller.PlayerControllerCreative;
import com.mojang.minecraft.player.controller.PlayerControllerSP;
import com.mojang.minecraft.render.EffectRenderer;
import com.mojang.minecraft.render.EntityRenderer;
import com.mojang.minecraft.render.FontRenderer;
import com.mojang.minecraft.render.GLAllocation;
import com.mojang.minecraft.render.OpenGlCapsChecker;
import com.mojang.minecraft.render.RenderEngine;
import com.mojang.minecraft.render.RenderGlobal;
import com.mojang.minecraft.render.RenderManager;
import com.mojang.minecraft.render.ScaledResolution;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.render.WorldRenderer;
import com.mojang.minecraft.sound.SoundManager;
import com.mojang.minecraft.sound.ThreadDownloadResources;
import com.mojang.minecraft.util.MathHelper;
import com.mojang.minecraft.util.ScreenShotHelper;
import com.mojang.minecraft.util.Session;
import com.mojang.minecraft.util.SkinManager;
import com.mojang.minecraft.util.ThreadSleepForever;
import com.mojang.minecraft.util.UnexpectedThrowable;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.File;
import java.util.ArrayList;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.glu.GLU;

public abstract class Minecraft
implements Runnable {
    private static Minecraft theMinecraft;
    public PlayerController playerController;
    private boolean isFullscreen = false;
    public int displayWidth;
    public int displayHeight;
    private OpenGlCapsChecker field_147_L;
    private Timer field_146_M = new Timer(20.0f);
    public World mcWorld;
    public RenderGlobal renderGlobal;
    public EntityPlayerSP thePlayer;
    public EntityLiving renderViewEntity;
    public EffectRenderer effectRenderer;
    public Session session = null;
    public String field_175_j;
    public Canvas field_174_k;
    public boolean field_173_l = true;
    public volatile boolean field_172_m = false;
    public RenderEngine renderEngine;
    public FontRenderer fontRender;
    public GuiScreen currentScreen = null;
    public LoadingScreenRenderer loadScreen = new LoadingScreenRenderer(this);
    public EntityRenderer field_167_r = new EntityRenderer(this);
    private ThreadDownloadResources field_145_N;
    private int field_144_O = 0;
    private int leftClickCounter = 0;
    private int field_142_Q;
    private int field_141_R;
    public String field_166_s = null;
    public int field_165_t = 0;
    public GuiIngame ingameGUI;
    public boolean field_163_v = false;
    public ModelBiped field_162_w = new ModelBiped(0.0f);
    public MovingObjectPosition objectMouseOver = null;
    public GameSettings options;
    protected MinecraftApplet field_159_z;
    public SoundManager soundMGR = new SoundManager();
    public MouseHelper mouseHelper;
    public File field_156_C;
    public static long[] field_155_D;
    public static int field_154_E;
    private String field_140_S;
    private int field_139_T;
    private TextureWaterFX field_138_U = new TextureWaterFX();
    private TextureLavaFX field_137_V = new TextureLavaFX();
    private TextureWaterOverlayFX waterOverlay = new TextureWaterOverlayFX();
    private static File dataFolder;
    public volatile boolean field_153_F = true;
    public String field_152_G = "";
    boolean isTakingScreenshot;
    long field_151_H = -1L;
    public boolean field_150_I = false;
    private int field_135_X = 0;
    public boolean enableRain = false;
    long field_148_K = System.currentTimeMillis();
    private int field_134_Y = 0;
    private Vec3D savedPlayerPos;
    public static boolean isIRIX;
    public static boolean isMACOS;
    public boolean hasChimed = false;
    public static String chime;
    public static String versionNumber;
    public static String version;
    public SkinManager skins;

    static {
        field_155_D = new long[512];
        field_154_E = 0;
        dataFolder = null;
        chime = "";
        versionNumber = "v1.1.11_110";
        version = "Minecraft Alpha " + versionNumber;
    }

    public Minecraft(Component component, Canvas canvas, MinecraftApplet minecraftapplet, int i2, int j2, boolean flag) {
        this.field_142_Q = i2;
        this.field_141_R = j2;
        this.isFullscreen = flag;
        this.field_159_z = minecraftapplet;
        new ThreadSleepForever(this, "Timer hack thread");
        this.field_174_k = canvas;
        this.displayWidth = i2;
        this.displayHeight = j2;
        this.isFullscreen = flag;
        this.savedPlayerPos = Vec3D.createVectorHelper(0.0, 128.0, 0.0);
        isIRIX = false;
        isMACOS = false;
        theMinecraft = this;
    }

    public abstract void func_110_a(UnexpectedThrowable var1);

    public void func_121_a(String s2, int i2) {
        this.field_140_S = s2;
        this.field_139_T = i2;
    }

    public void startupScreen() throws LWJGLException {
        if (this.field_174_k != null) {
            Graphics g2 = this.field_174_k.getGraphics();
            if (g2 != null) {
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, this.displayWidth, this.displayHeight);
                g2.dispose();
            }
            Display.setParent((Canvas)this.field_174_k);
        } else if (this.isFullscreen) {
            Display.setFullscreen((boolean)true);
            this.displayWidth = Display.getDisplayMode().getWidth();
            this.displayHeight = Display.getDisplayMode().getHeight();
            if (this.displayWidth <= 0) {
                this.displayWidth = 1;
            }
            if (this.displayHeight <= 0) {
                this.displayHeight = 1;
            }
        } else {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.displayWidth, this.displayHeight));
        }
        Display.setTitle((String)version);
        try {
            PixelFormat pixelformat = new PixelFormat();
            pixelformat = pixelformat.withDepthBits(24);
            Display.create((PixelFormat)pixelformat);
        }
        catch (LWJGLException lwjglexception) {
            lwjglexception.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Display.create();
        }
        RenderManager.subManager.itemRenderer = new ItemRenderer(this);
        this.field_156_C = Minecraft.func_106_b();
        this.options = new GameSettings(this, this.field_156_C);
        this.renderEngine = new RenderEngine(this.options);
        this.fontRender = new FontRenderer(this.options, "/default.png", this.renderEngine);
        this.showMahjong();
        Keyboard.create();
        Mouse.create();
        this.mouseHelper = new MouseHelper(this.field_174_k);
        try {
            Controllers.create();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.func_116_c("Pre startup");
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glCullFace((int)1029);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        this.func_116_c("Startup");
        this.field_147_L = new OpenGlCapsChecker();
        this.soundMGR.initialize(this.options);
        this.renderEngine.bindTextureFX(this.field_137_V);
        this.renderEngine.bindTextureFX(this.field_138_U);
        this.renderEngine.bindTextureFX(this.waterOverlay);
        this.renderEngine.bindTextureFX(new TextureCompassFX(this));
        this.renderEngine.bindTextureFX(new TexureWaterFlowFX());
        this.renderEngine.bindTextureFX(new TextureLavaFlowFX());
        this.renderEngine.bindTextureFX(new TextureFlamesFX(0));
        this.renderEngine.bindTextureFX(new TextureFlamesFX(1));
        this.renderEngine.bindTextureFX(new TextureGearFX(16));
        this.renderEngine.bindTextureFX(new TextureGearFX(17));
        this.renderEngine.bindTextureFX(new TextureGearIdleFX(0));
        this.renderEngine.bindTextureFX(new TextureGearIdleFX(1));
        this.renderGlobal = new RenderGlobal(this, this.renderEngine);
        GL11.glViewport((int)0, (int)0, (int)this.displayWidth, (int)this.displayHeight);
        this.effectRenderer = new EffectRenderer(this.mcWorld, this.renderEngine, this);
        try {
            this.field_145_N = new ThreadDownloadResources(this.field_156_C, this);
            this.field_145_N.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.func_116_c("Post startup");
        this.ingameGUI = new GuiIngame(this);
        this.skins = new SkinManager(this);
        if (this.field_140_S != null) {
            this.setCurrentScreen(new GuiConnecting(this, this.field_140_S, this.field_139_T));
        } else {
            while (this.options.soundVolume != 0.0f && !this.soundMGR.getLoaded()) {
            }
            this.setCurrentScreen(new GuiGrayScreen());
        }
    }

    private void showMahjong() throws LWJGLException {
        int oldScale = this.options.guiScale;
        this.options.guiScale = 0;
        ScaledResolution scaledresolution = new ScaledResolution(this.displayWidth, this.displayHeight, this);
        int i2 = scaledresolution.getScaledWidth();
        int j2 = scaledresolution.getScaledHeight();
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)i2, (double)j2, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)this.displayWidth, (int)this.displayHeight);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        int c2 = 256;
        int c1 = 256;
        if (!isMACOS && !isIRIX) {
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/title/mojang.png"));
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0xFFFFFF);
            tessellator.addVertexWithUV(0.0, this.displayHeight, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(this.displayWidth, this.displayHeight, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(this.displayWidth, 0.0, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
            tessellator.draw();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            tessellator.setColorOpaque_I(0xFFFFFF);
            this.drawPng((this.displayWidth / 2 - c2) / 2, (this.displayHeight / 2 - c1) / 2, 0, 0, c2, c1);
        } else if (isIRIX) {
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/title/sgi_grad.png"));
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0xFFFFFF);
            tessellator.addVertexWithUV(0.0, this.displayHeight, 0.0, 0.0, 2.0);
            tessellator.addVertexWithUV(this.displayWidth, this.displayHeight, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(this.displayWidth, 0.0, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
            tessellator.draw();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            tessellator.setColorOpaque_I(0xFFFFFF);
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/title/mojang_silicongraphics.png"));
            tessellator.startDrawingQuads();
            tessellator.draw();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            tessellator.setColorOpaque_I(0xFFFFFF);
            this.drawPng2((this.displayWidth / 2 - 112) / 2, (this.displayHeight / 4 - 22) / 2, 0, 0, 112, 22);
        } else {
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/title/mojang_apple.png"));
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0xFFFFFF);
            tessellator.addVertexWithUV(0.0, this.displayHeight, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(this.displayWidth, this.displayHeight, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(this.displayWidth, 0.0, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
            tessellator.draw();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            tessellator.setColorOpaque_I(0xFFFFFF);
            this.drawPng((this.displayWidth / 2 - c2) / 2, (this.displayHeight / 2 - c1) / 2, 0, 0, c2, c1);
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Display.swapBuffers();
        this.options.guiScale = oldScale;
    }

    public void drawPng(int x2, int y2, int u2, int v2, int u22, int v22) {
        float f2 = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x2 + 0, y2 + v22, 0.0, (float)(u2 + 0) * f2, (float)(v2 + v22) * f1);
        tessellator.addVertexWithUV(x2 + u22, y2 + v22, 0.0, (float)(u2 + u22) * f2, (float)(v2 + v22) * f1);
        tessellator.addVertexWithUV(x2 + u22, y2 + 0, 0.0, (float)(u2 + u22) * f2, (float)(v2 + 0) * f1);
        tessellator.addVertexWithUV(x2 + 0, y2 + 0, 0.0, (float)(u2 + 0) * f2, (float)(v2 + 0) * f1);
        tessellator.draw();
    }

    public void drawPng2(int x2, int y2, int u2, int v2, int u22, int v22) {
        float f2 = 0.00891f;
        float f1 = 0.045f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x2 + 0, y2 + v22, 0.0, (float)(u2 + 0) * f2, (float)(v2 + v22) * f1);
        tessellator.addVertexWithUV(x2 + u22, y2 + v22, 0.0, (float)(u2 + u22) * f2, (float)(v2 + v22) * f1);
        tessellator.addVertexWithUV(x2 + u22, y2 + 0, 0.0, (float)(u2 + u22) * f2, (float)(v2 + 0) * f1);
        tessellator.addVertexWithUV(x2 + 0, y2 + 0, 0.0, (float)(u2 + 0) * f2, (float)(v2 + 0) * f1);
        tessellator.draw();
    }

    public static File func_106_b() {
        if (dataFolder == null) {
            dataFolder = Minecraft.func_127_a("minecraft");
        }
        return dataFolder;
    }

    public static File func_127_a(String s2) {
        File file;
        String s1 = System.getProperty("user.home", ".");
        switch (EnumOSMappingHelper.osEnums[Minecraft.getCurrentOS().ordinal()]) {
            case 1: 
            case 2: {
                file = new File(s1, '.' + s2 + '/');
                break;
            }
            case 3: {
                String s22 = System.getenv("APPDATA");
                if (s22 != null) {
                    file = new File(s22, "." + s2 + '/');
                    break;
                }
                file = new File(s1, '.' + s2 + '/');
                break;
            }
            case 4: {
                file = new File(s1, "Library/Application Support/" + s2);
                break;
            }
            default: {
                file = new File(s1, s2 + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    private static EnumOS2 getCurrentOS() {
        String s2 = System.getProperty("os.name").toLowerCase();
        if (s2.contains("win")) {
            return EnumOS2.windows;
        }
        if (s2.contains("mac")) {
            isMACOS = true;
            chime = "random.bong";
            if (s2.contains("os 9")) {
                return EnumOS2.macos9;
            }
            return EnumOS2.macos;
        }
        if (s2.contains("solaris")) {
            return EnumOS2.solaris;
        }
        if (s2.contains("sunos")) {
            return EnumOS2.solaris;
        }
        if (s2.contains("linux")) {
            return EnumOS2.linux;
        }
        if (s2.contains("irix")) {
            isIRIX = true;
            chime = "random.indy";
            return EnumOS2.irix;
        }
        if (s2.contains("unix")) {
            return EnumOS2.linux;
        }
        return EnumOS2.unknown;
    }

    public void playChime() {
        if (isMACOS) {
            System.out.println("BONG");
            this.soundMGR.playSoundFX("random.mac_chord", 1.0f, 1.0f);
        }
    }

    public void setCurrentScreen(GuiScreen guiscreen) {
        if (this.currentScreen instanceof GuiUnused) {
            return;
        }
        if (this.currentScreen != null) {
            this.currentScreen.onGuiClosed();
        }
        if (guiscreen == null && this.mcWorld == null) {
            guiscreen = new GuiMainMenu();
        } else if (guiscreen == null && this.thePlayer.health <= 0) {
            guiscreen = new GuiGameOver();
        }
        this.currentScreen = guiscreen;
        if (guiscreen != null) {
            this.func_138_f();
            ScaledResolution scaledresolution = new ScaledResolution(this.displayWidth, this.displayHeight, this);
            int i2 = scaledresolution.getScaledWidth();
            int j2 = scaledresolution.getScaledHeight();
            guiscreen.setResolution(this, i2, j2);
            this.field_163_v = false;
        } else {
            this.func_123_e();
        }
    }

    private void func_116_c(String s2) {
        int i2 = GL11.glGetError();
        if (i2 != 0) {
            String s1 = GLU.gluErrorString((int)i2);
            System.out.println("########## GL ERROR ##########");
            System.out.println("@ " + s2);
            System.out.println(i2 + ": " + s1);
            System.exit(0);
        }
    }

    public void func_130_c() {
        if (this.field_159_z != null) {
            this.field_159_z.func_101_c();
        }
        try {
            if (this.field_145_N != null) {
                this.field_145_N.func_1208_b();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.out.println("Stopping!");
            this.changeWorld1(null);
            try {
                GLAllocation.func_1126_a();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.soundMGR.func_330_b();
            Mouse.destroy();
            Keyboard.destroy();
        }
        finally {
            Display.destroy();
        }
        System.gc();
    }

    public void run() {
        this.field_153_F = true;
        try {
            this.startupScreen();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.func_110_a(new UnexpectedThrowable("Failed to start game", exception));
            return;
        }
        try {
            long l2 = System.currentTimeMillis();
            int i2 = 0;
            while (this.field_153_F && (this.field_159_z == null || this.field_159_z.isActive())) {
                AxisAlignedBB.func_1173_a();
                Vec3D.initialize();
                if (this.field_174_k == null && Display.isCloseRequested()) {
                    this.func_109_d();
                }
                if (this.field_172_m && this.mcWorld != null) {
                    float f2 = this.field_146_M.field_1378_c;
                    this.field_146_M.func_904_a();
                    this.field_146_M.field_1378_c = f2;
                } else {
                    this.field_146_M.func_904_a();
                }
                int j2 = 0;
                while (j2 < this.field_146_M.field_1379_b) {
                    ++this.field_144_O;
                    try {
                        this.func_111_i();
                    }
                    catch (MinecraftException minecraftexception) {
                        this.mcWorld = null;
                        this.changeWorld1(null);
                        this.setCurrentScreen(new GuiConflictWarning());
                    }
                    ++j2;
                }
                this.func_116_c("Pre render");
                this.soundMGR.func_338_a(this.thePlayer, this.field_146_M.field_1378_c);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3024);
                if (this.mcWorld != null) {
                    while (this.mcWorld.func_638_e()) {
                    }
                }
                if (!this.field_163_v) {
                    if (this.playerController != null) {
                        this.playerController.func_723_a(this.field_146_M.field_1378_c);
                    }
                    this.field_167_r.func_909_b(this.field_146_M.field_1378_c);
                }
                if (!Display.isActive()) {
                    if (this.isFullscreen) {
                        this.func_133_h();
                    }
                    Thread.sleep(10L);
                }
                if (Keyboard.isKeyDown((int)65)) {
                    Display.update();
                }
                this.screenshotListener();
                if (Keyboard.isKeyDown((int)64)) {
                    this.drawLagometer();
                } else {
                    this.field_151_H = System.nanoTime();
                }
                Thread.yield();
                Display.update();
                if (!(this.field_174_k == null || this.isFullscreen || this.field_174_k.getWidth() == this.displayWidth && this.field_174_k.getHeight() == this.displayHeight)) {
                    this.displayWidth = this.field_174_k.getWidth();
                    this.displayHeight = this.field_174_k.getHeight();
                    if (this.displayWidth <= 0) {
                        this.displayWidth = 1;
                    }
                    if (this.displayHeight <= 0) {
                        this.displayHeight = 1;
                    }
                    this.func_115_a(this.displayWidth, this.displayHeight);
                }
                if (this.options.limitFramerate) {
                    Thread.sleep(10L);
                }
                this.func_116_c("Post render");
                ++i2;
                this.field_172_m = !this.isServer() && this.currentScreen != null && this.currentScreen.doesGuiPauseGame();
                while (System.currentTimeMillis() >= l2 + 1000L) {
                    this.field_152_G = i2 + " fps, " + WorldRenderer.chunksUpdated + " chunk updates";
                    WorldRenderer.chunksUpdated = 0;
                    l2 += 1000L;
                    i2 = 0;
                }
            }
        }
        catch (MinecraftError l2) {
        }
        catch (Throwable throwable) {
            this.mcWorld = null;
            throwable.printStackTrace();
            this.func_110_a(new UnexpectedThrowable("Unexpected error", throwable));
        }
    }

    private void screenshotListener() {
        if (Keyboard.isKeyDown((int)60)) {
            if (!this.isTakingScreenshot) {
                this.isTakingScreenshot = true;
                this.ingameGUI.addChatMessage(ScreenShotHelper.saveScreenshot(dataFolder, this.displayWidth, this.displayHeight));
            }
        } else {
            this.isTakingScreenshot = false;
        }
    }

    private void drawLagometer() {
        if (this.field_151_H == -1L) {
            this.field_151_H = System.nanoTime();
        }
        long l2 = System.nanoTime();
        Minecraft.field_155_D[Minecraft.field_154_E++ & Minecraft.field_155_D.length - 1] = l2 - this.field_151_H;
        this.field_151_H = l2;
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.displayWidth, (double)this.displayHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(7);
        tessellator.setColorOpaque_I(0x20200000);
        tessellator.addVertex(0.0, this.displayHeight - 100, 0.0);
        tessellator.addVertex(0.0, this.displayHeight, 0.0);
        tessellator.addVertex(field_155_D.length, this.displayHeight, 0.0);
        tessellator.addVertex(field_155_D.length, this.displayHeight - 100, 0.0);
        tessellator.draw();
        long l1 = 0L;
        int i2 = 0;
        while (i2 < field_155_D.length) {
            l1 += field_155_D[i2];
            ++i2;
        }
        int j2 = (int)(l1 / 200000L / (long)field_155_D.length);
        tessellator.startDrawing(7);
        tessellator.setColorOpaque_I(0x20400000);
        tessellator.addVertex(0.0, this.displayHeight - j2, 0.0);
        tessellator.addVertex(0.0, this.displayHeight, 0.0);
        tessellator.addVertex(field_155_D.length, this.displayHeight, 0.0);
        tessellator.addVertex(field_155_D.length, this.displayHeight - j2, 0.0);
        tessellator.draw();
        tessellator.startDrawing(1);
        int k2 = 0;
        while (k2 < field_155_D.length) {
            int i1 = (k2 - field_154_E & field_155_D.length - 1) * 255 / field_155_D.length;
            int j1 = i1 * i1 / 255;
            j1 = j1 * j1 / 255;
            int k1 = j1 * j1 / 255;
            k1 = k1 * k1 / 255;
            tessellator.setColorOpaque_I(-16777216 + k1 + j1 * 256 + i1 * 65536);
            long l22 = field_155_D[k2] / 200000L;
            tessellator.addVertex((float)k2 + 0.5f, (float)((long)this.displayHeight - l22) + 0.5f, 0.0);
            tessellator.addVertex((float)k2 + 0.5f, (float)this.displayHeight + 0.5f, 0.0);
            ++k2;
        }
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    public void func_109_d() {
        this.field_153_F = false;
    }

    public void func_123_e() {
        if (!Display.isActive()) {
            return;
        }
        if (this.field_150_I) {
            return;
        }
        this.field_150_I = true;
        this.mouseHelper.func_774_a();
        this.setCurrentScreen(null);
        this.field_135_X = this.field_144_O + 10000;
    }

    public void func_138_f() {
        if (!this.field_150_I) {
            return;
        }
        if (this.thePlayer != null) {
            this.thePlayer.func_458_k();
        }
        this.field_150_I = false;
        this.mouseHelper.func_773_b();
    }

    public void func_117_g() {
        if (this.currentScreen != null) {
            return;
        }
        if (this.thePlayer != null && this.thePlayer.loopHandler != null) {
            this.thePlayer.loopHandler.killLoops();
        }
        this.setCurrentScreen(new GuiIngameMenu());
    }

    private void func_119_a(int i2, boolean flag) {
        if (this.playerController.isCreative) {
            return;
        }
        if (i2 == 0 && this.leftClickCounter > 0) {
            return;
        }
        if (flag && this.objectMouseOver != null && this.objectMouseOver.typeOfHit == 0 && i2 == 0) {
            int j2 = this.objectMouseOver.blockX;
            int k2 = this.objectMouseOver.blockY;
            int l2 = this.objectMouseOver.blockZ;
            this.playerController.sendRemovingBlock(j2, k2, l2, this.objectMouseOver.sideHit);
            this.effectRenderer.addBlockHitEffects(j2, k2, l2, this.objectMouseOver.sideHit);
        } else {
            this.playerController.resetBlockRemoving();
        }
    }

    private void leftClick(int i2) {
        ItemStack itemstack;
        if (i2 == 0 && this.leftClickCounter > 0) {
            return;
        }
        if (i2 == 0) {
            this.thePlayer.swingItem();
        }
        if (this.objectMouseOver == null) {
            if (i2 == 0 && !(this.playerController instanceof PlayerControllerCreative)) {
                this.leftClickCounter = 10;
            }
        } else if (this.objectMouseOver.typeOfHit == 1) {
            if (this.mcWorld.multiplayerWorld) {
                if (i2 == 0) {
                    this.playerController.attackEntity(this.thePlayer, this.objectMouseOver.entityHit);
                }
                if (i2 == 1) {
                    this.playerController.interactWithEntity(this.thePlayer, this.objectMouseOver.entityHit);
                }
            } else {
                if (i2 == 0) {
                    this.thePlayer.attackEntity(this.objectMouseOver.entityHit);
                }
                if (i2 == 1) {
                    this.thePlayer.useCurrentItemOnEntity(this.objectMouseOver.entityHit);
                }
            }
        } else if (this.objectMouseOver.typeOfHit == 0) {
            int j2 = this.objectMouseOver.blockX;
            int k2 = this.objectMouseOver.blockY;
            int i1 = this.objectMouseOver.blockZ;
            int j1 = this.objectMouseOver.sideHit;
            Block block = Block.allBlocks[this.mcWorld.getBlockId(j2, k2, i1)];
            if (i2 == 0) {
                this.mcWorld.func_612_i(j2, k2, i1, this.objectMouseOver.sideHit);
                if (block != Block.bedrock || this.thePlayer.field_777_c >= 100) {
                    this.playerController.clickBlock(j2, k2, i1, this.objectMouseOver.sideHit);
                }
            } else {
                int k1;
                ItemStack itemstack2 = this.thePlayer.inventory.getCurrentItem();
                int n2 = k1 = itemstack2 == null ? 0 : itemstack2.stackSize;
                if (this.playerController.sendPlaceBlock(this.thePlayer, this.mcWorld, itemstack2, j2, k2, i1, j1)) {
                    this.thePlayer.swingItem();
                }
                if (itemstack2 == null) {
                    return;
                }
                if (itemstack2.stackSize == 0 && !this.playerController.isCreative) {
                    this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = null;
                } else if (itemstack2.stackSize != k1) {
                    this.field_167_r.itemRenderer.func_891_b();
                }
            }
        }
        if (i2 == 1 && (this.objectMouseOver == null || this.objectMouseOver != null && this.objectMouseOver.typeOfHit == 0) && (itemstack = this.thePlayer.inventory.getCurrentItem()) != null && this.playerController.sendUseItem(this.thePlayer, this.mcWorld, itemstack)) {
            int l2 = itemstack.stackSize;
            ItemStack itemstack1 = itemstack.useItemRightClick(this.mcWorld, this.thePlayer);
            if (this.playerController.isCreative) {
                itemstack1.stackSize = 1;
            }
            if (itemstack1 != itemstack || itemstack1 != null && itemstack1.stackSize != l2) {
                this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = itemstack1;
                this.field_167_r.itemRenderer.func_896_c();
                if (itemstack1.stackSize == 0) {
                    this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = null;
                }
            }
        }
    }

    public void func_133_h() {
        try {
            this.isFullscreen = !this.isFullscreen;
            System.out.println("Toggle fullscreen!");
            if (this.isFullscreen) {
                ArrayList<DisplayMode> Resolutions = new ArrayList<DisplayMode>();
                try {
                    DisplayMode[] modes = Display.getAvailableDisplayModes();
                    int i2 = 0;
                    while (i2 < modes.length) {
                        DisplayMode current = modes[i2];
                        Resolutions.add(current);
                        ++i2;
                    }
                }
                catch (LWJGLException e2) {
                    e2.printStackTrace();
                }
                if (this.options.displayMode == 0) {
                    Display.setDisplayMode((DisplayMode)Display.getDesktopDisplayMode());
                } else {
                    Display.setDisplayMode((DisplayMode)((DisplayMode)Resolutions.get(this.options.displayMode - 1)));
                }
                this.displayWidth = Display.getDisplayMode().getWidth();
                this.displayHeight = Display.getDisplayMode().getHeight();
                if (this.displayWidth <= 0) {
                    this.displayWidth = 1;
                }
                if (this.displayHeight <= 0) {
                    this.displayHeight = 1;
                }
            } else {
                if (this.field_174_k != null) {
                    this.displayWidth = this.field_174_k.getWidth();
                    this.displayHeight = this.field_174_k.getHeight();
                } else {
                    this.displayWidth = this.field_142_Q;
                    this.displayHeight = this.field_141_R;
                }
                if (this.displayWidth <= 0) {
                    this.displayWidth = 1;
                }
                if (this.displayHeight <= 0) {
                    this.displayHeight = 1;
                }
                Display.setDisplayMode((DisplayMode)new DisplayMode(this.field_142_Q, this.field_141_R));
            }
            this.func_138_f();
            Display.setFullscreen((boolean)this.isFullscreen);
            Display.update();
            if (this.isFullscreen) {
                this.func_123_e();
            }
            if (this.currentScreen != null) {
                this.func_138_f();
                this.func_115_a(this.displayWidth, this.displayHeight);
            }
            System.out.println("Size: " + this.displayWidth + ", " + this.displayHeight);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_115_a(int i2, int j2) {
        if (i2 <= 0) {
            i2 = 1;
        }
        if (j2 <= 0) {
            j2 = 1;
        }
        this.displayWidth = i2;
        this.displayHeight = j2;
        if (this.currentScreen != null) {
            ScaledResolution scaledresolution = new ScaledResolution(i2, j2, this);
            int k2 = scaledresolution.getScaledWidth();
            int l2 = scaledresolution.getScaledHeight();
            this.currentScreen.setResolution(this, k2, l2);
        }
    }

    private void pickBlock() {
        if (this.objectMouseOver != null) {
            int i2 = this.mcWorld.getBlockId(this.objectMouseOver.blockX, this.objectMouseOver.blockY, this.objectMouseOver.blockZ);
            if (i2 == Block.stairDouble.blockID) {
                i2 = Block.stairSingle.blockID;
            }
            if (i2 == Block.bedrock.blockID) {
                i2 = Block.stone.blockID;
            }
            if (i2 == Block.doorWood.blockID) {
                i2 = Item.doorWood.shiftedIndex;
            }
            if (i2 == Block.doorSteel.blockID) {
                i2 = Item.doorSteel.shiftedIndex;
            }
            if (i2 == Block.crops.blockID) {
                i2 = Item.seeds.shiftedIndex;
            }
            if (i2 == Block.pressurePlateWoodIdle.blockID) {
                i2 = Item.sign.shiftedIndex;
            }
            if (i2 == Block.signPost.blockID) {
                i2 = Item.sign.shiftedIndex;
            }
            if (i2 == Block.redstoneWire.blockID) {
                i2 = Item.redstone.shiftedIndex;
            }
            this.thePlayer.inventory.setCurrentItem(i2, 1, this.playerController instanceof PlayerControllerCreative);
        }
    }

    public void func_111_i() {
        this.ingameGUI.func_555_a();
        this.field_167_r.getMouseOver(1.0f);
        if (this.thePlayer != null) {
            this.thePlayer.func_462_n();
        }
        if (!this.field_172_m && this.mcWorld != null) {
            this.playerController.func_728_c();
        }
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/terrain.png"));
        if (!this.field_172_m) {
            this.renderEngine.attachTextureFX();
        }
        if (this.currentScreen == null && this.thePlayer != null && this.thePlayer.health <= 0) {
            this.setCurrentScreen(null);
        }
        if (this.currentScreen != null) {
            this.field_135_X = this.field_144_O + 10000;
        }
        if (this.currentScreen != null) {
            this.currentScreen.func_564_d();
            if (this.currentScreen != null) {
                this.currentScreen.updateScreen();
            }
        }
        if (this.currentScreen == null || this.currentScreen.field_948_f) {
            while (Mouse.next()) {
                long l2 = System.currentTimeMillis() - this.field_148_K;
                if (l2 > 200L) continue;
                int j2 = Mouse.getEventDWheel();
                if (j2 != 0) {
                    this.thePlayer.inventory.changeCurrentItem(j2);
                }
                if (this.currentScreen == null) {
                    if (!this.field_150_I && Mouse.getEventButtonState()) {
                        this.func_123_e();
                        continue;
                    }
                    if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState()) {
                        this.leftClick(0);
                        this.field_135_X = this.field_144_O;
                    }
                    if (Mouse.getEventButton() == 1 && Mouse.getEventButtonState()) {
                        this.leftClick(1);
                        this.field_135_X = this.field_144_O;
                    }
                    if (Mouse.getEventButton() != 2 || !Mouse.getEventButtonState()) continue;
                    this.pickBlock();
                    continue;
                }
                if (this.currentScreen == null) continue;
                this.currentScreen.func_566_e();
            }
            if (this.leftClickCounter > 0) {
                --this.leftClickCounter;
            }
            while (Keyboard.next()) {
                this.thePlayer.func_460_a(Keyboard.getEventKey(), Keyboard.getEventKeyState());
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == 87) {
                    this.func_133_h();
                    continue;
                }
                if (this.currentScreen != null) {
                    this.currentScreen.handleKeyboardInput();
                } else {
                    if (Keyboard.getEventKey() == 1) {
                        this.func_117_g();
                    }
                    if (Keyboard.getEventKey() == 31 && Keyboard.isKeyDown((int)61)) {
                        this.func_129_t();
                    }
                    if (Keyboard.getEventKey() == 63) {
                        boolean bl2 = this.options.thirdPersonView = !this.options.thirdPersonView;
                    }
                    if (Keyboard.getEventKey() == 65) {
                        boolean bl3 = this.enableRain = !this.enableRain;
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindBuild.keyCode && this.thePlayer.isCreative) {
                        this.setCurrentScreen(new GuiBuild(this, 0));
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindInventory.keyCode) {
                        this.setCurrentScreen(new GuiInventory(this.thePlayer));
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindDrop.keyCode) {
                        if (this.thePlayer instanceof EntityClientPlayerMP) {
                            EntityClientPlayerMP entmp = (EntityClientPlayerMP)this.thePlayer;
                            entmp.dropCurrentItem();
                        } else {
                            this.thePlayer.dropInventory(this.thePlayer.inventory.decrStackSize(this.thePlayer.inventory.currentItem, 1), false);
                        }
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindChat.keyCode) {
                        this.setCurrentScreen(new GuiChat());
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindSaveLocation.keyCode && this.thePlayer.isCreative) {
                        this.savedPlayerPos = Vec3D.createVectorHelper(this.thePlayer.posX, this.thePlayer.posY, this.thePlayer.posZ);
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindLoadLocation.keyCode && this.thePlayer.isCreative) {
                        this.thePlayer.setPosition(this.savedPlayerPos.xCoord, this.savedPlayerPos.yCoord, this.savedPlayerPos.zCoord);
                    }
                }
                int i2 = 0;
                while (i2 < 9) {
                    if (Keyboard.getEventKey() == 2 + i2) {
                        this.thePlayer.inventory.currentItem = i2;
                    }
                    ++i2;
                }
                if (Keyboard.getEventKey() != this.options.keyBindToggleFog.keyCode) continue;
                this.options.func_1045_b(4, !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54) ? 1 : -1);
            }
            if (this.currentScreen == null) {
                if (Mouse.isButtonDown((int)0) && (float)(this.field_144_O - this.field_135_X) >= this.field_146_M.field_1380_a / 4.0f && this.field_150_I) {
                    this.leftClick(0);
                    this.field_135_X = this.field_144_O;
                }
                if (Mouse.isButtonDown((int)1) && (float)(this.field_144_O - this.field_135_X) >= this.field_146_M.field_1380_a / 4.0f && this.field_150_I) {
                    this.leftClick(1);
                    this.field_135_X = this.field_144_O;
                }
            }
            this.func_119_a(0, this.currentScreen == null && Mouse.isButtonDown((int)0) && this.field_150_I);
        }
        if (this.mcWorld != null) {
            if (this.thePlayer != null) {
                ++this.field_134_Y;
                if (this.field_134_Y == 30) {
                    this.field_134_Y = 0;
                    this.mcWorld.func_705_f(this.thePlayer);
                }
            }
            this.mcWorld.difficulty = this.options.difficulty;
            if (this.mcWorld.multiplayerWorld) {
                this.mcWorld.difficulty = this.mcWorld.multiplayerDifficulty;
            } else {
                this.mcWorld.setSaveInterval(this.options.chunkSavingInterval);
            }
            if (!this.field_172_m) {
                this.field_167_r.updateRenderer();
            }
            if (!this.field_172_m) {
                this.renderGlobal.func_945_d();
            }
            if (!this.field_172_m) {
                this.mcWorld.updateEntityList();
            }
            if (!this.field_172_m || this.isServer()) {
                this.mcWorld.tick();
            }
            if (!this.field_172_m && this.mcWorld != null) {
                this.mcWorld.func_677_m(MathHelper.floor_double(this.thePlayer.posX), MathHelper.floor_double(this.thePlayer.posY), MathHelper.floor_double(this.thePlayer.posZ));
            }
            if (!this.field_172_m) {
                this.effectRenderer.updateEffects();
            }
        }
        this.field_148_K = System.currentTimeMillis();
    }

    private void func_129_t() {
        System.out.println("FORCING RELOAD!");
        this.soundMGR = new SoundManager();
        this.soundMGR.initialize(this.options);
        this.field_145_N.func_1210_a();
    }

    public boolean isServer() {
        return this.mcWorld != null && this.mcWorld.multiplayerWorld;
    }

    public void func_113_b(String s2, boolean snowCovered, boolean cheatsEnabled, int worldType) {
        this.changeWorld1(null);
        System.gc();
        World world = new World(new File(Minecraft.func_106_b(), "NSSSsaves"), s2, snowCovered, cheatsEnabled, worldType, this);
        if (world.isNewWorld) {
            this.func_105_a(world, "Generating level");
        } else {
            this.func_105_a(world, "Loading level");
        }
    }

    public void changeWorld1(World world) {
        this.func_105_a(world, "");
    }

    public void func_105_a(World world, String s2) {
        this.soundMGR.playStreaming(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.mcWorld != null) {
            this.mcWorld.doWorldSave(this.loadScreen);
        }
        this.mcWorld = world;
        if (world != null) {
            this.playerController.func_717_a(world);
            world.field_1038_m = this.fontRender;
            if (!this.isServer()) {
                this.thePlayer = (EntityPlayerSP)world.func_661_a(EntityPlayerSP.class);
            } else if (this.thePlayer != null) {
                this.thePlayer.preparePlayerToSpawn();
                if (world != null) {
                    world.entityJoinedWorld(this.thePlayer);
                }
            }
            if (!world.multiplayerWorld) {
                this.func_120_d(s2);
            }
            if (this.thePlayer == null) {
                this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(world);
                this.thePlayer.preparePlayerToSpawn();
                this.playerController.flipPlayer(this.thePlayer);
            }
            this.thePlayer.currentInput = new MovementInputFromOptions(this.options);
            if (this.renderGlobal != null) {
                this.renderGlobal.func_946_a(world);
            }
            if (this.effectRenderer != null) {
                this.effectRenderer.clearEffects(world);
            }
            this.playerController.initiateInventory(this.thePlayer);
            world.spawnPlayerWithLoadedChunks(this.thePlayer);
            if (world.isNewWorld) {
                world.doWorldSave(this.loadScreen);
            }
        } else {
            this.thePlayer = null;
            this.playerController = new PlayerControllerSP(this);
            this.renderGlobal.func_946_a(null);
            this.effectRenderer.clearEffects(null);
            this.renderGlobal.clear();
        }
        System.gc();
        this.field_148_K = 0L;
    }

    private void func_120_d(String s2) {
        this.loadScreen.func_596_a(s2);
        this.loadScreen.func_595_d("Building terrain");
        int questionMark = 128;
        int i2 = 0;
        int prog = questionMark * 2 / 16 + 1;
        prog *= prog;
        int k2 = -questionMark;
        while (k2 <= questionMark) {
            int spawnX = this.mcWorld.spawnX;
            int spawnZ = this.mcWorld.spawnZ;
            if (this.thePlayer != null) {
                spawnX = (int)this.thePlayer.posX;
                spawnZ = (int)this.thePlayer.posZ;
            }
            int j1 = -questionMark;
            while (j1 <= questionMark) {
                this.loadScreen.setProgess(i2++ * 100 / prog);
                this.mcWorld.getBlockId(spawnX + k2, 64, spawnZ + j1);
                j1 += 16;
            }
            k2 += 16;
        }
        System.out.println("Pass four");
        this.loadScreen.func_595_d("Simulating world for a bit");
        prog = 2000;
        this.mcWorld.func_656_j();
    }

    public void func_131_a(String s2, File file) {
        int i2 = s2.indexOf("/");
        String s1 = s2.substring(0, i2);
        s2 = s2.substring(i2 + 1);
        if (s1.equalsIgnoreCase("sound")) {
            this.soundMGR.addToSoundPool(s2, file);
        } else if (s1.equalsIgnoreCase("newsound")) {
            this.soundMGR.addToSoundPool(s2, file);
        } else if (s1.equalsIgnoreCase("streaming")) {
            this.soundMGR.addToStreamingPool(s2, file);
        } else if (s1.equalsIgnoreCase("music")) {
            this.soundMGR.addToMusicPool(s2, file);
        } else if (s1.equalsIgnoreCase("newmusic")) {
            this.soundMGR.addToMusicPool(s2, file);
        } else if (s1.equalsIgnoreCase("loops")) {
            this.soundMGR.addToLoopsPool(s2, file);
        }
    }

    public OpenGlCapsChecker func_137_k() {
        return this.field_147_L;
    }

    public String func_122_l() {
        return this.renderGlobal.func_953_b();
    }

    public String func_107_m() {
        return this.renderGlobal.func_957_c();
    }

    public String func_125_n() {
        return "Particles: " + this.effectRenderer.func_1190_b() + (". Gfx: " + GL11.glGetString((int)7937) + " ") + this.mcWorld.func_687_d();
    }

    public void respawn() {
        this.mcWorld.func_622_a();
        if (this.thePlayer != null) {
            this.mcWorld.setEntityDead(this.thePlayer);
        }
        this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(this.mcWorld);
        this.thePlayer.preparePlayerToSpawn();
        this.playerController.flipPlayer(this.thePlayer);
        this.mcWorld.spawnPlayerWithLoadedChunks(this.thePlayer);
        this.thePlayer.currentInput = new MovementInputFromOptions(this.options);
        this.playerController.initiateInventory(this.thePlayer);
        this.func_120_d("Respawning");
    }

    public void respawn(boolean flag, int i2) {
        System.out.println("RESPAWNING!");
        ChunkCoordinates chunkcoordinates = null;
        ChunkCoordinates chunkcoordinates1 = null;
        boolean flag1 = true;
        if (this.thePlayer != null && !flag && (chunkcoordinates = this.thePlayer.getPlayerSpawnCoordinate()) != null) {
            chunkcoordinates1 = EntityPlayer.func_25060_a(this.mcWorld, chunkcoordinates);
        }
        System.out.println("pass if 1");
        if (chunkcoordinates1 == null) {
            chunkcoordinates1 = this.mcWorld.getSpawnPoint();
            flag1 = false;
        }
        System.out.println("pass if 2");
        IChunkProvider ichunkprovider = this.mcWorld.chunkProvider;
        if (ichunkprovider instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            chunkproviderloadorgenerate.setCurrentChunkOver(chunkcoordinates1.x >> 4, chunkcoordinates1.z >> 4);
        }
        System.out.println("pass if 3");
        this.mcWorld.updateEntityList();
        int j2 = 0;
        if (this.thePlayer != null) {
            j2 = this.thePlayer.entityId;
            this.mcWorld.setEntityDead(this.thePlayer);
        }
        System.out.println("pass if 4");
        this.renderViewEntity = null;
        this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(this.mcWorld);
        this.renderViewEntity = this.thePlayer;
        this.thePlayer.preparePlayerToSpawn();
        if (flag1) {
            this.thePlayer.setPlayerSpawnCoordinate(chunkcoordinates);
            this.thePlayer.setLocationAndAngles((float)chunkcoordinates1.x + 0.5f, (float)chunkcoordinates1.y + 0.1f, (float)chunkcoordinates1.z + 0.5f, 0.0f, 0.0f);
        }
        System.out.println("pass if 5");
        this.playerController.flipPlayer(this.thePlayer);
        this.mcWorld.spawnPlayerWithLoadedChunks(this.thePlayer);
        this.thePlayer.currentInput = new MovementInputFromOptions(this.options);
        this.thePlayer.entityId = j2;
        this.thePlayer.func_6420_o();
        this.playerController.initiateInventory(this.thePlayer);
        this.func_120_d("Respawning");
        if (this.currentScreen instanceof GuiGameOver) {
            this.setCurrentScreen(null);
        }
        System.out.println("pass if 6");
    }

    public static void start(String username, String uuid, String token) {
        Minecraft.startMainThread(username, token, uuid, null);
    }

    public static void startMainThread(String s2, String sessionId, String uuid, String s22) {
        boolean flag = false;
        String username = s2;
        Frame frame = new Frame("Minecraft");
        Canvas canvas = new Canvas();
        frame.setLayout(new BorderLayout());
        frame.add((Component)canvas, "Center");
        canvas.setPreferredSize(new Dimension(854, 480));
        frame.pack();
        frame.setLocationRelativeTo(null);
        MinecraftImpl minecraftimpl = new MinecraftImpl(frame, canvas, null, 854, 480, flag, frame);
        Thread thread = new Thread((Runnable)minecraftimpl, "Minecraft main thread");
        thread.setPriority(10);
        minecraftimpl.field_173_l = false;
        minecraftimpl.field_175_j = "www.minecraft.net";
        System.out.println(String.valueOf(username) + " " + sessionId + " " + uuid);
        minecraftimpl.session = username != null && sessionId != null && uuid != null ? new Session(username, sessionId, uuid) : (username != null && sessionId != null ? new Session(username, sessionId) : new Session("Player" + System.currentTimeMillis() % 1000L, "", ""));
        if (s22 != null) {
            String[] as2 = s22.split(":");
            minecraftimpl.func_121_a(as2[0], Integer.parseInt(as2[1]));
        }
        frame.setVisible(true);
        frame.addWindowListener(new GameWindowListener(minecraftimpl, thread));
        thread.start();
    }

    public NetClientHandler getSendQueue() {
        if (this.thePlayer instanceof EntityClientPlayerMP) {
            return ((EntityClientPlayerMP)this.thePlayer).sendQueue;
        }
        return null;
    }

    public static void main(String[] args) {
        String username = args.length > 0 ? args[0] : "Player";
        String uuid = args.length > 1 ? args[1] : "0";
        String token = args.length > 2 ? args[2] : "0";
        Minecraft.start(username, uuid, token);
    }

    public static Minecraft getMinecraft() {
        return theMinecraft;
    }
}

