/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityGiant;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityList;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFluids;
import com.mojang.minecraft.level.tile.StepSound;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagDouble;
import com.mojang.minecraft.nbt.NBTTagFloat;
import com.mojang.minecraft.nbt.NBTTagList;
import com.mojang.minecraft.networknew.DataWatcher;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;
import java.util.List;
import java.util.Random;

public abstract class Entity {
    private static int nextEntityId = 0;
    public int entityId;
    public double renderDistanceWeight = 1.0;
    public boolean preventEntitySpawning = false;
    public Entity riddenByEntity;
    public Entity entityBeingRidden;
    public World worldObj;
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;
    public double posX;
    public double posY;
    public double posZ;
    public double motionX;
    public double motionY;
    public double motionZ;
    public float rotationYaw;
    public float rotationPitch;
    public float prevRotationYaw;
    public float prevRotationPitch;
    public final AxisAlignedBB boundingBox = AxisAlignedBB.getBoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround = false;
    public boolean isCollidedHorizionally;
    public boolean isCollidedVertically;
    public boolean isCollided = false;
    public boolean beenAttacked = true;
    public boolean isInWeb;
    public boolean isDead = false;
    public float yOffset = 0.0f;
    public float width = 0.6f;
    public float height = 1.8f;
    public float prevDistanceWalkedModified = 0.0f;
    public float distanceWalkedModified = 0.0f;
    protected boolean field_640_aG = true;
    protected float fallDistance = 0.0f;
    private int nextStepDistance = 1;
    public double lastTickPosX;
    public double lastTickPosY;
    public double lastTickPosZ;
    public float ySize = 0.0f;
    public float stepHeight = 0.0f;
    public boolean noClip = false;
    public float entityCollisionReduction = 0.0f;
    public boolean field_631_aP = false;
    protected Random rand;
    public int ticksExisted = 0;
    public int fireResistance = 1;
    public int fire = 0;
    protected int maxAir = 300;
    protected boolean inWater = false;
    protected boolean inLava;
    public int heartsLife = 0;
    public int air = 300;
    private boolean isFirstUpdate = true;
    public String skinURL;
    public String cloakURL;
    protected DataWatcher dataWatcher;
    private double entityRiderPitchDelta;
    private double entityRiderYawDelta;
    public boolean addedToChunk = false;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    public int serverPosX;
    public int serverPosY;
    public int serverPosZ;
    boolean flipflop = false;
    int leatherArmor;
    public int steelArmor;
    public int diamondArmor;
    public int chainArmor;
    public int goldArmor;

    public Entity(World world) {
        this.entityId = nextEntityId++;
        this.rand = new Random();
        this.dataWatcher = new DataWatcher();
        this.worldObj = world;
        this.setPosition(0.0, 0.0, 0.0);
        this.dataWatcher.addObject(0, (byte)0);
        this.leatherArmor = 0;
        this.entityInit();
    }

    protected abstract void entityInit();

    public DataWatcher getDataWatcher() {
        return this.dataWatcher;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Entity) {
            return ((Entity)obj).entityId == this.entityId;
        }
        return false;
    }

    public int hashCode() {
        return this.entityId;
    }

    protected void preparePlayerToSpawn() {
        if (this.worldObj == null) {
            return;
        }
        while (!(this.posY <= 0.0)) {
            this.setPosition(this.posX, this.posY, this.posZ);
            if (this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0) break;
            this.posY += 1.0;
        }
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.rotationPitch = 0.0f;
    }

    public void setEntityDead() {
        this.isDead = true;
    }

    protected void setSize(float f2, float f1) {
        this.width = f2;
        this.height = f1;
    }

    protected void setRotation(float f2, float f1) {
        this.rotationYaw = f2;
        this.rotationPitch = f1;
    }

    public void setPosition(double d2, double d1, double d22) {
        this.posX = d2;
        this.posY = d1;
        this.posZ = d22;
        float f2 = this.width / 2.0f;
        float f1 = this.height;
        this.boundingBox.setBounds(d2 - (double)f2, d1 - (double)this.yOffset + (double)this.ySize, d22 - (double)f2, d2 + (double)f2, d1 - (double)this.yOffset + (double)this.ySize + (double)f1, d22 + (double)f2);
    }

    public void func_346_d(float f2, float f1) {
        float f22 = this.rotationPitch;
        float f3 = this.rotationYaw;
        this.rotationYaw = (float)((double)this.rotationYaw + (double)f2 * 0.15);
        this.rotationPitch = (float)((double)this.rotationPitch - (double)f1 * 0.15);
        if (this.rotationPitch < -90.0f) {
            this.rotationPitch = -90.0f;
        }
        if (this.rotationPitch > 90.0f) {
            this.rotationPitch = 90.0f;
        }
        this.prevRotationPitch += this.rotationPitch - f22;
        this.prevRotationYaw += this.rotationYaw - f3;
    }

    public void onUpdate() {
        this.onEntityUpdate();
    }

    public void onEntityUpdate() {
        if (this.entityBeingRidden != null && this.entityBeingRidden.isDead) {
            this.entityBeingRidden = null;
        }
        ++this.ticksExisted;
        this.prevDistanceWalkedModified = this.distanceWalkedModified;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.prevRotationPitch = this.rotationPitch;
        this.prevRotationYaw = this.rotationYaw;
        if (this.handleWaterMovement()) {
            if (!this.inWater && !this.isFirstUpdate) {
                float f2 = MathHelper.sqrt_double(this.motionX * this.motionX * (double)0.2f + this.motionY * this.motionY + this.motionZ * this.motionZ * (double)0.2f) * 0.2f;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                this.worldObj.playSoundAtEntity(this, "random.splash", f2, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                float f1 = MathHelper.floor_double(this.boundingBox.minY);
                int i2 = 0;
                while ((float)i2 < 1.0f + this.width * 20.0f) {
                    float f22 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    float f4 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.spawnParticle("bubble", this.posX + (double)f22, f1 + 1.0f, this.posZ + (double)f4, this.motionX, this.motionY - (double)(this.rand.nextFloat() * 0.2f), this.motionZ);
                    ++i2;
                }
                int j2 = 0;
                while ((float)j2 < 1.0f + this.width * 20.0f) {
                    float f3 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    float f5 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.spawnParticle("splash", this.posX + (double)f3, f1 + 1.0f, this.posZ + (double)f5, this.motionX, this.motionY, this.motionZ);
                    ++j2;
                }
            }
            this.fallDistance = 0.0f;
            this.inWater = true;
            this.fire = 0;
        } else if (!this.handleLeavesMovement()) {
            this.inWater = false;
        }
        if (this.worldObj.multiplayerWorld) {
            this.fire = 0;
        } else if (this.fire > 0) {
            if (this.leatherArmor == 0) {
                if (this.fire % 20 == 0) {
                    this.attackEntityFrom(null, 1);
                }
            } else if (this.leatherArmor == 1) {
                if (this.fire % 30 == 0) {
                    this.attackEntityFrom(null, 1);
                }
            } else if (this.leatherArmor == 2) {
                if (this.fire % 40 == 0) {
                    this.attackEntityFrom(null, 1);
                }
            } else if (this.leatherArmor == 3) {
                if (this.fire % 50 == 0) {
                    this.attackEntityFrom(null, 1);
                }
            } else if (this.leatherArmor == 4 && this.fire % 60 == 0) {
                this.attackEntityFrom(null, 1);
            }
            --this.fire;
        }
        if (this.handleLavaMovement()) {
            this.attackEntityFrom(null, 10 - this.leatherArmor * 2);
            this.fire = 600;
            if (!this.inLava && !this.isFirstUpdate) {
                float f5;
                float f1 = MathHelper.floor_double(this.boundingBox.minY);
                int j3 = 0;
                while ((float)j3 < 1.0f + this.width * 20.0f) {
                    float f3 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    f5 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.spawnParticle("lava", this.posX + (double)f3, f1 + 1.0f, this.posZ + (double)f5, this.motionX, this.motionY, this.motionZ);
                    ++j3;
                }
                j3 = 0;
                while ((float)j3 < 1.0f + this.width * 20.0f) {
                    float f3 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    f5 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.spawnParticle("flame", this.posX + (double)f3, f1 + 1.0f, this.posZ + (double)f5, this.motionX, this.motionY + (double)(this.rand.nextFloat() * 0.2f), this.motionZ);
                    ++j3;
                }
                this.inLava = true;
            }
        } else {
            this.inLava = false;
        }
        if (this.posY < -64.0) {
            this.kill();
        }
        if (!this.worldObj.multiplayerWorld) {
            this.setEntityFlag(0, this.fire > 0);
            this.setEntityFlag(2, this.entityBeingRidden != null);
        }
        this.isFirstUpdate = false;
    }

    protected void kill() {
        this.setEntityDead();
    }

    public boolean isOffsetPositionInLiquid(double d2, double d1, double d22) {
        AxisAlignedBB axisalignedbb = this.boundingBox.getOffsetBoundingBox(d2, d1, d22);
        List<AxisAlignedBB> list = this.worldObj.getCollidingBoundingBoxes(this, axisalignedbb);
        if (list.size() > 0) {
            return false;
        }
        return !this.worldObj.getIsAnyLiquid(axisalignedbb);
    }

    public void moveEntity(double d2, double d1, double d22) {
        boolean flag;
        if (this.noClip) {
            this.boundingBox.offset(d2, d1, d22);
            this.posX = (this.boundingBox.minX + this.boundingBox.maxX) / 2.0;
            this.posY = this.boundingBox.minY + (double)this.yOffset - (double)this.ySize;
            this.posZ = (this.boundingBox.minZ + this.boundingBox.maxZ) / 2.0;
            return;
        }
        double d3 = this.posX;
        double d4 = this.posZ;
        if (this.isInWeb) {
            this.isInWeb = false;
            d2 *= 0.25;
            d1 *= (double)0.05f;
            d22 *= 0.25;
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
        }
        double d5 = d2;
        double d6 = d1;
        double d7 = d22;
        AxisAlignedBB axisalignedbb = this.boundingBox.copy();
        boolean bl2 = flag = this.onGround && this.getIsSneaking();
        if (flag) {
            double d8 = 0.05;
            while (d2 != 0.0 && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getOffsetBoundingBox(d2, -1.0, 0.0)).size() == 0) {
                d2 = d2 < d8 && d2 >= -d8 ? 0.0 : (d2 > 0.0 ? (d2 -= d8) : (d2 += d8));
                d5 = d2;
            }
            while (d22 != 0.0 && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getOffsetBoundingBox(0.0, -1.0, d22)).size() == 0) {
                d22 = d22 < d8 && d22 >= -d8 ? 0.0 : (d22 > 0.0 ? (d22 -= d8) : (d22 += d8));
                d7 = d22;
            }
        }
        List<AxisAlignedBB> list = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.addCoord(d2, d1, d22));
        int i2 = 0;
        while (i2 < list.size()) {
            d1 = list.get(i2).calculateYOffset(this.boundingBox, d1);
            ++i2;
        }
        this.boundingBox.offset(0.0, d1, 0.0);
        if (!this.beenAttacked && d6 != d1) {
            d22 = 0.0;
            d1 = 0.0;
            d2 = 0.0;
        }
        boolean flag1 = this.onGround || d6 != d1 && d6 < 0.0;
        int j2 = 0;
        while (j2 < list.size()) {
            d2 = list.get(j2).calculateXOffset(this.boundingBox, d2);
            ++j2;
        }
        this.boundingBox.offset(d2, 0.0, 0.0);
        if (!this.beenAttacked && d5 != d2) {
            d22 = 0.0;
            d1 = 0.0;
            d2 = 0.0;
        }
        int k2 = 0;
        while (k2 < list.size()) {
            d22 = list.get(k2).calculateZOffset(this.boundingBox, d22);
            ++k2;
        }
        this.boundingBox.offset(0.0, 0.0, d22);
        if (!this.beenAttacked && d7 != d22) {
            d22 = 0.0;
            d1 = 0.0;
            d2 = 0.0;
        }
        if (this.stepHeight > 0.0f && flag1 && this.ySize < 0.05f && (d5 != d2 || d7 != d22)) {
            double d9 = d2;
            double d11 = d1;
            double d13 = d22;
            d2 = d5;
            d1 = this.stepHeight;
            d22 = d7;
            AxisAlignedBB axisalignedbb1 = this.boundingBox.copy();
            this.boundingBox.setBB(axisalignedbb);
            List<AxisAlignedBB> list1 = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.addCoord(d2, d1, d22));
            int j22 = 0;
            while (j22 < list1.size()) {
                d1 = list1.get(j22).calculateYOffset(this.boundingBox, d1);
                ++j22;
            }
            this.boundingBox.offset(0.0, d1, 0.0);
            if (!this.beenAttacked && d6 != d1) {
                d22 = 0.0;
                d1 = 0.0;
                d2 = 0.0;
            }
            int k22 = 0;
            while (k22 < list1.size()) {
                d2 = list1.get(k22).calculateXOffset(this.boundingBox, d2);
                ++k22;
            }
            this.boundingBox.offset(d2, 0.0, 0.0);
            if (!this.beenAttacked && d5 != d2) {
                d22 = 0.0;
                d1 = 0.0;
                d2 = 0.0;
            }
            int l2 = 0;
            while (l2 < list1.size()) {
                d22 = list1.get(l2).calculateZOffset(this.boundingBox, d22);
                ++l2;
            }
            this.boundingBox.offset(0.0, 0.0, d22);
            if (!this.beenAttacked && d7 != d22) {
                d22 = 0.0;
                d1 = 0.0;
                d2 = 0.0;
            }
            if (d9 * d9 + d13 * d13 >= d2 * d2 + d22 * d22) {
                d2 = d9;
                d1 = d11;
                d22 = d13;
                this.boundingBox.setBB(axisalignedbb1);
            } else {
                this.ySize = (float)((double)this.ySize + 0.5);
            }
        }
        if (!this.worldObj.multiplayerWorld || this instanceof EntityPlayer || !(this instanceof EntityLiving)) {
            this.posX = (this.boundingBox.minX + this.boundingBox.maxX) / 2.0;
            this.posY = this.boundingBox.minY + (double)this.yOffset - (double)this.ySize;
            this.posZ = (this.boundingBox.minZ + this.boundingBox.maxZ) / 2.0;
        }
        this.isCollidedHorizionally = d5 != d2 || d7 != d22;
        this.isCollidedVertically = d6 != d1;
        this.onGround = d6 != d1 && d6 < 0.0;
        boolean bl3 = this.isCollided = this.isCollidedHorizionally || this.isCollidedVertically;
        if (this.onGround) {
            if (this.fallDistance > 0.0f) {
                this.fall(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (d1 < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - d1);
        }
        if (d5 != d2) {
            this.motionX = 0.0;
        }
        if (d6 != d1) {
            this.motionY = 0.0;
        }
        if (d7 != d22) {
            this.motionZ = 0.0;
        }
        double d10 = this.posX - d3;
        double d12 = this.posZ - d4;
        this.distanceWalkedModified = (float)((double)this.distanceWalkedModified + (double)MathHelper.sqrt_double(d10 * d10 + d12 * d12) * 0.6);
        if (this.field_640_aG && !flag) {
            int l2 = MathHelper.floor_double(this.posX);
            int j1 = MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset);
            int l1 = MathHelper.floor_double(this.posZ);
            int i3 = this.worldObj.getBlockId(l2, j1, l1);
            float vol = 0.15f;
            float pit = 1.0f;
            if (this instanceof EntityGiant) {
                vol = 0.5f;
                pit = 0.25f;
            }
            if (this.distanceWalkedModified > (float)this.nextStepDistance && i3 > 0) {
                ++this.nextStepDistance;
                StepSound stepsound = Block.allBlocks[i3].stepSound;
                if (this instanceof EntityPlayer && ((EntityPlayer)this).inventory.armorInventory[0] != null && ((EntityPlayer)this).inventory.armorInventory[0].itemID == Item.bootsSponge.shiftedIndex) {
                    if (this.flipflop) {
                        this.worldObj.playSoundAtEntity(this, "step.spongea", stepsound.getVolume() * 0.15f, stepsound.getPitch() + (this.rand.nextFloat() / 5.0f - 0.1f));
                    } else {
                        this.worldObj.playSoundAtEntity(this, "step.spongeb", stepsound.getVolume() * 0.15f, stepsound.getPitch() + (this.rand.nextFloat() / 5.0f - 0.1f));
                    }
                    this.flipflop = !this.flipflop;
                } else if (this.worldObj.getBlockId(l2, j1 + 1, l1) == Block.snow.blockID) {
                    stepsound = Block.snow.stepSound;
                    this.worldObj.playSoundAtEntity(this, stepsound.func_1145_d(), stepsound.getVolume() * vol, stepsound.getPitch() * pit);
                } else if (!Block.allBlocks[i3].blockMaterial.getIsGroundCover()) {
                    this.worldObj.playSoundAtEntity(this, stepsound.func_1145_d(), stepsound.getVolume() * vol, stepsound.getPitch() * pit);
                }
                Block.allBlocks[i3].onEntityWalking(this.worldObj, l2, j1, l1, this);
            }
        }
        int i1 = MathHelper.floor_double(this.boundingBox.minX);
        int k1 = MathHelper.floor_double(this.boundingBox.minY);
        int i22 = MathHelper.floor_double(this.boundingBox.minZ);
        int j3 = MathHelper.floor_double(this.boundingBox.maxX);
        int k3 = MathHelper.floor_double(this.boundingBox.maxY);
        int l3 = MathHelper.floor_double(this.boundingBox.maxZ);
        int i4 = i1;
        while (i4 <= j3) {
            int j4 = k1;
            while (j4 <= k3) {
                int k4 = i22;
                while (k4 <= l3) {
                    int l4 = this.worldObj.getBlockId(i4, j4, k4);
                    if (l4 > 0) {
                        Block.allBlocks[l4].onEntityCollidedWithBlock(this.worldObj, i4, j4, k4, this);
                    }
                    ++k4;
                }
                ++j4;
            }
            ++i4;
        }
        this.ySize *= 0.4f;
        boolean flag2 = this.handleWaterMovement();
        if (this.worldObj.isBoundingBoxBurning(this.boundingBox)) {
            this.dealFireDamage(1);
            if (!flag2) {
                ++this.fire;
                if (this.fire == 0) {
                    this.fire = 300;
                }
            }
        } else if (this.fire <= 0) {
            this.fire = -this.fireResistance;
        }
        if (flag2 && this.fire > 0) {
            this.worldObj.playSoundAtEntity(this, "random.fizz", 0.7f, 1.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
            this.fire = -this.fireResistance;
        }
    }

    public boolean getIsSneaking() {
        return this.isSneaking();
    }

    public AxisAlignedBB func_372_f_() {
        return null;
    }

    protected void dealFireDamage(int i2) {
        this.attackEntityFrom(null, i2);
    }

    protected void fall(float f2) {
    }

    public boolean handleWaterMovement() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox.expand(0.0, -0.4f, 0.0), Material.water, this);
    }

    public boolean handleLeavesMovement() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox.expand(0.0, -0.4f, 0.0), Material.leaves, this);
    }

    public boolean isInsideOfMaterial(Material material) {
        int k2;
        int j2;
        double d2 = this.posY + (double)this.func_373_s();
        int i2 = MathHelper.floor_double(this.posX);
        int l2 = this.worldObj.getBlockId(i2, j2 = MathHelper.floor_float(MathHelper.floor_double(d2)), k2 = MathHelper.floor_double(this.posZ));
        if (l2 != 0 && Block.allBlocks[l2].blockMaterial == material) {
            float f2 = BlockFluids.getFluidLevel(this.worldObj.getBlockMetadata(i2, j2, k2)) - 0.1111111f;
            float f1 = (float)(j2 + 1) - f2;
            return d2 < (double)f1;
        }
        return false;
    }

    protected float func_373_s() {
        return 0.0f;
    }

    public boolean handleLavaMovement() {
        return this.worldObj.func_689_a(this.boundingBox.expand(0.0, -0.4f, 0.0), Material.lava);
    }

    public void moveFlying(float f2, float f1, float f22) {
        float f3 = MathHelper.sqrt_float(f2 * f2 + f1 * f1);
        if (f3 < 0.01f) {
            return;
        }
        if (f3 < 1.0f) {
            f3 = 1.0f;
        }
        f3 = f22 / f3;
        float f4 = MathHelper.sin(this.rotationYaw * 3.141593f / 180.0f);
        float f5 = MathHelper.cos(this.rotationYaw * 3.141593f / 180.0f);
        this.motionX += (double)((f2 *= f3) * f5 - (f1 *= f3) * f4);
        this.motionZ += (double)(f1 * f5 + f2 * f4);
    }

    public float getEntityBrightness(float f2) {
        int i2 = MathHelper.floor_double(this.posX);
        double d2 = (this.boundingBox.maxY - this.boundingBox.minY) * 0.66;
        int j2 = MathHelper.floor_double(this.posY - (double)this.yOffset + d2);
        int k2 = MathHelper.floor_double(this.posZ);
        return this.worldObj.getBrightness(i2, j2, k2);
    }

    public void setWorld(World world) {
        this.worldObj = world;
    }

    public void setPositionAndRotation(double d2, double d1, double d22, float f2, float f1) {
        this.prevPosX = this.posX = d2;
        this.prevPosY = this.posY = d1;
        this.prevPosZ = this.posZ = d22;
        this.rotationYaw = f2;
        this.rotationPitch = f1;
        this.ySize = 0.0f;
        double d3 = this.prevRotationYaw - f2;
        if (d3 < -180.0) {
            this.prevRotationYaw += 360.0f;
        }
        if (d3 >= 180.0) {
            this.prevRotationYaw -= 360.0f;
        }
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public void setLocationAndAngles(double d2, double d1, double d22, float f2, float f1) {
        this.prevPosX = this.posX = d2;
        this.prevPosY = this.posY = d1 + (double)this.yOffset;
        this.prevPosZ = this.posZ = d22;
        this.rotationYaw = f2;
        this.rotationPitch = f1;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public float getDistanceToEntity(Entity entity) {
        float f2 = (float)(this.posX - entity.posX);
        float f1 = (float)(this.posY - entity.posY);
        float f22 = (float)(this.posZ - entity.posZ);
        return MathHelper.sqrt_float(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double getDistanceSq(double d2, double d1, double d22) {
        double d3 = this.posX - d2;
        double d4 = this.posY - d1;
        double d5 = this.posZ - d22;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double getDistance(double d2, double d1, double d22) {
        double d3 = this.posX - d2;
        double d4 = this.posY - d1;
        double d5 = this.posZ - d22;
        return MathHelper.sqrt_double(d3 * d3 + d4 * d4 + d5 * d5);
    }

    public double getDistanceSqToEntity(Entity entity) {
        double d2 = this.posX - entity.posX;
        double d1 = this.posY - entity.posY;
        double d22 = this.posZ - entity.posZ;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public void onCollideWithPlayer(EntityPlayer entityplayer) {
    }

    public void applyEntityCollision(Entity entity) {
        if (entity.riddenByEntity == this || entity.entityBeingRidden == this) {
            return;
        }
        double d2 = entity.posX - this.posX;
        double d1 = entity.posZ - this.posZ;
        double d22 = MathHelper.func_1107_a(d2, d1);
        if (d22 >= (double)0.01f) {
            d22 = MathHelper.sqrt_double(d22);
            d2 /= d22;
            d1 /= d22;
            double d3 = 1.0 / d22;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d2 *= d3;
            d1 *= d3;
            d2 *= (double)0.05f;
            d1 *= (double)0.05f;
            this.addVelocity(-(d2 *= (double)(1.0f - this.entityCollisionReduction)), 0.0, -(d1 *= (double)(1.0f - this.entityCollisionReduction)));
            entity.addVelocity(d2, 0.0, d1);
        }
    }

    public void addVelocity(double d2, double d1, double d22) {
        this.motionX += d2;
        this.motionY += d1;
        this.motionZ += d22;
    }

    public void setVelocity(double d2, double d1, double d22) {
        this.motionX = d2;
        this.motionY = d1;
        this.motionZ = d22;
    }

    public void handleHealthUpdate(byte byte0) {
    }

    public boolean attackEntityFrom(Entity entity, int i2) {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canBePushed() {
        return false;
    }

    public void addToPlayerScore(Entity entity, int i2) {
    }

    public boolean isInRangeToRenderVec3D(Vec3D vec3d) {
        double d2 = this.posX - vec3d.xCoord;
        double d1 = this.posY - vec3d.yCoord;
        double d22 = this.posZ - vec3d.zCoord;
        double d3 = d2 * d2 + d1 * d1 + d22 * d22;
        return this.isInRangeToRenderDist(d3);
    }

    public boolean isInRangeToRenderDist(double d2) {
        double d1 = this.boundingBox.getAverageEdgeLength();
        return d2 < (d1 *= 64.0 * this.renderDistanceWeight) * d1;
    }

    public String getEntityTexture() {
        return null;
    }

    public boolean addEntityID(NBTTagCompound nbttagcompound) {
        String s2 = this.getEntityString();
        if (this.isDead || s2 == null) {
            return false;
        }
        nbttagcompound.setString("id", s2);
        this.writeToNBT(nbttagcompound);
        return true;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_762_a("Pos", this.newDoubleNBTList(new double[]{this.posX, this.posY, this.posZ}));
        nbttagcompound.func_762_a("Motion", this.newDoubleNBTList(new double[]{this.motionX, this.motionY, this.motionZ}));
        nbttagcompound.func_762_a("Rotation", this.newFloatNBTList(new float[]{this.rotationYaw, this.rotationPitch}));
        nbttagcompound.setFloat("FallDistance", this.fallDistance);
        nbttagcompound.setShort("Fire", (short)this.fire);
        nbttagcompound.setShort("Air", (short)this.air);
        nbttagcompound.setBool("OnGround", this.onGround);
        this.writeEntityToNBT(nbttagcompound);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = nbttagcompound.getTagList("Pos");
        NBTTagList nbttaglist1 = nbttagcompound.getTagList("Motion");
        NBTTagList nbttaglist2 = nbttagcompound.getTagList("Rotation");
        this.setPosition(0.0, 0.0, 0.0);
        this.motionX = ((NBTTagDouble)nbttaglist1.tagAt((int)0)).doubleValue;
        this.motionY = ((NBTTagDouble)nbttaglist1.tagAt((int)1)).doubleValue;
        this.motionZ = ((NBTTagDouble)nbttaglist1.tagAt((int)2)).doubleValue;
        this.lastTickPosX = this.posX = ((NBTTagDouble)nbttaglist.tagAt((int)0)).doubleValue;
        this.prevPosX = this.posX;
        this.lastTickPosY = this.posY = ((NBTTagDouble)nbttaglist.tagAt((int)1)).doubleValue;
        this.prevPosY = this.posY;
        this.lastTickPosZ = this.posZ = ((NBTTagDouble)nbttaglist.tagAt((int)2)).doubleValue;
        this.prevPosZ = this.posZ;
        this.prevRotationYaw = this.rotationYaw = ((NBTTagFloat)nbttaglist2.tagAt((int)0)).floatValue;
        this.prevRotationPitch = this.rotationPitch = ((NBTTagFloat)nbttaglist2.tagAt((int)1)).floatValue;
        this.fallDistance = nbttagcompound.getFloat("FallDistance");
        this.fire = nbttagcompound.getShort("Fire");
        this.air = nbttagcompound.getShort("Air");
        this.onGround = nbttagcompound.getBoolean("OnGround");
        this.setPosition(this.posX, this.posY, this.posZ);
        this.readEntityFromNBT(nbttagcompound);
    }

    protected final String getEntityString() {
        return EntityList.getEntityString(this);
    }

    protected abstract void readEntityFromNBT(NBTTagCompound var1);

    protected abstract void writeEntityToNBT(NBTTagCompound var1);

    protected NBTTagList newDoubleNBTList(double[] ad2) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] ad1 = ad2;
        int i2 = ad1.length;
        int j2 = 0;
        while (j2 < i2) {
            double d2 = ad1[j2];
            nbttaglist.setTag(new NBTTagDouble(d2));
            ++j2;
        }
        return nbttaglist;
    }

    protected NBTTagList newFloatNBTList(float[] af2) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] af1 = af2;
        int i2 = af1.length;
        int j2 = 0;
        while (j2 < i2) {
            float f2 = af1[j2];
            nbttaglist.setTag(new NBTTagFloat(f2));
            ++j2;
        }
        return nbttaglist;
    }

    public float getShadowSize() {
        return this.height / 2.0f;
    }

    public EntityItem dropItem(int i2, int j2) {
        return this.dropItemWithOffset(i2, j2, 0.0f);
    }

    public EntityItem dropItemWithOffset(int i2, int j2, float f2) {
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY + (double)f2, this.posZ, new ItemStack(i2, j2));
        entityitem.delayBeforeCanPickup = 10;
        this.worldObj.entityJoinedWorld(entityitem);
        return entityitem;
    }

    public boolean isEntityAlive() {
        return !this.isDead;
    }

    public boolean isEntityInsideOpaqueBlock() {
        int i2 = MathHelper.floor_double(this.posX);
        int j2 = MathHelper.floor_double(this.posY + (double)this.func_373_s());
        int k2 = MathHelper.floor_double(this.posZ);
        return this.worldObj.isBlockNormalCube(i2, j2, k2);
    }

    public boolean interact(EntityPlayer entityplayer) {
        return false;
    }

    public AxisAlignedBB getCollisionBox(Entity entity) {
        return null;
    }

    public void updateRidden() {
        if (this.entityBeingRidden.isDead) {
            this.entityBeingRidden = null;
            return;
        }
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.onUpdate();
        if (this.entityBeingRidden == null) {
            return;
        }
        this.entityBeingRidden.updateRiderPosition();
        if (!this.worldObj.multiplayerWorld) {
            this.entityRiderYawDelta += (double)(this.entityBeingRidden.rotationYaw - this.entityBeingRidden.prevRotationYaw);
            this.entityRiderPitchDelta += (double)(this.entityBeingRidden.rotationPitch - this.entityBeingRidden.prevRotationPitch);
        }
        while (this.entityRiderYawDelta >= 180.0) {
            this.entityRiderYawDelta -= 360.0;
        }
        while (this.entityRiderYawDelta < -180.0) {
            this.entityRiderYawDelta += 360.0;
        }
        while (this.entityRiderPitchDelta >= 180.0) {
            this.entityRiderPitchDelta -= 360.0;
        }
        while (this.entityRiderPitchDelta < -180.0) {
            this.entityRiderPitchDelta += 360.0;
        }
        double d2 = this.entityRiderYawDelta * 0.5;
        double d1 = this.entityRiderPitchDelta * 0.5;
        float f2 = 10.0f;
        if (d2 > (double)f2) {
            d2 = f2;
        }
        if (d2 < (double)(-f2)) {
            d2 = -f2;
        }
        if (d1 > (double)f2) {
            d1 = f2;
        }
        if (d1 < (double)(-f2)) {
            d1 = -f2;
        }
        this.entityRiderYawDelta -= d2;
        this.entityRiderPitchDelta -= d1;
        this.rotationYaw = (float)((double)this.rotationYaw + d2);
        this.rotationPitch = (float)((double)this.rotationPitch + d1);
    }

    protected void updateRiderPosition() {
        this.riddenByEntity.setPosition(this.posX, this.posY + this.getMountedYOffset() + this.riddenByEntity.getYOffset(), this.posZ);
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.75;
    }

    public void mountEntity(Entity entity) {
        this.entityRiderPitchDelta = 0.0;
        this.entityRiderYawDelta = 0.0;
        if (entity == null) {
            if (this.entityBeingRidden != null) {
                this.setLocationAndAngles(this.entityBeingRidden.posX, this.entityBeingRidden.boundingBox.minY + (double)this.entityBeingRidden.height, this.entityBeingRidden.posZ, this.rotationYaw, this.rotationPitch);
                this.entityBeingRidden.riddenByEntity = null;
            }
            this.entityBeingRidden = null;
            return;
        }
        if (this.entityBeingRidden == entity) {
            this.entityBeingRidden.riddenByEntity = null;
            this.entityBeingRidden = null;
            this.setLocationAndAngles(entity.posX, entity.boundingBox.minY + (double)entity.height, entity.posZ, this.rotationYaw, this.rotationPitch);
            return;
        }
        if (this.entityBeingRidden != null) {
            this.entityBeingRidden.riddenByEntity = null;
        }
        if (entity.riddenByEntity != null) {
            entity.riddenByEntity.entityBeingRidden = null;
        }
        this.entityBeingRidden = entity;
        entity.riddenByEntity = this;
        System.out.println("MOUNTING " + this + " TO " + entity);
    }

    public void setPositionAndRotation2(double d2, double d1, double d22, float f2, float f1, int i2) {
        this.setPosition(d2, d1, d22);
        this.setRotation(f2, f1);
        List<AxisAlignedBB> list = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.expand(0.03125, 0.0, 0.03125));
        if (list.size() > 0) {
            double d3 = 0.0;
            int j2 = 0;
            while (j2 < list.size()) {
                AxisAlignedBB axisalignedbb = list.get(j2);
                if (axisalignedbb.maxY > d3) {
                    d3 = axisalignedbb.maxY;
                }
                ++j2;
            }
            this.setPosition(d2, d1, d22);
        }
    }

    public double getRealMoveSpeed() {
        return 0.5;
    }

    public boolean isBurning() {
        return this.fire > 0 || this.getEntityFlag(0);
    }

    public void performHurtAnimation() {
    }

    public void updateCloak() {
    }

    public void outfitWithItem(int i2, int j2, int k2) {
    }

    public boolean isRiding() {
        return this.entityBeingRidden != null || this.getEntityFlag(2);
    }

    public void setSneaking(boolean flag) {
        this.setEntityFlag(1, flag);
    }

    public boolean isSneaking() {
        return this.getEntityFlag(1);
    }

    public void setRunning(boolean flag) {
        this.setEntityFlag(5, flag);
    }

    public boolean isRunning() {
        return this.getEntityFlag(5);
    }

    protected boolean getEntityFlag(int i2) {
        return (this.dataWatcher.getWatchableObjectByte(0) & 1 << i2) != 0;
    }

    protected void setEntityFlag(int i2, boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(0);
        if (flag) {
            this.dataWatcher.updateObject(0, (byte)(byte0 | 1 << i2));
        } else {
            this.dataWatcher.updateObject(0, (byte)(byte0 & ~(1 << i2)));
        }
    }

    public float getEyeHeight() {
        return this.yOffset;
    }
}

