/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityAnimals;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;

public class EntityPig
extends EntityAnimals {
    public EntityPig(World world) {
        super(world);
        this.setSaddled(false);
        this.scoreYield = 10;
        this.texture = "/mob/pig.png";
        this.setSize(0.9f, 0.9f);
        this.setSaddled(false);
    }

    protected void entityInit() {
        this.dataWatcher.addObject(16, (byte)0);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBool("Saddle", this.getSaddled());
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSaddled(nbttagcompound.getBoolean("Saddle"));
    }

    protected String idleSound() {
        return "mob.pig";
    }

    protected String hurtSound() {
        return "mob.pig";
    }

    protected String deathSound() {
        return "mob.pigdeath";
    }

    public boolean interact(EntityPlayer entityplayer) {
        if (this.getSaddled() && !this.worldObj.multiplayerWorld && (this.riddenByEntity == null || this.riddenByEntity == entityplayer)) {
            entityplayer.mountEntity(this);
            return true;
        }
        return false;
    }

    protected int deathDropItem() {
        if (this.worldObj.multiplayerWorld) {
            return 0;
        }
        if (!this.getSaddled()) {
            if (this.fire > 0) {
                return Item.porkCooked.shiftedIndex;
            }
            return Item.porkRaw.shiftedIndex;
        }
        this.dropItem(Item.saddle.shiftedIndex, 1);
        if (this.fire > 0) {
            return Item.porkCooked.shiftedIndex;
        }
        return Item.porkRaw.shiftedIndex;
    }

    public boolean getSaddled() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void setSaddled(boolean flag) {
        if (flag) {
            this.dataWatcher.updateObject(16, (byte)1);
        } else {
            this.dataWatcher.updateObject(16, (byte)0);
        }
    }
}

