/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPickupFX;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.gui.GuiChest;
import com.mojang.minecraft.gui.GuiCrafting;
import com.mojang.minecraft.gui.GuiEditSign;
import com.mojang.minecraft.gui.GuiFurnace;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.player.controller.MovementInput;
import com.mojang.minecraft.player.controller.PlayerControllerCreative;
import com.mojang.minecraft.sound.AmbientLoopHandler;
import com.mojang.minecraft.util.MathHelper;
import com.mojang.minecraft.util.Session;
import com.mojang.minecraft.util.SkinManager;

public class EntityPlayerSP
extends EntityPlayer {
    public MovementInput currentInput;
    private Minecraft mc;
    public AmbientLoopHandler loopHandler;
    private int stamina;
    private boolean exhausted;

    public EntityPlayerSP(Minecraft minecraft, World world, Session session) {
        super(world);
        this.mc = minecraft;
        this.stamina = this.getMaxStamina();
        this.playerName = session.username;
        this.modelAlex = false;
        if (session != null && session.username != null && session.username.length() > 0 && session.getProfile().getId() != null) {
            SkinManager cfr_ignored_0 = this.mc.skins;
            SkinManager.getSkin(session.getProfile(), this);
        }
        this.loopHandler = new AmbientLoopHandler(world, this);
    }

    public int getMaxStamina() {
        return this.health * 20;
    }

    public boolean getIsExhausted() {
        return this.exhausted;
    }

    public int getStamina() {
        return this.stamina;
    }

    public void setStamina(int stam) {
        this.stamina = stam;
        if (stam == this.getMaxStamina()) {
            this.exhausted = false;
        }
    }

    public Double getExhaustion() {
        return 1.0 - (double)this.stamina / 400.0;
    }

    public void updateEntityActionState() {
        super.updateEntityActionState();
        this.movingLeftRight = this.currentInput.movementLeftRight;
        this.movingForwardBack = this.currentInput.movementForwardBack;
        this.isJumping = this.currentInput.movementIsJumping;
        this.setRunning(this.currentInput.movementIsRunning && !this.exhausted);
        if (this.stamina <= 0) {
            this.exhausted = true;
        }
        if (this.stamina < this.getMaxStamina() && (!this.isRunning() || this.exhausted)) {
            ++this.stamina;
            if (this.stamina >= this.getMaxStamina()) {
                this.exhausted = false;
            }
        }
        if (this.stamina > this.getMaxStamina()) {
            this.stamina = this.getMaxStamina();
        }
    }

    private float getDirection() {
        int yaw1;
        float yaw = this.mc.thePlayer.rotationYaw;
        float moveForward = this.mc.thePlayer.movingForwardBack;
        float moveStrafing = this.mc.thePlayer.movingLeftRight;
        yaw += (float)(moveForward < 0.0f ? 180 : 0);
        int n2 = moveForward == 0.0f ? 90 : (yaw1 = moveForward < 0.0f ? -45 : 45);
        if (moveStrafing < 0.0f) {
            yaw += (float)yaw1;
        }
        if (moveStrafing > 0.0f) {
            yaw -= (float)yaw1;
        }
        return yaw * ((float)Math.PI / 180);
    }

    public double getSpeed() {
        return Math.sqrt(MathHelper.square(this.motionX) + MathHelper.square(this.motionZ));
    }

    public void setSpeed(double speed) {
        this.mc.thePlayer.motionX = (double)(-MathHelper.sin(this.getDirection())) * speed;
        this.mc.thePlayer.motionZ = (double)MathHelper.cos(this.getDirection()) * speed;
    }

    public void onLivingUpdate() {
        this.currentInput.func_797_a(this);
        if (this.currentInput.movementIsSneaking && this.ySize < 0.2f) {
            this.ySize = 0.2f;
        }
        if (!(this.exhausted || !this.isRunning() || this.isInWeb || this.currentInput.movementForwardBack == 0.0f && this.currentInput.movementLeftRight == 0.0f || this.worldObj.difficulty >= 3 || this.entityBeingRidden != null || this.handleWaterMovement() || this.handleLavaMovement())) {
            if (this.worldObj.difficulty == 2 && !this.isCreative) {
                --this.stamina;
                --this.stamina;
                this.setSpeed(0.2);
            } else {
                this.setSpeed(0.2);
            }
        }
        if (this.isCreative && this.mc.playerController != new PlayerControllerCreative(this.mc)) {
            this.mc.playerController = new PlayerControllerCreative(this.mc);
        }
        super.onLivingUpdate();
    }

    public void func_458_k() {
        this.currentInput.func_798_a();
    }

    public void func_460_a(int i2, boolean flag) {
        this.currentInput.func_796_a(i2, flag);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setInteger("Score", this.score);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.score = nbttagcompound.getInteger("Score");
    }

    public void displayGUIChest(IInventory iinventory) {
        this.mc.setCurrentScreen(new GuiChest(this.inventory, iinventory));
    }

    public void displayGUIEditSign(TileEntitySign tileentitysign) {
        this.mc.setCurrentScreen(new GuiEditSign(tileentitysign));
    }

    public void respawnPlayer() {
        this.mc.respawn(false, 0);
    }

    public void displayWorkbenchGUI(int i2, int j2, int k2) {
        this.mc.setCurrentScreen(new GuiCrafting(this.inventory, this.worldObj, i2, j2, k2));
    }

    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
        this.mc.setCurrentScreen(new GuiFurnace(this.inventory, tileentityfurnace));
    }

    public void attackEntity(Entity entity) {
        int i2 = this.inventory.getDamageVsEntity(entity);
        if (i2 > 0) {
            entity.attackEntityFrom(this, i2);
            ItemStack itemstack = this.getCurrentEquippedItem();
            if (itemstack != null && entity instanceof EntityLiving) {
                itemstack.hitEntity((EntityLiving)entity);
                if (itemstack.stackSize <= 0) {
                    itemstack.func_1097_a(this);
                    this.destroyCurrentEquippedItem();
                }
            }
        }
    }

    public void onEntityUpdate() {
        super.onEntityUpdate();
        if (this.mc.soundMGR.getLoaded()) {
            this.loopHandler.update();
        }
    }

    public void onItemPickup(Entity entity, int i2) {
        this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.mcWorld, entity, this, -0.5f));
    }

    public int getPlayerArmorValue() {
        return this.inventory.getTotalArmorValue();
    }

    public void useCurrentItemOnEntity(Entity entity) {
        if (entity.interact(this)) {
            return;
        }
        ItemStack itemstack = this.getCurrentEquippedItem();
        if (itemstack != null && entity instanceof EntityLiving) {
            itemstack.useItemOnEntity((EntityLiving)entity);
            if (itemstack.stackSize <= 0) {
                itemstack.func_1097_a(this);
                this.destroyCurrentEquippedItem();
            }
        }
    }

    public void sendChatMessage(String s2) {
    }

    public void func_462_n() {
    }

    public boolean getIsSneaking() {
        return this.currentInput.movementIsSneaking;
    }

    public double getRealMoveSpeed() {
        if (this.isRunning()) {
            return 0.75;
        }
        return 0.5;
    }

    public int posXInt() {
        return (int)Math.round(this.posX);
    }

    public int posYInt() {
        return (int)Math.round(this.posY);
    }

    public int posZInt() {
        return (int)Math.round(this.posZ);
    }

    public void setHealth(int i2) {
        int j2 = this.health - i2;
        if (j2 <= 0) {
            this.health = i2;
            if (j2 < 0) {
                this.heartsLife = this.maxHealth / 2;
            }
        } else {
            this.field_701_U = j2;
            this.prevHealth = this.health;
            this.heartsLife = this.maxHealth;
            this.damageEntity(j2);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
    }

    public void closeScreen() {
        super.closeScreen();
        this.mc.setCurrentScreen(null);
    }
}

