/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.render;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.model.ModelBase;
import com.mojang.minecraft.gui.GuiIngame;
import com.mojang.minecraft.render.FontRenderer;
import com.mojang.minecraft.render.Render;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class RenderLiving
extends Render {
    protected ModelBase mainModel;
    protected ModelBase field_202_e;
    public static boolean bobbing = true;

    public RenderLiving(ModelBase modelbase, float f2) {
        this.mainModel = modelbase;
        this.shadowSize = f2;
    }

    public void func_169_a(ModelBase modelbase) {
        this.field_202_e = modelbase;
    }

    private float setBobbing(EntityLiving par1EntityLivingBase, float f5, float par9) {
        if (par1EntityLivingBase.ridingEntity != null && par1EntityLivingBase.ridingEntity instanceof EntityLiving) {
            return this.setBobbing((EntityLiving)par1EntityLivingBase.ridingEntity, f5, par9);
        }
        float bobStrength = 0.0f;
        if (!bobbing || !(par1EntityLivingBase instanceof EntityPlayer)) {
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * f5 + 1.4f), (float)0.0f);
            float f7 = par1EntityLivingBase.limbSwing - par1EntityLivingBase.limbSwingAmount * (1.0f - par9);
            return f7;
        }
        bobStrength = 1.0f;
        float f7 = par1EntityLivingBase.unknownFloat + (par1EntityLivingBase.field_731_r - par1EntityLivingBase.unknownFloat) * par9;
        float f32 = par1EntityLivingBase.field_733_p + (par1EntityLivingBase.field_732_q - par1EntityLivingBase.field_733_p) * par9;
        float bob = -Math.abs(MathHelper.cos(f7 * 0.6662f)) * 5.0f * f32 * bobStrength - 23.0f;
        GL11.glTranslatef((float)0.0f, (float)(bob * f5 + 1.4f), (float)0.0f);
        return f7;
    }

    public void func_171_a(EntityLiving entityliving, double d2, double d1, double d22, float f2, float f1) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        this.mainModel.onGround = this.func_167_c(entityliving, f1);
        boolean bl2 = this.mainModel.field_1243_l = entityliving.entityBeingRidden != null;
        if (this.field_202_e != null) {
            this.field_202_e.field_1243_l = this.mainModel.field_1243_l;
        }
        try {
            float f22 = entityliving.prevRenderYawOffset + (entityliving.renderYawOffset - entityliving.prevRenderYawOffset) * f1;
            float f3 = entityliving.prevRotationYaw + (entityliving.rotationYaw - entityliving.prevRotationYaw) * f1;
            float f4 = entityliving.prevRotationPitch + (entityliving.rotationPitch - entityliving.prevRotationPitch) * f1;
            GL11.glTranslatef((float)((float)d2), (float)((float)d1), (float)((float)d22));
            float f5 = this.func_170_d(entityliving, f1);
            GL11.glRotatef((float)(180.0f - f22), (float)0.0f, (float)1.0f, (float)0.0f);
            if (entityliving.deathTime > 0) {
                float f6 = ((float)entityliving.deathTime + f1 - 1.0f) / 20.0f * 1.6f;
                if ((f6 = MathHelper.sqrt_float(f6)) > 1.0f) {
                    f6 = 1.0f;
                }
                GL11.glRotatef((float)(f6 * this.func_172_a(entityliving)), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            float f7 = 0.0625f;
            GL11.glEnable((int)32826);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.func_168_a(entityliving, f1);
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * f7 - 0.0078125f), (float)0.0f);
            float f8 = entityliving.field_705_Q + (entityliving.limbSwingAmount - entityliving.field_705_Q) * f1;
            float f9 = this.setBobbing(entityliving, f7, f1);
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
            this.func_140_a(entityliving.skinURL, entityliving.getEntityTexture());
            GL11.glEnable((int)3008);
            this.mainModel.setRotationAnglesAndRender(f9, f8, f5, f3 - f22, f4, f7);
            int i2 = 0;
            while (i2 < 4) {
                if (this.func_166_a(entityliving, i2)) {
                    this.field_202_e.setRotationAnglesAndRender(f9, f8, f5, f3 - f22, f4, f7);
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)3008);
                }
                ++i2;
            }
            this.func_174_b(entityliving, f1);
            float f10 = entityliving.getEntityBrightness(f1);
            int j2 = this.func_173_a(entityliving, f10, f1);
            if ((j2 >> 24 & 0xFF) > 0 || entityliving.hurtTime > 0 || entityliving.deathTime > 0) {
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (entityliving.hurtTime > 0 || entityliving.deathTime > 0) {
                    GL11.glColor4f((float)f10, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.mainModel.setRotationAnglesAndRender(f9, f8, f5, f3 - f22, f4, f7);
                    int k2 = 0;
                    while (k2 < 4) {
                        if (this.func_166_a(entityliving, k2)) {
                            GL11.glColor4f((float)f10, (float)0.0f, (float)0.0f, (float)0.4f);
                            this.field_202_e.setRotationAnglesAndRender(f9, f8, f5, f3 - f22, f4, f7);
                        }
                        ++k2;
                    }
                }
                if ((j2 >> 24 & 0xFF) > 0) {
                    float f11 = (float)(j2 >> 16 & 0xFF) / 255.0f;
                    float f12 = (float)(j2 >> 8 & 0xFF) / 255.0f;
                    float f13 = (float)(j2 & 0xFF) / 255.0f;
                    float f14 = (float)(j2 >> 24 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f11, (float)f12, (float)f13, (float)f14);
                    this.mainModel.setRotationAnglesAndRender(f9, f8, f5, f3 - f22, f4, f7);
                    int l2 = 0;
                    while (l2 < 4) {
                        if (this.func_166_a(entityliving, l2)) {
                            GL11.glColor4f((float)f11, (float)f12, (float)f13, (float)f14);
                            this.field_202_e.setRotationAnglesAndRender(f9, f8, f5, f3 - f22, f4, f7);
                        }
                        ++l2;
                    }
                }
                GL11.glDepthFunc((int)515);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)32826);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        this.passSpecialRender(entityliving, d2, d1, d22);
    }

    protected float func_167_c(EntityLiving entityliving, float f2) {
        return entityliving.getSwingProgress(f2);
    }

    protected float func_170_d(EntityLiving entityliving, float f2) {
        return (float)entityliving.ticksExisted + f2;
    }

    protected void func_174_b(EntityLiving entityliving, float f2) {
    }

    protected boolean func_166_a(EntityLiving entityliving, int i2) {
        return false;
    }

    protected float func_172_a(EntityLiving entityliving) {
        return 90.0f;
    }

    protected int func_173_a(EntityLiving entityliving, float f2, float f1) {
        return 0;
    }

    protected void func_168_a(EntityLiving entityliving, float f2) {
    }

    protected void passSpecialRender(EntityLiving entityliving, double d2, double d1, double d22) {
        if (GuiIngame.debugOpen) {
            this.renderLivingLabel(entityliving, Integer.toString(entityliving.entityId), d2, d1, d22, 64);
        }
    }

    protected void renderLivingLabel(EntityLiving entityliving, String s2, double d2, double d1, double d22, int i2) {
        float f2 = entityliving.getDistanceToEntity(this.renderManager.livingPlayer);
        if (f2 > (float)i2) {
            return;
        }
        FontRenderer fontrenderer = this.getFontRendererFromRenderManager();
        float f1 = 1.6f;
        float f22 = 0.01666667f * f1;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d2 + 0.0f), (float)((float)d1 + 2.3f), (float)((float)d22));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
        float f4 = entityliving.getDistanceToEntity(this.renderManager.livingPlayer);
        f22 = (float)((double)f22 * (Math.sqrt(f4) / 2.0));
        GL11.glScalef((float)(-f22), (float)(-f22), (float)f22);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.instance;
        int byte0 = 0;
        if (s2.equals("deadmau5")) {
            byte0 = -10;
        }
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        int j2 = fontrenderer.getStringWidth(s2) / 2;
        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.addVertex(-j2 - 1, -1 + byte0, 0.0);
        tessellator.addVertex(-j2 - 1, 8 + byte0, 0.0);
        tessellator.addVertex(j2 + 1, 8 + byte0, 0.0);
        tessellator.addVertex(j2 + 1, -1 + byte0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        fontrenderer.drawString(s2, -fontrenderer.getStringWidth(s2) / 2, byte0, 0x20FFFFFF);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontrenderer.drawString(s2, -fontrenderer.getStringWidth(s2) / 2, byte0, -1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void doRender(Entity entity, double d2, double d1, double d22, float f2, float f1) {
        this.func_171_a((EntityLiving)entity, d2, d1, d22, f2, f1);
    }
}

