/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.tile;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFurnace;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagList;

public class TileEntityFurnace
extends TileEntity
implements IInventory {
    private ItemStack[] furnaceItemStacks = new ItemStack[3];
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int furnaceCookTime = 0;

    public int getSizeInventory() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack getStackInSlot(int i2) {
        return this.furnaceItemStacks[i2];
    }

    public ItemStack decrStackSize(int i2, int j2) {
        if (this.furnaceItemStacks[i2] != null) {
            if (this.furnaceItemStacks[i2].stackSize <= j2) {
                ItemStack itemstack = this.furnaceItemStacks[i2];
                this.furnaceItemStacks[i2] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.furnaceItemStacks[i2].splitStack(j2);
            if (this.furnaceItemStacks[i2].stackSize == 0) {
                this.furnaceItemStacks[i2] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void setInventorySlotContents(int i2, ItemStack itemstack) {
        this.furnaceItemStacks[i2] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
    }

    public String getInvName() {
        return "Chest";
    }

    public void func_482_a(NBTTagCompound nbttagcompound) {
        super.func_482_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
        this.furnaceItemStacks = new ItemStack[this.getSizeInventory()];
        int i2 = 0;
        while (i2 < nbttaglist.tagCount()) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i2);
            byte byte0 = nbttagcompound1.getByte("Slot");
            if (byte0 >= 0 && byte0 < this.furnaceItemStacks.length) {
                this.furnaceItemStacks[byte0] = new ItemStack(nbttagcompound1);
            }
            ++i2;
        }
        this.furnaceBurnTime = nbttagcompound.getShort("BurnTime");
        this.furnaceCookTime = nbttagcompound.getShort("CookTime");
        this.currentItemBurnTime = this.func_488_a(this.furnaceItemStacks[1]);
    }

    public void func_481_b(NBTTagCompound nbttagcompound) {
        super.func_481_b(nbttagcompound);
        nbttagcompound.setShort("BurnTime", (short)this.furnaceBurnTime);
        nbttagcompound.setShort("CookTime", (short)this.furnaceCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        int i2 = 0;
        while (i2 < this.furnaceItemStacks.length) {
            if (this.furnaceItemStacks[i2] != null) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)i2);
                this.furnaceItemStacks[i2].writeToNBT(nbttagcompound1);
                nbttaglist.setTag(nbttagcompound1);
            }
            ++i2;
        }
        nbttagcompound.func_762_a("Items", nbttaglist);
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public int getCookProgressScaled(int i2) {
        return this.furnaceCookTime * i2 / 200;
    }

    public int getBurnTimeRemainingScaled(int i2) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * i2 / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_475_b() {
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.world.multiplayerWorld) {
            if (this.furnaceBurnTime == 0 && this.func_491_j()) {
                this.currentItemBurnTime = this.furnaceBurnTime = this.func_488_a(this.furnaceItemStacks[1]);
                if (this.furnaceBurnTime > 0) {
                    flag1 = true;
                    if (this.furnaceItemStacks[1] != null) {
                        --this.furnaceItemStacks[1].stackSize;
                        if (this.furnaceItemStacks[1].stackSize == 0) {
                            this.furnaceItemStacks[1] = null;
                        }
                    }
                }
            }
            if (this.isBurning() && this.func_491_j()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == 200) {
                    this.furnaceCookTime = 0;
                    this.func_487_i();
                    flag1 = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
                BlockFurnace.func_285_a(this.furnaceBurnTime > 0, this.world, this.x, this.y, this.z);
            }
        }
        if (flag1) {
            this.onInventoryChanged();
        }
    }

    private boolean func_491_j() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        int i2 = this.func_486_d(this.furnaceItemStacks[0].getItem().shiftedIndex);
        if (i2 < 0) {
            return false;
        }
        if (this.furnaceItemStacks[2] == null) {
            return true;
        }
        if (this.furnaceItemStacks[2].itemID != i2) {
            return false;
        }
        if (this.furnaceItemStacks[2].stackSize < this.getInventoryStackLimit() && this.furnaceItemStacks[2].stackSize < this.furnaceItemStacks[2].getMaxStackSize()) {
            return true;
        }
        return this.furnaceItemStacks[2].stackSize < Item.itemsList[i2].func_200_b();
    }

    public void func_487_i() {
        if (!this.func_491_j()) {
            return;
        }
        int i2 = this.func_486_d(this.furnaceItemStacks[0].getItem().shiftedIndex);
        if (this.furnaceItemStacks[2] == null) {
            this.furnaceItemStacks[2] = new ItemStack(i2, 1);
        } else if (this.furnaceItemStacks[2].itemID == i2) {
            ++this.furnaceItemStacks[2].stackSize;
        }
        --this.furnaceItemStacks[0].stackSize;
        if (this.furnaceItemStacks[0].stackSize <= 0) {
            this.furnaceItemStacks[0] = null;
        }
    }

    private int func_486_d(int i2) {
        if (i2 == Block.oreIron.blockID) {
            return Item.ingotIron.shiftedIndex;
        }
        if (i2 == Block.oreGold.blockID) {
            return Item.ingotGold.shiftedIndex;
        }
        if (i2 == Block.oreDiamond.blockID) {
            return Item.diamond.shiftedIndex;
        }
        if (i2 == Block.oreCopper.blockID) {
            return Item.ingotCopper.shiftedIndex;
        }
        if (i2 == Block.sand.blockID) {
            return Block.glass.blockID;
        }
        if (i2 == Item.porkRaw.shiftedIndex) {
            return Item.porkCooked.shiftedIndex;
        }
        if (i2 == Block.cobblestone.blockID) {
            return Block.stone.blockID;
        }
        if (i2 == Item.clay.shiftedIndex) {
            return Item.brick.shiftedIndex;
        }
        if (i2 == Block.wood.blockID) {
            return Item.coal.shiftedIndex;
        }
        if (i2 == Block.cactus.blockID) {
            return Item.dyeGreen.shiftedIndex;
        }
        if (i2 == Item.egg.shiftedIndex) {
            return Item.eggCooked.shiftedIndex;
        }
        if (i2 == Item.fishRaw.shiftedIndex) {
            return Item.fishCooked.shiftedIndex;
        }
        if (i2 == Item.silk.shiftedIndex) {
            return Item.carbonFilament.shiftedIndex;
        }
        return -1;
    }

    private int func_488_a(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        int i2 = itemstack.getItem().shiftedIndex;
        if (i2 < 256 && Block.allBlocks[i2].blockMaterial == Material.wood) {
            return 300;
        }
        if (i2 == Item.stick.shiftedIndex) {
            return 100;
        }
        if (i2 == Block.cactus.blockID) {
            return 200;
        }
        if (i2 == Item.coal.shiftedIndex) {
            return 1600;
        }
        return i2 != Item.bucketLava.shiftedIndex ? 0 : 20000;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return true;
    }
}

