/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockSponge
extends Block {
    static final byte radius = 2;

    protected BlockSponge(int i2) {
        super(i2, Material.sponge);
        this.blockIndexInTexture = 48;
    }

    public void onBlockAdded(World world, int a2, int b2, int c2) {
        super.onBlockAdded(world, a2, b2, c2);
        int x2 = a2 - 2;
        while (x2 <= a2 + 2) {
            int y2 = b2 - 2;
            while (y2 <= b2 + 2) {
                int z2 = c2 - 2;
                while (z2 <= c2 + 2) {
                    if (world.getBlockId(x2, y2, z2) == Block.waterMoving.blockID || world.getBlockId(x2, y2, z2) == Block.waterStill.blockID) {
                        world.setBlockWithNotify(x2, y2, z2, 0);
                    }
                    ++z2;
                }
                ++y2;
            }
            ++x2;
        }
    }

    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (this.isReceivingRedstonePower(world, i2, j2, k2, l2)) {
            this.dropBlockAsItemWithChance(world, i2, j2, k2, 19);
            world.setBlockWithNotify(i2, j2, k2, 87);
        }
    }

    private boolean isReceivingRedstonePower(World world, int i2, int j2, int k2, int l2) {
        if (l2 != 0 && world.isBlockIndirectlyProvidingPowerTo(i2, j2 - 1, k2, 0)) {
            return true;
        }
        if (l2 != 1 && world.isBlockIndirectlyProvidingPowerTo(i2, j2 + 1, k2, 1)) {
            return true;
        }
        if (l2 != 2 && world.isBlockIndirectlyProvidingPowerTo(i2, j2, k2 - 1, 2)) {
            return true;
        }
        if (l2 != 3 && world.isBlockIndirectlyProvidingPowerTo(i2, j2, k2 + 1, 3)) {
            return true;
        }
        if (l2 != 5 && world.isBlockIndirectlyProvidingPowerTo(i2 + 1, j2, k2, 5)) {
            return true;
        }
        if (l2 != 4 && world.isBlockIndirectlyProvidingPowerTo(i2 - 1, j2, k2, 4)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2, j2, k2, 0)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2, j2 + 2, k2, 1)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2, j2 + 1, k2 - 1, 2)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2, j2 + 1, k2 + 1, 3)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2 - 1, j2 + 1, k2, 4)) {
            return true;
        }
        return world.isBlockIndirectlyProvidingPowerTo(i2 + 1, j2 + 1, k2, 5);
    }

    public void dropWater(World world, int x2, int y2, int z2) {
        int i2 = y2;
        while (i2 > y2 - 3) {
            if (world.getBlockId(x2, i2, z2) != 0 && world.getBlockId(x2, i2, z2) != Block.waterStill.blockID || !BlockSponge.getSurroundSponge(world, x2, i2, z2)) break;
            --i2;
        }
    }

    public void flowWater(World world, int x2, int y2, int z2, int sx, int sy, int sz) {
        int radius = 3;
        if (!(world.getBlockId(x2, y2, z2) != 0 && world.getBlockId(x2, y2, z2) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x2, y2, z2))) {
            this.dropWater(world, x2, y2, z2);
            if (!(x2 + 1 >= sx + radius || world.getBlockId(x2 + 1, y2, z2) != 0 && world.getBlockId(x2 + 1, y2, z2) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x2 + 1, y2, z2))) {
                world.notifyBlocksOfNeighborChange(x2 + 1, y2, z2, 1);
            }
            if (!(z2 + 1 >= sz + radius || world.getBlockId(x2, y2, z2 + 1) != 0 && world.getBlockId(x2, y2, z2 + 1) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x2, y2, z2 + 1))) {
                world.notifyBlocksOfNeighborChange(x2, y2, z2 + 1, 1);
            }
            if (!(x2 - 1 <= sx - radius || world.getBlockId(x2 - 1, y2, z2) != 0 && world.getBlockId(x2 - 1, y2, z2) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x2 - 1, y2, z2))) {
                world.notifyBlocksOfNeighborChange(x2 - 1, y2, z2, 1);
            }
            if (!(z2 - 1 <= sz - radius || world.getBlockId(x2, y2, z2 - 1) != 0 && world.getBlockId(x2, y2, z2 - 1) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x2, y2, z2 - 1))) {
                world.notifyBlocksOfNeighborChange(x2, y2, z2 + 1, 1);
            }
        }
    }

    public void updateTick(World world, int a2, int b2, int c2, Random random) {
        super.updateTick(world, a2, b2, c2, random);
        int x2 = a2 - 2;
        while (x2 <= a2 + 2) {
            int y2 = b2 - 2;
            while (y2 <= b2 + 2) {
                int z2 = c2 - 2;
                while (z2 <= c2 + 2) {
                    if (world.getBlockId(x2, y2, z2) == Block.waterMoving.blockID || world.getBlockId(x2, y2, z2) == Block.waterStill.blockID) {
                        world.setBlockWithNotify(x2, y2, z2, 0);
                    }
                    ++z2;
                }
                ++y2;
            }
            ++x2;
        }
    }

    public void fillWater(World world, int x2, int y2, int z2) {
        int radius = 3;
        int x1 = x2 - radius;
        while (x1 <= x2 + radius) {
            int y1 = y2;
            while (y1 > y2 - radius) {
                int z1 = z2 - radius;
                while (z1 <= z2 + radius) {
                    if (!(world.getBlockId(x1, y1, z1) != 0 && world.getBlockId(x1, y1, z1) != Block.waterStill.blockID && world.getBlockId(x1, y1, z1) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x2, y2, z2))) {
                        world.setBlockWithNotify(x1, y1, z1, Block.waterMoving.blockID);
                    }
                    ++z1;
                }
                --y1;
            }
            ++x1;
        }
    }

    public static boolean getSurroundSponge(World world, int x2, int y2, int z2) {
        int x1 = x2 - 2;
        while (x1 <= x2 + 2) {
            int y1 = y2 - 2;
            while (y1 <= y2 + 2) {
                int z1 = z2 - 2;
                while (z1 <= z2 + 2) {
                    if (world.getBlockId(x1, y1, z1) == Block.sponge.blockID) {
                        return true;
                    }
                    ++z1;
                }
                ++y1;
            }
            ++x1;
        }
        return false;
    }

    public void dropBlockAsItemWithChance(World world, int a2, int b2, int c2, int bid) {
        super.dropBlockAsItemWithChance(world, a2, b2, c2, bid);
        int radius = 3;
        int x2 = a2 - radius;
        while (x2 <= a2 + radius) {
            int y2 = b2 + radius;
            while (y2 > b2 - radius) {
                int z2 = c2 - radius;
                while (z2 <= c2 + radius) {
                    if (world.getBlockId(x2, y2, z2) == Block.waterMoving.blockID || world.getBlockId(x2, y2, z2) == Block.waterStill.blockID) {
                        this.flowWater(world, x2, y2, z2, a2, b2, c2);
                    }
                    ++z2;
                }
                --y2;
            }
            ++x2;
        }
    }
}

