/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.nbt;

import com.mojang.minecraft.nbt.NBTBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NBTTagList
extends NBTBase {
    private List<NBTBase> tagList = new ArrayList<NBTBase>();
    private byte tagType;

    void writeTagContents(DataOutput dataoutput) throws IOException {
        this.tagType = this.tagList.size() > 0 ? this.tagList.get(0).getType() : (byte)1;
        dataoutput.writeByte(this.tagType);
        dataoutput.writeInt(this.tagList.size());
        int i2 = 0;
        while (i2 < this.tagList.size()) {
            this.tagList.get(i2).writeTagContents(dataoutput);
            ++i2;
        }
    }

    void readTagContents(DataInput datainput) throws IOException {
        this.tagType = datainput.readByte();
        int i2 = datainput.readInt();
        this.tagList = new ArrayList<NBTBase>();
        int j2 = 0;
        while (j2 < i2) {
            NBTBase nbtbase = NBTBase.createTagOfType(this.tagType);
            nbtbase.readTagContents(datainput);
            this.tagList.add(nbtbase);
            ++j2;
        }
    }

    public byte getType() {
        return 9;
    }

    public String toString() {
        return "" + this.tagList.size() + " entries of type " + NBTBase.getTagName(this.tagType);
    }

    public void setTag(NBTBase nbtbase) {
        this.tagType = nbtbase.getType();
        this.tagList.add(nbtbase);
    }

    public NBTBase tagAt(int i2) {
        return this.tagList.get(i2);
    }

    public int tagCount() {
        return this.tagList.size();
    }
}

