/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.networknew;

import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.networknew.WatchableObject;
import com.mojang.minecraft.networknew.packet.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataWatcher {
    private static final HashMap dataTypes = new HashMap();
    private final Map watchedObjects = new HashMap();
    private boolean objectChanged;

    static {
        dataTypes.put(Byte.class, 0);
        dataTypes.put(Short.class, 1);
        dataTypes.put(Integer.class, 2);
        dataTypes.put(Float.class, 3);
        dataTypes.put(String.class, 4);
        dataTypes.put(ItemStack.class, 5);
        dataTypes.put(ChunkCoordinates.class, 6);
    }

    public void addObject(int i2, Object obj) {
        Integer integer = (Integer)dataTypes.get(obj.getClass());
        if (integer == null) {
            throw new IllegalArgumentException("Unknown data type: " + obj.getClass());
        }
        if (i2 > 31) {
            throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is " + 31 + ")");
        }
        if (this.watchedObjects.containsKey(i2)) {
            throw new IllegalArgumentException("Duplicate id value for " + i2 + "!");
        }
        WatchableObject watchableobject = new WatchableObject(integer, i2, obj);
        this.watchedObjects.put(i2, watchableobject);
    }

    public byte getWatchableObjectByte(int i2) {
        return (Byte)((WatchableObject)this.watchedObjects.get(i2)).getObject();
    }

    public int getWatchableObjectInt(int i2) {
        return (Integer)((WatchableObject)this.watchedObjects.get(i2)).getObject();
    }

    public String getWatchableObjectString(int i2) {
        return (String)((WatchableObject)this.watchedObjects.get(i2)).getObject();
    }

    public void updateObject(int i2, Object obj) {
        WatchableObject watchableobject = (WatchableObject)this.watchedObjects.get(i2);
        if (!obj.equals(watchableobject.getObject())) {
            watchableobject.setObject(obj);
            watchableobject.setWatching(true);
            this.objectChanged = true;
        }
    }

    public static void writeObjectsInListToStream(List list, DataOutputStream dataoutputstream) throws IOException {
        if (list != null) {
            for (WatchableObject watchableobject : list) {
                DataWatcher.writeWatchableObject(dataoutputstream, watchableobject);
            }
        }
        dataoutputstream.writeByte(127);
    }

    public void writeWatchableObjects(DataOutputStream dataoutputstream) throws IOException {
        for (WatchableObject watchableobject : this.watchedObjects.values()) {
            DataWatcher.writeWatchableObject(dataoutputstream, watchableobject);
        }
        dataoutputstream.writeByte(127);
    }

    private static void writeWatchableObject(DataOutputStream dataoutputstream, WatchableObject watchableobject) throws IOException {
        int i2 = (watchableobject.getObjectType() << 5 | watchableobject.getDataValueId() & 0x1F) & 0xFF;
        dataoutputstream.writeByte(i2);
        switch (watchableobject.getObjectType()) {
            case 0: {
                dataoutputstream.writeByte(((Byte)watchableobject.getObject()).byteValue());
                break;
            }
            case 1: {
                dataoutputstream.writeShort(((Short)watchableobject.getObject()).shortValue());
                break;
            }
            case 2: {
                dataoutputstream.writeInt((Integer)watchableobject.getObject());
                break;
            }
            case 3: {
                dataoutputstream.writeFloat(((Float)watchableobject.getObject()).floatValue());
                break;
            }
            case 4: {
                Packet.writeString((String)watchableobject.getObject(), dataoutputstream);
                break;
            }
            case 5: {
                ItemStack itemstack = (ItemStack)watchableobject.getObject();
                dataoutputstream.writeShort(itemstack.itemID);
                dataoutputstream.writeByte(itemstack.stackSize);
                dataoutputstream.writeShort(itemstack.itemDamage);
                break;
            }
            case 6: {
                ChunkCoordinates chunkcoordinates = (ChunkCoordinates)watchableobject.getObject();
                dataoutputstream.writeInt(chunkcoordinates.x);
                dataoutputstream.writeInt(chunkcoordinates.z);
            }
        }
    }

    public static List readWatchableObjects(DataInputStream datainputstream) throws IOException {
        ArrayList<WatchableObject> arraylist = null;
        byte byte0 = datainputstream.readByte();
        while (byte0 != 127) {
            if (arraylist == null) {
                arraylist = new ArrayList<WatchableObject>();
            }
            int i2 = (byte0 & 0xE0) >> 5;
            int j2 = byte0 & 0x1F;
            WatchableObject watchableobject = null;
            switch (i2) {
                case 0: {
                    watchableobject = new WatchableObject(i2, j2, datainputstream.readByte());
                    break;
                }
                case 1: {
                    watchableobject = new WatchableObject(i2, j2, datainputstream.readShort());
                    break;
                }
                case 2: {
                    watchableobject = new WatchableObject(i2, j2, datainputstream.readInt());
                    break;
                }
                case 3: {
                    watchableobject = new WatchableObject(i2, j2, Float.valueOf(datainputstream.readFloat()));
                    break;
                }
                case 4: {
                    watchableobject = new WatchableObject(i2, j2, Packet.readString(datainputstream, 64));
                    break;
                }
                case 5: {
                    short word0 = datainputstream.readShort();
                    byte byte1 = datainputstream.readByte();
                    short word1 = datainputstream.readShort();
                    watchableobject = new WatchableObject(i2, j2, new ItemStack(word0, (int)byte1, (int)word1));
                    break;
                }
                case 6: {
                    int k2 = datainputstream.readInt();
                    int l2 = datainputstream.readInt();
                    int i1 = datainputstream.readInt();
                    watchableobject = new WatchableObject(i2, j2, new ChunkCoordinates(k2, i1));
                }
            }
            arraylist.add(watchableobject);
            byte0 = datainputstream.readByte();
        }
        return arraylist;
    }

    public void updateWatchedObjectsFromList(List list) {
        for (WatchableObject watchableobject : list) {
            WatchableObject watchableobject1 = (WatchableObject)this.watchedObjects.get(watchableobject.getDataValueId());
            if (watchableobject1 == null) continue;
            watchableobject1.setObject(watchableobject.getObject());
        }
    }

    static Class _mthclass$(String s2) {
        try {
            return Class.forName(s2);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }
}

