/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.player.controller;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.player.controller.KeyBinding;
import com.mojang.minecraft.util.MathHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameSettings {
    private static final String[] RENDER_DISTANCES = new String[]{"FURTHEST", "FURTHER", "FAR", "NORMAL", "SHORT", "TINY"};
    private static final String[] DIFFICULTY_LEVELS = new String[]{"Peaceful", "Easy", "Normal", "Hard"};
    private static final String[] GUI_SCALES = new String[]{"Big", "Eyestrain", "Small", "Normal"};
    private static final String[] CLOUD_LEVELS = new String[]{"OFF", "FAST", "FANCY"};
    private static final String[] LEAF_LEVELS = new String[]{"FAST", "QUICK", "PRETTY", "FANCY"};
    public String lastServer;
    public float musicVolume = 1.0f;
    public float soundVolume = 1.0f;
    public float ambienceVolume = 1.0f;
    public float mouseSensitivity = 0.5f;
    public float modemVolume = 0.0f;
    public boolean invertMouse = false;
    public int renderDistance = 0;
    public boolean viewBobbing = true;
    public boolean anaglyph = false;
    public boolean limitFramerate = false;
    public boolean fancyGraphics = true;
    public KeyBinding keyBindForward;
    public KeyBinding keyBindLeft;
    public KeyBinding keyBindBack;
    public KeyBinding keyBindRight;
    public KeyBinding keyBindJump;
    public KeyBinding keyBindBuild;
    public KeyBinding keyBindInventory;
    public KeyBinding keyBindDrop;
    public KeyBinding keyBindChat;
    public KeyBinding keyBindToggleFog;
    public KeyBinding keyBindSneak;
    public KeyBinding keyBindRun;
    public KeyBinding keyBindSaveLocation;
    public KeyBinding keyBindLoadLocation;
    public KeyBinding[] keyBindings;
    protected Minecraft mc;
    private File optionsFile;
    public int numberOfOptions;
    public int difficulty;
    public int chunkSavingInterval;
    public int guiScale;
    public int FOV;
    public boolean thirdPersonView;
    public boolean fog = true;
    public boolean clouds = true;
    public boolean particles = true;
    public boolean advancedOpenGL;
    public int displayMode;
    public int cloudLevel;
    public int leafLevel;
    public boolean precipLevel;
    public boolean vignette;
    public boolean mobShadows;
    public boolean vSync;
    public boolean ignoreJavaWarning;

    public GameSettings(Minecraft minecraft, File file) {
        this.lastServer = "";
        this.chunkSavingInterval = 0;
        this.advancedOpenGL = false;
        this.keyBindForward = new KeyBinding("Forward", 17);
        this.keyBindLeft = new KeyBinding("Left", 30);
        this.keyBindBack = new KeyBinding("Back", 31);
        this.keyBindRight = new KeyBinding("Right", 32);
        this.keyBindJump = new KeyBinding("Jump", 57);
        this.keyBindBuild = new KeyBinding("Build", 48);
        this.keyBindInventory = new KeyBinding("Inventory", 18);
        this.keyBindDrop = new KeyBinding("Drop", 16);
        this.keyBindChat = new KeyBinding("Chat", 20);
        this.keyBindToggleFog = new KeyBinding("Toggle fog", 33);
        this.keyBindSneak = new KeyBinding("Sneak", 42);
        this.keyBindRun = new KeyBinding("Run", 29);
        this.keyBindSaveLocation = new KeyBinding("Save Location", 28);
        this.keyBindLoadLocation = new KeyBinding("Load Location", 19);
        this.keyBindings = new KeyBinding[]{this.keyBindForward, this.keyBindLeft, this.keyBindBack, this.keyBindRight, this.keyBindJump, this.keyBindSneak, this.keyBindDrop, this.keyBindInventory, this.keyBindChat, this.keyBindToggleFog, this.keyBindRun, this.keyBindSaveLocation, this.keyBindLoadLocation};
        this.numberOfOptions = 12;
        this.difficulty = 2;
        this.thirdPersonView = false;
        this.guiScale = 0;
        this.FOV = 0;
        this.mc = minecraft;
        this.ignoreJavaWarning = false;
        this.displayMode = -1;
        this.cloudLevel = 2;
        this.leafLevel = 3;
        this.precipLevel = true;
        this.vignette = true;
        this.mobShadows = true;
        this.vSync = false;
        this.optionsFile = new File(file, "optionsNSSS.txt");
        this.readOptions();
    }

    public GameSettings() {
        this.chunkSavingInterval = 0;
        this.advancedOpenGL = false;
        this.keyBindForward = new KeyBinding("Forward", 17);
        this.keyBindLeft = new KeyBinding("Left", 30);
        this.keyBindBack = new KeyBinding("Back", 31);
        this.keyBindRight = new KeyBinding("Right", 32);
        this.keyBindJump = new KeyBinding("Jump", 57);
        this.keyBindInventory = new KeyBinding("Inventory", 18);
        this.keyBindDrop = new KeyBinding("Drop", 16);
        this.keyBindChat = new KeyBinding("Chat", 20);
        this.keyBindToggleFog = new KeyBinding("Toggle fog", 33);
        this.keyBindSneak = new KeyBinding("Sneak", 42);
        this.keyBindRun = new KeyBinding("Run", 29);
        this.keyBindSaveLocation = new KeyBinding("Save Location", 28);
        this.keyBindLoadLocation = new KeyBinding("Load Location", 19);
        this.keyBindings = new KeyBinding[]{this.keyBindForward, this.keyBindLeft, this.keyBindBack, this.keyBindRight, this.keyBindJump, this.keyBindSneak, this.keyBindDrop, this.keyBindInventory, this.keyBindChat, this.keyBindToggleFog, this.keyBindRun, this.keyBindSaveLocation, this.keyBindLoadLocation};
        this.numberOfOptions = 12;
        this.difficulty = 2;
        this.thirdPersonView = false;
        this.guiScale = 0;
        this.FOV = 0;
        this.ignoreJavaWarning = false;
        this.displayMode = -1;
        this.cloudLevel = 2;
        this.leafLevel = 3;
        this.precipLevel = true;
        this.vignette = true;
        this.mobShadows = true;
        this.vSync = false;
    }

    public String func_1043_a(int i2) {
        return this.keyBindings[i2].keyDescription + ": " + Keyboard.getKeyName((int)this.keyBindings[i2].keyCode);
    }

    public void func_1042_a(int i2, int j2) {
        this.keyBindings[i2].keyCode = j2;
        this.save();
    }

    public ArrayList<String> getDisplayModes() {
        ArrayList<DisplayMode> Resolutions = new ArrayList<DisplayMode>();
        ArrayList<String> Modes = new ArrayList<String>();
        Modes.add("Display: DEFAULT");
        try {
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            int i2 = 0;
            while (i2 < modes.length) {
                DisplayMode current = modes[i2];
                Resolutions.add(current);
                ++i2;
            }
        }
        catch (LWJGLException e2) {
            e2.printStackTrace();
        }
        int i3 = 0;
        for (DisplayMode mode : Resolutions) {
            Modes.add("Display: " + mode.getWidth() + "x" + mode.getHeight() + "x" + mode.getBitsPerPixel() + " " + mode.getFrequency() + "Hz");
            ++i3;
        }
        return Modes;
    }

    public void saveSliderValue(int i2, float f2) {
        if (i2 == 0) {
            this.musicVolume = f2;
            this.mc.soundMGR.updateVolume();
        }
        if (i2 == 1) {
            this.soundVolume = f2;
            this.mc.soundMGR.updateVolume();
        }
        if (i2 == 2) {
            this.ambienceVolume = f2;
            this.mc.soundMGR.updateVolume();
        }
        if (i2 == 3) {
            this.mouseSensitivity = f2;
        }
        if (i2 == 4) {
            this.renderDistance = 3 - MathHelper.floor_float(f2 * 6.0f);
            this.save();
        }
        if (i2 == 12) {
            this.FOV = (int)(f2 * 60.0f);
        }
        if (i2 == 566) {
            this.modemVolume = f2;
        }
        if (i2 == 104) {
            this.chunkSavingInterval = MathHelper.floor_float(f2 * 58.0f);
        }
    }

    public void func_1045_b(int i2, int j2) {
        if (i2 == 10) {
            boolean bl2 = this.invertMouse = !this.invertMouse;
        }
        if (i2 == 4) {
            this.renderDistance += j2;
            if (this.renderDistance > 3) {
                this.renderDistance = -2;
            } else if (this.renderDistance < -2) {
                this.renderDistance = 3;
            }
        }
        if (i2 == 5) {
            boolean bl3 = this.viewBobbing = !this.viewBobbing;
        }
        if (i2 == 6) {
            this.anaglyph = !this.anaglyph;
            this.mc.renderEngine.func_1065_b();
        }
        if (i2 == 7) {
            this.limitFramerate = false;
        }
        if (i2 == 8) {
            this.difficulty = this.difficulty + j2 & 3;
        }
        if (i2 == 9) {
            this.fancyGraphics = !this.fancyGraphics;
            this.mc.renderGlobal.loadRenderers();
        }
        if (i2 == 11) {
            this.guiScale += j2;
            if (this.guiScale > 3) {
                this.guiScale = 0;
            }
        }
        if (i2 == 101) {
            boolean bl4 = this.clouds = !this.clouds;
        }
        if (i2 == 100) {
            boolean bl5 = this.fog = !this.fog;
        }
        if (i2 == 1993) {
            boolean bl6 = this.advancedOpenGL = !this.advancedOpenGL;
        }
        if (i2 == 1997) {
            this.cloudLevel += j2;
            if (this.cloudLevel > 2) {
                this.cloudLevel = 0;
            } else if (this.cloudLevel < 0) {
                this.cloudLevel = 2;
            }
        }
        if (i2 == 1998) {
            this.leafLevel += j2;
            if (this.leafLevel > 3) {
                this.leafLevel = 0;
            } else if (this.leafLevel < 0) {
                this.leafLevel = 3;
            }
            this.mc.renderGlobal.loadRenderers();
        }
        if (i2 == 1999) {
            boolean bl7 = this.vignette = !this.vignette;
        }
        if (i2 == 2000) {
            boolean bl8 = this.precipLevel = !this.precipLevel;
        }
        if (i2 == 2001) {
            boolean bl9 = this.mobShadows = !this.mobShadows;
        }
        if (i2 == 2002) {
            this.vSync = !this.vSync;
            Display.setVSyncEnabled((boolean)this.vSync);
        }
        this.save();
    }

    public int func_1046_b(int i2) {
        if (i2 == 0) {
            return 1;
        }
        if (i2 == 1) {
            return 1;
        }
        if (i2 == 2) {
            return 1;
        }
        if (i2 == 3) {
            return 1;
        }
        return i2 != 4 ? 0 : 1;
    }

    public float sliderType(int i2) {
        if (i2 == 0) {
            return this.musicVolume;
        }
        if (i2 == 1) {
            return this.soundVolume;
        }
        if (i2 == 2) {
            return this.ambienceVolume;
        }
        if (i2 == 3) {
            return this.mouseSensitivity;
        }
        if (i2 == 4) {
            return this.renderDistance;
        }
        if (i2 == 104) {
            return this.chunkSavingInterval;
        }
        if (i2 == 12) {
            return this.FOV;
        }
        if (i2 == 566) {
            return this.modemVolume;
        }
        return 0.0f;
    }

    public String getOptionValue(int i2) {
        if (i2 == 0) {
            return "Music: " + (this.musicVolume <= 0.0f ? "OFF" : (int)(this.musicVolume * 100.0f) + "%");
        }
        if (i2 == 1) {
            return "Sound: " + (this.soundVolume <= 0.0f ? "OFF" : (int)(this.soundVolume * 100.0f) + "%");
        }
        if (i2 == 2) {
            return "Ambience: " + (this.ambienceVolume <= 0.0f ? "OFF" : (int)(this.ambienceVolume * 100.0f) + "%");
        }
        if (i2 == 12) {
            if (this.FOV == 0) {
                return "FOV: Normal";
            }
            if (this.FOV == 60) {
                return "FOV: CinemaScope";
            }
            return "FOV: " + (this.FOV + 70) + "\u00b0";
        }
        if (i2 == 10) {
            return "Invert mouse: " + (this.invertMouse ? "ON" : "OFF");
        }
        if (i2 == 3) {
            if (this.mouseSensitivity == 0.0f) {
                return "Sensitivity: *yawn*";
            }
            if (this.mouseSensitivity == 1.0f) {
                return "Sensitivity: HYPERSPEED!!!";
            }
            return "Sensitivity: " + (int)(this.mouseSensitivity * 200.0f) + "%";
        }
        if (i2 == 4) {
            if (this.renderDistance >= -2 && this.renderDistance <= 4) {
                return "Render distance: " + RENDER_DISTANCES[this.renderDistance + 2];
            }
            return "Render distance: " + RENDER_DISTANCES[this.renderDistance + 3];
        }
        if (i2 == 5) {
            return "View bobbing: " + (this.viewBobbing ? "ON" : "OFF");
        }
        if (i2 == 6) {
            return "3d anaglyph: " + (this.anaglyph ? "ON" : "OFF");
        }
        if (i2 == 7) {
            return "Credits...";
        }
        if (i2 == 8) {
            if (this.mc.mcWorld == null || !this.mc.mcWorld.multiplayerWorld) {
                return "Difficulty: " + DIFFICULTY_LEVELS[this.difficulty];
            }
            return "Server Difficulty: " + DIFFICULTY_LEVELS[this.mc.mcWorld.multiplayerDifficulty];
        }
        if (i2 == 11) {
            return "Gui Scale: " + GUI_SCALES[this.guiScale];
        }
        if (i2 == 104) {
            return "Save every " + (this.chunkSavingInterval + 2) + " seconds";
        }
        if (i2 == 100) {
            return "Fog: " + (this.fog ? "ON" : "OFF");
        }
        if (i2 == 101) {
            return "Clouds: " + (this.clouds ? "ON" : "OFF");
        }
        if (i2 == 102) {
            return "Particles: " + (this.particles ? "ON" : "OFF");
        }
        if (i2 == 1993) {
            return "*Advanced OpenGL: " + (this.advancedOpenGL ? "ON" : "OFF");
        }
        if (i2 == 566) {
            return "Modem Volume: " + (this.modemVolume <= 0.0f ? "OFF" : (int)(this.modemVolume * 100.0f) + "%");
        }
        if (i2 == 9) {
            return "Graphics: " + (this.fancyGraphics ? "FANCY" : "FAST");
        }
        if (i2 == 1996) {
            if (this.displayMode == -1) {
                return "Display: DEFAULT";
            }
            return "Display: " + this.getDisplayModes().get(this.displayMode);
        }
        if (i2 == 1997) {
            return "Clouds: " + CLOUD_LEVELS[this.cloudLevel];
        }
        if (i2 == 1998) {
            return "Leaves: " + LEAF_LEVELS[this.leafLevel];
        }
        if (i2 == 1999) {
            return "Vignette: " + (this.vignette ? "ON" : "OFF");
        }
        if (i2 == 2000) {
            return "Precipitation: " + (this.precipLevel ? "FANCY" : "FAST");
        }
        if (i2 == 2001) {
            return "Mob Shadows: " + (this.mobShadows ? "ON" : "OFF");
        }
        if (i2 == 2002) {
            return "Vsync: " + (this.vSync ? "ON" : "OFF");
        }
        return "";
    }

    public void readOptions() {
        try {
            if (!this.optionsFile.exists()) {
                return;
            }
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.optionsFile));
            String s2 = "";
            while ((s2 = bufferedreader.readLine()) != null) {
                String[] as2 = s2.split(":");
                if (as2[0].equals("music")) {
                    this.musicVolume = this.func_1050_a(as2[1]);
                }
                if (as2[0].equals("sound")) {
                    this.soundVolume = this.func_1050_a(as2[1]);
                }
                if (as2[0].equals("ambience")) {
                    this.ambienceVolume = this.func_1050_a(as2[1]);
                }
                if (as2[0].equals("FOV")) {
                    this.FOV = Integer.parseInt(as2[1]);
                }
                if (as2[0].equals("mouseSensitivity")) {
                    this.mouseSensitivity = this.func_1050_a(as2[1]);
                }
                if (as2[0].equals("modemVolume")) {
                    this.modemVolume = this.func_1050_a(as2[1]);
                }
                if (as2[0].equals("invertYMouse")) {
                    this.invertMouse = as2[1].equals("true");
                }
                if (as2[0].equals("viewDistance")) {
                    this.renderDistance = Integer.parseInt(as2[1]);
                }
                if (as2[0].equals("bobView")) {
                    this.viewBobbing = as2[1].equals("true");
                }
                if (as2[0].equals("anaglyph3d")) {
                    this.anaglyph = as2[1].equals("true");
                }
                if (as2[0].equals("limitFramerate")) {
                    this.limitFramerate = as2[1].equals("true");
                }
                if (as2[0].equals("difficulty")) {
                    this.difficulty = Integer.parseInt(as2[1]);
                }
                if (as2[0].equals("guiScale")) {
                    this.guiScale = Integer.parseInt(as2[1]);
                }
                if (as2[0].equals("fancyGraphics")) {
                    this.fancyGraphics = as2[1].equals("true");
                }
                if (as2[0].equals("lastServer") && as2.length > 1) {
                    this.lastServer = String.valueOf(as2[1]) + ":" + as2[2];
                }
                if (as2[0].equals("fog")) {
                    this.fog = as2[1].equals("true");
                }
                if (as2[0].equals("Clouds")) {
                    this.clouds = as2[1].equals("true");
                }
                if (as2[0].equals("particles")) {
                    this.particles = as2[1].equals("true");
                }
                if (as2[0].equals("ignoreJavaWarning")) {
                    this.ignoreJavaWarning = as2[1].equals("true");
                }
                if (as2[0].equals("saverate")) {
                    this.chunkSavingInterval = Integer.parseInt(as2[1]);
                }
                if (as2[0].equals("advancedopengl")) {
                    this.advancedOpenGL = as2[1].equals("true");
                }
                if (as2[0].equals("displayMode")) {
                    this.displayMode = Integer.parseInt(as2[1]);
                }
                if (as2[0].equals("cloudLevel")) {
                    this.cloudLevel = Integer.parseInt(as2[1]);
                }
                if (as2[0].equals("leafLevel")) {
                    this.leafLevel = Integer.parseInt(as2[1]);
                }
                if (as2[0].equals("precipLevel")) {
                    this.precipLevel = as2[1].equals("true");
                }
                if (as2[0].equals("vignette")) {
                    this.vignette = as2[1].equals("true");
                }
                if (as2[0].equals("mobShadows")) {
                    this.mobShadows = as2[1].equals("true");
                }
                if (as2[0].equals("vsync")) {
                    this.vSync = as2[1].equals("true");
                }
                int i2 = 0;
                while (i2 < this.keyBindings.length) {
                    if (as2[0].equals("key_" + this.keyBindings[i2].keyDescription)) {
                        this.keyBindings[i2].keyCode = Integer.parseInt(as2[1]);
                    }
                    ++i2;
                }
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to load options");
            exception.printStackTrace();
        }
    }

    private float func_1050_a(String s2) {
        if (s2.equals("true")) {
            return 1.0f;
        }
        if (s2.equals("false")) {
            return 0.0f;
        }
        return Float.parseFloat(s2);
    }

    public void save() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            printwriter.println("music:" + this.musicVolume);
            printwriter.println("sound:" + this.soundVolume);
            printwriter.println("ambience:" + this.ambienceVolume);
            printwriter.println("FOV:" + this.FOV);
            printwriter.println("invertYMouse:" + this.invertMouse);
            printwriter.println("mouseSensitivity:" + this.mouseSensitivity);
            printwriter.println("modemVolume:" + this.modemVolume);
            printwriter.println("viewDistance:" + this.renderDistance);
            printwriter.println("bobView:" + this.viewBobbing);
            printwriter.println("anaglyph3d:" + this.anaglyph);
            printwriter.println("limitFramerate:" + this.limitFramerate);
            printwriter.println("difficulty:" + this.difficulty);
            printwriter.println("guiScale:" + this.guiScale);
            printwriter.println("fancyGraphics:" + this.fancyGraphics);
            printwriter.println(new StringBuilder().append("lastServer:").append(this.lastServer));
            printwriter.println("fog:" + this.fog);
            printwriter.println("Clouds:" + this.clouds);
            printwriter.println("particles:" + this.particles);
            printwriter.println("ignoreJavaWarning:" + this.ignoreJavaWarning);
            printwriter.println("saverate:" + this.chunkSavingInterval);
            printwriter.println("advancedopengl:" + this.advancedOpenGL);
            printwriter.println("displayMode:" + this.displayMode);
            printwriter.println("cloudLevel:" + this.cloudLevel);
            printwriter.println("leafLevel:" + this.leafLevel);
            printwriter.println("precipLevel:" + this.precipLevel);
            printwriter.println("vignette:" + this.vignette);
            printwriter.println("mobShadows:" + this.mobShadows);
            printwriter.println("vsync:" + this.vSync);
            int i2 = 0;
            while (i2 < this.keyBindings.length) {
                printwriter.println("key_" + this.keyBindings[i2].keyDescription + ":" + this.keyBindings[i2].keyCode);
                ++i2;
            }
            printwriter.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to save options");
            exception.printStackTrace();
        }
    }
}

