/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.player.inventory;

import com.mojang.minecraft.crafting.CraftingManager;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.player.inventory.Container;
import com.mojang.minecraft.player.inventory.InventoryCraftResult;
import com.mojang.minecraft.player.inventory.InventoryCrafting;
import com.mojang.minecraft.player.inventory.InventoryPlayer;
import com.mojang.minecraft.player.inventory.Slot;
import com.mojang.minecraft.player.inventory.SlotArmor;
import com.mojang.minecraft.player.inventory.SlotCrafting;

public class ContainerPlayer
extends Container {
    public InventoryCrafting craftMatrix = new InventoryCrafting(this, 2, 2);
    public IInventory craftResult = new InventoryCraftResult();
    public boolean isSinglePlayer;

    public ContainerPlayer(InventoryPlayer inventoryplayer) {
        this(inventoryplayer, true);
    }

    public ContainerPlayer(InventoryPlayer inventoryplayer, boolean flag) {
        this.isSinglePlayer = !inventoryplayer.player.worldObj.multiplayerWorld;
        this.addSlot(new SlotCrafting(inventoryplayer.player, this.craftMatrix, this.craftResult, 0, 144, 36));
        int i2 = 0;
        while (i2 < 2) {
            int i1 = 0;
            while (i1 < 2) {
                this.addSlot(new Slot(this.craftMatrix, i1 + i2 * 2, 88 + i1 * 18, 26 + i2 * 18));
                ++i1;
            }
            ++i2;
        }
        int j2 = 0;
        while (j2 < 4) {
            int j1 = j2;
            if (this.isSinglePlayer) {
                this.addSlot(new SlotArmor(this, inventoryplayer, inventoryplayer.getSizeInventory() - 2 - j2, 8, 8 + j2 * 18, j1));
            } else {
                this.addSlot(new SlotArmor(this, inventoryplayer, inventoryplayer.getSizeInventory() - 1 - j2, 8, 8 + j2 * 18, j1));
            }
            ++j2;
        }
        int k2 = 0;
        while (k2 < 3) {
            int k1 = 0;
            while (k1 < 9) {
                this.addSlot(new Slot(inventoryplayer, k1 + (k2 + 1) * 9, 8 + k1 * 18, 84 + k2 * 18));
                ++k1;
            }
            ++k2;
        }
        int l2 = 0;
        while (l2 < 9) {
            this.addSlot(new Slot(inventoryplayer, l2, 8 + l2 * 18, 142));
            ++l2;
        }
        this.onCraftMatrixChanged(this.craftMatrix);
    }

    public void onCraftMatrixChanged(IInventory iinventory) {
        this.craftResult.setInventorySlotContents(0, CraftingManager.getInstance().findMatchingRecipe(this.craftMatrix));
    }

    public void onCraftGuiClosed(EntityPlayer entityplayer) {
        super.onCraftGuiClosed(entityplayer);
    }

    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public ItemStack getStackInSlot(int i2) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.slots.get(i2);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (i2 == 0) {
                this.func_28125_a(itemstack1, 9, 45, true);
            } else if (i2 >= 9 && i2 < 36) {
                this.func_28125_a(itemstack1, 36, 45, false);
            } else if (i2 >= 36 && i2 < 45) {
                this.func_28125_a(itemstack1, 9, 36, false);
            } else {
                this.func_28125_a(itemstack1, 9, 45, false);
            }
            if (itemstack1.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.stackSize != itemstack.stackSize) {
                slot.onPickupFromSlot(itemstack1);
            } else {
                return null;
            }
        }
        return itemstack;
    }
}

