/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.crafting;

import com.mojang.minecraft.crafting.IRecipe;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.player.inventory.InventoryCrafting;

public class ShapedRecipes
implements IRecipe {
    private int recipeWidth;
    private int recipeHeight;
    private ItemStack[] recipeItems;
    private ItemStack recipeOutput;
    public final int recipeOutputItemID;

    public ShapedRecipes(int i2, int j2, ItemStack[] aitemstack, ItemStack itemstack) {
        this.recipeOutputItemID = itemstack.itemID;
        this.recipeWidth = i2;
        this.recipeHeight = j2;
        this.recipeItems = aitemstack;
        this.recipeOutput = itemstack;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public boolean matches(InventoryCrafting inventorycrafting) {
        int i2 = 0;
        while (i2 <= 3 - this.recipeWidth) {
            int j2 = 0;
            while (j2 <= 3 - this.recipeHeight) {
                if (this.func_21137_a(inventorycrafting, i2, j2, true)) {
                    return true;
                }
                if (this.func_21137_a(inventorycrafting, i2, j2, false)) {
                    return true;
                }
                ++j2;
            }
            ++i2;
        }
        return false;
    }

    private boolean func_21137_a(InventoryCrafting inventorycrafting, int i2, int j2, boolean flag) {
        int k2 = 0;
        while (k2 < 3) {
            int l2 = 0;
            while (l2 < 3) {
                ItemStack itemstack1;
                int i1 = k2 - i2;
                int j1 = l2 - j2;
                ItemStack itemstack = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    itemstack = flag ? this.recipeItems[this.recipeWidth - i1 - 1 + j1 * this.recipeWidth] : this.recipeItems[i1 + j1 * this.recipeWidth];
                }
                if ((itemstack1 = inventorycrafting.func_21103_b(k2, l2)) != null || itemstack != null) {
                    if (itemstack1 == null && itemstack != null || itemstack1 != null && itemstack == null) {
                        return false;
                    }
                    if (itemstack.itemID != itemstack1.itemID) {
                        return false;
                    }
                    if (itemstack.getItemDamage() != -1 && itemstack.getItemDamage() != itemstack1.getItemDamage()) {
                        return false;
                    }
                }
                ++l2;
            }
            ++k2;
        }
        return true;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        return new ItemStack(this.recipeOutput.itemID, this.recipeOutput.stackSize, this.recipeOutput.getItemDamage());
    }

    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }
}

