/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityMobs;
import com.mojang.minecraft.entity.EntitySkeleton;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;

public class EntityCreeper
extends EntityMobs {
    int timeSinceIgnited;
    int lastActiveTime;
    int field_766_c;

    public EntityCreeper(World world) {
        super(world);
        this.scoreYield = 50;
        this.texture = "/mob/creeper.png";
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (byte)-1);
        this.dataWatcher.addObject(17, (byte)0);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    protected void attackBlockedEntity(Entity entity, float f2) {
        if (this.worldObj.multiplayerWorld) {
            return;
        }
        if (this.timeSinceIgnited > 0) {
            this.setCreeperState(-1);
            --this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
        }
    }

    public void onUpdate() {
        this.lastActiveTime = this.timeSinceIgnited;
        if (this.worldObj.multiplayerWorld) {
            int i2 = this.getCreeperState();
            if (i2 > 0 && this.timeSinceIgnited == 0) {
                this.worldObj.playSoundAtEntity(this, "random.fuse", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i2;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= 30) {
                this.timeSinceIgnited = 30;
            }
        }
        super.onUpdate();
        if (this.entityToAttack == null && this.timeSinceIgnited > 0) {
            this.setCreeperState(-1);
            --this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
        }
    }

    protected String hurtSound() {
        return "mob.creeper";
    }

    protected String deathSound() {
        return "mob.creeperdeath";
    }

    public void onDeath(Entity entity) {
        super.onDeath(entity);
        if (entity instanceof EntitySkeleton) {
            if (this.worldObj.multiplayerWorld) {
                return;
            }
            this.dropItem(Item.record13.shiftedIndex + this.rand.nextInt(13), 1);
        }
    }

    protected void attackEntity(Entity entity, float f2) {
        if (this.worldObj.multiplayerWorld) {
            return;
        }
        int i2 = this.getCreeperState();
        if (i2 <= 0 && f2 < 3.0f || i2 > 0 && f2 < 7.0f) {
            if (this.timeSinceIgnited == 0) {
                this.worldObj.playSoundAtEntity(this, "random.fuse", 1.0f, 0.5f);
            }
            this.setCreeperState(1);
            ++this.timeSinceIgnited;
            if (this.timeSinceIgnited >= 30) {
                this.worldObj.createExplosion(this, this.posX, this.posY, this.posZ, 3.0f);
                this.setEntityDead();
            }
            this.hasAttacked = true;
        } else {
            this.setCreeperState(-1);
            --this.timeSinceIgnited;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
        }
    }

    public float setCreeperFlashTime(float f2) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * f2) / 28.0f;
    }

    protected int deathDropItem() {
        return Item.gunpowder.shiftedIndex;
    }

    private int getCreeperState() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    private void setCreeperState(int i2) {
        this.dataWatcher.updateObject(16, (byte)i2);
    }
}

