/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;
import java.util.List;

public class EntityFireExtinguisher
extends Entity {
    private int xTileFireExt = -1;
    private int yTileFireExt = -1;
    private int zTileFireExt = -1;
    private int inTileFireExt = 0;
    private boolean inGroundFireExt = false;
    public int shakeFireExt = 0;
    private EntityLiving thrower;
    private int ticksInGroundSnowball;
    private int ticksInAirFireExt = 0;

    public EntityFireExtinguisher(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
    }

    protected void entityInit() {
    }

    public boolean isInRangeToRenderDist(double d2) {
        double d1 = this.boundingBox.getAverageEdgeLength() * 4.0;
        return d2 < (d1 *= 64.0) * d1;
    }

    public EntityFireExtinguisher(World world, EntityLiving entityliving) {
        super(world);
        this.thrower = entityliving;
        this.setSize(0.25f, 0.25f);
        this.setLocationAndAngles(entityliving.posX, entityliving.posY, entityliving.posZ, entityliving.rotationYaw, entityliving.rotationPitch);
        this.posX -= (double)(MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        float f2 = 0.4f;
        this.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f2;
        this.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f2;
        this.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * 3.141593f) * f2;
        this.setSnowballHeading(this.motionX, this.motionY, this.motionZ, 1.5f, 1.0f);
    }

    public EntityFireExtinguisher(World world, double d2, double d1, double d22) {
        super(world);
        this.ticksInGroundSnowball = 0;
        this.setSize(0.25f, 0.25f);
        this.setPosition(d2, d1, d22);
        this.yOffset = 0.0f;
    }

    public void setSnowballHeading(double d2, double d1, double d22, float f2, float f1) {
        float f22 = MathHelper.sqrt_double(d2 * d2 + d1 * d1 + d22 * d22);
        d2 /= (double)f22;
        d1 /= (double)f22;
        d22 /= (double)f22;
        d2 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d1 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d22 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        this.motionX = d2 *= (double)f2;
        this.motionY = d1 *= (double)f2;
        this.motionZ = d22 *= (double)f2;
        float f3 = MathHelper.sqrt_double(d2 * d2 + d22 * d22);
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(d2, d22) * 180.0 / 3.1415927410125732);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
        this.ticksInGroundSnowball = 0;
    }

    public void setVelocity(double d2, double d1, double d22) {
        this.motionX = d2;
        this.motionY = d1;
        this.motionZ = d22;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f2 = MathHelper.sqrt_double(d2 * d2 + d22 * d22);
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(d2, d22) * 180.0 / 3.1415927410125732);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(d1, f2) * 180.0 / 3.1415927410125732);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onUpdate() {
        block19: {
            super.onUpdate();
            if (this.shakeFireExt > 0) {
                --this.shakeFireExt;
            }
            if (this.inGroundFireExt) {
                int i2 = this.worldObj.getBlockId(this.xTileFireExt, this.yTileFireExt, this.zTileFireExt);
                if (i2 != this.inTileFireExt) {
                    this.inGroundFireExt = false;
                    this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                    this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                    this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                    this.ticksInGroundSnowball = 0;
                    this.ticksInAirFireExt = 0;
                    break block19;
                } else {
                    ++this.ticksInGroundSnowball;
                    if (this.ticksInGroundSnowball == 1200) {
                        this.setEntityDead();
                    }
                    return;
                }
            }
            ++this.ticksInAirFireExt;
        }
        Vec3D vec3d = Vec3D.createVector(this.posX, this.posY, this.posZ);
        Vec3D vec3d1 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        MovingObjectPosition movingobjectposition = this.worldObj.rayTraceBlocks(vec3d, vec3d1);
        vec3d = Vec3D.createVector(this.posX, this.posY, this.posZ);
        vec3d1 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (movingobjectposition != null) {
            vec3d1 = Vec3D.createVector(movingobjectposition.hitVec.xCoord, movingobjectposition.hitVec.yCoord, movingobjectposition.hitVec.zCoord);
        }
        if (!this.worldObj.multiplayerWorld) {
            Entity entity = null;
            List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double d2 = 0.0;
            int j2 = 0;
            while (j2 < list.size()) {
                double d1;
                float f2;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = list.get(j2);
                if (entity1.canBeCollidedWith() && (entity1 != this.thrower || this.ticksInAirFireExt >= 5) && (movingobjectposition1 = (axisalignedbb = entity1.boundingBox.expand(f2 = 0.3f, f2, f2)).func_1169_a(vec3d, vec3d1)) != null && ((d1 = vec3d.distanceTo(movingobjectposition1.hitVec)) < d2 || d2 == 0.0)) {
                    entity = entity1;
                    d2 = d1;
                }
                ++j2;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.entityHit == null || !movingobjectposition.entityHit.attackEntityFrom(this.thrower, 0)) {
                // empty if block
            }
            int k2 = 0;
            while (k2 < 8) {
                this.worldObj.spawnParticle("explode", this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
                ++k2;
            }
            this.extinguish((int)this.posX, (int)this.posY, (int)this.posZ);
            this.setEntityDead();
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f2 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f2) * 180.0 / 3.1415927410125732);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float f1 = 0.99f;
        float f3 = 0.03f;
        if (this.handleWaterMovement()) {
            int l2 = 0;
            while (l2 < 4) {
                float f4 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f4, this.posY - this.motionY * (double)f4, this.posZ - this.motionZ * (double)f4, this.motionX, this.motionY, this.motionZ);
                ++l2;
            }
            f1 = 0.8f;
        }
        this.motionX *= (double)f1;
        this.motionY *= (double)f1;
        this.motionZ *= (double)f1;
        this.motionY -= (double)f3;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    private void extinguish(int xp, int yp, int zp) {
        int radius = 3;
        float f2 = (float)Math.random() / 10.0f + 1.0f;
        float f1 = (float)Math.random() / 10.0f + 1.0f;
        this.worldObj.playSoundAtEntity(this, "random.glass", 1.0f, f2 - 0.25f);
        this.worldObj.playSoundAtEntity(this, "random.splash", 1.0f, f1 + 0.25f);
        int l2 = 0;
        while (l2 < 128) {
            double f4 = Math.random() * 5.0 - 2.5;
            double f3 = Math.random() * 5.0 - 2.5;
            double f22 = Math.random() * 5.0 - 2.5;
            this.worldObj.spawnParticle("bigsplash", this.posX + f4, this.posY + f22, this.posZ + f3, 0.0, this.motionY, 0.0);
            ++l2;
        }
        List<Entity> entities = this.worldObj.getEntitiesWithinAABB(EntityLiving.class, AxisAlignedBB.getBoundingBoxFromPool(xp, yp, zp, xp + 1, yp + 1, zp + 1).expand(radius, radius, radius));
        int i2 = 0;
        while (i2 < entities.size()) {
            if (entities.get((int)i2).fire > 0) {
                this.worldObj.spawnParticle("bigsmoke", entities.get((int)i2).posX, entities.get((int)i2).posY + 1.0, entities.get((int)i2).posZ, 0.0, 1.0, 0.0);
                float f5 = (float)Math.random() / 10.0f + 1.0f;
                this.worldObj.playSoundEffect(entities.get((int)i2).posX, entities.get((int)i2).posY, entities.get((int)i2).posZ, "random.fizz", 1.0f, f5 + 0.25f);
                entities.get((int)i2).fire = 0;
            }
            ++i2;
        }
        int x2 = xp - radius;
        while (x2 <= xp + radius) {
            int y2 = yp - radius;
            while (y2 <= yp + radius) {
                int z2 = zp - radius;
                while (z2 <= zp + radius) {
                    if (this.worldObj.getBlockId(x2, y2, z2) == Block.fire.blockID) {
                        this.worldObj.spawnParticle("bigsmoke", x2, y2, z2, 0.0, 1.0, 0.0);
                        float f5 = (float)Math.random() / 10.0f + 1.0f;
                        this.worldObj.playSoundEffect(x2, y2, z2, "random.fizz", 1.0f, f5 + 0.25f);
                        this.worldObj.setBlock(x2, y2, z2, 0);
                    }
                    ++z2;
                }
                ++y2;
            }
            ++x2;
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("xTile", (short)this.xTileFireExt);
        nbttagcompound.setShort("yTile", (short)this.yTileFireExt);
        nbttagcompound.setShort("zTile", (short)this.zTileFireExt);
        nbttagcompound.setByte("inTile", (byte)this.inTileFireExt);
        nbttagcompound.setByte("shake", (byte)this.shakeFireExt);
        nbttagcompound.setByte("inGround", (byte)(this.inGroundFireExt ? 1 : 0));
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.xTileFireExt = nbttagcompound.getShort("xTile");
        this.yTileFireExt = nbttagcompound.getShort("yTile");
        this.zTileFireExt = nbttagcompound.getShort("zTile");
        this.inTileFireExt = nbttagcompound.getByte("inTile") & 0xFF;
        this.shakeFireExt = nbttagcompound.getByte("shake") & 0xFF;
        this.inGroundFireExt = nbttagcompound.getByte("inGround") == 1;
    }

    public void onCollideWithPlayer(EntityPlayer entityplayer) {
        if (this.inGroundFireExt && this.thrower == entityplayer && this.shakeFireExt <= 0 && entityplayer.inventory.addItemStackToInventory(new ItemStack(Item.arrow.shiftedIndex, 1))) {
            this.worldObj.playSoundAtEntity(this, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.onItemPickup(this, 1);
            this.setEntityDead();
        }
    }

    public float getShadowSize() {
        return 0.0f;
    }
}

