/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityArrow;
import com.mojang.minecraft.entity.EntityFish;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityMobs;
import com.mojang.minecraft.entity.EntitySkeleton;
import com.mojang.minecraft.entity.EntitySpider;
import com.mojang.minecraft.entity.EntityZombie;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.WorldClient;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagList;
import com.mojang.minecraft.player.controller.MovementInput;
import com.mojang.minecraft.player.inventory.Container;
import com.mojang.minecraft.player.inventory.ContainerPlayer;
import com.mojang.minecraft.player.inventory.InventoryPlayer;
import com.mojang.minecraft.util.MathHelper;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class EntityPlayer
extends EntityLiving {
    static String[] PLAYER_COLORS = new String[]{"c", "b", "a", "5", "6", "e", "d", "7"};
    public InventoryPlayer inventory = new InventoryPlayer(this);
    public MovementInput currentInput;
    public Container inventorySlots;
    public Container craftingInventory;
    public byte field_777_c = 0;
    public int score = 0;
    public float field_775_e;
    public float field_774_f;
    public boolean field_773_g = false;
    public int field_772_h = 0;
    public String playerName = "";
    public String particleEffect = "";
    public String chatColor;
    public String playerCloakUrl;
    public double field_20066_r;
    public double field_20065_s;
    public double field_20064_t;
    public double field_20063_u;
    public double field_20062_v;
    public double field_20061_w;
    private int damageRemainder = 0;
    public EntityFish fishEntity;
    public boolean modelRene = false;
    private ChunkCoordinates playerSpawnCoordinate;

    public EntityPlayer(World world) {
        super(world);
        this.craftingInventory = this.inventorySlots = new ContainerPlayer(this.inventory, !world.multiplayerWorld);
        this.yOffset = 1.62f;
        this.setLocationAndAngles((double)world.spawnX + 0.5, world.spawnY + 1, (double)world.spawnZ + 0.5, 0.0f, 0.0f);
        this.health = 20;
        this.field_725_x = "humanoid";
        this.field_726_w = 180.0f;
        this.fireResistance = 20;
        this.texture = "/char.png";
        this.spongeArmor = 0;
        this.leatherArmor = 0;
        this.goldArmor = 0;
        this.chainArmor = 0;
        this.steelArmor = 0;
        this.diamondArmor = 0;
        this.chatColor = EntityPlayer.computePlayerColor(this.worldObj.mc.session.username);
    }

    public static String computePlayerColor(String name) {
        byte[] pName = null;
        try {
            pName = name.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        int length = pName.length;
        int oddShift = 1 - length % 2;
        int value = 0;
        int i2 = 0;
        while (i2 < length) {
            byte by2 = pName[i2];
            int rev = length - (i2 + 1) + oddShift;
            value = rev % 4 >= 2 ? (value -= by2) : (value += by2);
            ++i2;
        }
        if ((value %= 8) < 0) {
            value = PLAYER_COLORS.length + value;
        }
        System.out.println(value);
        return PLAYER_COLORS[value];
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.multiplayerWorld && this.craftingInventory != null && !this.craftingInventory.isUsableByPlayer(this)) {
            this.closeScreen();
            this.craftingInventory = this.inventorySlots;
        }
        this.field_20066_r = this.field_20063_u;
        this.field_20065_s = this.field_20062_v;
        this.field_20064_t = this.field_20061_w;
        double d2 = this.posX - this.field_20063_u;
        double d1 = this.posY - this.field_20062_v;
        double d22 = this.posZ - this.field_20061_w;
        double d3 = 10.0;
        if (d2 > d3) {
            this.field_20066_r = this.field_20063_u = this.posX;
        }
        if (d22 > d3) {
            this.field_20064_t = this.field_20061_w = this.posZ;
        }
        if (d1 > d3) {
            this.field_20065_s = this.field_20062_v = this.posY;
        }
        if (d2 < -d3) {
            this.field_20066_r = this.field_20063_u = this.posX;
        }
        if (d22 < -d3) {
            this.field_20064_t = this.field_20061_w = this.posZ;
        }
        if (d1 < -d3) {
            this.field_20065_s = this.field_20062_v = this.posY;
        }
        this.field_20063_u += d2 * 0.25;
        this.field_20061_w += d22 * 0.25;
        this.field_20062_v += d1 * 0.25;
    }

    public int posXInt() {
        return (int)Math.round(this.posX);
    }

    public int posYInt() {
        return (int)Math.round(this.posY);
    }

    public int posZInt() {
        return (int)Math.round(this.posZ);
    }

    protected void closeScreen() {
        this.craftingInventory = this.inventorySlots;
    }

    public void updateCloak() {
        this.playerCloakUrl = this.cloakURL;
    }

    public void updateRidden() {
        super.updateRidden();
        this.field_775_e = this.field_774_f;
        this.field_774_f = 0.0f;
    }

    public void preparePlayerToSpawn() {
        this.yOffset = 1.62f;
        this.setSize(0.6f, 1.8f);
        super.preparePlayerToSpawn();
        this.health = 20;
        this.deathTime = 0;
    }

    protected void updateEntityActionState() {
        if (this.field_773_g) {
            ++this.field_772_h;
            if (this.field_772_h == 8) {
                this.field_772_h = 0;
                this.field_773_g = false;
            }
        } else {
            this.field_772_h = 0;
        }
        this.swingProgress = (float)this.field_772_h / 8.0f;
    }

    public void onLivingUpdate() {
        List<Entity> list;
        if (!(this.worldObj instanceof WorldClient) && this.worldObj.difficulty == 0 && this.health < 20 && this.ticksExisted % 20 * 4 == 0) {
            this.heal(1);
        }
        this.spongeArmor = this.inventory.getArmorCount("sponge");
        this.leatherArmor = this.inventory.getArmorCount("leather");
        this.goldArmor = this.inventory.getArmorCount("gold");
        this.chainArmor = this.inventory.getArmorCount("chain");
        this.steelArmor = this.inventory.getArmorCount("steel");
        this.diamondArmor = this.inventory.getArmorCount("diamond");
        this.inventory.decrementAnimations();
        this.field_775_e = this.field_774_f;
        super.onLivingUpdate();
        float hypotenuseMove = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float f1 = (float)Math.atan(-this.motionY * (double)0.2f) * 15.0f;
        if (hypotenuseMove > 0.15f) {
            hypotenuseMove = 0.15f;
        }
        if (!this.onGround || this.health <= 0) {
            hypotenuseMove = 0.0f;
        }
        if (this.onGround || this.health <= 0) {
            f1 = 0.0f;
        }
        this.field_774_f += (hypotenuseMove - this.field_774_f) * 0.4f;
        this.field_709_M += (f1 - this.field_709_M) * 0.8f;
        if (this.health > 0 && (list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(1.0, 0.0, 1.0))) != null) {
            int i2 = 0;
            while (i2 < list.size()) {
                this.func_451_h(list.get(i2));
                ++i2;
            }
        }
        if (this.posY < -64.0) {
            this.health -= 4;
        }
    }

    private void func_451_h(Entity entity) {
        entity.onCollideWithPlayer(this);
    }

    public int getScore() {
        return this.score;
    }

    public void onDeath(Entity entity) {
        this.setSize(0.2f, 0.2f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionY = 0.1f;
        if (this.playerName.equals("Noptch")) {
            this.dropInventory(new ItemStack(Item.appleRed, 1), true);
        }
        if (!this.worldObj.multiplayerWorld) {
            this.inventory.dropAllItems();
        }
        if (entity != null) {
            this.motionX = -MathHelper.cos((this.attackedAtYaw + this.rotationYaw) * 3.141593f / 180.0f) * 0.1f;
            this.motionZ = -MathHelper.sin((this.attackedAtYaw + this.rotationYaw) * 3.141593f / 180.0f) * 0.1f;
        } else {
            this.motionZ = 0.0;
            this.motionX = 0.0;
        }
        this.yOffset = 0.1f;
    }

    public void addToPlayerScore(Entity entity, int i2) {
        this.score += i2;
    }

    public void dropPlayerItem(ItemStack itemstack) {
        this.dropInventory(itemstack, false);
    }

    public void dropInventory(ItemStack itemstack, boolean flag) {
        if (itemstack == null || this.worldObj.multiplayerWorld) {
            return;
        }
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY - (double)0.3f + (double)this.func_373_s(), this.posZ, itemstack);
        entityitem.delayBeforeCanPickup = 40;
        if (flag) {
            float f2 = this.rand.nextFloat() * 0.5f;
            float f4 = this.rand.nextFloat() * 3.141593f * 2.0f;
            entityitem.motionX = -MathHelper.sin(f4) * f2;
            entityitem.motionZ = MathHelper.cos(f4) * f2;
            entityitem.motionY = 0.2f;
        } else {
            float f1 = 0.3f;
            entityitem.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f1;
            entityitem.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f1;
            entityitem.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * 3.141593f) * f1 + 0.1f;
            f1 = 0.02f;
            float f3 = this.rand.nextFloat() * 3.141593f * 2.0f;
            entityitem.motionX += Math.cos(f3) * (double)(f1 *= this.rand.nextFloat());
            entityitem.motionY += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
            entityitem.motionZ += Math.sin(f3) * (double)f1;
        }
        this.func_446_a(entityitem);
    }

    protected void func_446_a(EntityItem entityitem) {
        this.worldObj.entityJoinedWorld(entityitem);
    }

    public float getMiningInhibitors(Block block) {
        float f2 = this.inventory.getStrVsBlock(block);
        if (this.isInsideOfMaterial(Material.water)) {
            f2 = this.spongeArmor > 0 ? (f2 /= (float)(5 - this.spongeArmor)) : (f2 /= 5.0f);
        }
        if (!this.onGround) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean checkBreakBlock(Block block) {
        return this.inventory.canHarvestBlock(block);
    }

    public boolean checkGoldTouch(Block block) {
        return this.inventory.canHarvestBlockGoldTouch(block);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Inventory");
        this.inventory.readFromNBT(nbttaglist);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.func_762_a("Inventory", this.inventory.writeToNBT(new NBTTagList()));
    }

    public void displayGUIChest(IInventory iinventory) {
    }

    public void displayWorkbenchGUI() {
    }

    public void onItemPickup(Entity entity, int i2) {
    }

    protected float func_373_s() {
        return 0.12f;
    }

    public boolean attackEntityFrom(Entity entity, int damage) {
        this.field_701_U = 0;
        if (this.health <= 0) {
            return false;
        }
        if ((float)this.heartsLife > (float)this.maxHealth / 2.0f) {
            return false;
        }
        if (entity instanceof EntityMobs || entity instanceof EntityArrow) {
            if (this.worldObj.difficulty == 0) {
                damage = 0;
            }
            if (this.worldObj.difficulty == 1) {
                damage = damage / 3 + 1;
            }
            if (this.worldObj.difficulty == 3) {
                damage = damage * 3 / 2;
            }
        }
        int j2 = 25 - this.inventory.getTotalArmorValue();
        int k2 = damage * j2 + this.damageRemainder;
        this.inventory.damageArmor(damage);
        damage = k2 / 25;
        this.damageRemainder = k2 % 25;
        if (!(damage != 0 || entity instanceof EntityArrow || entity instanceof EntitySpider || entity instanceof EntityZombie || entity instanceof EntitySkeleton)) {
            return false;
        }
        return super.attackEntityFrom(entity, damage);
    }

    protected void damageEntity(int i2) {
        int j2 = 25 - this.inventory.getTotalArmorValue();
        int k2 = i2 * j2 + this.damageRemainder;
        this.inventory.damageArmor(i2);
        i2 = k2 / 25;
        this.damageRemainder = k2 % 25;
        super.damageEntity(i2);
    }

    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
    }

    public void displayGUIEditSign(TileEntitySign tileentitysign) {
    }

    public void useCurrentItemOnEntity(Entity entity) {
    }

    public ItemStack getCurrentEquippedItem() {
        return this.inventory.getCurrentItem();
    }

    public void destroyCurrentEquippedItem() {
        this.inventory.setInventorySlotContents(this.inventory.currentItem, null);
    }

    public double getYOffset() {
        return this.yOffset - 0.5f;
    }

    public void swingItem() {
        this.field_772_h = -1;
        this.field_773_g = true;
    }

    public void attackTargetEntityWithCurrentItem(Entity entity) {
        int i2 = this.inventory.getDamageVsEntity(entity);
        if (i2 > 0) {
            if (this.motionY < 0.0) {
                ++i2;
            }
            entity.attackEntityFrom(this, i2);
            ItemStack itemstack = this.getCurrentEquippedItem();
            if (itemstack != null && entity instanceof EntityLiving) {
                itemstack.hitEntity((EntityLiving)entity);
                if (itemstack.stackSize <= 0) {
                    itemstack.func_1097_a(this);
                    this.destroyCurrentEquippedItem();
                }
            }
        }
    }

    public void func_6420_o() {
    }

    public void setEntityDead() {
        super.setEntityDead();
        this.inventorySlots.onCraftGuiClosed(this);
        if (this.craftingInventory != null) {
            this.craftingInventory.onCraftGuiClosed(this);
        }
    }

    public void onItemStackChanged(ItemStack itemstack) {
    }

    public static ChunkCoordinates func_25060_a(World world, ChunkCoordinates chunkcoordinates) {
        return null;
    }

    public ChunkCoordinates getPlayerSpawnCoordinate() {
        return this.playerSpawnCoordinate;
    }

    public void setPlayerSpawnCoordinate(ChunkCoordinates chunkcoordinates) {
        this.playerSpawnCoordinate = chunkcoordinates != null ? new ChunkCoordinates(chunkcoordinates.x, chunkcoordinates.z) : null;
    }

    public void onEntityUpdate() {
        float f1 = MathHelper.floor_double(this.boundingBox.minY);
        int i2 = 0;
        while ((float)i2 < 1.0f + this.width * 20.0f) {
            float f2 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
            float f4 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
            this.worldObj.spawnParticle(this.particleEffect, this.posX + (double)f2, f1, this.posZ + (double)f4, this.motionX, this.motionY, this.motionZ);
            ++i2;
        }
        super.onEntityUpdate();
    }

    public void setEyeHeight(float f2) {
    }

    public void handleKeyPress(int eventKey, boolean eventKeyState) {
    }

    public void displayWorkbenchGUI(int i2, int j2, int k2) {
    }
}

