/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.render;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemArmor;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.model.ModelBiped;
import com.mojang.minecraft.entity.model.ModelPlayer;
import com.mojang.minecraft.entity.model.ModelPlayerRene;
import com.mojang.minecraft.entity.render.RenderLiving;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.render.FontRenderer;
import com.mojang.minecraft.render.RenderBlocks;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.util.MathHelper;
import java.util.UUID;
import org.lwjgl.opengl.GL11;

public class RenderPlayer
extends RenderLiving {
    private ModelBiped modelBipedMain;
    private ModelBiped modelArmorChestplate;
    private ModelBiped modelArmor;
    private ModelPlayerRene modelRene;
    private ModelPlayer modelSteve = new ModelPlayer(0.0f);
    private static final String[] armorFilenamePrefix = new String[]{"cloth", "chain", "iron", "diamond", "gold", "sponge", "quiver"};

    public RenderPlayer() {
        super(new ModelBiped(0.0f), 0.5f);
        this.modelRene = new ModelPlayerRene(0.0f);
        this.modelBipedMain = (ModelBiped)this.mainModel;
        this.modelArmorChestplate = new ModelBiped(1.0f);
        this.modelArmor = new ModelBiped(0.5f);
        bobbing = true;
    }

    protected boolean setArmorModel(EntityPlayer entityplayer, int i2) {
        Item item;
        ItemStack itemstack = entityplayer.inventory.armorItemInSlot(3 - i2);
        if (itemstack != null && (item = itemstack.getItem()) instanceof ItemArmor) {
            ItemArmor itemarmor = (ItemArmor)item;
            this.loadTexture("/armor/" + armorFilenamePrefix[itemarmor.armorMaterial] + "_" + (i2 != 2 ? 1 : 2) + ".png");
            ModelBiped modelbiped = i2 != 2 ? this.modelArmorChestplate : this.modelArmor;
            modelbiped.bipedHead.showModel = i2 == 0;
            modelbiped.bipedHeadwear.showModel = i2 == 0;
            modelbiped.bipedBody.showModel = i2 == 1 || i2 == 2;
            modelbiped.bipedRightArm.showModel = i2 == 1;
            modelbiped.bipedLeftArm.showModel = i2 == 1;
            modelbiped.bipedRightLeg.showModel = i2 == 2 || i2 == 3;
            modelbiped.bipedLeftLeg.showModel = i2 == 2 || i2 == 3;
            this.func_169_a(modelbiped);
            return true;
        }
        return false;
    }

    public void func_188_a(EntityPlayer entityplayer, double d2, double d1, double d22, float f2, float f1) {
        this.modelBipedMain = entityplayer.modelRene ? this.modelRene : this.modelBipedMain;
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        this.modelBipedMain.field_1278_i = itemstack != null;
        this.modelArmor.field_1278_i = this.modelBipedMain.field_1278_i;
        this.modelArmorChestplate.field_1278_i = this.modelBipedMain.field_1278_i;
        this.modelArmor.bipedIsSneaking = this.modelBipedMain.bipedIsSneaking = entityplayer.getIsSneaking();
        this.modelArmorChestplate.bipedIsSneaking = this.modelBipedMain.bipedIsSneaking;
        ModelBiped.oldWalking = entityplayer.isRunning();
        bobbing = entityplayer.isRunning();
        super.func_171_a(entityplayer, d2, d1 - (double)entityplayer.yOffset, d22, f2, f1);
        this.modelBipedMain.bipedIsSneaking = false;
        this.modelArmor.bipedIsSneaking = false;
        this.modelArmorChestplate.bipedIsSneaking = false;
        this.modelBipedMain.field_1278_i = false;
        this.modelArmor.field_1278_i = false;
        this.modelArmorChestplate.field_1278_i = false;
        FontRenderer fontrenderer = this.getFontRendererFromRenderManager();
        float f22 = 1.6f;
        float f3 = 0.01666667f * f22;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d2 + 0.0f), (float)((float)d1 + 2.3f), (float)((float)d22));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
        float f4 = entityplayer.getDistanceToEntity(this.renderManager.livingPlayer);
        f3 = (float)((double)f3 * (Math.sqrt(f4) / 2.0));
        GL11.glScalef((float)(-f3), (float)(-f3), (float)f3);
        String s2 = entityplayer.playerName;
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        int i2 = fontrenderer.getStringWidth(s2) / 2;
        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.addVertex(-i2 - 1, -1.0, 0.0);
        tessellator.addVertex(-i2 - 1, 8.0, 0.0);
        tessellator.addVertex(i2 + 1, 8.0, 0.0);
        tessellator.addVertex(i2 + 1, -1.0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        fontrenderer.drawString(s2, -fontrenderer.getStringWidth(s2) / 2, 0, 0x20FFFFFF);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontrenderer.drawString(s2, -fontrenderer.getStringWidth(s2) / 2, 0, -1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    protected void renderSpecials(EntityPlayer entityplayer, float f2) {
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        if (itemstack != null) {
            GL11.glPushMatrix();
            this.modelBipedMain.bipedRightArm.func_926_b(0.0625f);
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            if (itemstack.itemID < 256 && RenderBlocks.getRenderItemType(Block.allBlocks[itemstack.itemID].getRenderType())) {
                float f1 = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(f1 *= 0.75f), (float)(-f1), (float)f1);
            } else if (Item.itemsList[itemstack.itemID].func_194_a()) {
                float f22 = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
                GL11.glScalef((float)f22, (float)(-f22), (float)f22);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                float f3 = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
                GL11.glScalef((float)f3, (float)f3, (float)f3);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.renderManager.itemRenderer.func_897_a(itemstack);
            GL11.glPopMatrix();
        }
        if (!(Minecraft.getMinecraft().session.getProfile().getId() == null && entityplayer.playerName != "deadmau5" || !Minecraft.getMinecraft().session.getProfile().getId().equals(UUID.fromString("1e18d5ff-643d-45c8-b509-43b8461d8614")) && entityplayer.playerName != "deadmau5")) {
            int i2 = 0;
            while (i2 < 2) {
                float f23 = entityplayer.prevRotationYaw + (entityplayer.rotationYaw - entityplayer.prevRotationYaw) * f2 - (entityplayer.prevRenderYawOffset + (entityplayer.renderYawOffset - entityplayer.prevRenderYawOffset) * f2);
                float f6 = entityplayer.prevRotationPitch + (entityplayer.rotationPitch - entityplayer.prevRotationPitch) * f2;
                GL11.glPushMatrix();
                GL11.glRotatef((float)f23, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)f6, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.375f * (float)(i2 * 2 - 1)), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.375f, (float)0.0f);
                GL11.glRotatef((float)(-f6), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(-f23), (float)0.0f, (float)1.0f, (float)0.0f);
                float f7 = 1.333333f;
                GL11.glScalef((float)f7, (float)f7, (float)f7);
                this.modelBipedMain.renderEars(0.0625f);
                GL11.glPopMatrix();
                ++i2;
            }
        }
        if (this.loadDownloadableImageTexture(entityplayer.cloakURL, null)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
            double d2 = entityplayer.field_20066_r + (entityplayer.field_20063_u - entityplayer.field_20066_r) * (double)f2 - (entityplayer.prevPosX + (entityplayer.posX - entityplayer.prevPosX) * (double)f2);
            double d1 = entityplayer.field_20065_s + (entityplayer.field_20062_v - entityplayer.field_20065_s) * (double)f2 - (entityplayer.prevPosY + (entityplayer.posY - entityplayer.prevPosY) * (double)f2);
            double d22 = entityplayer.field_20064_t + (entityplayer.field_20061_w - entityplayer.field_20064_t) * (double)f2 - (entityplayer.prevPosZ + (entityplayer.posZ - entityplayer.prevPosZ) * (double)f2);
            float f8 = entityplayer.prevRenderYawOffset + (entityplayer.renderYawOffset - entityplayer.prevRenderYawOffset) * f2;
            double d3 = MathHelper.sin(f8 * 3.141593f / 180.0f);
            double d4 = -MathHelper.cos(f8 * 3.141593f / 180.0f);
            float f9 = (float)d1 * 10.0f;
            if (f9 < -6.0f) {
                f9 = -6.0f;
            }
            if (f9 > 32.0f) {
                f9 = 32.0f;
            }
            float f10 = (float)(d2 * d3 + d22 * d4) * 100.0f;
            float f11 = (float)(d2 * d4 - d22 * d3) * 100.0f;
            if (f10 < 0.0f) {
                f10 = 0.0f;
            }
            float f12 = entityplayer.field_775_e + (entityplayer.field_774_f - entityplayer.field_775_e) * f2;
            f9 += MathHelper.sin((entityplayer.prevDistanceWalkedModified + (entityplayer.distanceWalkedModified - entityplayer.prevDistanceWalkedModified) * f2) * 6.0f) * 32.0f * f12;
            if (entityplayer.isSneaking()) {
                f9 += 25.0f;
            }
            GL11.glRotatef((float)(6.0f + f10 / 2.0f + f9), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(f11 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-f11 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelBipedMain.renderCloak(0.0625f);
            GL11.glPopMatrix();
        }
    }

    protected void func_186_b(EntityPlayer entityplayer, float f2) {
        float f1 = 0.9375f;
        GL11.glScalef((float)f1, (float)f1, (float)f1);
    }

    public void func_185_b() {
        this.modelBipedMain.onGround = 0.0f;
        this.modelBipedMain.setRotationAngles(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        this.modelBipedMain.bipedRightArm.render(0.0625f);
    }

    protected void func_168_a(EntityLiving entityliving, float f2) {
        this.func_186_b((EntityPlayer)entityliving, f2);
    }

    protected boolean func_166_a(EntityLiving entityliving, int i2) {
        return this.setArmorModel((EntityPlayer)entityliving, i2);
    }

    protected void func_174_b(EntityLiving entityliving, float f2) {
        this.renderSpecials((EntityPlayer)entityliving, f2);
    }

    public void func_171_a(EntityLiving entityliving, double d2, double d1, double d22, float f2, float f1) {
        this.func_188_a((EntityPlayer)entityliving, d2, d1, d22, f2, f1);
    }

    public void doRender(Entity entity, double d2, double d1, double d22, float f2, float f1) {
        this.func_188_a((EntityPlayer)entity, d2, d1, d22, f2, f1);
    }
}

