/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityChicken;
import com.mojang.minecraft.entity.EntityCow;
import com.mojang.minecraft.entity.EntityCreeper;
import com.mojang.minecraft.entity.EntityGiant;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLightningBolt;
import com.mojang.minecraft.entity.EntityMob;
import com.mojang.minecraft.entity.EntityMobs;
import com.mojang.minecraft.entity.EntityPig;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntitySheep;
import com.mojang.minecraft.entity.EntitySkeleton;
import com.mojang.minecraft.entity.EntitySlime;
import com.mojang.minecraft.entity.EntitySpider;
import com.mojang.minecraft.entity.EntityZombie;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntityMobSpawner;
import com.mojang.minecraft.gui.ChatAllowedCharacters;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.player.controller.PlayerControllerCreative;
import com.mojang.minecraft.player.controller.PlayerControllerSP;
import com.mojang.minecraft.util.IdMap;
import com.mojang.minecraft.util.SkinManager;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import org.lwjgl.input.Keyboard;

public class GuiChat
extends GuiScreen {
    static String[] PLAYER_COLORS = new String[]{"c", "b", "a", "5", "6", "e", "d", "7"};
    private String message = "";
    private int updateCounter = 0;

    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void updateScreen() {
        ++this.updateCounter;
    }

    public void sendText(String s2) {
        this.mc.ingameGUI.addChatMessage(s2);
    }

    public static String computePlayerColor(String name) {
        byte[] pName = null;
        try {
            pName = name.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        int length = pName.length;
        int oddShift = 1 - length % 2;
        int value = 0;
        int i2 = 0;
        while (i2 < length) {
            byte by2 = pName[i2];
            int rev = length - (i2 + 1) + oddShift;
            value = rev % 4 >= 2 ? (value -= by2) : (value += by2);
            ++i2;
        }
        if ((value %= 8) < 0) {
            value = PLAYER_COLORS.length + value;
        }
        System.out.println(value);
        return PLAYER_COLORS[value];
    }

    protected void keyTyped(char c2, int i2) {
        String s2;
        if (i2 == 1) {
            this.mc.setCurrentScreen(null);
            return;
        }
        if (c2 == '\u0016') {
            int j2;
            s2 = GuiScreen.getClipboardString();
            if (s2 == null) {
                s2 = "";
            }
            if ((j2 = 256 - this.message.length()) > s2.length()) {
                j2 = s2.length();
            }
            if (j2 > 0) {
                this.message = String.valueOf(this.message) + s2.substring(0, j2);
            }
        }
        if (i2 == 28) {
            s2 = this.message.trim();
            if (s2.length() > 0) {
                this.mc.thePlayer.sendChatMessage(this.message.trim());
            }
            this.mc.setCurrentScreen(null);
            if (!this.mc.isServer()) {
                if (this.message.startsWith("/") && !this.mc.thePlayer.worldObj.cheatsDisabled) {
                    this.handleCommand(this.message.replaceFirst("/", ""));
                } else if (!this.message.startsWith("/")) {
                    System.out.println(this.mc.thePlayer.chatColor);
                    this.sendText("<\u00a7" + this.mc.thePlayer.chatColor + this.mc.session.username + "\u00a7f> " + this.message);
                }
            }
            return;
        }
        if (i2 == 14 && this.message.length() > 0) {
            this.message = this.message.substring(0, this.message.length() - 1);
        }
        if (ChatAllowedCharacters.allowedCharacters.indexOf(c2) >= 0 && this.message.length() < 256) {
            this.message = String.valueOf(this.message) + c2;
        }
    }

    private Block getBlockIfExist(int id2) {
        int i2 = 0;
        while (i2 < Block.allBlocks.length) {
            if (Block.allBlocks[i2] != null && Block.allBlocks[i2].blockID == id2) {
                return Block.allBlocks[i2];
            }
            ++i2;
        }
        return null;
    }

    private Item getItemIfExist(int id2) {
        int i2 = 0;
        while (i2 < Item.itemsList.length) {
            if (Item.itemsList[i2] != null && Item.itemsList[i2].shiftedIndex == id2) {
                return Item.itemsList[i2];
            }
            ++i2;
        }
        return null;
    }

    private void handleCommand(String command) {
        String[] commandArgs = command.split(" ");
        if (commandArgs[0].equalsIgnoreCase("give") || commandArgs[0].equalsIgnoreCase("i")) {
            block107: {
                if (commandArgs.length <= 3 && commandArgs.length >= 2) {
                    try {
                        int id2;
                        block106: {
                            id2 = 0;
                            try {
                                id2 = Integer.parseInt(commandArgs[1]);
                            }
                            catch (Exception ex2) {
                                id2 = IdMap.getItem(commandArgs[1]);
                                if (id2 != -1) break block106;
                                this.sendText("Invalid item: " + commandArgs[1]);
                                if (commandArgs[1].equals("null")) {
                                    this.mc.changeWorld(null, "");
                                }
                                return;
                            }
                        }
                        Block blk = this.getBlockIfExist(id2);
                        Item itm = null;
                        int size = 64;
                        if (commandArgs.length == 3) {
                            size = Integer.parseInt(commandArgs[2]);
                        }
                        if (blk == null) {
                            itm = this.getItemIfExist(id2);
                            if (itm != null) {
                                if (commandArgs.length < 3) {
                                    size = itm.maxStackSize;
                                }
                                this.sendText("Giving " + size + " of item " + id2);
                                EntityItem entityitem = new EntityItem(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY, this.mc.thePlayer.posZ, new ItemStack(itm, size));
                                entityitem.delayBeforeCanPickup = 10;
                                this.mc.thePlayer.worldObj.entityJoinedWorld(entityitem);
                            } else {
                                this.sendText("\u00a7cInvalid item: " + id2);
                            }
                            break block107;
                        }
                        this.sendText("Giving " + size + " of item " + id2);
                        EntityItem entityitem = new EntityItem(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY, this.mc.thePlayer.posZ, new ItemStack(blk, size));
                        entityitem.delayBeforeCanPickup = 10;
                        this.mc.thePlayer.worldObj.entityJoinedWorld(entityitem);
                    }
                    catch (Exception ex3) {
                        this.sendText("\u00a7cInvalid syntax for command: " + command);
                        ex3.printStackTrace();
                    }
                } else if (commandArgs.length < 2) {
                    this.sendText("\u00a7cThis requires 2 or more arguments!");
                } else {
                    this.sendText("\u00a7cThis command cannot accept more than 3 arguments!");
                }
            }
            return;
        }
        if (commandArgs.length == 2) {
            if (commandArgs[0].equalsIgnoreCase("setwinter")) {
                try {
                    commandArgs[1] = commandArgs[1].toLowerCase();
                    if (commandArgs[1].equalsIgnoreCase("true") || commandArgs[1].equalsIgnoreCase("false")) {
                        this.mc.thePlayer.worldObj.snowCovered = Boolean.parseBoolean(commandArgs[1]);
                    } else {
                        this.sendText("\u00a7cYou cannot set winter to " + commandArgs[1] + "!");
                    }
                }
                catch (Exception ex4) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex4.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("summon")) {
                Random rand = new Random();
                Entity entitysummon = null;
                if (commandArgs[1].equalsIgnoreCase("slime")) {
                    entitysummon = new EntitySlime(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("mob")) {
                    entitysummon = new EntityMob(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("monster")) {
                    entitysummon = new EntityMobs(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("zombie")) {
                    entitysummon = new EntityZombie(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("creeper")) {
                    entitysummon = new EntityCreeper(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("skeleton")) {
                    entitysummon = new EntitySkeleton(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("sheep")) {
                    entitysummon = new EntitySheep(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("pig")) {
                    entitysummon = new EntityPig(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("cow")) {
                    entitysummon = new EntityCow(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("chicken")) {
                    entitysummon = new EntityChicken(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("giant")) {
                    entitysummon = new EntityGiant(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("spider")) {
                    entitysummon = new EntitySpider(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("player")) {
                    entitysummon = new EntityPlayer(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("lightning")) {
                    entitysummon = new EntityLightningBolt(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY - 2.0, this.mc.thePlayer.posZ);
                }
                if (entitysummon != null) {
                    if (this.mc.objectMouseOver != null && this.mc.thePlayer.worldObj.getBlockId(this.mc.objectMouseOver.blockX, this.mc.objectMouseOver.blockY, this.mc.objectMouseOver.blockZ) == Block.mobSpawner.blockID) {
                        TileEntityMobSpawner tile = (TileEntityMobSpawner)this.mc.thePlayer.worldObj.getBlockTileEntity(this.mc.objectMouseOver.blockX, this.mc.objectMouseOver.blockY, this.mc.objectMouseOver.blockZ);
                        tile.entityID = commandArgs[1];
                    } else {
                        entitysummon.setLocationAndAngles(this.mc.thePlayer.posX, this.mc.thePlayer.posY + 0.5, this.mc.thePlayer.posZ, rand.nextFloat() * 360.0f, 0.0f);
                        this.mc.thePlayer.worldObj.entityJoinedWorld(entitysummon);
                        if (entitysummon instanceof EntityPlayer) {
                            int chance = rand.nextInt(10);
                            switch (chance) {
                                case 0: {
                                    ((EntityPlayer)entitysummon).playerName = "Noptch";
                                    break;
                                }
                                case 1: {
                                    ((EntityPlayer)entitysummon).playerName = "DirtPiper";
                                    break;
                                }
                                case 2: {
                                    ((EntityPlayer)entitysummon).playerName = "Vulpovile";
                                    break;
                                }
                                case 3: {
                                    ((EntityPlayer)entitysummon).playerName = "LO6AN_";
                                    break;
                                }
                                case 4: {
                                    ((EntityPlayer)entitysummon).playerName = "deadmau5";
                                    break;
                                }
                                case 5: {
                                    ((EntityPlayer)entitysummon).playerName = "Herobrine";
                                    break;
                                }
                                case 6: {
                                    ((EntityPlayer)entitysummon).playerName = "GenericPnPMonior";
                                    break;
                                }
                                case 7: {
                                    ((EntityPlayer)entitysummon).playerName = "Steve";
                                    break;
                                }
                                case 8: {
                                    ((EntityPlayer)entitysummon).playerName = "Rene";
                                    ((EntityPlayer)entitysummon).modelRene = true;
                                    break;
                                }
                                case 9: {
                                    ((EntityPlayer)entitysummon).playerName = "jom";
                                }
                            }
                            if (!(((EntityPlayer)entitysummon).playerName.equals("Rene") || ((EntityPlayer)entitysummon).playerName.equals("Steve") || ((EntityPlayer)entitysummon).playerName.equals("Herobrine"))) {
                                SkinManager.getSkinFromName(((EntityPlayer)entitysummon).playerName, (EntityPlayer)entitysummon);
                            }
                            ((EntityPlayer)entitysummon).yOffset = 0.0f;
                            this.mc.mcWorld.obtainEntitySkin(entitysummon);
                        }
                    }
                } else {
                    this.sendText("\u00a7cA " + commandArgs[1] + " is not a valid entity!");
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("gamemode")) {
                if (commandArgs[1].equalsIgnoreCase("survival") || commandArgs[1].equalsIgnoreCase("s") || commandArgs[1].equalsIgnoreCase("0")) {
                    this.mc.playerController = new PlayerControllerSP(this.mc);
                    this.mc.thePlayer.isCreative = false;
                    this.sendText("Your game mode has been set to survival.");
                } else if (commandArgs[1].equalsIgnoreCase("creative") || commandArgs[1].equalsIgnoreCase("c") || commandArgs[1].equalsIgnoreCase("1")) {
                    this.mc.playerController = new PlayerControllerCreative(this.mc);
                    this.mc.thePlayer.isCreative = true;
                    this.sendText("Your game mode has been set to creative.");
                } else {
                    this.sendText("\u00a7c" + commandArgs[1] + " is not a valid game mode!");
                }
                return;
            }
        } else if (commandArgs.length == 3) {
            if (commandArgs[0].equalsIgnoreCase("summon") && commandArgs[1].equalsIgnoreCase("player")) {
                Random rand = new Random();
                EntityPlayer entitysummon = new EntityPlayer(this.mc.thePlayer.worldObj);
                entitysummon.setLocationAndAngles(this.mc.thePlayer.posX, this.mc.thePlayer.posY + 0.5, this.mc.thePlayer.posZ, rand.nextFloat() * 360.0f, 0.0f);
                this.mc.thePlayer.worldObj.entityJoinedWorld(entitysummon);
                entitysummon.playerName = commandArgs[2];
                SkinManager.getSkinFromName(entitysummon.playerName, entitysummon);
                entitysummon.yOffset = 0.0f;
                this.mc.mcWorld.obtainEntitySkin(entitysummon);
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("time")) {
                try {
                    if (commandArgs[1].equalsIgnoreCase("add")) {
                        int ticks = Integer.parseInt(commandArgs[2]);
                        this.mc.thePlayer.worldObj.worldTime += (long)ticks;
                    } else if (commandArgs[1].equalsIgnoreCase("set")) {
                        if (commandArgs[2].equalsIgnoreCase("day")) {
                            this.mc.thePlayer.worldObj.worldTime = 0L;
                        } else if (commandArgs[2].equalsIgnoreCase("night")) {
                            this.mc.thePlayer.worldObj.worldTime = 13000L;
                        } else {
                            int ticks = Integer.parseInt(commandArgs[2]);
                            this.mc.thePlayer.worldObj.worldTime = ticks;
                        }
                    } else {
                        this.sendText("\u00a7cInvalid parameter for time command: " + commandArgs[1] + ". Use 'add' or 'set'");
                    }
                }
                catch (Exception ex5) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex5.printStackTrace();
                }
                return;
            }
        } else if (commandArgs.length == 4) {
            if (commandArgs[0].equalsIgnoreCase("give") || commandArgs[0].equalsIgnoreCase("i")) {
                try {
                    int id3 = Integer.parseInt(commandArgs[1]);
                    int size = Integer.parseInt(commandArgs[2]);
                    int damage = Integer.parseInt(commandArgs[3]);
                    Block blk = this.getBlockIfExist(id3);
                    Item itm = null;
                    if (blk == null) {
                        itm = this.getItemIfExist(id3);
                        if (itm != null) {
                            this.sendText("Giving " + size + " of item " + id3 + " with damage " + damage);
                            EntityItem entityitem = new EntityItem(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY, this.mc.thePlayer.posZ, new ItemStack(itm.shiftedIndex, size, damage));
                            entityitem.delayBeforeCanPickup = 10;
                            this.mc.thePlayer.worldObj.entityJoinedWorld(entityitem);
                        } else {
                            this.sendText("\u00a7cInvalid item: " + id3);
                        }
                    } else {
                        this.sendText("Giving " + size + " of item " + id3 + " with damage " + damage);
                        this.sendText("Damage invalid for block, ignoring");
                        EntityItem entityitem = new EntityItem(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY, this.mc.thePlayer.posZ, new ItemStack(blk, size));
                        entityitem.delayBeforeCanPickup = 10;
                        this.mc.thePlayer.worldObj.entityJoinedWorld(entityitem);
                    }
                }
                catch (Exception ex6) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex6.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("teleport") || commandArgs[0].equalsIgnoreCase("tp")) {
                try {
                    int x2 = Integer.parseInt(commandArgs[1]);
                    int y2 = Integer.parseInt(commandArgs[2]);
                    int z2 = Integer.parseInt(commandArgs[3]);
                    if (this.mc.thePlayer.worldObj.getBlockId(x2, y2, z2) != 0) {
                        // empty if block
                    }
                    y2 = this.getHighestBlock(this.mc.thePlayer.worldObj, x2, y2, z2);
                    this.mc.thePlayer.setPosition(x2, y2, z2);
                }
                catch (Exception ex7) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex7.printStackTrace();
                }
                return;
            }
        } else if (commandArgs.length == 1) {
            if (commandArgs[0].equalsIgnoreCase("spawn")) {
                try {
                    int x3 = this.mc.thePlayer.worldObj.spawnX;
                    int y3 = this.mc.thePlayer.worldObj.spawnY;
                    int z3 = this.mc.thePlayer.worldObj.spawnZ;
                    if (this.mc.thePlayer.worldObj.getBlockId(x3, y3, z3) != 0) {
                        // empty if block
                    }
                    y3 = this.getHighestBlock(this.mc.thePlayer.worldObj, x3, y3, z3);
                    this.mc.thePlayer.setPosition(x3, y3, z3);
                }
                catch (Exception ex8) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex8.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("help")) {
                this.sendText("\u00a7b---------------Command help (Page 1 of 1)---------------");
                this.sendText("\u00a7e/teleport/tp <x> <y> <z> - teleport to a location");
                this.sendText("\u00a7e/give <item> [quantity] - gives requested item");
                this.sendText("\u00a7e/i <item> [quantity] - alias to give");
                this.sendText("\u00a7e/time <set/add> <ticks> - changes the time");
                this.sendText("\u00a7e/setwinter <true/false> - sets the world's climate");
                this.sendText("\u00a7e/summon <entity> - spawns the requested entity");
                this.sendText("\u00a7e/spawn - sends you to the spawn location");
                this.sendText("\u00a7e/gamemode <survival/creative> - sets your current gamemode");
                this.sendText("\u00a7b-----------------------------------------------------");
                return;
            }
        }
        this.sendText("\u00a7cInvalid command: " + command);
    }

    private int getHighestBlock(World world, int x2, int y2, int z2) {
        int i2 = 128;
        while (i2 > 0) {
            if (world.getBlockId(x2, i2, z2) != 0) {
                return i2 + 2;
            }
            --i2;
        }
        return 0;
    }

    public void drawScreen(int i2, int j2, float f2) {
        this.drawRect(2, this.height - 14, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        this.drawString(this.fontRenderer, "> " + this.message + (this.updateCounter / 6 % 2 != 0 ? "" : "_"), 4, this.height - 12, 0xE0E0E0);
    }

    public void handleMouseInput() {
        super.handleMouseInput();
        if (this.scrollAmount < 0) {
            this.scrollAmount = 0;
        }
        if (this.scrollAmount > 512) {
            this.scrollAmount = 512;
        }
    }

    public void sendScroll(int j2) {
        if (j2 > 0) {
            j2 = 1;
        }
        if (j2 < 0) {
            j2 = -1;
        }
        this.scrollAmount += j2;
    }

    protected void mouseClicked(int i2, int j2, int k2) {
        System.out.println(this.message);
        if (k2 != 0 || this.mc.ingameGUI.hoveredPlayer == null) {
            return;
        }
        if (this.message.length() > 0 && !this.message.endsWith(" ")) {
            this.message = String.valueOf(this.message) + " ";
        }
        this.message = String.valueOf(this.message) + this.mc.ingameGUI.hoveredPlayer;
        int byte0 = 256;
        if (this.message.length() > byte0) {
            this.message = this.message.substring(0, byte0);
        }
    }
}

