/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.render.RenderItem;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.player.inventory.Container;
import com.mojang.minecraft.player.inventory.InventoryPlayer;
import com.mojang.minecraft.player.inventory.Slot;
import com.mojang.minecraft.render.RenderHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainer
extends GuiScreen {
    private static RenderItem itemRenderer = new RenderItem();
    public int xSize = 176;
    public int ySize = 166;
    protected Container inventorySlots;

    public GuiContainer(Container container) {
        this.inventorySlots = container;
    }

    public void initGui() {
        super.initGui();
        this.mc.thePlayer.craftingInventory = this.inventorySlots;
    }

    public void drawScreen(int i2, int j2, float f2) {
        this.drawDefaultBackground();
        int k2 = (this.width - this.xSize) / 2;
        int l2 = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(f2);
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)k2, (float)l2, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        int i1 = 0;
        while (i1 < this.inventorySlots.slots.size()) {
            Slot slot1 = (Slot)this.inventorySlots.slots.get(i1);
            this.drawSlotInventory(slot1);
            if (this.getIsMouseOverSlot(slot1, i2, j2)) {
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                int j1 = slot1.xDisplayPosition;
                int k1 = slot1.yDisplayPosition;
                this.drawGradientRect(j1, k1, j1 + 16, k1 + 16, -2130706433, -2130706433);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
            ++i1;
        }
        InventoryPlayer inventoryplayer = this.mc.thePlayer.inventory;
        if (inventoryplayer.itemStack != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            itemRenderer.renderItemBlock(this.fontRenderer, this.mc.renderEngine, inventoryplayer.itemStack, i2 - k2 - 8, j2 - l2 - 8);
            itemRenderer.renderTextDmg(this.fontRenderer, this.mc.renderEngine, inventoryplayer.itemStack, i2 - k2 - 8, j2 - l2 - 8);
        }
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.drawGuiContainerForegroundLayer();
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    protected void drawGuiContainerForegroundLayer() {
    }

    protected abstract void drawGuiContainerBackgroundLayer(float var1);

    private void drawSlotInventory(Slot slot) {
        int k2;
        int i2 = slot.xDisplayPosition;
        int j2 = slot.yDisplayPosition;
        ItemStack itemstack = slot.getStack();
        if (itemstack == null && (k2 = slot.getBackgroundIconIndex()) >= 0) {
            GL11.glDisable((int)2896);
            this.mc.renderEngine.bindTex(this.mc.renderEngine.getTex("/gui/items.png"));
            this.drawTexturedModalRect(i2, j2, k2 % 16 * 16, k2 / 16 * 16, 16, 16);
            GL11.glEnable((int)2896);
            return;
        }
        itemRenderer.renderItemBlock(this.fontRenderer, this.mc.renderEngine, itemstack, i2, j2);
        itemRenderer.renderTextDmg(this.fontRenderer, this.mc.renderEngine, itemstack, i2, j2);
    }

    private Slot getSlotAtPosition(int i2, int j2) {
        int k2 = 0;
        while (k2 < this.inventorySlots.slots.size()) {
            Slot slot = (Slot)this.inventorySlots.slots.get(k2);
            if (this.getIsMouseOverSlot(slot, i2, j2)) {
                return slot;
            }
            ++k2;
        }
        return null;
    }

    private boolean getIsMouseOverSlot(Slot slot, int i2, int j2) {
        int k2 = (this.width - this.xSize) / 2;
        int l2 = (this.height - this.ySize) / 2;
        return (i2 -= k2) >= slot.xDisplayPosition - 1 && i2 < slot.xDisplayPosition + 16 + 1 && (j2 -= l2) >= slot.yDisplayPosition - 1 && j2 < slot.yDisplayPosition + 16 + 1;
    }

    protected void mouseClicked(int i2, int j2, int k2) {
        super.mouseClicked(i2, j2, k2);
        if (k2 == 0 || k2 == 1) {
            Slot slot = this.getSlotAtPosition(i2, j2);
            int l2 = (this.width - this.xSize) / 2;
            int i1 = (this.height - this.ySize) / 2;
            boolean flag = i2 < l2 || j2 < i1 || i2 >= l2 + this.xSize || j2 >= i1 + this.ySize;
            int j1 = -1;
            if (slot != null) {
                j1 = slot.slotNumber;
            }
            if (flag) {
                j1 = -999;
            }
            if (j1 != -1) {
                boolean flag1 = j1 != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                this.mc.playerController.func_27174_a(this.inventorySlots.windowId, j1, k2, flag1, this.mc.thePlayer);
            }
        }
    }

    protected void mouseMovedOrUp(int i2, int j2, int k2) {
        if (k2 != 0) {
            // empty if block
        }
    }

    protected void keyTyped(char c2, int i2) {
        if (i2 == 1 || i2 == this.mc.options.keyBindInventory.keyCode) {
            this.mc.thePlayer.closeScreen();
        }
    }

    public void onGuiClosed() {
        if (this.mc.thePlayer == null) {
            return;
        }
        this.mc.playerController.func_20086_a(this.inventorySlots.windowId, this.mc.thePlayer);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }
}

