/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.gui.GuiButton;
import com.mojang.minecraft.gui.GuiControls;
import com.mojang.minecraft.gui.GuiCredits;
import com.mojang.minecraft.gui.GuiExtraVideoSettings;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.gui.GuiSlider;
import com.mojang.minecraft.gui.GuiSmallButton;
import com.mojang.minecraft.player.controller.GameSettings;
import com.mojang.minecraft.render.ScaledResolution;

public class GuiOptions
extends GuiScreen {
    private GuiScreen parentScreen;
    protected String screenTitle = "Options";
    private GameSettings options;

    public GuiOptions(GuiScreen guiscreen, GameSettings gamesettings) {
        this.parentScreen = guiscreen;
        this.options = gamesettings;
    }

    public void initGui() {
        this.controlList.clear();
        int i2 = 0;
        while (i2 < this.options.numberOfOptions) {
            int j2 = this.options.func_1046_b(i2);
            if (j2 == 0) {
                this.controlList.add(new GuiSmallButton(i2, this.width / 2 - 155 + i2 % 2 * 160, this.height / 6 + 24 * (i2 >> 1), this.options.getOptionValue(i2)));
            } else if (i2 != 4) {
                this.controlList.add(new GuiSlider(i2, this.width / 2 - 155 + i2 % 2 * 160, this.height / 6 + 24 * (i2 >> 1), i2, this.options.getOptionValue(i2), this.options.sliderType(i2)));
            } else {
                this.controlList.add(new GuiSlider(i2, this.width / 2 - 155 + i2 % 2 * 160, this.height / 6 + 24 * (i2 >> 1), i2, this.options.getOptionValue(i2), 1.0f - (this.options.sliderType(i2) + 3.0f) / 6.0f));
            }
            ++i2;
        }
        this.controlList.add(new GuiButton(100, this.width / 2 - 100, this.height / 6 + 145, 98, 20, "Controls..."));
        this.controlList.add(new GuiButton(300, this.width / 2 + 2, this.height / 6 + 145, 98, 20, "Extra Settings..."));
        this.controlList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 168, "Done"));
        if (this.mc.mcWorld != null && this.mc.mcWorld.multiplayerWorld) {
            ((GuiButton)this.controlList.get((int)8)).enabled = false;
        }
        ((GuiButton)this.controlList.get((int)9)).enabled = false;
        ((GuiButton)this.controlList.get((int)9)).displayString = "Mods & Texture Packs...";
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 7) {
            this.mc.setCurrentScreen(new GuiCredits(this));
        }
        if (guibutton.id < 100) {
            if (guibutton.id != 4 && guibutton.id != 7) {
                this.options.setOptionValue(guibutton.id, 1);
            }
            guibutton.displayString = this.options.getOptionValue(guibutton.id);
        }
        if (guibutton.id == 11) {
            this.mc.setIngameNotInFocus();
            ScaledResolution scaledresolution = new ScaledResolution(this.mc.displayWidth, this.mc.displayHeight, this.mc);
            int i2 = scaledresolution.getScaledWidth();
            int j2 = scaledresolution.getScaledHeight();
            this.setResolution(this.mc, i2, j2);
            this.mc.skipRenderWorld = false;
        }
        if (guibutton.id == 100) {
            this.mc.setCurrentScreen(new GuiControls(this, this.options));
        }
        if (guibutton.id == 200) {
            this.mc.setCurrentScreen(this.parentScreen);
        }
        if (guibutton.id == 300) {
            this.mc.setCurrentScreen(new GuiExtraVideoSettings(this, this.options));
        }
    }

    public void drawScreen(int i2, int j2, float f2) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(i2, j2, f2);
    }
}

