/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkProviderGenerate;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.generate.WorldGenBigTree;
import com.mojang.minecraft.level.generate.WorldGenCactus;
import com.mojang.minecraft.level.generate.WorldGenClay;
import com.mojang.minecraft.level.generate.WorldGenDungeons;
import com.mojang.minecraft.level.generate.WorldGenFlowers;
import com.mojang.minecraft.level.generate.WorldGenLiquids;
import com.mojang.minecraft.level.generate.WorldGenMinable;
import com.mojang.minecraft.level.generate.WorldGenReed;
import com.mojang.minecraft.level.generate.WorldGenTrees;
import com.mojang.minecraft.level.generate.WorldGenWaterDungeons;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockSand;
import com.mojang.minecraft.level.tile.material.Material;

public class ChunkProviderDesert
extends ChunkProviderGenerate {
    public ChunkProviderDesert(World world, long l2) {
        super(world, l2);
        world.cloudHeight = -10.0f;
    }

    public void replaceBlocksForBiome(int i2, int j2, byte[] abyte0) {
        int seaLevel = 64;
        double d2 = 0.03125;
        this.sandBeachNoise = this.beachNoise.generateNoiseOctaves_2(this.sandBeachNoise, i2 * 16, j2 * 16, 0.0, 16, 16, 1, d2, d2, 1.0);
        this.gravelBeachNoise = this.beachNoise.generateNoiseOctaves_2(this.gravelBeachNoise, j2 * 16, 109.0134, i2 * 16, 16, 1, 16, d2, 1.0, d2);
        this.soilThicknessNoise = this.soilNoise.generateNoiseOctaves_2(this.soilThicknessNoise, i2 * 16, j2 * 16, 0.0, 16, 16, 1, d2 * 2.0, d2 * 2.0, d2 * 2.0);
        int k2 = 0;
        while (k2 < 16) {
            int l2 = 0;
            while (l2 < 16) {
                boolean flag = this.sandBeachNoise[l2 + k2 * 16] + this.genRandom.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelBeachNoise[k2 + l2 * 16] + this.genRandom.nextDouble() * 0.2 > 3.0;
                int i1 = (int)(this.soilThicknessNoise[l2 + k2 * 16] / 3.0 + 3.0 + this.genRandom.nextDouble() * 0.25);
                int j1 = -1;
                byte byte1 = (byte)Block.sand.blockID;
                byte byte2 = (byte)Block.sand.blockID;
                int k1 = 127;
                while (k1 >= 0) {
                    int l1 = (k2 * 16 + l2) * 128 + k1;
                    if (k1 <= 0 + this.genRandom.nextInt(6) - 1) {
                        abyte0[l1] = (byte)Block.bedrock.blockID;
                    } else {
                        byte byte3 = abyte0[l1];
                        if (byte3 == 0) {
                            j1 = -1;
                        } else if (byte3 == Block.stone.blockID) {
                            if (j1 == -1) {
                                if (i1 <= 0) {
                                    byte1 = 0;
                                    byte2 = (byte)Block.stone.blockID;
                                } else if (k1 >= seaLevel - 4 && k1 <= seaLevel + 1) {
                                    byte1 = (byte)Block.sand.blockID;
                                    byte2 = (byte)Block.sand.blockID;
                                    if (flag1) {
                                        byte1 = 0;
                                    }
                                    if (flag1) {
                                        byte2 = (byte)Block.gravel.blockID;
                                    }
                                    if (flag) {
                                        byte1 = (byte)Block.grass.blockID;
                                    }
                                    if (flag) {
                                        byte2 = (byte)Block.dirt.blockID;
                                    }
                                }
                                if (k1 < seaLevel && byte1 == 0) {
                                    byte1 = (byte)Block.waterStill.blockID;
                                }
                                j1 = i1;
                                abyte0[l1] = k1 >= seaLevel - 1 ? byte1 : byte2;
                            } else if (j1 > 0) {
                                --j1;
                                abyte0[l1] = byte2;
                            }
                        }
                    }
                    --k1;
                }
                ++l2;
            }
            ++k2;
        }
    }

    protected double[] initializeNoiseField(double[] ad2, int i2, int j2, int k2, int l2, int i1, int j1) {
        double noiseScaleX = 80.0;
        double noiseScaleY = 160.0;
        double noiseScaleZ = 80.0;
        double floatyness = 0.0;
        if (ad2 == null) {
            ad2 = new double[l2 * i1 * j1];
        }
        double coordinateScale = 684.412;
        double heightScale = 684.412;
        this.heightBias1 = this.noiseGen6.generateNoiseOctaves(this.heightBias1, i2, j2, k2, l2, 1, j1, 1.0, 0.0, 1.0);
        this.heightBias2 = this.noiseGen7.generateNoiseOctaves(this.heightBias2, i2, j2, k2, l2, 1, j1, 100.0, 0.0, 100.0);
        this.noiseData1 = this.noiseGen3.generateNoiseOctaves(this.noiseData1, i2, j2, k2, l2, i1, j1, coordinateScale / noiseScaleX, heightScale / noiseScaleY, coordinateScale / noiseScaleZ);
        this.noiseData2 = this.noiseGen1.generateNoiseOctaves(this.noiseData2, i2, j2, k2, l2, i1, j1, coordinateScale, heightScale, coordinateScale);
        this.noiseData3 = this.noiseGen2.generateNoiseOctaves(this.noiseData3, i2, j2, k2, l2, i1, j1, coordinateScale, heightScale, coordinateScale);
        int k1 = 0;
        int l1 = 0;
        int i22 = 0;
        while (i22 < l2) {
            int j22 = 0;
            while (j22 < j1) {
                double d2 = (this.heightBias1[l1] + 256.0) / 512.0;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                double d3 = floatyness;
                double d4 = this.heightBias2[l1] / 8000.0;
                if (d4 < 0.0) {
                    d4 = -d4;
                }
                if ((d4 = d4 * 3.0 - 3.0) < 0.0) {
                    if ((d4 /= 2.0) < -1.0) {
                        d4 = -1.0;
                    }
                    d4 /= 1.4;
                    d4 /= 2.0;
                    d2 = 0.0;
                } else {
                    if (d4 > 1.0) {
                        d4 = 1.0;
                    }
                    d4 /= 6.0;
                }
                d2 += 0.5;
                d4 = d4 * (double)i1 / 16.0;
                double d5 = (double)i1 / 2.0 + d4 * 4.0;
                ++l1;
                int k22 = 0;
                while (k22 < i1) {
                    double d6 = 0.0;
                    double d7 = ((double)k22 - d5) * 12.0 / d2;
                    if (d7 < 0.0) {
                        d7 *= 4.0;
                    }
                    double d8 = this.noiseData2[k1] / 512.0;
                    double d9 = this.noiseData3[k1] / 512.0;
                    double d10 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k22 > i1 - 4) {
                        double d11 = (float)(k22 - (i1 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)k22 < d3) {
                        double d12 = (d3 - (double)k22) / 4.0;
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 > 1.0) {
                            d12 = 1.0;
                        }
                        d6 = d6 * (1.0 - d12) + -10.0 * d12;
                    }
                    ad2[k1] = d6;
                    ++k1;
                    ++k22;
                }
                ++j22;
            }
            ++i22;
        }
        return ad2;
    }

    public boolean chunkExists(int i2, int j2) {
        return true;
    }

    public void generateStructures(IChunkProvider ichunkprovider, int i2, int j2) {
        int l13;
        int i9;
        int k12;
        int l7;
        int k5;
        int i11;
        int j6;
        int i4;
        BlockSand.fallInstantly = true;
        int k2 = i2 * 16;
        int l2 = j2 * 16;
        this.genRandom.setSeed(this.worldObj.randomSeed);
        long l1 = this.genRandom.nextLong() / 2L * 2L + 1L;
        long l22 = this.genRandom.nextLong() / 2L * 2L + 1L;
        this.genRandom.setSeed((long)i2 * l1 + (long)j2 * l22 ^ this.worldObj.randomSeed);
        double d2 = 0.25;
        int i1 = 0;
        while (i1 < 8) {
            i4 = k2 + this.genRandom.nextInt(16) + 8;
            j6 = this.genRandom.nextInt(128);
            i11 = l2 + this.genRandom.nextInt(16) + 8;
            new WorldGenDungeons().generate(this.worldObj, this.genRandom, i4, j6, i11);
            ++i1;
        }
        if (!(k2 <= 1000 && k2 >= -1000 || l2 <= 1000 && l2 >= -1000 || this.genRandom.nextInt(4000) != 2)) {
            int y2 = 0;
            while (y2 < 128) {
                short inc = (short)(y2 - 128);
                int x2 = k2 + inc + 1;
                while (x2 < k2 - inc) {
                    int z2 = l2 + inc + 1;
                    while (z2 < l2 - inc) {
                        if (!this.worldObj.isBlockNormalCube(x2, y2, z2)) {
                            this.worldObj.setBlockWithNotify(x2, y2, z2, Block.sand.blockID);
                        }
                        ++z2;
                    }
                    ++x2;
                }
                y2 = (short)(y2 + 1);
            }
        }
        i1 = 0;
        while (i1 < 8) {
            i4 = k2 + this.genRandom.nextInt(16) + 8;
            j6 = this.genRandom.nextInt(512);
            i11 = l2 + this.genRandom.nextInt(16) + 8;
            try {
                new WorldGenWaterDungeons().generate(this.worldObj, this.genRandom, i4, j6, i11);
            }
            catch (NullPointerException ex2) {
                System.out.print("Attempted and failed!");
            }
            ++i1;
        }
        int j1 = 0;
        while (j1 < 10) {
            int j4 = k2 + this.genRandom.nextInt(16);
            int k6 = this.genRandom.nextInt(64);
            int j11 = l2 + this.genRandom.nextInt(16);
            new WorldGenClay(8, new int[]{Block.grass.blockID, Block.dirt.blockID}).generate(this.worldObj, this.genRandom, j4, k6, j11);
            ++j1;
        }
        int k1 = 0;
        while (k1 < 20) {
            int k4 = k2 + this.genRandom.nextInt(16);
            int l6 = this.genRandom.nextInt(128);
            int k11 = l2 + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32).generate(this.worldObj, this.genRandom, k4, l6, k11);
            ++k1;
        }
        int i22 = 0;
        while (i22 < 10) {
            int l4 = k2 + this.genRandom.nextInt(16);
            int i7 = this.genRandom.nextInt(128);
            int l11 = l2 + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32).generate(this.worldObj, this.genRandom, l4, i7, l11);
            ++i22;
        }
        int j22 = 0;
        while (j22 < 20) {
            int i5 = k2 + this.genRandom.nextInt(16);
            int j7 = this.genRandom.nextInt(128);
            int i12 = l2 + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreCoal.blockID, 16).generate(this.worldObj, this.genRandom, i5, j7, i12);
            ++j22;
        }
        int k22 = 0;
        while (k22 < 20) {
            int j5 = k2 + this.genRandom.nextInt(16);
            int k7 = this.genRandom.nextInt(64);
            int j12 = l2 + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreIron.blockID, 8).generate(this.worldObj, this.genRandom, j5, k7, j12);
            ++k22;
        }
        int i3 = 0;
        while (i3 < 2) {
            k5 = k2 + this.genRandom.nextInt(16);
            l7 = this.genRandom.nextInt(32);
            k12 = l2 + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreGold.blockID, 8).generate(this.worldObj, this.genRandom, k5, l7, k12);
            ++i3;
        }
        i3 = 0;
        while (i3 < 6) {
            k5 = k2 + this.genRandom.nextInt(16);
            l7 = this.genRandom.nextInt(32);
            k12 = l2 + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreCopper.blockID, 8).generate(this.worldObj, this.genRandom, k5, l7, k12);
            ++i3;
        }
        int j3 = 0;
        while (j3 < 8) {
            int l5 = k2 + this.genRandom.nextInt(16);
            int i8 = this.genRandom.nextInt(16);
            int l12 = l2 + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreRed.blockID, 7).generate(this.worldObj, this.genRandom, l5, i8, l12);
            ++j3;
        }
        int k3 = 0;
        while (k3 < 1) {
            int i6 = k2 + this.genRandom.nextInt(16);
            int j8 = this.genRandom.nextInt(16);
            int i13 = l2 + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreDiamond.blockID, 7).generate(this.worldObj, this.genRandom, i6, j8, i13);
            ++k3;
        }
        d2 = 0.5;
        int l3 = (int)((this.treeNoise.func_806_a((double)k2 * d2, (double)l2 * d2) / 8.0 + this.genRandom.nextDouble() * 4.0 + 4.0) / 3.0);
        if (l3 < 0) {
            l3 = 0;
        }
        if (this.genRandom.nextInt(10) == 0) {
            ++l3;
        }
        WorldGenerator obj = new WorldGenTrees();
        if (this.genRandom.nextInt(10) == 0) {
            obj = new WorldGenBigTree();
        }
        int k8 = 0;
        while (k8 < l3) {
            int j13 = k2 + this.genRandom.nextInt(16) + 8;
            int l15 = l2 + this.genRandom.nextInt(16) + 8;
            ((WorldGenerator)obj).func_517_a(1.0, 1.0, 1.0);
            ((WorldGenerator)obj).generate(this.worldObj, this.genRandom, j13, this.worldObj.getHeightValue(j13, l15), l15);
            ++k8;
        }
        int l8 = 0;
        while (l8 < 2) {
            int k13 = k2 + this.genRandom.nextInt(16) + 8;
            int i16 = this.genRandom.nextInt(128);
            int j18 = l2 + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantYellow.blockID).generate(this.worldObj, this.genRandom, k13, i16, j18);
            ++l8;
        }
        if (this.genRandom.nextInt(2) == 0) {
            i9 = k2 + this.genRandom.nextInt(16) + 8;
            l13 = this.genRandom.nextInt(128);
            int j16 = l2 + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantRed.blockID).generate(this.worldObj, this.genRandom, i9, l13, j16);
        }
        if (this.genRandom.nextInt(1) == 0) {
            i9 = k2 + this.genRandom.nextInt(16) + 8;
            l13 = this.genRandom.nextInt(128);
            int j16 = l2 + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantBlue.blockID).generate(this.worldObj, this.genRandom, i9, l13, j16);
        }
        if (this.genRandom.nextInt(4) == 0) {
            int j9 = k2 + this.genRandom.nextInt(16) + 8;
            int i14 = this.genRandom.nextInt(128);
            int k16 = l2 + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.genRandom, j9, i14, k16);
        }
        if (this.genRandom.nextInt(8) == 0) {
            int k9 = k2 + this.genRandom.nextInt(16) + 8;
            int j14 = this.genRandom.nextInt(128);
            int l16 = l2 + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.genRandom, k9, j14, l16);
        }
        int l9 = 0;
        while (l9 < 10) {
            int k14 = k2 + this.genRandom.nextInt(16) + 8;
            int i17 = this.genRandom.nextInt(128);
            int k18 = l2 + this.genRandom.nextInt(16) + 8;
            new WorldGenReed().generate(this.worldObj, this.genRandom, k14, i17, k18);
            ++l9;
        }
        int i10 = 0;
        while (i10 < 10) {
            int l14 = k2 + this.genRandom.nextInt(16) + 8;
            int j17 = this.genRandom.nextInt(128);
            int l18 = l2 + this.genRandom.nextInt(16) + 8;
            new WorldGenCactus().generate(this.worldObj, this.genRandom, l14, j17, l18);
            ++i10;
        }
        int j10 = 0;
        while (j10 < 50) {
            int i15 = k2 + this.genRandom.nextInt(16) + 8;
            int k17 = this.genRandom.nextInt(this.genRandom.nextInt(120) + 8);
            int i19 = l2 + this.genRandom.nextInt(16) + 8;
            new WorldGenLiquids(Block.waterMoving.blockID).generate(this.worldObj, this.genRandom, i15, k17, i19);
            ++j10;
        }
        int k10 = 0;
        while (k10 < 20) {
            int j15 = k2 + this.genRandom.nextInt(16) + 8;
            int l17 = this.genRandom.nextInt(this.genRandom.nextInt(this.genRandom.nextInt(112) + 8) + 8);
            int j19 = l2 + this.genRandom.nextInt(16) + 8;
            new WorldGenLiquids(Block.lavaMoving.blockID).generate(this.worldObj, this.genRandom, j15, l17, j19);
            ++k10;
        }
        int l10 = k2 + 8 + 0;
        while (l10 < k2 + 8 + 16) {
            int k15 = l2 + 8 + 0;
            while (k15 < l2 + 8 + 16) {
                int i18 = this.worldObj.getTopSolidOrLiquidBlock(l10, k15);
                if (this.worldObj.snowCovered && i18 > 0 && i18 < 128 && this.worldObj.getBlockId(l10, i18, k15) == 0 && this.worldObj.getMaterialXYZ(l10, i18 - 1, k15).blocksMovement() && this.worldObj.getMaterialXYZ(l10, i18 - 1, k15) != Material.ice) {
                    this.worldObj.setBlockWithNotify(l10, i18, k15, Block.snow.blockID);
                }
                ++k15;
            }
            ++l10;
        }
        BlockSand.fallInstantly = false;
    }
}

