/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.generate.noise;

import com.mojang.minecraft.level.generate.noise.NoiseGenerator;
import java.util.Random;

public class InfdevNoiseGeneratorPerlin
extends NoiseGenerator {
    private int[] permutations = new int[512];
    private double xCoord;
    private double yCoord;
    private double zCoord;

    public InfdevNoiseGeneratorPerlin() {
        this(new Random());
    }

    public InfdevNoiseGeneratorPerlin(Random random) {
        this.xCoord = random.nextDouble() * 256.0;
        this.yCoord = random.nextDouble() * 256.0;
        this.zCoord = random.nextDouble() * 256.0;
        int i2 = 0;
        while (i2 < 256) {
            this.permutations[i2] = i2;
            ++i2;
        }
        int j2 = 0;
        while (j2 < 256) {
            int k2 = random.nextInt(256 - j2) + j2;
            int l2 = this.permutations[j2];
            this.permutations[j2] = this.permutations[k2];
            this.permutations[k2] = l2;
            this.permutations[j2 + 256] = this.permutations[j2];
            ++j2;
        }
    }

    private double generateNoise(double d1, double d2, double d3) {
        double d4 = d1 + this.xCoord;
        double d5 = d2 + this.yCoord;
        double d6 = d3 + this.zCoord;
        d1 = (int)d4;
        int i2 = (int)d5;
        d2 = (int)d6;
        if (d4 < d1) {
            d1 -= 1.0;
        }
        if (d5 < (double)i2) {
            --i2;
        }
        if (d6 < d2) {
            d2 -= 1.0;
        }
        int j2 = (int)d1 & 0xFF;
        d3 = i2 & 0xFF;
        int k2 = (int)d2 & 0xFF;
        double d7 = (d4 -= d1) * d4 * d4 * (d4 * (d4 * 6.0 - 15.0) + 10.0);
        double d8 = (d5 -= (double)i2) * d5 * d5 * (d5 * (d5 * 6.0 - 15.0) + 10.0);
        double d9 = (d6 -= d2) * d6 * d6 * (d6 * (d6 * 6.0 - 15.0) + 10.0);
        d1 = (double)this.permutations[j2] + d3;
        i2 = this.permutations[(int)d1] + k2;
        d1 = this.permutations[(int)d1 + 1] + k2;
        d2 = (double)this.permutations[j2 + 1] + d3;
        j2 = this.permutations[(int)d2] + k2;
        d2 = this.permutations[(int)d2 + 1] + k2;
        return this.lerp(d9, this.lerp(d8, this.lerp(d7, this.grad(this.permutations[i2], d4, d5, d6), this.grad(this.permutations[j2], d4 - 1.0, d5, d6)), this.lerp(d7, this.grad(this.permutations[(int)d1], d4, d5 - 1.0, d6), this.grad(this.permutations[(int)d2], d4 - 1.0, d5 - 1.0, d6))), this.lerp(d8, this.lerp(d7, this.grad(this.permutations[i2 + 1], d4, d5, d6 - 1.0), this.grad(this.permutations[j2 + 1], d4 - 1.0, d5, d6 - 1.0)), this.lerp(d7, this.grad(this.permutations[(int)d1 + 1], d4, d5 - 1.0, d6 - 1.0), this.grad(this.permutations[(int)d2 + 1], d4 - 1.0, d5 - 1.0, d6 - 1.0))));
    }

    private double lerp(double d1, double d2, double d3) {
        return d2 + d1 * (d3 - d2);
    }

    private double grad(int i2, double d1, double d2, double d3) {
        double d4;
        double d5 = d4 = (i2 &= 0xF) >= 8 ? d2 : d1;
        double d52 = i2 >= 4 ? (i2 != 12 && i2 != 14 ? d3 : d1) : d2;
        return ((i2 & 1) != 0 ? -d4 : d4) + ((i2 & 2) != 0 ? -d52 : d52);
    }

    public double func_801_a(double d1, double d2) {
        return this.generateNoise(d1, d2, 0.0);
    }

    public double a(double d1, double d2, double d3) {
        return this.generateNoise(d1, d2, d3);
    }

    public void func_805_a(double[] ad2, int i2, int j2, int k2, int l2, int i1, int j1, double d1, double d2, double d3, double d4) {
        int l1 = 0;
        double d5 = 1.0 / d4;
        d4 = -1.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int l22 = 0;
        while (l22 < l2) {
            double d10 = (double)(i2 + l22) * d1 + this.xCoord;
            int k1 = (int)d10;
            if (d10 < (double)k1) {
                --k1;
            }
            int i3 = k1 & 0xFF;
            double d11 = (d10 -= (double)k1) * d10 * d10 * (d10 * (d10 * 6.0 - 15.0) + 10.0);
            int j3 = 0;
            while (j3 < j1) {
                double d12 = (double)(k2 + j3) * d3 + this.zCoord;
                k1 = (int)d12;
                if (d12 < (double)k1) {
                    --k1;
                }
                int k3 = k1 & 0xFF;
                double d13 = (d12 -= (double)k1) * d12 * d12 * (d12 * (d12 * 6.0 - 15.0) + 10.0);
                int l3 = 0;
                while (l3 < i1) {
                    double d14 = (double)(j2 + l3) * d2 + this.yCoord;
                    k1 = (int)d14;
                    if (d14 < (double)k1) {
                        --k1;
                    }
                    int j22 = k1 & 0xFF;
                    double d15 = (d14 -= (double)k1) * d14 * d14 * (d14 * (d14 * 6.0 - 15.0) + 10.0);
                    if (l3 == 0 || (double)j22 != d4) {
                        d4 = j22;
                        k1 = this.permutations[i3] + j22;
                        int i22 = this.permutations[k1] + k3;
                        k1 = this.permutations[k1 + 1] + k3;
                        j22 = this.permutations[i3 + 1] + j22;
                        int k22 = this.permutations[j22] + k3;
                        j22 = this.permutations[j22 + 1] + k3;
                        d6 = this.lerp(d11, this.grad(this.permutations[i22], d10, d14, d12), this.grad(this.permutations[k22], d10 - 1.0, d14, d12));
                        d7 = this.lerp(d11, this.grad(this.permutations[k1], d10, d14 - 1.0, d12), this.grad(this.permutations[j22], d10 - 1.0, d14 - 1.0, d12));
                        d8 = this.lerp(d11, this.grad(this.permutations[i22 + 1], d10, d14, d12 - 1.0), this.grad(this.permutations[k22 + 1], d10 - 1.0, d14, d12 - 1.0));
                        d9 = this.lerp(d11, this.grad(this.permutations[k1 + 1], d10, d14 - 1.0, d12 - 1.0), this.grad(this.permutations[j22 + 1], d10 - 1.0, d14 - 1.0, d12 - 1.0));
                    }
                    double d16 = this.lerp(d15, d6, d7);
                    double d17 = this.lerp(d15, d8, d9);
                    double d18 = this.lerp(d13, d16, d17);
                    int n2 = l1++;
                    ad2[n2] = ad2[n2] + d18 * d5;
                    ++l3;
                }
                ++j3;
            }
            ++l22;
        }
    }
}

