/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityChest;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockContainer;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.player.inventory.InventoryLargeChest;
import java.util.Random;

public class BlockChest
extends BlockContainer {
    private Random field_457_a = new Random();

    protected BlockChest(int i2) {
        super(i2, Material.wood);
        this.blockIndexInTexture = 26;
    }

    public int getTextureIndex(IBlockAccess iblockaccess, int x2, int y2, int z2, int meta) {
        int leftHalf = 57;
        int rightHalf = 58;
        int middle = 30;
        if (meta == 1) {
            return this.blockIndexInTexture - 1;
        }
        if (meta == 0) {
            return this.blockIndexInTexture - 1;
        }
        int blockEast = iblockaccess.getBlockId(x2, y2, z2 - 1);
        int blockWest = iblockaccess.getBlockId(x2, y2, z2 + 1);
        int blockNorth = iblockaccess.getBlockId(x2 - 1, y2, z2);
        int blockSouth = iblockaccess.getBlockId(x2 + 1, y2, z2);
        int blockEaster = iblockaccess.getBlockId(x2, y2, z2 - 2);
        int blockWester = iblockaccess.getBlockId(x2, y2, z2 + 2);
        int blockNorther = iblockaccess.getBlockId(x2 - 2, y2, z2);
        int blockSouther = iblockaccess.getBlockId(x2 + 2, y2, z2);
        if (blockWest == this.blockID && blockWester == this.blockID) {
            if (meta == 2) {
                return this.blockIndexInTexture;
            }
            if (meta == 3) {
                return this.blockIndexInTexture;
            }
            if (meta == 4) {
                return leftHalf;
            }
            if (meta == 5) {
                return rightHalf;
            }
        }
        if (blockNorth == this.blockID && blockNorther == this.blockID) {
            if (meta == 2) {
                return leftHalf;
            }
            if (meta == 3) {
                return rightHalf;
            }
            if (meta == 4) {
                return this.blockIndexInTexture;
            }
            if (meta == 5) {
                return this.blockIndexInTexture;
            }
        }
        if (blockEast == this.blockID && blockEaster == this.blockID) {
            if (meta == 2) {
                return this.blockIndexInTexture;
            }
            if (meta == 3) {
                return this.blockIndexInTexture;
            }
            if (meta == 4) {
                return rightHalf;
            }
            if (meta == 5) {
                return leftHalf;
            }
        }
        if (blockSouth == this.blockID && blockSouther == this.blockID) {
            if (meta == 2) {
                return rightHalf;
            }
            if (meta == 3) {
                return leftHalf;
            }
            if (meta == 4) {
                return this.blockIndexInTexture;
            }
            if (meta == 5) {
                return this.blockIndexInTexture;
            }
        }
        if (blockEast == this.blockID && blockWest == this.blockID) {
            int byte0 = 3;
            if (Block.opaqueCubeLookup[blockEast] && !Block.opaqueCubeLookup[blockWest]) {
                byte0 = 3;
            }
            if (Block.opaqueCubeLookup[blockWest] && !Block.opaqueCubeLookup[blockEast]) {
                byte0 = 2;
            }
            if (Block.opaqueCubeLookup[blockNorth] && !Block.opaqueCubeLookup[blockSouth]) {
                byte0 = 5;
            }
            if (Block.opaqueCubeLookup[blockSouth] && !Block.opaqueCubeLookup[blockNorth]) {
                byte0 = 4;
            }
            return meta != byte0 ? this.blockIndexInTexture : middle;
        }
        if (blockNorth == this.blockID && blockSouth == this.blockID) {
            int byte0 = 3;
            if (Block.opaqueCubeLookup[blockEast] && !Block.opaqueCubeLookup[blockWest]) {
                byte0 = 3;
            }
            if (Block.opaqueCubeLookup[blockWest] && !Block.opaqueCubeLookup[blockEast]) {
                byte0 = 2;
            }
            if (Block.opaqueCubeLookup[blockNorth] && !Block.opaqueCubeLookup[blockSouth]) {
                byte0 = 5;
            }
            if (Block.opaqueCubeLookup[blockSouth] && !Block.opaqueCubeLookup[blockNorth]) {
                byte0 = 4;
            }
            return meta != byte0 ? this.blockIndexInTexture : middle;
        }
        if (blockEast == this.blockID || blockWest == this.blockID) {
            if (meta == 2 || meta == 3) {
                return this.blockIndexInTexture;
            }
            int i2 = 0;
            if (blockEast == this.blockID) {
                i2 = -1;
            }
            int k2 = iblockaccess.getBlockId(x2 - 1, y2, blockEast != this.blockID ? z2 + 1 : z2 - 1);
            int i3 = iblockaccess.getBlockId(x2 + 1, y2, blockEast != this.blockID ? z2 + 1 : z2 - 1);
            if (meta == 4) {
                i2 = -1 - i2;
            }
            int byte1 = 5;
            if ((Block.opaqueCubeLookup[blockNorth] || Block.opaqueCubeLookup[k2]) && !Block.opaqueCubeLookup[blockSouth] && !Block.opaqueCubeLookup[i3]) {
                byte1 = 5;
            }
            if ((Block.opaqueCubeLookup[blockSouth] || Block.opaqueCubeLookup[i3]) && !Block.opaqueCubeLookup[blockNorth] && !Block.opaqueCubeLookup[k2]) {
                byte1 = 4;
            }
            return (meta != byte1 ? this.blockIndexInTexture + 32 : this.blockIndexInTexture + 16) + i2;
        }
        if (blockNorth == this.blockID || blockSouth == this.blockID) {
            if (meta == 4 || meta == 5) {
                return this.blockIndexInTexture;
            }
            int j2 = 0;
            if (blockNorth == this.blockID) {
                j2 = -1;
            }
            int l2 = iblockaccess.getBlockId(blockNorth != this.blockID ? x2 + 1 : x2 - 1, y2, z2 - 1);
            int j3 = iblockaccess.getBlockId(blockNorth != this.blockID ? x2 + 1 : x2 - 1, y2, z2 + 1);
            if (meta == 3) {
                j2 = -1 - j2;
            }
            int byte2 = 3;
            if ((Block.opaqueCubeLookup[blockEast] || Block.opaqueCubeLookup[l2]) && !Block.opaqueCubeLookup[blockWest] && !Block.opaqueCubeLookup[j3]) {
                byte2 = 3;
            }
            if ((Block.opaqueCubeLookup[blockWest] || Block.opaqueCubeLookup[j3]) && !Block.opaqueCubeLookup[blockEast] && !Block.opaqueCubeLookup[l2]) {
                byte2 = 2;
            }
            return (meta != byte2 ? this.blockIndexInTexture + 32 : this.blockIndexInTexture + 16) + j2;
        }
        int byte0 = 3;
        if (Block.opaqueCubeLookup[blockEast] && !Block.opaqueCubeLookup[blockWest]) {
            byte0 = 3;
        }
        if (Block.opaqueCubeLookup[blockWest] && !Block.opaqueCubeLookup[blockEast]) {
            byte0 = 2;
        }
        if (Block.opaqueCubeLookup[blockNorth] && !Block.opaqueCubeLookup[blockSouth]) {
            byte0 = 5;
        }
        if (Block.opaqueCubeLookup[blockSouth] && !Block.opaqueCubeLookup[blockNorth]) {
            byte0 = 4;
        }
        return meta != byte0 ? this.blockIndexInTexture : this.blockIndexInTexture + 1;
    }

    public int getTextureIndex(int i2) {
        if (i2 == 1) {
            return this.blockIndexInTexture - 1;
        }
        if (i2 == 0) {
            return this.blockIndexInTexture - 1;
        }
        if (i2 == 3) {
            return this.blockIndexInTexture + 1;
        }
        return this.blockIndexInTexture;
    }

    public boolean canPlace(World world, int i2, int j2, int k2) {
        int l2 = 0;
        if (world.getBlockId(i2 - 1, j2, k2) == this.blockID) {
            ++l2;
        }
        if (world.getBlockId(i2 + 1, j2, k2) == this.blockID) {
            ++l2;
        }
        if (world.getBlockId(i2, j2, k2 - 1) == this.blockID) {
            ++l2;
        }
        if (world.getBlockId(i2, j2, k2 + 1) == this.blockID) {
            ++l2;
        }
        if (l2 > 1) {
            return false;
        }
        if (this.isThereANeighborChest(world, i2 - 1, j2, k2)) {
            return false;
        }
        if (this.isThereANeighborChest(world, i2 + 1, j2, k2)) {
            return false;
        }
        if (this.isThereANeighborChest(world, i2, j2, k2 - 1)) {
            return false;
        }
        return !this.isThereANeighborChest(world, i2, j2, k2 + 1);
    }

    private boolean isThereANeighborChest(World world, int i2, int j2, int k2) {
        if (world.getBlockId(i2, j2, k2) != this.blockID) {
            return false;
        }
        if (world.getBlockId(i2 - 1, j2, k2) == this.blockID) {
            return true;
        }
        if (world.getBlockId(i2 + 1, j2, k2) == this.blockID) {
            return true;
        }
        if (world.getBlockId(i2, j2, k2 - 1) == this.blockID) {
            return true;
        }
        return world.getBlockId(i2, j2, k2 + 1) == this.blockID;
    }

    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        TileEntityChest tileentitychest = (TileEntityChest)world.getBlockTileEntity(i2, j2, k2);
        int l2 = 0;
        while (l2 < tileentitychest.getSizeInventory()) {
            ItemStack itemstack = tileentitychest.getStackInSlot(l2);
            if (itemstack != null) {
                float f2 = this.field_457_a.nextFloat() * 0.8f + 0.1f;
                float f1 = this.field_457_a.nextFloat() * 0.8f + 0.1f;
                float f22 = this.field_457_a.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.field_457_a.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i2 + f2, (float)j2 + f1, (float)k2 + f22, new ItemStack(itemstack.itemID, i1, itemstack.itemDamage));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.field_457_a.nextGaussian() * f3;
                    entityitem.motionY = (float)this.field_457_a.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.field_457_a.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
            ++l2;
        }
        super.onBlockRemoval(world, i2, j2, k2);
    }

    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        IInventory obj = (TileEntityChest)world.getBlockTileEntity(i2, j2, k2);
        if (world.isBlockNormalCube(i2, j2 + 1, k2)) {
            return true;
        }
        if (world.getBlockId(i2 - 1, j2, k2) == this.blockID && world.isBlockNormalCube(i2 - 1, j2 + 1, k2)) {
            return true;
        }
        if (world.getBlockId(i2 + 1, j2, k2) == this.blockID && world.isBlockNormalCube(i2 + 1, j2 + 1, k2)) {
            return true;
        }
        if (world.getBlockId(i2, j2, k2 - 1) == this.blockID && world.isBlockNormalCube(i2, j2 + 1, k2 - 1)) {
            return true;
        }
        if (world.getBlockId(i2, j2, k2 + 1) == this.blockID && world.isBlockNormalCube(i2, j2 + 1, k2 + 1)) {
            return true;
        }
        if (world.getBlockId(i2 - 1, j2, k2) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", (TileEntityChest)world.getBlockTileEntity(i2 - 1, j2, k2), obj);
        }
        if (world.getBlockId(i2 + 1, j2, k2) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", obj, (TileEntityChest)world.getBlockTileEntity(i2 + 1, j2, k2));
        }
        if (world.getBlockId(i2, j2, k2 - 1) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", (TileEntityChest)world.getBlockTileEntity(i2, j2, k2 - 1), obj);
        }
        if (world.getBlockId(i2, j2, k2 + 1) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", obj, (TileEntityChest)world.getBlockTileEntity(i2, j2, k2 + 1));
        }
        if (world.multiplayerWorld) {
            return true;
        }
        entityplayer.displayGUIChest(obj);
        return true;
    }

    protected TileEntity getBlockEntity() {
        return new TileEntityChest();
    }
}

