/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockBreakable;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockIce
extends BlockBreakable {
    public BlockIce(int i2, int j2) {
        super(i2, j2, Material.ice, false);
        this.slipperiness = 0.98f;
        this.setTickOnLoad(true);
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return super.shouldSideBeRendered(iblockaccess, i2, j2, k2, 1 - l2);
    }

    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        Material material = world.getMaterialXYZ(i2, j2 - 1, k2);
        if (material.blocksMovement() || material.getIsGroundCover()) {
            world.setBlockWithNotify(i2, j2, k2, Block.waterMoving.blockID);
        }
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        if (world.getBlockLighting(EnumSkyBlock.Block, i2, j2, k2) > 11 - Block.lightOpacity[this.blockID]) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, Block.waterStill.blockID);
        }
    }
}

