/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockRedstoneWire
extends Block {
    private boolean wiresProvidePower = true;

    public BlockRedstoneWire(int i2, int j2) {
        super(i2, j2, Material.circuits);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        return this.blockIndexInTexture + (j2 <= 0 ? 0 : 16);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return 5;
    }

    public boolean canPlace(World world, int i2, int j2, int k2) {
        return world.isBlockNormalCube(i2, j2 - 1, k2);
    }

    private void func_280_h(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        int i1 = 0;
        this.wiresProvidePower = false;
        boolean flag = world.isBlockIndirectlyGettingPowered(i2, j2, k2);
        this.wiresProvidePower = true;
        if (flag) {
            i1 = 15;
        } else {
            int j1 = 0;
            while (j1 < 4) {
                int l1 = i2;
                int j22 = k2;
                if (j1 == 0) {
                    --l1;
                }
                if (j1 == 1) {
                    ++l1;
                }
                if (j1 == 2) {
                    --j22;
                }
                if (j1 == 3) {
                    ++j22;
                }
                i1 = this.getMaxCurrentStrength(world, l1, j2, j22, i1);
                if (world.isBlockNormalCube(l1, j2, j22) && !world.isBlockNormalCube(i2, j2 + 1, k2)) {
                    i1 = this.getMaxCurrentStrength(world, l1, j2 + 1, j22, i1);
                } else if (!world.isBlockNormalCube(l1, j2, j22)) {
                    i1 = this.getMaxCurrentStrength(world, l1, j2 - 1, j22, i1);
                }
                ++j1;
            }
            i1 = i1 > 0 ? --i1 : 0;
        }
        if (l2 != i1) {
            world.setBlockMetadataWithNotify(i2, j2, k2, i1);
            world.markBlocksDirty(i2, j2, k2, i2, j2, k2);
            if (i1 > 0) {
                --i1;
            }
            int k1 = 0;
            while (k1 < 4) {
                int i3;
                int i22 = i2;
                int k22 = k2;
                int l22 = j2 - 1;
                if (k1 == 0) {
                    --i22;
                }
                if (k1 == 1) {
                    ++i22;
                }
                if (k1 == 2) {
                    --k22;
                }
                if (k1 == 3) {
                    ++k22;
                }
                if (world.isBlockNormalCube(i22, j2, k22)) {
                    l22 += 2;
                }
                if ((i3 = this.getMaxCurrentStrength(world, i22, j2, k22, -1)) >= 0 && i3 != i1) {
                    this.func_280_h(world, i22, j2, k22);
                }
                if ((i3 = this.getMaxCurrentStrength(world, i22, l22, k22, -1)) >= 0 && i3 != i1) {
                    this.func_280_h(world, i22, l22, k22);
                }
                ++k1;
            }
            if (l2 == 0 || i1 == 0) {
                world.notifyBlocksOfNeighborChange(i2, j2, k2, this.blockID);
                world.notifyBlocksOfNeighborChange(i2 - 1, j2, k2, this.blockID);
                world.notifyBlocksOfNeighborChange(i2 + 1, j2, k2, this.blockID);
                world.notifyBlocksOfNeighborChange(i2, j2, k2 - 1, this.blockID);
                world.notifyBlocksOfNeighborChange(i2, j2, k2 + 1, this.blockID);
                world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
                world.notifyBlocksOfNeighborChange(i2, j2 + 1, k2, this.blockID);
            }
        }
    }

    private void notifyWireNeighborsOfNeighborChange(World world, int i2, int j2, int k2) {
        if (world.getBlockId(i2, j2, k2) != this.blockID) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i2, j2, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2 - 1, j2, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2 + 1, j2, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2, k2 - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2, k2 + 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2 + 1, k2, this.blockID);
    }

    public void onBlockAdded(World world, int i2, int j2, int k2) {
        super.onBlockAdded(world, i2, j2, k2);
        if (world.multiplayerWorld) {
            return;
        }
        this.func_280_h(world, i2, j2, k2);
        world.notifyBlocksOfNeighborChange(i2, j2 + 1, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
        this.notifyWireNeighborsOfNeighborChange(world, i2 - 1, j2, k2);
        this.notifyWireNeighborsOfNeighborChange(world, i2 + 1, j2, k2);
        this.notifyWireNeighborsOfNeighborChange(world, i2, j2, k2 - 1);
        this.notifyWireNeighborsOfNeighborChange(world, i2, j2, k2 + 1);
        if (world.isBlockNormalCube(i2 - 1, j2, k2)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2 - 1, j2 + 1, k2);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2 - 1, j2 - 1, k2);
        }
        if (world.isBlockNormalCube(i2 + 1, j2, k2)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2 + 1, j2 + 1, k2);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2 + 1, j2 - 1, k2);
        }
        if (world.isBlockNormalCube(i2, j2, k2 - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 + 1, k2 - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 - 1, k2 - 1);
        }
        if (world.isBlockNormalCube(i2, j2, k2 + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 + 1, k2 + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 - 1, k2 + 1);
        }
    }

    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        super.onBlockRemoval(world, i2, j2, k2);
        if (world.multiplayerWorld) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i2, j2 + 1, k2, this.blockID);
        world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
        this.func_280_h(world, i2, j2, k2);
        this.notifyWireNeighborsOfNeighborChange(world, i2 - 1, j2, k2);
        this.notifyWireNeighborsOfNeighborChange(world, i2 + 1, j2, k2);
        this.notifyWireNeighborsOfNeighborChange(world, i2, j2, k2 - 1);
        this.notifyWireNeighborsOfNeighborChange(world, i2, j2, k2 + 1);
        if (world.isBlockNormalCube(i2 - 1, j2, k2)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2 - 1, j2 + 1, k2);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2 - 1, j2 - 1, k2);
        }
        if (world.isBlockNormalCube(i2 + 1, j2, k2)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2 + 1, j2 + 1, k2);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2 + 1, j2 - 1, k2);
        }
        if (world.isBlockNormalCube(i2, j2, k2 - 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 + 1, k2 - 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 - 1, k2 - 1);
        }
        if (world.isBlockNormalCube(i2, j2, k2 + 1)) {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 + 1, k2 + 1);
        } else {
            this.notifyWireNeighborsOfNeighborChange(world, i2, j2 - 1, k2 + 1);
        }
    }

    private int getMaxCurrentStrength(World world, int i2, int j2, int k2, int l2) {
        if (world.getBlockId(i2, j2, k2) != this.blockID) {
            return l2;
        }
        int i1 = world.getBlockMetadata(i2, j2, k2);
        if (i1 > l2) {
            return i1;
        }
        return l2;
    }

    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (world.multiplayerWorld) {
            return;
        }
        int i1 = world.getBlockMetadata(i2, j2, k2);
        boolean flag = this.canPlace(world, i2, j2, k2);
        if (!flag) {
            this.dropBlockAsItem(world, i2, j2, k2, i1);
            world.setBlockWithNotify(i2, j2, k2, 0);
        } else {
            this.func_280_h(world, i2, j2, k2);
        }
        super.onNeighborBlockChange(world, i2, j2, k2, l2);
    }

    public int idDropped(int i2, Random random) {
        return Item.redstone.shiftedIndex;
    }

    public boolean isIndirectlyPoweringTo(World world, int i2, int j2, int k2, int l2) {
        if (!this.wiresProvidePower) {
            return false;
        }
        return this.isPoweringTo(world, i2, j2, k2, l2);
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        boolean flag3;
        if (!this.wiresProvidePower) {
            return false;
        }
        if (iblockaccess.getBlockMetadata(i2, j2, k2) == 0) {
            return false;
        }
        if (l2 == 1) {
            return true;
        }
        boolean flag = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2 - 1, j2, k2) || !iblockaccess.isBlockNormalCube(i2 - 1, j2, k2) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2 - 1, j2 - 1, k2);
        boolean flag1 = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2 + 1, j2, k2) || !iblockaccess.isBlockNormalCube(i2 + 1, j2, k2) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2 + 1, j2 - 1, k2);
        boolean flag2 = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2, j2, k2 - 1) || !iblockaccess.isBlockNormalCube(i2, j2, k2 - 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2, j2 - 1, k2 - 1);
        boolean bl2 = flag3 = BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2, j2, k2 + 1) || !iblockaccess.isBlockNormalCube(i2, j2, k2 + 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2, j2 - 1, k2 + 1);
        if (!iblockaccess.isBlockNormalCube(i2, j2 + 1, k2)) {
            if (iblockaccess.isBlockNormalCube(i2 - 1, j2, k2) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2 - 1, j2 + 1, k2)) {
                flag = true;
            }
            if (iblockaccess.isBlockNormalCube(i2 + 1, j2, k2) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2 + 1, j2 + 1, k2)) {
                flag1 = true;
            }
            if (iblockaccess.isBlockNormalCube(i2, j2, k2 - 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2, j2 + 1, k2 - 1)) {
                flag2 = true;
            }
            if (iblockaccess.isBlockNormalCube(i2, j2, k2 + 1) && BlockRedstoneWire.isPowerProviderOrWire(iblockaccess, i2, j2 + 1, k2 + 1)) {
                flag3 = true;
            }
        }
        if (!(flag2 || flag1 || flag || flag3 || l2 < 2 || l2 > 5)) {
            return true;
        }
        if (l2 == 2 && flag2 && !flag && !flag1) {
            return true;
        }
        if (l2 == 3 && flag3 && !flag && !flag1) {
            return true;
        }
        if (l2 == 4 && flag && !flag2 && !flag3) {
            return true;
        }
        return l2 == 5 && flag1 && !flag2 && !flag3;
    }

    public boolean canProvidePower() {
        return this.wiresProvidePower;
    }

    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        if (world.getBlockMetadata(i2, j2, k2) > 0) {
            double d2 = (double)i2 + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            double d1 = (float)j2 + 0.0625f;
            double d22 = (double)k2 + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            world.spawnParticle("reddust", d2, d1, d22, 0.0, 0.0, 0.0);
        }
    }

    public static boolean isPowerProviderOrWire(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        int l2 = iblockaccess.getBlockId(i2, j2, k2);
        if (l2 == Block.redstoneWire.blockID) {
            return true;
        }
        if (l2 == 0) {
            return false;
        }
        return Block.allBlocks[l2].canProvidePower();
    }
}

