/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockSnow
extends Block {
    protected BlockSnow(int i2, int j2) {
        super(i2, j2, Material.snow);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.setTickOnLoad(true);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public boolean canPlace(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockId(i2, j2 - 1, k2);
        if (l2 == 0 || !Block.allBlocks[l2].isOpaqueCube()) {
            return false;
        }
        return world.getMaterialXYZ(i2, j2 - 1, k2).blocksMovement();
    }

    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        this.func_314_h(world, i2, j2, k2);
    }

    private boolean func_314_h(World world, int i2, int j2, int k2) {
        if (!this.canPlace(world, i2, j2, k2)) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, 0);
            return false;
        }
        return true;
    }

    public void harvestBlock(World world, int i2, int j2, int k2, int l2) {
        if (world.multiplayerWorld) {
            return;
        }
        int i1 = Item.snowball.shiftedIndex;
        float f2 = 0.7f;
        double d2 = (double)(world.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
        double d1 = (double)(world.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
        double d22 = (double)(world.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i2 + d2, (double)j2 + d1, (double)k2 + d22, new ItemStack(i1));
        entityitem.delayBeforeCanPickup = 10;
        world.entityJoinedWorld(entityitem);
        world.setBlockWithNotify(i2, j2, k2, 0);
    }

    public int idDropped(int i2, Random random) {
        return Item.snowball.shiftedIndex;
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        if (world.getBlockLighting(EnumSkyBlock.Block, i2, j2, k2) > 11) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, 0);
        }
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        Material material = iblockaccess.getMaterialXYZ(i2, j2, k2);
        if (l2 == 1) {
            return true;
        }
        if (material == this.blockMaterial) {
            return false;
        }
        return super.shouldSideBeRendered(iblockaccess, i2, j2, k2, l2);
    }
}

