/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityTNTPrimed;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockTNT
extends Block {
    public BlockTNT(int i2, int j2) {
        super(i2, j2, Material.tnt);
    }

    public int getTextureIndex(int i2) {
        if (i2 == 0) {
            return this.blockIndexInTexture + 2;
        }
        if (i2 == 1) {
            return this.blockIndexInTexture + 1;
        }
        return this.blockIndexInTexture;
    }

    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (l2 > 0 && Block.allBlocks[l2].canProvidePower() && world.isBlockIndirectlyGettingPowered(i2, j2, k2)) {
            this.dropBlockAsItemWithChance(world, i2, j2, k2, 0);
            world.setBlockWithNotify(i2, j2, k2, 0);
        }
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    public void onBlockDestroyedByExplosion(World world, int i2, int j2, int k2) {
        EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f);
        entitytntprimed.field_689_a = world.rand.nextInt(entitytntprimed.field_689_a / 4) + entitytntprimed.field_689_a / 8;
        world.entityJoinedWorld(entitytntprimed);
    }

    public void dropBlockAsItemWithChance(World world, int i2, int j2, int k2, int l2) {
        if (world.multiplayerWorld) {
            return;
        }
        EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f);
        world.entityJoinedWorld(entitytntprimed);
        world.playSoundAtEntity(entitytntprimed, "random.fuse", 1.0f, 1.0f);
    }
}

