/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayerSP;
import com.mojang.minecraft.entity.EntityRainFX;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemRenderer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkProviderLoadOrGenerate;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.level.tile.phys.ClippingHelperImplementation;
import com.mojang.minecraft.player.controller.PlayerControllerCreative;
import com.mojang.minecraft.render.EffectRenderer;
import com.mojang.minecraft.render.Frustrum;
import com.mojang.minecraft.render.GLAllocation;
import com.mojang.minecraft.render.RenderGlobal;
import com.mojang.minecraft.render.RenderHelper;
import com.mojang.minecraft.render.ScaledResolution;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Random;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class EntityRenderer {
    private Minecraft mc;
    private float farPlaneDistance = 0.0f;
    public ItemRenderer itemRenderer;
    private int field_1386_j;
    private Entity field_1385_k = null;
    private double field_21155_l = 1.0;
    private double field_21154_m = 0.0;
    private double field_21153_n = 0.0;
    private long field_1384_l = System.currentTimeMillis();
    private Random random = new Random();
    volatile int field_1394_b = 0;
    volatile int field_1393_c = 0;
    FloatBuffer field_1392_d = GLAllocation.func_1123_d(16);
    float fogColorRed;
    float fogColorGreen;
    float fogColorBlue;
    private float field_1382_n;
    private float hasSubtypes;

    public EntityRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        this.itemRenderer = new ItemRenderer(minecraft);
    }

    public void updateRenderer() {
        this.field_1382_n = this.hasSubtypes;
        float f2 = this.mc.mcWorld.getBrightness(MathHelper.floor_double(this.mc.thePlayer.posX), MathHelper.floor_double(this.mc.thePlayer.posY), MathHelper.floor_double(this.mc.thePlayer.posZ));
        float f1 = (float)(3 - this.mc.options.renderDistance) / 3.0f;
        float f22 = f2 * (1.0f - f1) + f1;
        this.hasSubtypes += (f22 - this.hasSubtypes) * 0.1f;
        ++this.field_1386_j;
        this.itemRenderer.updateEquippedItem();
        boolean cfr_ignored_0 = this.mc.enableRain;
    }

    public void getMouseOver(float f2) {
        if (this.mc.thePlayer != null) {
            double d2 = this.mc.playerController.getBlockReachDistance();
            this.mc.objectMouseOver = this.mc.thePlayer.rayTrace(d2, f2);
            double d1 = d2;
            Vec3D vec3d = this.mc.thePlayer.getPosition(f2);
            if (this.mc.objectMouseOver != null) {
                d1 = this.mc.objectMouseOver.hitVec.distanceTo(vec3d);
            }
            if (this.mc.playerController instanceof PlayerControllerCreative) {
                d2 = 32.0;
                d1 = 32.0;
            } else {
                if (d1 > 3.0) {
                    d1 = 3.0;
                }
                d2 = d1;
            }
            Vec3D vec3d1 = this.mc.thePlayer.getLook(f2);
            Vec3D vec3d2 = vec3d.addVector(vec3d1.xCoord * d2, vec3d1.yCoord * d2, vec3d1.zCoord * d2);
            this.field_1385_k = null;
            float f1 = 1.0f;
            List<Entity> list = this.mc.mcWorld.getEntitiesWithinAABBExcludingEntity(this.mc.thePlayer, this.mc.thePlayer.boundingBox.addCoord(vec3d1.xCoord * d2, vec3d1.yCoord * d2, vec3d1.zCoord * d2).expand(f1, f1, f1));
            double d22 = 0.0;
            int i2 = 0;
            while (i2 < list.size()) {
                Entity entity = list.get(i2);
                if (entity.canBeCollidedWith()) {
                    double d3;
                    float f22 = 0.1f;
                    AxisAlignedBB axisalignedbb = entity.boundingBox.expand(f22, f22, f22);
                    MovingObjectPosition movingobjectposition = axisalignedbb.func_1169_a(vec3d, vec3d2);
                    if (axisalignedbb.isVecInside(vec3d)) {
                        if (0.0 < d22 || d22 == 0.0) {
                            this.field_1385_k = entity;
                            d22 = 0.0;
                        }
                    } else if (movingobjectposition != null && ((d3 = vec3d.distanceTo(movingobjectposition.hitVec)) < d22 || d22 == 0.0)) {
                        this.field_1385_k = entity;
                        d22 = d3;
                    }
                }
                ++i2;
            }
            if (this.field_1385_k != null) {
                this.mc.objectMouseOver = new MovingObjectPosition(this.field_1385_k);
            }
        }
    }

    private float getFOV(float f2) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        float f1 = 70.0f;
        if (entityplayersp.isInsideOfMaterial(Material.water)) {
            f1 = 60.0f;
        }
        if (entityplayersp.isRunning() && this.mc.options.difficulty < 3) {
            f1 = 71.5f;
        }
        if (entityplayersp.health <= 0) {
            float f22 = (float)entityplayersp.deathTime + f2;
            f1 /= (1.0f - 500.0f / (f22 + 500.0f)) * 2.0f + 1.0f;
        }
        return f1 + (float)this.mc.options.FOV;
    }

    private void hurtCameraEffect(float f2) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        float f1 = (float)entityplayersp.hurtTime - f2;
        if (entityplayersp.health <= 0) {
            float f22 = (float)entityplayersp.deathTime + f2;
            GL11.glRotatef((float)(40.0f - 8000.0f / (f22 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (f1 >= 0.0f) {
            f1 /= (float)entityplayersp.maxHurtTime;
            f1 = MathHelper.sin(f1 * f1 * f1 * f1 * 3.141593f);
            float f3 = entityplayersp.attackedAtYaw;
            GL11.glRotatef((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-f1 * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)f3, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void setupViewBobbing(float f2) {
        if (!this.mc.options.thirdPersonView) {
            EntityPlayerSP entityplayersp = this.mc.thePlayer;
            float f1 = entityplayersp.distanceWalkedModified - entityplayersp.prevDistanceWalkedModified;
            float f22 = entityplayersp.distanceWalkedModified + f1 * f2;
            float f3 = entityplayersp.field_775_e + (entityplayersp.field_774_f - entityplayersp.field_775_e) * f2;
            float f4 = entityplayersp.lookPitch + (entityplayersp.field_709_M - entityplayersp.lookPitch) * f2;
            GL11.glTranslatef((float)(MathHelper.sin(f22 * 3.141593f) * f3 * 0.5f), (float)(-Math.abs(MathHelper.cos(f22 * 3.141593f) * f3)), (float)0.0f);
            GL11.glRotatef((float)(MathHelper.sin(f22 * 3.141593f) * f3 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(Math.abs(MathHelper.cos(f22 * 3.141593f + 0.2f) * f3) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)f4, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private void orientCamera(float f2) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        double d2 = entityplayersp.prevPosX + (entityplayersp.posX - entityplayersp.prevPosX) * (double)f2;
        double d1 = entityplayersp.prevPosY + (entityplayersp.posY - entityplayersp.prevPosY) * (double)f2;
        double d22 = entityplayersp.prevPosZ + (entityplayersp.posZ - entityplayersp.prevPosZ) * (double)f2;
        if (this.mc.options.thirdPersonView) {
            double d3 = 4.0;
            float f1 = entityplayersp.rotationYaw;
            float f22 = entityplayersp.rotationPitch;
            if (Keyboard.isKeyDown((int)59)) {
                f22 += 180.0f;
                d3 += 2.0;
            }
            double d4 = (double)(-MathHelper.sin(f1 / 180.0f * 3.141593f) * MathHelper.cos(f22 / 180.0f * 3.141593f)) * d3;
            double d5 = (double)(MathHelper.cos(f1 / 180.0f * 3.141593f) * MathHelper.cos(f22 / 180.0f * 3.141593f)) * d3;
            double d6 = (double)(-MathHelper.sin(f22 / 180.0f * 3.141593f)) * d3;
            int i2 = 0;
            while (i2 < 8) {
                double d7;
                MovingObjectPosition movingobjectposition;
                float f3 = (i2 & 1) * 2 - 1;
                float f4 = (i2 >> 1 & 1) * 2 - 1;
                float f5 = (i2 >> 2 & 1) * 2 - 1;
                if ((movingobjectposition = this.mc.mcWorld.rayTraceBlocks(Vec3D.createVector(d2 + (double)(f3 *= 0.1f), d1 + (double)(f4 *= 0.1f), d22 + (double)(f5 *= 0.1f)), Vec3D.createVector(d2 - d4 + (double)f3 + (double)f5, d1 - d6 + (double)f4, d22 - d5 + (double)f5))) != null && (d7 = movingobjectposition.hitVec.distanceTo(Vec3D.createVector(d2, d1, d22))) < d3) {
                    d3 = d7;
                }
                ++i2;
            }
            if (Keyboard.isKeyDown((int)59)) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glRotatef((float)(entityplayersp.rotationPitch - f22), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(entityplayersp.rotationYaw - f1), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)(-d3)));
            GL11.glRotatef((float)(f1 - entityplayersp.rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(f22 - entityplayersp.rotationPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.1f);
        }
        GL11.glRotatef((float)(entityplayersp.prevRotationPitch + (entityplayersp.rotationPitch - entityplayersp.prevRotationPitch) * f2), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(entityplayersp.prevRotationYaw + (entityplayersp.rotationYaw - entityplayersp.prevRotationYaw) * f2 + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void setupCameraTransform(float f2, int i2) {
        this.farPlaneDistance = this.mc.options.fog ? (this.mc.options.renderDistance > 0 ? (float)(256 >> this.mc.options.renderDistance) : (float)(256 << -this.mc.options.renderDistance)) : 512.0f;
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        float f1 = 0.07f;
        if (this.mc.options.anaglyph) {
            GL11.glTranslatef((float)((float)(-(i2 * 2 - 1)) * f1), (float)0.0f, (float)0.0f);
        }
        GLU.gluPerspective((float)this.getFOV(f2), (float)((float)this.mc.displayWidth / (float)this.mc.displayHeight), (float)0.05f, (float)this.farPlaneDistance);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        if (this.mc.options.anaglyph) {
            GL11.glTranslatef((float)((float)(i2 * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        this.hurtCameraEffect(f2);
        if (this.mc.options.viewBobbing) {
            this.setupViewBobbing(f2);
        }
        this.orientCamera(f2);
    }

    private void func_907_b(float f2, int i2) {
        GL11.glLoadIdentity();
        if (this.mc.options.anaglyph) {
            GL11.glTranslatef((float)((float)(i2 * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        GL11.glPushMatrix();
        this.hurtCameraEffect(f2);
        if (this.mc.options.viewBobbing) {
            this.setupViewBobbing(f2);
        }
        if (!this.mc.options.thirdPersonView) {
            this.itemRenderer.func_894_a(f2);
        }
        GL11.glPopMatrix();
        if (!this.mc.options.thirdPersonView) {
            this.itemRenderer.func_893_b(f2);
            this.hurtCameraEffect(f2);
        }
        if (this.mc.options.viewBobbing) {
            this.setupViewBobbing(f2);
        }
    }

    public void updateCameraAndRender(float f2) {
        if (!Display.isActive()) {
            if (System.currentTimeMillis() - this.field_1384_l > 500L) {
                this.mc.displayInGameMenu();
            }
        } else {
            this.field_1384_l = System.currentTimeMillis();
        }
        if (this.mc.inGameHasFocus) {
            this.mc.mouseHelper.mouseXYChange();
            float f1 = this.mc.options.mouseSensitivity * 0.6f + 0.2f;
            float f22 = f1 * f1 * f1 * 8.0f;
            float f3 = (float)this.mc.mouseHelper.field_1114_a * f22;
            float f4 = (float)this.mc.mouseHelper.field_1113_b * f22;
            int l2 = 1;
            if (this.mc.options.invertMouse) {
                l2 = -1;
            }
            this.mc.thePlayer.func_346_d(f3, f4 * (float)l2);
        }
        if (!this.mc.skipRenderWorld) {
            ScaledResolution scaledresolution = new ScaledResolution(this.mc.displayWidth, this.mc.displayHeight, this.mc);
            int i2 = scaledresolution.getScaledWidth();
            int j2 = scaledresolution.getScaledHeight();
            int k2 = Mouse.getX() * i2 / this.mc.displayWidth;
            int i1 = j2 - Mouse.getY() * j2 / this.mc.displayHeight - 1;
            if (this.mc.mcWorld != null) {
                this.renderWorld(f2);
                if (!Keyboard.isKeyDown((int)59)) {
                    this.mc.ingameGUI.renderGameOverlay(f2, this.mc.currentScreen != null, k2, i1);
                }
            } else {
                GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5888);
                GL11.glLoadIdentity();
                this.func_905_b();
            }
            if (this.mc.currentScreen != null) {
                GL11.glClear((int)256);
                this.mc.currentScreen.drawScreen(k2, i1, f2);
            }
        }
    }

    public void renderWorld(float f2) {
        this.getMouseOver(f2);
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        RenderGlobal renderglobal = this.mc.renderGlobal;
        EffectRenderer effectrenderer = this.mc.effectRenderer;
        double d2 = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * (double)f2;
        double d1 = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * (double)f2;
        double d22 = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * (double)f2;
        IChunkProvider ichunkprovider = this.mc.mcWorld.getIChunkProvider();
        if (ichunkprovider instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            int l2 = MathHelper.floor_float((int)d2) >> 4;
            int i2 = MathHelper.floor_float((int)d22) >> 4;
            chunkproviderloadorgenerate.setCurrentChunkOver(l2, i2);
        }
        int k2 = 0;
        while (k2 < 2) {
            if (this.mc.options.anaglyph) {
                if (k2 == 0) {
                    GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)false);
                } else {
                    GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                }
            }
            GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
            this.updateFogColor(f2);
            GL11.glClear((int)16384);
            GL11.glClear((int)256);
            GL11.glEnable((int)2884);
            this.setupCameraTransform(f2, k2);
            ClippingHelperImplementation.func_1155_a();
            if (this.mc.options.fog) {
                if (this.mc.options.renderDistance < 4) {
                    this.renderFog(-1);
                    renderglobal.renderSky(f2);
                }
            } else {
                this.renderFog(4);
                renderglobal.renderSky(f2);
            }
            GL11.glEnable((int)2912);
            this.renderFog(1);
            Frustrum frustrum = new Frustrum();
            frustrum.func_343_a(d2, d1, d22);
            this.mc.renderGlobal.func_960_a(frustrum, f2);
            this.mc.renderGlobal.updateRenderers(entityplayersp, false);
            this.renderFog(0);
            GL11.glEnable((int)2912);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTex("/terrain.png"));
            RenderHelper.disableStandardItemLighting();
            renderglobal.func_943_a(entityplayersp, 0, f2);
            RenderHelper.enableStandardItemLighting();
            renderglobal.handleTileEntityRendering(entityplayersp.getPosition(f2), frustrum, f2);
            effectrenderer.func_1187_b(entityplayersp, f2);
            RenderHelper.disableStandardItemLighting();
            this.renderFog(0);
            effectrenderer.renderParticles(entityplayersp, f2);
            if (this.mc.objectMouseOver != null && entityplayersp.isInsideOfMaterial(Material.water)) {
                GL11.glDisable((int)3008);
                renderglobal.renderHeldItem(entityplayersp, this.mc.objectMouseOver, 0, entityplayersp.inventory.getCurrentItem(), f2);
                renderglobal.drawSelectionBox(entityplayersp, this.mc.objectMouseOver, 0, entityplayersp.inventory.getCurrentItem(), f2);
                GL11.glEnable((int)3008);
            }
            GL11.glBlendFunc((int)770, (int)771);
            this.renderFog(0);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTex("/terrain.png"));
            if (this.mc.options.fancyGraphics) {
                if (this.mc.options.anaglyph) {
                    if (k2 == 0) {
                        GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)false);
                    } else {
                        GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                    }
                }
                int n2 = renderglobal.func_943_a(entityplayersp, 1, f2);
            } else {
                renderglobal.func_943_a(entityplayersp, 1, f2);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            if (this.mc.objectMouseOver != null && !entityplayersp.isInsideOfMaterial(Material.water)) {
                GL11.glDisable((int)3008);
                renderglobal.renderHeldItem(entityplayersp, this.mc.objectMouseOver, 0, entityplayersp.inventory.getCurrentItem(), f2);
                renderglobal.drawSelectionBox(entityplayersp, this.mc.objectMouseOver, 0, entityplayersp.inventory.getCurrentItem(), f2);
                GL11.glEnable((int)3008);
            }
            GL11.glDisable((int)2912);
            if (this.mc.mcWorld.snowCovered) {
                this.snowFall(f2);
            }
            if (this.mc.enableRain) {
                this.rainFall(f2);
                if (this.mc.currentScreen == null) {
                    this.raining();
                }
            }
            if (this.field_1385_k == null) {
                // empty if block
            }
            this.renderFog(0);
            GL11.glEnable((int)2912);
            renderglobal.func_947_b(f2);
            GL11.glDisable((int)2912);
            this.renderFog(1);
            GL11.glClear((int)256);
            this.func_907_b(f2, k2);
            if (!this.mc.options.anaglyph) {
                return;
            }
            ++k2;
        }
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
    }

    private void raining() {
        if (this.mc.options.precipLevel && this.mc.options.particles) {
            EntityPlayerSP entityplayersp = this.mc.thePlayer;
            World world = this.mc.mcWorld;
            int i2 = MathHelper.floor_double(entityplayersp.posX);
            int j2 = MathHelper.floor_double(entityplayersp.posY);
            int k2 = MathHelper.floor_double(entityplayersp.posZ);
            int byte0 = 16;
            int l2 = 0;
            while (l2 < 150) {
                int i1 = i2 + this.random.nextInt(byte0) - this.random.nextInt(byte0);
                int j1 = k2 + this.random.nextInt(byte0) - this.random.nextInt(byte0);
                int k1 = world.func_696_e(i1, j1);
                int l1 = world.getBlockId(i1, k1 - 1, j1);
                if (k1 <= j2 + byte0 && k1 >= j2 - byte0) {
                    Random random2 = new Random();
                    float f2 = random2.nextFloat();
                    float f1 = random2.nextFloat();
                    if (l1 > 0) {
                        this.mc.effectRenderer.addEffect(new EntityRainFX(world, (float)i1 + f2, (double)((float)k1 + 0.1f) - Block.allBlocks[l1].minY, (float)j1 + f1));
                    }
                }
                ++l2;
            }
        }
    }

    private void rainFall(float f2) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        World world = this.mc.mcWorld;
        int i2 = MathHelper.floor_double(entityplayersp.posX);
        int j2 = MathHelper.floor_double(entityplayersp.posY);
        int k2 = MathHelper.floor_double(entityplayersp.posZ);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2884);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTex("/rain.png"));
        double d2 = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * (double)f2;
        double d1 = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * (double)f2;
        double d22 = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * (double)f2;
        int l2 = 5;
        if (this.mc.options.precipLevel) {
            l2 = 10;
        }
        int i1 = i2 - l2;
        while (i1 <= i2 + l2) {
            int j1 = k2 - l2;
            while (j1 <= k2 + l2) {
                int k1 = world.getTopSolidOrLiquidBlock(i1, j1);
                if (k1 < 0) {
                    k1 = 0;
                }
                int l1 = j2 - l2;
                int i22 = j2 + l2;
                if (l1 < k1) {
                    l1 = k1;
                }
                if (i22 < k1) {
                    i22 = k1;
                }
                float f1 = 2.0f;
                if (l1 != i22) {
                    this.random.setSeed(i1 * i1 * 3121 + i1 * 45238971 + j1 * j1 * 418711 + j1 * 13761);
                    float f22 = this.field_1386_j;
                    float f3 = ((float)(this.field_1386_j & 0x1FF) + f2) / 25.0f;
                    float f4 = this.random.nextFloat() + f22 * 0.01f * (float)this.random.nextGaussian();
                    float f5 = this.random.nextFloat() + f22 * (float)this.random.nextGaussian() * 0.001f;
                    double d3 = (double)((float)i1 + 0.5f) - entityplayersp.posX;
                    double d4 = (double)((float)j1 + 0.5f) - entityplayersp.posZ;
                    float f6 = MathHelper.sqrt_double(d3 * d3 + d4 * d4) / (float)l2;
                    tessellator.startDrawingQuads();
                    float f7 = world.getBrightness(i1, 128, j1);
                    GL11.glColor4f((float)f7, (float)f7, (float)f7, (float)((1.0f - f6 * f6) * 0.7f));
                    tessellator.setTranslationD(-d2 * 1.0, -d1 * 1.0, -d22 * 1.0);
                    tessellator.addVertexWithUV(i1 + 0, l1, j1 + 0, 0.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, l1, j1 + 1, 1.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, i22, j1 + 1, 1.0f * f1 + f4, (float)i22 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 0, i22, j1 + 0, 0.0f * f1 + f4, (float)i22 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 0, l1, j1 + 1, 0.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, l1, j1 + 0, 1.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, i22, j1 + 0, 1.0f * f1 + f4, (float)i22 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 0, i22, j1 + 1, 0.0f * f1 + f4, (float)i22 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.setTranslationD(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
                ++j1;
            }
            ++i1;
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    private void snowFall(float f2) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        World world = this.mc.mcWorld;
        int i2 = MathHelper.floor_double(entityplayersp.posX);
        int j2 = MathHelper.floor_double(entityplayersp.posY);
        int k2 = MathHelper.floor_double(entityplayersp.posZ);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2884);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTex("/snow.png"));
        double d2 = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * (double)f2;
        double d1 = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * (double)f2;
        double d22 = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * (double)f2;
        int l2 = 5;
        if (this.mc.options.precipLevel) {
            l2 = 10;
        }
        int i1 = i2 - l2;
        while (i1 <= i2 + l2) {
            int j1 = k2 - l2;
            while (j1 <= k2 + l2) {
                int k1 = world.getTopSolidOrLiquidBlock(i1, j1);
                if (k1 < 0) {
                    k1 = 0;
                }
                int l1 = j2 - l2;
                int i22 = j2 + l2;
                if (l1 < k1) {
                    l1 = k1;
                }
                if (i22 < k1) {
                    i22 = k1;
                }
                float f1 = 2.0f;
                if (l1 != i22) {
                    this.random.setSeed(i1 * i1 * 3121 + i1 * 45238971 + j1 * j1 * 418711 + j1 * 13761);
                    float f22 = (float)this.field_1386_j + f2;
                    float f3 = ((float)(this.field_1386_j & 0x1FF) + f2) / 512.0f;
                    float f4 = this.random.nextFloat() + f22 * 0.01f * (float)this.random.nextGaussian();
                    float f5 = this.random.nextFloat() + f22 * (float)this.random.nextGaussian() * 0.001f;
                    double d3 = (double)((float)i1 + 0.5f) - entityplayersp.posX;
                    double d4 = (double)((float)j1 + 0.5f) - entityplayersp.posZ;
                    float f6 = MathHelper.sqrt_double(d3 * d3 + d4 * d4) / (float)l2;
                    tessellator.startDrawingQuads();
                    float f7 = world.getBrightness(i1, 128, j1);
                    GL11.glColor4f((float)f7, (float)f7, (float)f7, (float)((1.0f - f6 * f6) * 0.7f));
                    tessellator.setTranslationD(-d2 * 1.0, -d1 * 1.0, -d22 * 1.0);
                    tessellator.addVertexWithUV(i1 + 0, l1, j1 + 0, 0.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, l1, j1 + 1, 1.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, i22, j1 + 1, 1.0f * f1 + f4, (float)i22 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 0, i22, j1 + 0, 0.0f * f1 + f4, (float)i22 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 0, l1, j1 + 1, 0.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, l1, j1 + 0, 1.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, i22, j1 + 0, 1.0f * f1 + f4, (float)i22 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 0, i22, j1 + 1, 0.0f * f1 + f4, (float)i22 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.setTranslationD(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
                ++j1;
            }
            ++i1;
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    public void func_905_b() {
        ScaledResolution scaledresolution = new ScaledResolution(this.mc.displayWidth, this.mc.displayHeight, this.mc);
        int i2 = scaledresolution.getScaledWidth();
        int j2 = scaledresolution.getScaledHeight();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)i2, (double)j2, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    private void updateFogColor(float f2) {
        World world = this.mc.mcWorld;
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        float f1 = 1.0f;
        if (this.mc.options.fog) {
            f1 = 1.0f / (float)(4 - this.mc.options.renderDistance);
        }
        f1 = 1.0f - (float)Math.pow(f1, 0.25);
        Vec3D vec3d = world.func_626_b(f2);
        float f22 = (float)vec3d.xCoord;
        float f3 = (float)vec3d.yCoord;
        float f4 = (float)vec3d.zCoord;
        Vec3D vec3d1 = world.func_686_e(f2);
        this.fogColorRed = (float)vec3d1.xCoord;
        this.fogColorGreen = (float)vec3d1.yCoord;
        this.fogColorBlue = (float)vec3d1.zCoord;
        this.fogColorRed += (f22 - this.fogColorRed) * f1;
        this.fogColorGreen += (f3 - this.fogColorGreen) * f1;
        this.fogColorBlue += (f4 - this.fogColorBlue) * f1;
        if (entityplayersp.isInsideOfMaterial(Material.water)) {
            this.fogColorRed = 0.02f;
            this.fogColorGreen = 0.02f;
            this.fogColorBlue = 0.2f;
        } else if (entityplayersp.isInsideOfMaterial(Material.lava)) {
            this.fogColorRed = 0.6f;
            this.fogColorGreen = 0.1f;
            this.fogColorBlue = 0.0f;
        }
        float f5 = this.field_1382_n + (this.hasSubtypes - this.field_1382_n) * f2;
        this.fogColorRed *= f5;
        this.fogColorGreen *= f5;
        this.fogColorBlue *= f5;
        if (this.mc.options.anaglyph) {
            float f6 = (this.fogColorRed * 30.0f + this.fogColorGreen * 59.0f + this.fogColorBlue * 11.0f) / 100.0f;
            float f7 = (this.fogColorRed * 30.0f + this.fogColorGreen * 70.0f) / 100.0f;
            float f8 = (this.fogColorRed * 30.0f + this.fogColorBlue * 70.0f) / 100.0f;
            this.fogColorRed = f6;
            this.fogColorGreen = f7;
            this.fogColorBlue = f8;
        }
        GL11.glClearColor((float)this.fogColorRed, (float)this.fogColorGreen, (float)this.fogColorBlue, (float)0.0f);
    }

    private void renderFog(int i2) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        GL11.glFog((int)2918, (FloatBuffer)this.func_908_a(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, 1.0f));
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (entityplayersp.isInsideOfMaterial(Material.water)) {
            GL11.glFogi((int)2917, (int)2048);
            if (entityplayersp.inventory.armorInventory[3] != null && entityplayersp.inventory.armorInventory[3].itemID == Item.helmetSponge.shiftedIndex) {
                GL11.glFogf((int)2914, (float)0.025f);
            } else {
                GL11.glFogf((int)2914, (float)0.1f);
            }
            float f2 = 0.4f;
            float f22 = 0.4f;
            float f4 = 0.9f;
            if (this.mc.options.anaglyph) {
                float f6 = (f2 * 30.0f + f22 * 59.0f + f4 * 11.0f) / 100.0f;
                float f8 = (f2 * 30.0f + f22 * 70.0f) / 100.0f;
                float f10 = (f2 * 30.0f + f4 * 70.0f) / 100.0f;
                f2 = f6;
                f22 = f8;
                f4 = f10;
            }
        } else if (entityplayersp.isInsideOfMaterial(Material.lava)) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)2.0f);
            float f1 = 0.4f;
            float f3 = 0.3f;
            float f5 = 0.3f;
            if (this.mc.options.anaglyph) {
                float f7 = (f1 * 30.0f + f3 * 59.0f + f5 * 11.0f) / 100.0f;
                float f9 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
                float f11 = (f1 * 30.0f + f5 * 70.0f) / 100.0f;
                f1 = f7;
                f3 = f9;
                f5 = f11;
            }
        } else {
            GL11.glFogi((int)2917, (int)9729);
            GL11.glFogf((int)2915, (float)(this.farPlaneDistance * 0.25f));
            GL11.glFogf((int)2916, (float)this.farPlaneDistance);
            if (i2 < 0) {
                GL11.glFogf((int)2915, (float)0.0f);
                GL11.glFogf((int)2916, (float)(this.farPlaneDistance * 0.8f));
            }
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GL11.glFogi((int)34138, (int)34139);
            }
        }
        GL11.glEnable((int)2903);
        GL11.glColorMaterial((int)1028, (int)4608);
    }

    private FloatBuffer func_908_a(float f2, float f1, float f22, float f3) {
        this.field_1392_d.clear();
        this.field_1392_d.put(f2).put(f1).put(f22).put(f3);
        this.field_1392_d.flip();
        return this.field_1392_d;
    }
}

