/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.level.tile.fx.TextureFX;
import com.mojang.minecraft.player.controller.GameSettings;
import com.mojang.minecraft.render.GLAllocation;
import com.mojang.minecraft.render.ImageBuffer;
import com.mojang.minecraft.util.DownloadImageThreadData;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;

public class RenderEngine {
    public static boolean useMipMaps = false;
    private HashMap<String, Integer> textureMap = new HashMap();
    private HashMap<Integer, BufferedImage> textureNameToImageMap = new HashMap();
    private IntBuffer singleIntBuffer = GLAllocation.createDirectIntBuffer(1);
    private ByteBuffer field_1605_e = GLAllocation.createDirectByteBuffer(0x100000);
    private List<TextureFX> field_1604_f = new ArrayList<TextureFX>();
    private Map<String, DownloadImageThreadData> field_1603_g = new HashMap<String, DownloadImageThreadData>();
    private GameSettings field_1602_h;
    private boolean field_1601_i = false;

    public RenderEngine(GameSettings gamesettings) {
        this.field_1602_h = gamesettings;
    }

    public int getTex(String s2) {
        Integer integer = this.textureMap.get(s2);
        if (integer != null) {
            return integer;
        }
        try {
            this.singleIntBuffer.clear();
            GLAllocation.generateTextureNames(this.singleIntBuffer);
            int i2 = this.singleIntBuffer.get(0);
            if (s2.startsWith("##")) {
                this.setupTexture(this.unwrapImageByColumns(ImageIO.read(RenderEngine.class.getResourceAsStream(s2.substring(2)))), i2);
            } else if (s2.startsWith("%%")) {
                this.field_1601_i = true;
                this.setupTexture(ImageIO.read(RenderEngine.class.getResourceAsStream(s2.substring(2))), i2);
                this.field_1601_i = false;
            } else {
                this.setupTexture(ImageIO.read(RenderEngine.class.getResourceAsStream(s2)), i2);
            }
            this.textureMap.put(s2, i2);
            return i2;
        }
        catch (IOException ioexception) {
            throw new RuntimeException("!!");
        }
    }

    private BufferedImage unwrapImageByColumns(BufferedImage bufferedimage) {
        int i2 = bufferedimage.getWidth() / 16;
        BufferedImage bufferedimage1 = new BufferedImage(16, bufferedimage.getHeight() * i2, 2);
        Graphics g2 = bufferedimage1.getGraphics();
        int j2 = 0;
        while (j2 < i2) {
            g2.drawImage(bufferedimage, -j2 * 16, j2 * bufferedimage.getHeight(), null);
            ++j2;
        }
        g2.dispose();
        return bufferedimage1;
    }

    public int allocateAndSetupTexture(BufferedImage bufferedimage) {
        this.singleIntBuffer.clear();
        GLAllocation.generateTextureNames(this.singleIntBuffer);
        int i2 = this.singleIntBuffer.get(0);
        this.setupTexture(bufferedimage, i2);
        this.textureNameToImageMap.put(i2, bufferedimage);
        return i2;
    }

    public void setupTexture(BufferedImage bufferedimage, int i2) {
        GL11.glBindTexture((int)3553, (int)i2);
        if (useMipMaps) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (this.field_1601_i) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        int j2 = bufferedimage.getWidth();
        int k2 = bufferedimage.getHeight();
        int[] ai2 = new int[j2 * k2];
        byte[] abyte0 = new byte[j2 * k2 * 4];
        bufferedimage.getRGB(0, 0, j2, k2, ai2, 0, j2);
        int l2 = 0;
        while (l2 < ai2.length) {
            int j1 = ai2[l2] >> 24 & 0xFF;
            int l1 = ai2[l2] >> 16 & 0xFF;
            int j22 = ai2[l2] >> 8 & 0xFF;
            int l22 = ai2[l2] & 0xFF;
            if (this.field_1602_h != null && this.field_1602_h.anaglyph) {
                int j3 = (l1 * 30 + j22 * 59 + l22 * 11) / 100;
                int l3 = (l1 * 30 + j22 * 70) / 100;
                int j4 = (l1 * 30 + l22 * 70) / 100;
                l1 = j3;
                j22 = l3;
                l22 = j4;
            }
            abyte0[l2 * 4 + 0] = (byte)l1;
            abyte0[l2 * 4 + 1] = (byte)j22;
            abyte0[l2 * 4 + 2] = (byte)l22;
            abyte0[l2 * 4 + 3] = (byte)j1;
            ++l2;
        }
        this.field_1605_e.clear();
        this.field_1605_e.put(abyte0);
        this.field_1605_e.position(0).limit(abyte0.length);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)j2, (int)k2, (int)0, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
        if (useMipMaps) {
            int i1 = 1;
            while (i1 <= 4) {
                int k1 = j2 >> i1 - 1;
                int i22 = j2 >> i1;
                int k22 = k2 >> i1;
                int i3 = 0;
                while (i3 < i22) {
                    int k3 = 0;
                    while (k3 < k22) {
                        int i4 = this.field_1605_e.getInt((i3 * 2 + 0 + (k3 * 2 + 0) * k1) * 4);
                        int k4 = this.field_1605_e.getInt((i3 * 2 + 1 + (k3 * 2 + 0) * k1) * 4);
                        int l4 = this.field_1605_e.getInt((i3 * 2 + 1 + (k3 * 2 + 1) * k1) * 4);
                        int i5 = this.field_1605_e.getInt((i3 * 2 + 0 + (k3 * 2 + 1) * k1) * 4);
                        int j5 = this.func_1077_b(this.func_1077_b(i4, k4), this.func_1077_b(l4, i5));
                        this.field_1605_e.putInt((i3 + k3 * i22) * 4, j5);
                        ++k3;
                    }
                    ++i3;
                }
                GL11.glTexImage2D((int)3553, (int)i1, (int)6408, (int)i22, (int)k22, (int)0, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
                ++i1;
            }
        }
    }

    public void func_1078_a(int i2) {
        this.textureNameToImageMap.remove(i2);
        this.singleIntBuffer.clear();
        this.singleIntBuffer.put(i2);
        this.singleIntBuffer.flip();
        GL11.glDeleteTextures((IntBuffer)this.singleIntBuffer);
    }

    public int getTextureForDownloadableImage(String s2, String s1) {
        DownloadImageThreadData downloadimagethreaddata = this.field_1603_g.get(s2);
        if (downloadimagethreaddata != null && downloadimagethreaddata.field_1706_a != null && !downloadimagethreaddata.field_1707_d) {
            if (downloadimagethreaddata.field_1708_c < 0) {
                downloadimagethreaddata.field_1708_c = this.allocateAndSetupTexture(downloadimagethreaddata.field_1706_a);
            } else {
                this.setupTexture(downloadimagethreaddata.field_1706_a, downloadimagethreaddata.field_1708_c);
            }
            downloadimagethreaddata.field_1707_d = true;
        }
        if (downloadimagethreaddata == null || downloadimagethreaddata.field_1708_c < 0) {
            if (s1 == null) {
                return -1;
            }
            return this.getTex(s1);
        }
        return downloadimagethreaddata.field_1708_c;
    }

    public DownloadImageThreadData obtainImageData(String s2, ImageBuffer imagebuffer) {
        DownloadImageThreadData downloadimagethreaddata = this.field_1603_g.get(s2);
        if (downloadimagethreaddata == null) {
            this.field_1603_g.put(s2, new DownloadImageThreadData(s2, imagebuffer));
        } else {
            ++downloadimagethreaddata.field_1705_b;
        }
        return downloadimagethreaddata;
    }

    public void releaseImageData(String s2) {
        DownloadImageThreadData downloadimagethreaddata = this.field_1603_g.get(s2);
        if (downloadimagethreaddata != null) {
            --downloadimagethreaddata.field_1705_b;
            if (downloadimagethreaddata.field_1705_b == 0) {
                if (downloadimagethreaddata.field_1708_c >= 0) {
                    this.func_1078_a(downloadimagethreaddata.field_1708_c);
                }
                this.field_1603_g.remove(s2);
            }
        }
    }

    public void bindTextureFX(TextureFX texturefx) {
        this.field_1604_f.add(texturefx);
        texturefx.render();
    }

    public void updateDynamicTextures() {
        int i2 = 0;
        while (i2 < this.field_1604_f.size()) {
            TextureFX texturefx = this.field_1604_f.get(i2);
            texturefx.field_1131_c = this.field_1602_h.anaglyph;
            texturefx.render();
            this.field_1605_e.clear();
            this.field_1605_e.put(texturefx.field_1127_a);
            this.field_1605_e.position(0).limit(texturefx.field_1127_a.length);
            texturefx.bindTextureFXToTexture(this);
            int texFXU = 0;
            while (texFXU < texturefx.prevSize) {
                int texFXV = 0;
                while (texFXV < texturefx.prevSize) {
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)(texturefx.texIndex % 16 * 16 + texFXU * 16), (int)(texturefx.texIndex / 16 * 16 + texFXV * 16), (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
                    if (useMipMaps) {
                        for (int k1 = 1; k1 <= 4; ++k1) {
                            int i22 = 16 >> k1 - 1;
                            int k2 = 16 >> k1;
                            int i3 = 0;
                            while (i3 < k2) {
                                int k3 = 0;
                                while (k3 < k2) {
                                    int i4 = this.field_1605_e.getInt((i3 * 2 + 0 + (k3 * 2 + 0) * i22) * 4);
                                    int k4 = this.field_1605_e.getInt((i3 * 2 + 1 + (k3 * 2 + 0) * i22) * 4);
                                    int i5 = this.field_1605_e.getInt((i3 * 2 + 1 + (k3 * 2 + 1) * i22) * 4);
                                    int k5 = this.field_1605_e.getInt((i3 * 2 + 0 + (k3 * 2 + 1) * i22) * 4);
                                    int l5 = this.func_1072_a(this.func_1072_a(i4, k4), this.func_1072_a(i5, k5));
                                    this.field_1605_e.putInt((i3 + k3 * k2) * 4, l5);
                                    ++k3;
                                }
                                ++i3;
                            }
                            GL11.glTexSubImage2D((int)3553, (int)k1, (int)(texturefx.texIndex % 16 * k2), (int)(texturefx.texIndex / 16 * k2), (int)k2, (int)k2, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
                        }
                    }
                    ++texFXV;
                }
                ++texFXU;
            }
            ++i2;
        }
        int j2 = 0;
        while (j2 < this.field_1604_f.size()) {
            TextureFX texturefx1 = this.field_1604_f.get(j2);
            if (texturefx1.size > 0) {
                this.field_1605_e.clear();
                this.field_1605_e.put(texturefx1.field_1127_a);
                this.field_1605_e.position(0).limit(texturefx1.field_1127_a.length);
                GL11.glBindTexture((int)3553, (int)texturefx1.size);
                GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
                if (useMipMaps) {
                    for (int l2 = 1; l2 <= 4; ++l2) {
                        int j1 = 16 >> l2 - 1;
                        int l1 = 16 >> l2;
                        int j22 = 0;
                        while (j22 < l1) {
                            int l22 = 0;
                            while (l22 < l1) {
                                int j3 = this.field_1605_e.getInt((j22 * 2 + 0 + (l22 * 2 + 0) * j1) * 4);
                                int l3 = this.field_1605_e.getInt((j22 * 2 + 1 + (l22 * 2 + 0) * j1) * 4);
                                int j4 = this.field_1605_e.getInt((j22 * 2 + 1 + (l22 * 2 + 1) * j1) * 4);
                                int l4 = this.field_1605_e.getInt((j22 * 2 + 0 + (l22 * 2 + 1) * j1) * 4);
                                int j5 = this.func_1072_a(this.func_1072_a(j3, l3), this.func_1072_a(j4, l4));
                                this.field_1605_e.putInt((j22 + l22 * l1) * 4, j5);
                                ++l22;
                            }
                            ++j22;
                        }
                        GL11.glTexSubImage2D((int)3553, (int)l2, (int)0, (int)0, (int)l1, (int)l1, (int)6408, (int)5121, (ByteBuffer)this.field_1605_e);
                    }
                }
            }
            ++j2;
        }
    }

    private int func_1072_a(int i2, int j2) {
        int k2 = (i2 & 0xFF000000) >> 24 & 0xFF;
        int l2 = (j2 & 0xFF000000) >> 24 & 0xFF;
        return (k2 + l2 >> 1 << 24) + ((i2 & 0xFEFEFE) + (j2 & 0xFEFEFE) >> 1);
    }

    private int func_1077_b(int i2, int j2) {
        int k2 = (i2 & 0xFF000000) >> 24 & 0xFF;
        int l2 = (j2 & 0xFF000000) >> 24 & 0xFF;
        int c2 = 255;
        if (k2 + l2 == 0) {
            k2 = 1;
            l2 = 1;
            c2 = 0;
        }
        int i1 = (i2 >> 16 & 0xFF) * k2;
        int j1 = (i2 >> 8 & 0xFF) * k2;
        int k1 = (i2 & 0xFF) * k2;
        int l1 = (j2 >> 16 & 0xFF) * l2;
        int i22 = (j2 >> 8 & 0xFF) * l2;
        int j22 = (j2 & 0xFF) * l2;
        int k22 = (i1 + l1) / (k2 + l2);
        int l22 = (j1 + i22) / (k2 + l2);
        int i3 = (k1 + j22) / (k2 + l2);
        return c2 << 24 | k22 << 16 | l22 << 8 | i3;
    }

    public void func_1065_b() {
        for (int i2 : this.textureNameToImageMap.keySet()) {
            BufferedImage bufferedimage = this.textureNameToImageMap.get(i2);
            this.setupTexture(bufferedimage, i2);
        }
        for (DownloadImageThreadData downloadimagethreaddata : this.field_1603_g.values()) {
            downloadimagethreaddata.field_1707_d = false;
        }
        for (String s2 : this.textureMap.keySet()) {
            try {
                BufferedImage bufferedimage1;
                if (s2.startsWith("##")) {
                    bufferedimage1 = this.unwrapImageByColumns(ImageIO.read(RenderEngine.class.getResourceAsStream(s2.substring(2))));
                } else if (s2.startsWith("%%")) {
                    this.field_1601_i = true;
                    bufferedimage1 = ImageIO.read(RenderEngine.class.getResourceAsStream(s2.substring(2)));
                    this.field_1601_i = false;
                } else {
                    bufferedimage1 = ImageIO.read(RenderEngine.class.getResourceAsStream(s2));
                }
                int j2 = this.textureMap.get(s2);
                this.setupTexture(bufferedimage1, j2);
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
    }

    public void bindTex(int i2) {
        if (i2 < 0) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)i2);
    }
}

