/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.Minecraft;

public class ScaledResolution {
    private int scaledWidth;
    private int scaledHeight;
    public int scaleFactor;

    public ScaledResolution(int i2, int j2, Minecraft mc2) {
        this.scaledWidth = i2;
        this.scaledHeight = j2;
        this.scaleFactor = 1;
        int k2 = mc2.options.guiScale;
        if (k2 == 0) {
            k2 = 1000;
        }
        while (this.scaleFactor < k2 && this.scaledWidth / (this.scaleFactor + 1) >= 320 && this.scaledHeight / (this.scaleFactor + 1) >= 240) {
            ++this.scaleFactor;
        }
        this.scaledWidth /= this.scaleFactor;
        this.scaledHeight /= this.scaleFactor;
    }

    public int getScaledWidth() {
        return this.scaledWidth;
    }

    public int getScaledHeight() {
        return this.scaledHeight;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }
}

