/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.render.GLAllocation;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Util;

public class Tessellator {
    private static boolean convertQuadsToTriangles;
    private static boolean tryVBO;
    private ByteBuffer byteBuffer;
    private IntBuffer intBuffer;
    private FloatBuffer floatBuffer;
    private int vertexCount = 0;
    private double textureU;
    private double textureV;
    private int color;
    private boolean hasColor = false;
    private boolean hasTexture = false;
    private boolean hasNormals = false;
    private int rawBufferIndex = 0;
    private int addedVertices = 0;
    private boolean isColorDisabled = false;
    private int drawMode;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private int normal;
    public static final Tessellator instance;
    public boolean isDrawing = false;
    private boolean useVBO = false;
    private IntBuffer vertexBuffers;
    private int vboIndex = 0;
    private int vboCount = 10;
    private int bufferSize;
    private static boolean renderingChunk;
    public static int chunkOffsetX;
    public static int chunkOffsetZ;
    public boolean noTextures;
    private int lastDrawMode = 7;

    static {
        chunkOffsetX = 0;
        chunkOffsetZ = 0;
        convertQuadsToTriangles = true;
        tryVBO = false;
        instance = new Tessellator(0x200000);
        renderingChunk = false;
    }

    private Tessellator(int i2) {
        this.bufferSize = i2;
        this.byteBuffer = GLAllocation.createDirectByteBuffer(i2 * 4);
        this.intBuffer = this.byteBuffer.asIntBuffer();
        this.floatBuffer = this.byteBuffer.asFloatBuffer();
        boolean bl2 = this.useVBO = tryVBO && GLContext.getCapabilities().GL_ARB_vertex_buffer_object;
        if (this.useVBO) {
            this.vertexBuffers = GLAllocation.createDirectIntBuffer(this.vboCount);
            ARBVertexBufferObject.glGenBuffersARB((IntBuffer)this.vertexBuffers);
        }
    }

    public void draw() {
        if (!this.isDrawing) {
            throw new IllegalStateException("Not tesselating!");
        }
        this.isDrawing = false;
        if (!renderingChunk) {
            GL11.glEnd();
            this.func_21021_e();
        } else if (this.vertexCount > 0) {
            this.byteBuffer.position(0);
            this.byteBuffer.limit(this.rawBufferIndex * 4);
            GL11.glEnableClientState((int)32888);
            GL11.glEnableClientState((int)32886);
            GL11.glEnableClientState((int)32884);
            if (this.noTextures) {
                GL11.glDisable((int)3553);
            }
            if (this.useVBO) {
                this.vboIndex = (this.vboIndex + 1) % this.vboCount;
                ARBVertexBufferObject.glBindBufferARB((int)35044, (int)this.vertexBuffers.get(this.vboIndex));
                ARBVertexBufferObject.glBufferDataARB((int)35044, (ByteBuffer)this.byteBuffer, (int)35040);
                GL11.glTexCoordPointer((int)2, (int)5126, (int)24, (long)12L);
                GL11.glColorPointer((int)4, (int)5121, (int)24, (long)20L);
                GL11.glVertexPointer((int)3, (int)5126, (int)24, (long)0L);
            } else {
                this.floatBuffer.position(3);
                GL11.glTexCoordPointer((int)2, (int)24, (FloatBuffer)this.floatBuffer);
                this.byteBuffer.position(20);
                GL11.glColorPointer((int)4, (boolean)true, (int)24, (ByteBuffer)this.byteBuffer);
                this.floatBuffer.position(0);
                GL11.glVertexPointer((int)3, (int)24, (FloatBuffer)this.floatBuffer);
            }
            if (this.drawMode == 7 && convertQuadsToTriangles) {
                GL11.glDrawArrays((int)4, (int)0, (int)this.vertexCount);
            } else {
                GL11.glDrawArrays((int)this.drawMode, (int)0, (int)this.vertexCount);
            }
            GL11.glDisableClientState((int)32888);
            GL11.glDisableClientState((int)32886);
            GL11.glDisableClientState((int)32884);
        }
        this.reset();
    }

    public void draw_() {
        if (!this.isDrawing) {
            throw new IllegalStateException("Not tesselating!");
        }
        this.isDrawing = false;
        if (!renderingChunk) {
            GL11.glEnd();
        } else if (this.vertexCount > 0) {
            this.intBuffer.clear();
            this.byteBuffer.position(0);
            this.byteBuffer.limit(this.rawBufferIndex * 4);
            if (this.useVBO) {
                this.vboIndex = (this.vboIndex + 1) % this.vboCount;
                ARBVertexBufferObject.glBindBufferARB((int)34962, (int)this.vertexBuffers.get(this.vboIndex));
                ARBVertexBufferObject.glBufferDataARB((int)34962, (ByteBuffer)this.byteBuffer, (int)35040);
            }
            if (this.hasTexture) {
                if (this.useVBO) {
                    GL11.glTexCoordPointer((int)2, (int)5126, (int)32, (long)12L);
                } else {
                    this.floatBuffer.position(3);
                    GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)this.floatBuffer);
                }
                GL11.glEnableClientState((int)32888);
            }
            if (this.hasColor) {
                if (this.useVBO) {
                    GL11.glColorPointer((int)4, (int)5121, (int)32, (long)20L);
                } else {
                    this.byteBuffer.position(20);
                    GL11.glColorPointer((int)4, (boolean)true, (int)32, (ByteBuffer)this.byteBuffer);
                }
                GL11.glEnableClientState((int)32886);
            }
            if (this.hasNormals) {
                if (this.useVBO) {
                    GL11.glNormalPointer((int)5120, (int)32, (long)24L);
                } else {
                    this.byteBuffer.position(24);
                    GL11.glNormalPointer((int)32, (ByteBuffer)this.byteBuffer);
                }
                GL11.glEnableClientState((int)32885);
            }
            if (this.useVBO) {
                GL11.glVertexPointer((int)3, (int)5126, (int)32, (long)0L);
            } else {
                this.floatBuffer.position(0);
                GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)this.floatBuffer);
            }
            GL11.glEnableClientState((int)32884);
            if (this.drawMode == 7 && convertQuadsToTriangles) {
                GL11.glDrawArrays((int)4, (int)0, (int)this.vertexCount);
            } else {
                GL11.glDrawArrays((int)this.drawMode, (int)0, (int)this.vertexCount);
            }
            GL11.glDisableClientState((int)32884);
            if (this.hasTexture) {
                GL11.glDisableClientState((int)32888);
            }
            if (this.hasColor) {
                GL11.glDisableClientState((int)32886);
            }
            if (this.hasNormals) {
                GL11.glDisableClientState((int)32885);
            }
        }
        this.reset();
    }

    private void reset() {
        this.vertexCount = 0;
        this.byteBuffer.clear();
        this.intBuffer.clear();
        this.rawBufferIndex = 0;
        this.addedVertices = 0;
    }

    public void startDrawingQuads() {
        this.startDrawing(7);
    }

    public void startDrawing(int i2) {
        if (this.isDrawing) {
            throw new IllegalStateException("Already tesselating!");
        }
        if (!renderingChunk) {
            GL11.glBegin((int)i2);
        }
        this.isDrawing = true;
        this.reset();
        this.drawMode = i2;
        this.hasNormals = false;
        this.hasColor = false;
        this.hasTexture = false;
        this.isColorDisabled = false;
    }

    public void setTextureUV(double d2, double d1) {
        this.hasTexture = true;
        this.textureU = d2;
        this.textureV = d1;
        if (!renderingChunk) {
            GL11.glTexCoord2f((float)((float)d2), (float)((float)d1));
        }
    }

    public void setColorOpaque_F(float f2, float f1, float f22) {
        this.setColorOpaque((int)(f2 * 255.0f), (int)(f1 * 255.0f), (int)(f22 * 255.0f));
    }

    public void setColorRGBA_F(float f2, float f1, float f22, float f3) {
        this.setColorRGBA((int)(f2 * 255.0f), (int)(f1 * 255.0f), (int)(f22 * 255.0f), (int)(f3 * 255.0f));
    }

    public void setColorOpaque(int i2, int j2, int k2) {
        this.setColorRGBA(i2, j2, k2, 255);
    }

    public void setColorRGBA(int i2, int j2, int k2, int l2) {
        if (!this.isColorDisabled) {
            if (i2 > 255) {
                i2 = 255;
            }
            if (j2 > 255) {
                j2 = 255;
            }
            if (k2 > 255) {
                k2 = 255;
            }
            if (l2 > 255) {
                l2 = 255;
            }
            if (i2 < 0) {
                i2 = 0;
            }
            if (j2 < 0) {
                j2 = 0;
            }
            if (k2 < 0) {
                k2 = 0;
            }
            if (l2 < 0) {
                l2 = 0;
            }
            this.hasColor = true;
            if (!renderingChunk) {
                GL11.glColor4ub((byte)((byte)i2), (byte)((byte)j2), (byte)((byte)k2), (byte)((byte)l2));
            } else {
                this.color = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? l2 << 24 | k2 << 16 | j2 << 8 | i2 : i2 << 24 | j2 << 16 | k2 << 8 | l2;
            }
        }
    }

    public void addVertexWithUV(double x2, double y2, double z2, double u2, double v2) {
        this.setTextureUV(u2, v2);
        this.addVertex(x2, y2, z2);
    }

    public void addVertex(double d2, double d1, double d22) {
        if (!renderingChunk) {
            GL11.glVertex3f((float)((float)(d2 + this.xOffset)), (float)((float)(d1 + this.yOffset)), (float)((float)(d22 + this.zOffset)));
            return;
        }
        ++this.addedVertices;
        if (this.drawMode == 7 && convertQuadsToTriangles && this.addedVertices % 4 == 0) {
            int i2 = 0;
            while (i2 < 2) {
                int j2 = 6 * (3 - i2);
                this.intBuffer.put(this.intBuffer.get(this.rawBufferIndex - j2 + 0));
                this.intBuffer.put(this.intBuffer.get(this.rawBufferIndex - j2 + 1));
                this.intBuffer.put(this.intBuffer.get(this.rawBufferIndex - j2 + 2));
                this.intBuffer.put(this.intBuffer.get(this.rawBufferIndex - j2 + 3));
                this.intBuffer.put(this.intBuffer.get(this.rawBufferIndex - j2 + 4));
                this.intBuffer.put(this.intBuffer.get(this.rawBufferIndex - j2 + 5));
                ++this.vertexCount;
                this.rawBufferIndex += 6;
                ++i2;
            }
        }
        if (renderingChunk) {
            this.intBuffer.put(Float.floatToRawIntBits((float)(d2 + this.xOffset) - (float)chunkOffsetX));
            this.intBuffer.put(Float.floatToRawIntBits((float)(d1 + this.yOffset)));
            this.intBuffer.put(Float.floatToRawIntBits((float)(d22 + this.zOffset) - (float)chunkOffsetZ));
        } else {
            this.intBuffer.put(Float.floatToRawIntBits((float)(d2 + this.xOffset)));
            this.intBuffer.put(Float.floatToRawIntBits((float)(d1 + this.yOffset)));
            this.intBuffer.put(Float.floatToRawIntBits((float)(d22 + this.zOffset)));
        }
        this.intBuffer.put(Float.floatToRawIntBits((float)this.textureU));
        this.intBuffer.put(Float.floatToRawIntBits((float)this.textureV));
        this.intBuffer.put(this.color);
        this.rawBufferIndex += 6;
        ++this.vertexCount;
        if (renderingChunk && this.vertexCount % 4 == 0 && this.rawBufferIndex >= this.bufferSize - 32) {
            this.draw();
            this.isDrawing = true;
        }
    }

    public void setColorOpaque_I(int i2) {
        int j2 = i2 >> 16 & 0xFF;
        int k2 = i2 >> 8 & 0xFF;
        int l2 = i2 & 0xFF;
        this.setColorOpaque(j2, k2, l2);
    }

    public void setColorRGBA_I(int i2, int j2) {
        int k2 = i2 >> 16 & 0xFF;
        int l2 = i2 >> 8 & 0xFF;
        int i1 = i2 & 0xFF;
        this.setColorRGBA(k2, l2, i1, j2);
    }

    public void disableColor() {
        this.isColorDisabled = true;
    }

    public void setNormal(float f2, float f1, float f22) {
        if (!this.isDrawing) {
            System.out.println("But..");
        }
        this.hasNormals = true;
        byte byte0 = (byte)(f2 * 128.0f);
        byte byte1 = (byte)(f1 * 127.0f);
        byte byte2 = (byte)(f22 * 127.0f);
        if (!renderingChunk) {
            GL11.glNormal3b((byte)byte0, (byte)byte1, (byte)byte2);
        } else {
            System.out.println("ERROR ERROR NORMALS IN CHUNK MODE");
        }
    }

    public void setTranslationD(double d2, double d1, double d22) {
        this.xOffset = d2;
        this.yOffset = d1;
        this.zOffset = d22;
    }

    public void setTranslationF(float f2, float f1, float f22) {
        this.xOffset += (double)f2;
        this.yOffset += (double)f1;
        this.zOffset += (double)f22;
    }

    public void setRenderingChunk(boolean flag) {
        renderingChunk = flag;
    }

    private void func_21021_e() {
        int i2 = GL11.glGetError();
        if (i2 != 0) {
            System.out.println(i2 + ": " + Util.translateGLErrorString((int)i2));
            StackTraceElement[] astacktraceelement = Thread.currentThread().getStackTrace();
            int j2 = 0;
            while (j2 < astacktraceelement.length) {
                StackTraceElement stacktraceelement = astacktraceelement[j2];
                System.out.println(" in class:" + stacktraceelement.getClassName() + " in source file:" + stacktraceelement.getFileName() + " in method:" + stacktraceelement.getMethodName() + " at line:" + stacktraceelement.getLineNumber() + " " + (stacktraceelement.isNativeMethod() ? "native" : ""));
                ++j2;
            }
        }
    }
}

