/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.util.auth;

import com.mojang.minecraft.util.auth.PropertyMap;
import java.util.UUID;

public class GameProfile {
    private final UUID id;
    private final String name;
    private final PropertyMap properties = new PropertyMap();
    private boolean legacy;

    public GameProfile(UUID id2, String name) {
        if (id2 == null && (name == null || name == "")) {
            throw new IllegalArgumentException("Name and ID cannot both be blank");
        }
        this.id = id2;
        this.name = name;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public PropertyMap getProperties() {
        return this.properties;
    }

    public boolean isComplete() {
        return this.id != null && this.getName() != null && this.getName() != "";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        GameProfile that = (GameProfile)o2;
        if (!(this.id != null ? this.id.equals(that.id) : that.id == null)) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this + "id" + this.id + "name" + this.name + "properties" + this.properties + "legacy" + this.legacy;
    }

    public boolean isLegacy() {
        return this.legacy;
    }
}

