/*
 * Decompiled with CFR 0.152.
 */
class FlowThread
extends Thread {
    World world;
    BlockSponge sponge;
    int x;
    int y;
    int z;
    int sx;
    int sy;
    int sz;

    public FlowThread(World world, BlockSponge sponge, int x2, int y2, int z2, int sx, int sy, int sz) {
        this.world = world;
        this.sponge = sponge;
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.sx = sx;
        this.sy = sy;
        this.sz = sz;
    }

    @Override
    public void run() {
        this.flowWater(this.world, this.x, this.y, this.z, this.sx, this.sy, this.sz);
    }

    public void dropWater(World world, int x2, int y2, int z2) {
        int i2 = y2;
        while (i2 > y2 - 3) {
            if (world.getBlock(x2, i2, z2) != 0 && world.getBlock(x2, i2, z2) != Block.waterMoving.blockID) break;
            if (!BlockSponge.getSurroundSponge(world, x2, i2, z2)) {
                world.setBlock(x2, i2, z2, Block.waterStill.blockID);
            }
            --i2;
        }
    }

    public void flowWater(World world, int x2, int y2, int z2, int sx, int sy, int sz) {
        int radius = 3;
        if (!(world.getBlock(x2, y2, z2) != 0 && world.getBlock(x2, y2, z2) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x2, y2, z2))) {
            world.setBlock(x2, y2, z2, Block.waterStill.blockID);
            this.dropWater(world, x2, y2, z2);
            if (!(x2 + 1 >= sx + radius || world.getBlock(x2 + 1, y2, z2) != 0 && world.getBlock(x2 + 1, y2, z2) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x2 + 1, y2, z2))) {
                this.flowWater(world, x2 + 1, y2, z2, sx, sy, sz);
            }
            if (!(z2 + 1 >= sz + radius || world.getBlock(x2, y2, z2 + 1) != 0 && world.getBlock(x2, y2, z2 + 1) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x2, y2, z2 + 1))) {
                this.flowWater(world, x2, y2, z2 + 1, sx, sy, sz);
            }
            if (!(x2 - 1 <= sx - radius || world.getBlock(x2 - 1, y2, z2) != 0 && world.getBlock(x2 - 1, y2, z2) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x2 - 1, y2, z2))) {
                this.flowWater(world, x2 - 1, y2, z2, sx, sy, sz);
            }
            if (!(z2 - 1 <= sz - radius || world.getBlock(x2, y2, z2 - 1) != 0 && world.getBlock(x2, y2, z2 - 1) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x2, y2, z2 - 1))) {
                this.flowWater(world, x2, y2, z2 - 1, sx, sy, sz);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
    }
}

